/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provisioning.dao;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.provisioning.ProvisionedIdentifier;
import org.wso2.carbon.identity.provisioning.ProvisioningEntity;
import org.wso2.carbon.identity.provisioning.cache.ProvisioningEntityCache;
import org.wso2.carbon.identity.provisioning.cache.ProvisioningEntityCacheEntry;
import org.wso2.carbon.identity.provisioning.cache.ProvisioningEntityCacheKey;
import org.wso2.carbon.identity.provisioning.dao.ProvisioningManagementDAO;

public class CacheBackedProvisioningMgtDAO {
    private static final Log log = LogFactory.getLog(CacheBackedProvisioningMgtDAO.class);
    private ProvisioningManagementDAO provisioningMgtDAO = null;
    private ProvisioningEntityCache provisioningEntityCache = null;

    public CacheBackedProvisioningMgtDAO(ProvisioningManagementDAO provisioningManagementDAO) {
        this.provisioningMgtDAO = provisioningManagementDAO;
        this.provisioningEntityCache = ProvisioningEntityCache.getInstance();
    }

    public void addProvisioningEntity(String identityProviderName, String connectorType, ProvisioningEntity provisioningEntity, int tenantId, String tenantDomain) throws IdentityApplicationManagementException {
        this.provisioningMgtDAO.addProvisioningEntity(identityProviderName, connectorType, provisioningEntity, tenantId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Caching newly added Provisioning Entity : identityProviderName=" + identityProviderName + "&& connectorType=" + connectorType + "&& provisioningEntityType=" + provisioningEntity.getEntityType() + "&& provisioningEntityName=" + provisioningEntity.getEntityName() + "&& provisioningIdentifier=" + provisioningEntity.getIdentifier().getIdentifier()));
        }
        ProvisioningEntityCacheKey cacheKey = new ProvisioningEntityCacheKey(identityProviderName, connectorType, provisioningEntity, tenantDomain);
        ProvisioningEntityCacheEntry entry = new ProvisioningEntityCacheEntry();
        ProvisioningEntity cachedProvisioningEntity = new ProvisioningEntity(provisioningEntity.getEntityType(), provisioningEntity.getOperation());
        ProvisionedIdentifier provisionedIdentifier = provisioningEntity.getIdentifier();
        cachedProvisioningEntity.setIdentifier(provisionedIdentifier);
        entry.setProvisioningEntity(cachedProvisioningEntity);
        this.provisioningEntityCache.addToCache((Serializable)((Object)cacheKey), (Serializable)((Object)entry));
    }

    public ProvisionedIdentifier getProvisionedIdentifier(String identityProviderName, String connectorType, ProvisioningEntity provisioningEntity, int tenantId, String tenantDomain) throws IdentityApplicationManagementException {
        ProvisionedIdentifier provisionedIdentifier;
        ProvisioningEntityCacheKey cacheKey = new ProvisioningEntityCacheKey(identityProviderName, connectorType, provisioningEntity, tenantDomain);
        ProvisioningEntityCacheEntry entry = (ProvisioningEntityCacheEntry)((Object)this.provisioningEntityCache.getValueFromCache((Serializable)((Object)cacheKey)));
        if (entry != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache entry found for Provisioning Entity : identityProviderName=" + identityProviderName + "&& connectorType=" + connectorType + "&& provisioningEntityType=" + provisioningEntity.getEntityType() + "&& provisioningEntityName=" + provisioningEntity.getEntityName()));
            }
            provisioningEntity = entry.getProvisioningEntity();
            return provisioningEntity.getIdentifier();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cache entry not found for Provisioning Entity : identityProviderName=" + identityProviderName + "&& connectorType=" + connectorType + "&& provisioningEntityType=" + provisioningEntity.getEntityType() + "&& provisioningEntityName=" + provisioningEntity.getEntityName() + ". Fetching entity from DB"));
        }
        if ((provisionedIdentifier = this.provisioningMgtDAO.getProvisionedIdentifier(identityProviderName, connectorType, provisioningEntity, tenantId)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entry fetched from DB for Provisioning Entity : identityProviderName=" + identityProviderName + "&& connectorType=" + connectorType + "&& provisioningEntityType=" + provisioningEntity.getEntityType() + "&& provisioningEntityName=" + provisioningEntity.getEntityName() + ". Updating cache"));
            }
            ProvisioningEntity cachedProvisioningEntity = new ProvisioningEntity(provisioningEntity.getEntityType(), provisioningEntity.getOperation());
            cachedProvisioningEntity.setIdentifier(provisionedIdentifier);
            entry = new ProvisioningEntityCacheEntry();
            entry.setProvisioningEntity(cachedProvisioningEntity);
            this.provisioningEntityCache.addToCache((Serializable)((Object)cacheKey), (Serializable)((Object)entry));
            return provisionedIdentifier;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entry for Provisioning Entity : identityProviderName=" + identityProviderName + "&& connectorType=" + connectorType + "&& provisioningEntityType=" + provisioningEntity.getEntityType() + "&& provisioningEntityName=" + provisioningEntity.getEntityName() + " not found in cache or DB"));
        }
        return null;
    }

    public void deleteProvisioningEntity(String identityProviderName, String connectorType, ProvisioningEntity provisioningEntity, int tenantId, String tenantDomain) throws IdentityApplicationManagementException {
        ProvisioningEntityCacheKey cacheKey = new ProvisioningEntityCacheKey(identityProviderName, connectorType, provisioningEntity, tenantDomain);
        ProvisioningEntityCacheEntry entry = (ProvisioningEntityCacheEntry)((Object)this.provisioningEntityCache.getValueFromCache((Serializable)((Object)cacheKey)));
        if (entry != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache entry found for Provisioning Entity : identityProviderName=" + identityProviderName + "&& connectorType=" + connectorType + "&& provisioningEntityType=" + provisioningEntity.getEntityType() + "&& provisioningEntityName=" + provisioningEntity.getEntityName() + ". Hence remove from cache"));
            }
            this.provisioningEntityCache.clearCacheEntry((Serializable)((Object)cacheKey));
        }
        this.provisioningMgtDAO.deleteProvisioningEntity(identityProviderName, connectorType, provisioningEntity, tenantId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entry removed from DB for Provisioning Entity : identityProviderName=" + identityProviderName + "&& connectorType=" + connectorType + "&& provisioningEntityType=" + provisioningEntity.getEntityType() + "&& provisioningEntityName=" + provisioningEntity.getEntityName()));
        }
    }

    public void updateProvisionedEntityName(ProvisioningEntity provisioningEntity) throws IdentityApplicationManagementException {
        this.provisioningMgtDAO.updateProvisioningEntityName(provisioningEntity);
    }

    public String getProvisionedEntityNameByLocalId(String localId) throws IdentityApplicationManagementException {
        return this.provisioningMgtDAO.getProvisionedEntityNameByLocalId(localId);
    }
}

