/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provisioning;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.claim.metadata.mgt.ClaimMetadataHandler;
import org.wso2.carbon.identity.provisioning.ProvisioningEntity;

public class ProvisioningUtil {
    private static final Log log = LogFactory.getLog(ProvisioningUtil.class);

    private ProvisioningUtil() {
    }

    public static List<String> getClaimValues(Map<ClaimMapping, List<String>> attributeMap, String claimUri, String userStoreDomainName) {
        List<String> claimValues = new ArrayList<String>();
        for (Map.Entry<ClaimMapping, List<String>> entry : attributeMap.entrySet()) {
            ClaimMapping mapping = entry.getKey();
            if (mapping.getLocalClaim() == null || !claimUri.equals(mapping.getLocalClaim().getClaimUri())) continue;
            claimValues = entry.getValue();
            break;
        }
        if (userStoreDomainName != null) {
            ArrayList<String> modifiedClaimValues = new ArrayList<String>();
            for (String claimValue : claimValues) {
                if (StringUtils.contains((String)claimValue, (String)"/")) {
                    claimValue = claimValue.substring(claimValue.indexOf("/") + 1);
                }
                claimValue = userStoreDomainName + "/" + claimValue;
                modifiedClaimValues.add(claimValue);
            }
            claimValues = modifiedClaimValues;
        }
        return claimValues;
    }

    public static void setClaimValue(String claimUri, Map<ClaimMapping, List<String>> attributeMap, List<String> attributeList) {
        ClaimMapping clmMapping = null;
        for (Map.Entry<ClaimMapping, List<String>> entry : attributeMap.entrySet()) {
            ClaimMapping mapping = entry.getKey();
            if (mapping.getLocalClaim() == null || !claimUri.equals(mapping.getLocalClaim().getClaimUri())) continue;
            clmMapping = mapping;
            break;
        }
        if (clmMapping != null) {
            attributeMap.put(clmMapping, attributeList);
        }
    }

    public static String getAttributeValue(ProvisioningEntity provisioningEntity, String claimURI) {
        List<String> valueList;
        Map<ClaimMapping, List<String>> attributes = provisioningEntity.getAttributes();
        if (MapUtils.isNotEmpty(attributes) && (valueList = attributes.get(ClaimMapping.build((String)claimURI, null, null, (boolean)false))) != null && !valueList.isEmpty()) {
            return valueList.get(0);
        }
        return null;
    }

    public static Map<ClaimMapping, List<String>> getMappedClaims(String outboundClaimDialect, Map<String, String> inboundClaimValueMap, ClaimMapping[] inboundClaimMappings, Map<ClaimMapping, List<String>> outboundClaimValueMappings, String tenantDomain) throws IdentityApplicationManagementException {
        try {
            if (MapUtils.isEmpty(inboundClaimValueMap)) {
                return outboundClaimValueMappings;
            }
            HashMap<String, String> claimMap = null;
            Map outBoundToCarbonClaimMapppings = null;
            outBoundToCarbonClaimMapppings = ClaimMetadataHandler.getInstance().getMappingsMapFromOtherDialectToCarbon(outboundClaimDialect, null, tenantDomain, true);
            if (outBoundToCarbonClaimMapppings == null) {
                return outboundClaimValueMappings;
            }
            claimMap = new HashMap<String, String>();
            for (ClaimMapping inboundClaimMapping : inboundClaimMappings) {
                if (inboundClaimMapping.getLocalClaim() == null || inboundClaimMapping.getLocalClaim().getClaimUri() == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Inbound claim - local claim is null");
                    continue;
                }
                String outboundClaim = (String)outBoundToCarbonClaimMapppings.get(inboundClaimMapping.getLocalClaim().getClaimUri());
                if (outboundClaim == null || inboundClaimMapping.getRemoteClaim() == null || inboundClaimMapping.getRemoteClaim().getClaimUri() == null) continue;
                claimMap.put(inboundClaimMapping.getRemoteClaim().getClaimUri(), outboundClaim);
            }
            if (claimMap.isEmpty()) {
                return outboundClaimValueMappings;
            }
            for (Map.Entry entry : claimMap.entrySet()) {
                String inboundClaimUri = (String)entry.getKey();
                String outboundClaimUri = (String)entry.getValue();
                String claimValue = null;
                if (outboundClaimUri != null) {
                    claimValue = inboundClaimValueMap.get(inboundClaimUri);
                }
                if (claimValue == null) continue;
                outboundClaimValueMappings.put(ClaimMapping.build((String)inboundClaimUri, (String)outboundClaimUri, null, (boolean)false), Arrays.asList(claimValue));
            }
        }
        catch (Exception e) {
            throw new IdentityApplicationManagementException("Error while loading claim mappings.", (Throwable)e);
        }
        return outboundClaimValueMappings;
    }

    public static Map<ClaimMapping, List<String>> getMappedClaims(String outboundClaimDialect, Map<String, String> inboundClaimValueMap, String inboundClaimMappingDialect, Map<ClaimMapping, List<String>> outboundClaimValueMappings, String tenantDomain) throws IdentityApplicationManagementException {
        try {
            if (MapUtils.isEmpty(inboundClaimValueMap)) {
                return outboundClaimValueMappings;
            }
            HashMap claimMap = null;
            if ("http://wso2.org/claims".equals(inboundClaimMappingDialect)) {
                claimMap = ClaimMetadataHandler.getInstance().getMappingsMapFromOtherDialectToCarbon(outboundClaimDialect, null, tenantDomain, true);
            } else {
                Map inboundToCarbonClaimMaping = null;
                Map outBoundToCarbonClaimMappping = null;
                inboundToCarbonClaimMaping = ClaimMetadataHandler.getInstance().getMappingsMapFromOtherDialectToCarbon(inboundClaimMappingDialect, inboundClaimValueMap.keySet(), tenantDomain, false);
                outBoundToCarbonClaimMappping = ClaimMetadataHandler.getInstance().getMappingsMapFromOtherDialectToCarbon(outboundClaimDialect, null, tenantDomain, true);
                claimMap = new HashMap();
                for (Map.Entry entry : inboundToCarbonClaimMaping.entrySet()) {
                    String outboundClaim = (String)outBoundToCarbonClaimMappping.get(entry.getValue());
                    if (outboundClaim == null) continue;
                    claimMap.put(entry.getKey(), outboundClaim);
                }
            }
            if (claimMap.isEmpty()) {
                return outboundClaimValueMappings;
            }
            for (Map.Entry entry : claimMap.entrySet()) {
                String outboundClaimUri = (String)entry.getValue();
                String inboundClaimUri = (String)entry.getKey();
                String claimValue = null;
                if (outboundClaimUri != null) {
                    claimValue = inboundClaimValueMap.get(inboundClaimUri);
                }
                if (claimValue == null) continue;
                outboundClaimValueMappings.put(ClaimMapping.build((String)inboundClaimUri, (String)outboundClaimUri, null, (boolean)false), Arrays.asList(claimValue));
            }
        }
        catch (Exception e) {
            throw new IdentityApplicationManagementException("Error while loading claim mappings.", (Throwable)e);
        }
        return outboundClaimValueMappings;
    }

    public static Map<ClaimMapping, List<String>> getMappedClaims(ClaimMapping[] outboundClaimMappings, Map<String, String> inboundClaimValueMap, ClaimMapping[] inboundClaimMappings, Map<ClaimMapping, List<String>> outboundClaimValueMappings) throws IdentityApplicationManagementException {
        try {
            if (outboundClaimValueMappings == null) {
                outboundClaimValueMappings = new HashMap<ClaimMapping, List<String>>();
            }
            if (MapUtils.isEmpty(inboundClaimValueMap)) {
                if (outboundClaimMappings != null && outboundClaimMappings.length > 0) {
                    for (ClaimMapping mapping : outboundClaimMappings) {
                        if (mapping.getDefaultValue() == null) continue;
                        outboundClaimValueMappings.put(mapping, Arrays.asList(mapping.getDefaultValue()));
                    }
                }
                return outboundClaimValueMappings;
            }
            if (outboundClaimMappings == null || outboundClaimMappings.length == 0) {
                return outboundClaimValueMappings;
            }
            HashMap<String, String> claimMap = null;
            HashMap<String, String> inboundToCarbonClaimMaping = new HashMap<String, String>();
            HashMap<String, String> outBoundToCarbonClaimMappping = new HashMap<String, String>();
            HashMap<String, String> outboundClaimDefaultValues = new HashMap<String, String>();
            for (ClaimMapping inboundClaimMapping : inboundClaimMappings) {
                if (inboundClaimMapping.getLocalClaim() == null) continue;
                inboundToCarbonClaimMaping.put(inboundClaimMapping.getLocalClaim().getClaimUri(), inboundClaimMapping.getRemoteClaim().getClaimUri());
            }
            for (ClaimMapping outboundClaimMapping : outboundClaimMappings) {
                if (outboundClaimMapping.getLocalClaim() != null) {
                    outBoundToCarbonClaimMappping.put(outboundClaimMapping.getRemoteClaim().getClaimUri(), outboundClaimMapping.getLocalClaim().getClaimUri());
                } else {
                    outBoundToCarbonClaimMappping.put(outboundClaimMapping.getRemoteClaim().getClaimUri(), null);
                }
                outboundClaimDefaultValues.put(outboundClaimMapping.getRemoteClaim().getClaimUri(), outboundClaimMapping.getDefaultValue());
            }
            claimMap = new HashMap<String, String>();
            for (Map.Entry entry : outBoundToCarbonClaimMappping.entrySet()) {
                String localClaimUri = (String)entry.getValue();
                String outboundClaimUri = (String)entry.getKey();
                String inboundClaim = (String)inboundToCarbonClaimMaping.get(localClaimUri);
                claimMap.put(outboundClaimUri, inboundClaim);
            }
            if (claimMap.isEmpty()) {
                return outboundClaimValueMappings;
            }
            for (Map.Entry entry : claimMap.entrySet()) {
                String outboundClaimUri = (String)entry.getKey();
                String inboundClaimUri = (String)entry.getValue();
                if (inboundClaimUri != null && inboundClaimValueMap.get(inboundClaimUri) != null) {
                    outboundClaimValueMappings.put(ClaimMapping.build((String)inboundClaimUri, (String)outboundClaimUri, (String)((String)outboundClaimDefaultValues.get(outboundClaimUri)), (boolean)false), Arrays.asList(inboundClaimValueMap.get(inboundClaimUri)));
                    continue;
                }
                outboundClaimValueMappings.put(ClaimMapping.build((String)inboundClaimUri, (String)outboundClaimUri, (String)((String)outboundClaimDefaultValues.get(outboundClaimUri)), (boolean)false), Arrays.asList((String)outboundClaimDefaultValues.get(outboundClaimUri)));
            }
        }
        catch (Exception e) {
            throw new IdentityApplicationManagementException("Error while loading claim mappings.", (Throwable)e);
        }
        return outboundClaimValueMappings;
    }

    public static Map<ClaimMapping, List<String>> getMappedClaims(ClaimMapping[] outboundClaimMappings, Map<String, String> inboundClaimValueMap, String inboundClaimMappingDialect, Map<ClaimMapping, List<String>> outboundClaimValueMappings, String tenantDomain) throws IdentityApplicationManagementException {
        try {
            if (MapUtils.isEmpty(inboundClaimValueMap)) {
                if (outboundClaimMappings != null && outboundClaimMappings.length > 0) {
                    for (ClaimMapping mapping : outboundClaimMappings) {
                        if (mapping.getDefaultValue() == null) continue;
                        outboundClaimValueMappings.put(mapping, Arrays.asList(mapping.getDefaultValue()));
                    }
                }
                return outboundClaimValueMappings;
            }
            if (outboundClaimMappings == null || outboundClaimMappings.length == 0) {
                return outboundClaimValueMappings;
            }
            HashMap<String, String> claimMap = null;
            Map carbonToInboundClaimMapping = null;
            carbonToInboundClaimMapping = ClaimMetadataHandler.getInstance().getMappingsMapFromOtherDialectToCarbon(inboundClaimMappingDialect, inboundClaimValueMap.keySet(), tenantDomain, true);
            claimMap = new HashMap<String, String>();
            HashMap<String, String> outboundClaimDefaultValues = new HashMap<String, String>();
            for (ClaimMapping outboundClaimMapping : outboundClaimMappings) {
                String inboundClaim = null;
                if (outboundClaimMapping.getLocalClaim() != null) {
                    inboundClaim = (String)carbonToInboundClaimMapping.get(outboundClaimMapping.getLocalClaim().getClaimUri());
                }
                claimMap.put(outboundClaimMapping.getRemoteClaim().getClaimUri(), inboundClaim);
                outboundClaimDefaultValues.put(outboundClaimMapping.getRemoteClaim().getClaimUri(), outboundClaimMapping.getDefaultValue());
            }
            if (claimMap.isEmpty()) {
                return outboundClaimValueMappings;
            }
            for (Map.Entry entry : claimMap.entrySet()) {
                String outboundClaimUri = (String)entry.getKey();
                String inboundClaimUri = (String)entry.getValue();
                if (inboundClaimUri != null && inboundClaimValueMap.get(inboundClaimUri) != null) {
                    outboundClaimValueMappings.put(ClaimMapping.build((String)inboundClaimUri, (String)outboundClaimUri, (String)((String)outboundClaimDefaultValues.get(outboundClaimUri)), (boolean)false), Arrays.asList(inboundClaimValueMap.get(inboundClaimUri)));
                    continue;
                }
                outboundClaimValueMappings.put(ClaimMapping.build((String)inboundClaimUri, (String)outboundClaimUri, (String)((String)outboundClaimDefaultValues.get(outboundClaimUri)), (boolean)false), Arrays.asList((String)outboundClaimDefaultValues.get(outboundClaimUri)));
            }
        }
        catch (Exception e) {
            throw new IdentityApplicationManagementException("Error while loading claim mappings.", (Throwable)e);
        }
        return outboundClaimValueMappings;
    }
}

