/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provisioning;

import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.provisioning.AbstractOutboundProvisioningConnector;
import org.wso2.carbon.identity.provisioning.IdentityProvisioningException;
import org.wso2.carbon.identity.provisioning.ProvisionedIdentifier;
import org.wso2.carbon.identity.provisioning.ProvisioningEntity;
import org.wso2.carbon.identity.provisioning.ProvisioningEntityType;
import org.wso2.carbon.identity.provisioning.ProvisioningOperation;
import org.wso2.carbon.identity.provisioning.ProvisioningUtil;
import org.wso2.carbon.identity.provisioning.dao.CacheBackedProvisioningMgtDAO;
import org.wso2.carbon.idp.mgt.util.IdPManagementUtil;
import org.wso2.carbon.user.api.UserStoreException;

public class ProvisioningThread
implements Callable<Boolean> {
    private ProvisioningEntity provisioningEntity;
    private String tenantDomainName;
    private AbstractOutboundProvisioningConnector connector;
    private String connectorType;
    private String idPName;
    private CacheBackedProvisioningMgtDAO dao;
    private static final Log log = LogFactory.getLog(ProvisioningThread.class);

    public ProvisioningThread(ProvisioningEntity provisioningEntity, String tenantDomainName, AbstractOutboundProvisioningConnector connector, String connectorType, String idPName, CacheBackedProvisioningMgtDAO dao) {
        this.provisioningEntity = provisioningEntity;
        this.tenantDomainName = tenantDomainName;
        this.connector = connector;
        this.connectorType = connectorType;
        this.idPName = idPName;
        this.dao = dao;
    }

    @Override
    public Boolean call() throws IdentityProvisioningException {
        boolean success = false;
        String tenantDomainName = this.tenantDomainName;
        try {
            String newGroupName;
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomainName);
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.getTenantIdFromDomain(tenantDomainName));
            ProvisionedIdentifier provisionedIdentifier = null;
            provisionedIdentifier = this.connector.provision(this.provisioningEntity);
            if (this.provisioningEntity.getOperation() == ProvisioningOperation.DELETE) {
                this.deleteProvisionedEntityIdentifier(this.idPName, this.connectorType, this.provisioningEntity, tenantDomainName);
            } else if (this.provisioningEntity.getOperation() == ProvisioningOperation.POST) {
                if (provisionedIdentifier == null || provisionedIdentifier.getIdentifier() == null) {
                    provisionedIdentifier = new ProvisionedIdentifier();
                    provisionedIdentifier.setIdentifier(UUID.randomUUID().toString());
                }
                this.provisioningEntity.setIdentifier(provisionedIdentifier);
                this.storeProvisionedEntityIdentifier(this.idPName, this.connectorType, this.provisioningEntity, tenantDomainName);
            } else if (this.provisioningEntity.getEntityType() == ProvisioningEntityType.GROUP && this.provisioningEntity.getOperation() == ProvisioningOperation.PUT && (newGroupName = ProvisioningUtil.getAttributeValue(this.provisioningEntity, "org:wso2:carbon:identity:provisioning:claim:group:name:new")) != null) {
                this.dao.updateProvisionedEntityName(this.provisioningEntity);
            }
            success = true;
        }
        catch (Exception e) {
            String errMsg = " Provisioning for Entity " + this.provisioningEntity.getEntityName() + " For operation = " + this.provisioningEntity.getOperation();
            log.error((Object)errMsg, (Throwable)e);
            throw new IdentityProvisioningException(errMsg, e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
            if (tenantDomainName != null) {
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomainName);
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.getTenantIdFromDomain(tenantDomainName));
            }
        }
        return success;
    }

    private void storeProvisionedEntityIdentifier(String idpName, String connectorType, ProvisioningEntity provisioningEntity, String tenantDomain) throws IdentityApplicationManagementException {
        try {
            int tenantId = IdPManagementUtil.getTenantIdOfDomain((String)tenantDomain);
            this.dao.addProvisioningEntity(idpName, connectorType, provisioningEntity, tenantId, tenantDomain);
        }
        catch (UserStoreException e) {
            throw new IdentityApplicationManagementException("Error while storing provisioning identifier.", (Throwable)e);
        }
    }

    private void deleteProvisionedEntityIdentifier(String idpName, String connectorType, ProvisioningEntity provisioningEntity, String tenantDomain) throws IdentityApplicationManagementException {
        try {
            int tenantId = IdPManagementUtil.getTenantIdOfDomain((String)tenantDomain);
            this.dao.deleteProvisioningEntity(idpName, connectorType, provisioningEntity, tenantId, tenantDomain);
        }
        catch (UserStoreException e) {
            throw new IdentityApplicationManagementException("Error while deleting provisioning identifier.", (Throwable)e);
        }
    }

    private int getTenantIdFromDomain(String tenantDomainName) throws IdentityProvisioningException {
        if (StringUtils.isBlank((String)tenantDomainName)) {
            throw new IdentityProvisioningException("Provided tenant domain is invalid");
        }
        try {
            return IdPManagementUtil.getTenantIdOfDomain((String)tenantDomainName);
        }
        catch (UserStoreException e) {
            throw new IdentityProvisioningException("Error occurred while resolving tenant Id from tenant domain :" + tenantDomainName, e);
        }
    }
}

