/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provisioning;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.util.AnonymousSessionUtil;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.OutboundProvisioningConfig;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.ProvisioningConnectorConfig;
import org.wso2.carbon.identity.application.common.model.RoleMapping;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.provisioning.AbstractOutboundProvisioningConnector;
import org.wso2.carbon.identity.provisioning.AbstractProvisioningConnectorFactory;
import org.wso2.carbon.identity.provisioning.IdentityProvisioningException;
import org.wso2.carbon.identity.provisioning.ProvisionedIdentifier;
import org.wso2.carbon.identity.provisioning.ProvisioningEntity;
import org.wso2.carbon.identity.provisioning.ProvisioningEntityType;
import org.wso2.carbon.identity.provisioning.ProvisioningOperation;
import org.wso2.carbon.identity.provisioning.ProvisioningThread;
import org.wso2.carbon.identity.provisioning.ProvisioningUtil;
import org.wso2.carbon.identity.provisioning.RuntimeProvisioningConfig;
import org.wso2.carbon.identity.provisioning.cache.ServiceProviderProvisioningConnectorCache;
import org.wso2.carbon.identity.provisioning.cache.ServiceProviderProvisioningConnectorCacheEntry;
import org.wso2.carbon.identity.provisioning.cache.ServiceProviderProvisioningConnectorCacheKey;
import org.wso2.carbon.identity.provisioning.dao.CacheBackedProvisioningMgtDAO;
import org.wso2.carbon.identity.provisioning.dao.ProvisioningManagementDAO;
import org.wso2.carbon.identity.provisioning.internal.IdentityProvisionServiceComponent;
import org.wso2.carbon.identity.provisioning.rules.XACMLBasedRuleHandler;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;
import org.wso2.carbon.idp.mgt.util.IdPManagementUtil;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class OutboundProvisioningManager {
    private static final Log log = LogFactory.getLog(OutboundProvisioningManager.class);
    private static CacheBackedProvisioningMgtDAO dao = new CacheBackedProvisioningMgtDAO(new ProvisioningManagementDAO());
    private static OutboundProvisioningManager provisioningManager = new OutboundProvisioningManager();

    private OutboundProvisioningManager() {
    }

    public static OutboundProvisioningManager getInstance() {
        return provisioningManager;
    }

    private static int getTenantIdOfDomain(String tenantDomain) throws IdentityApplicationManagementException {
        try {
            return IdPManagementUtil.getTenantIdOfDomain((String)tenantDomain);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            String msg = "Error occurred while getting Tenant Id from Tenant domain " + tenantDomain;
            throw new IdentityApplicationManagementException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, RuntimeProvisioningConfig> getOutboundProvisioningConnectors(ServiceProvider serviceProvider, String tenantDomainName) throws IdentityProvisioningException {
        ServiceProviderProvisioningConnectorCacheEntry entry;
        ServiceProviderProvisioningConnectorCacheKey key;
        int tenantId;
        String tenantDomain;
        HashMap<String, RuntimeProvisioningConfig> connectors;
        block20: {
            connectors = new HashMap<String, RuntimeProvisioningConfig>();
            tenantDomain = null;
            tenantId = -1234;
            key = null;
            entry = null;
            if (CarbonContext.getThreadLocalCarbonContext() != null) {
                tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
                tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
            }
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantId(-1234);
                carbonContext.setTenantDomain("carbon.super");
                if (serviceProvider != null && tenantDomain != null) {
                    key = new ServiceProviderProvisioningConnectorCacheKey(serviceProvider.getApplicationName(), tenantDomain);
                    entry = (ServiceProviderProvisioningConnectorCacheEntry)((Object)ServiceProviderProvisioningConnectorCache.getInstance().getValueFromCache((Serializable)((Object)key)));
                    if (entry != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Provisioning cache HIT for " + serviceProvider + " of " + tenantDomainName));
                        }
                        Map<String, RuntimeProvisioningConfig> map = entry.getConnectors();
                        return map;
                    }
                    break block20;
                }
                throw new IdentityProvisioningException("Error reading service provider from cache.");
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
                if (tenantDomain != null) {
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain);
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId);
                }
            }
        }
        Map<String, AbstractProvisioningConnectorFactory> registeredConnectorFactories = IdentityProvisionServiceComponent.getConnectorFactories();
        OutboundProvisioningConfig outboundProvisioningConfiguration = serviceProvider.getOutboundProvisioningConfig();
        if (outboundProvisioningConfiguration == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No outbound provisioning configuration defined for local service provider.");
            }
            return new HashMap<String, RuntimeProvisioningConfig>();
        }
        IdentityProvider[] provisionningIdPList = outboundProvisioningConfiguration.getProvisioningIdentityProviders();
        if (provisionningIdPList != null && provisionningIdPList.length > 0) {
            for (IdentityProvider fIdP : provisionningIdPList) {
                try {
                    AbstractOutboundProvisioningConnector connector;
                    ProvisioningConnectorConfig defaultConnector = fIdP.getDefaultProvisioningConnectorConfig();
                    if (defaultConnector == null) continue;
                    String connectorType = fIdP.getDefaultProvisioningConnectorConfig().getName();
                    boolean enableJitProvisioning = false;
                    if (fIdP.getJustInTimeProvisioningConfig() != null && fIdP.getJustInTimeProvisioningConfig().isProvisioningEnabled()) {
                        enableJitProvisioning = true;
                    }
                    if ((connector = this.getOutboundProvisioningConnector(fIdP, registeredConnectorFactories, tenantDomainName, enableJitProvisioning)) == null) continue;
                    RuntimeProvisioningConfig proConfig = new RuntimeProvisioningConfig();
                    proConfig.setProvisioningConnectorEntry(new AbstractMap.SimpleEntry<String, AbstractOutboundProvisioningConnector>(connectorType, connector));
                    proConfig.setBlocking(defaultConnector.isBlocking());
                    proConfig.setPolicyEnabled(defaultConnector.isRulesEnabled());
                    connectors.put(fIdP.getIdentityProviderName(), proConfig);
                }
                catch (IdentityProviderManagementException e) {
                    throw new IdentityProvisioningException("Error while retrieving idp configuration for " + fIdP.getIdentityProviderName(), e);
                }
            }
        }
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(-1234);
            carbonContext.setTenantDomain("carbon.super");
            entry = new ServiceProviderProvisioningConnectorCacheEntry();
            entry.setConnectors(connectors);
            ServiceProviderProvisioningConnectorCache.getInstance().addToCache((Serializable)((Object)key), (Serializable)((Object)entry));
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain);
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entry added successfully ");
        }
        return connectors;
    }

    private AbstractOutboundProvisioningConnector getOutboundProvisioningConnector(IdentityProvider fIdP, Map<String, AbstractProvisioningConnectorFactory> registeredConnectorFactories, String tenantDomainName, boolean enableJitProvisioning) throws IdentityProviderManagementException, IdentityProvisioningException {
        String idpName = fIdP.getIdentityProviderName();
        String connectorType = fIdP.getDefaultProvisioningConnectorConfig().getName();
        fIdP = IdentityProviderManager.getInstance().getEnabledIdPByName(idpName, tenantDomainName);
        if (fIdP == null) {
            throw new IdentityProvisioningException("Provisioning identity provider not available in the system. Idp Name : " + idpName);
        }
        ProvisioningConnectorConfig[] provisioningConfigs = fIdP.getProvisioningConnectorConfigs();
        if (provisioningConfigs != null && provisioningConfigs.length > 0) {
            for (ProvisioningConnectorConfig defaultProvisioningConfig : provisioningConfigs) {
                if (!connectorType.equals(defaultProvisioningConfig.getName()) || !defaultProvisioningConfig.isEnabled()) continue;
                AbstractProvisioningConnectorFactory factory = registeredConnectorFactories.get(connectorType);
                Property[] provisioningProperties = defaultProvisioningConfig.getProvisioningProperties();
                if (enableJitProvisioning) {
                    Property jitEnabled = new Property();
                    jitEnabled.setName("jitProvisioningEnabled");
                    jitEnabled.setValue("1");
                    provisioningProperties = IdentityApplicationManagementUtil.concatArrays((Property[])provisioningProperties, (Property[])new Property[]{jitEnabled});
                }
                Property userIdClaimURL = new Property();
                userIdClaimURL.setName("userIdClaimUri");
                if (fIdP.getClaimConfig() != null && fIdP.getClaimConfig().getUserClaimURI() != null) {
                    userIdClaimURL.setValue(fIdP.getClaimConfig().getUserClaimURI());
                } else {
                    userIdClaimURL.setValue("");
                }
                ArrayList<Property> provisioningPropertiesList = new ArrayList<Property>(Arrays.asList(provisioningProperties));
                provisioningPropertiesList.add(userIdClaimURL);
                provisioningProperties = new Property[provisioningPropertiesList.size()];
                provisioningProperties = provisioningPropertiesList.toArray(provisioningProperties);
                return factory.getConnector(idpName, provisioningProperties, tenantDomainName);
            }
        }
        return null;
    }

    public void provision(ProvisioningEntity provisioningEntity, String serviceProviderIdentifier, String inboundClaimDialect, String tenantDomainName, boolean jitProvisioning) throws IdentityProvisioningException {
        try {
            ServiceProvider serviceProvider;
            if (provisioningEntity.getEntityName() == null) {
                this.setProvisioningEntityName(provisioningEntity);
            }
            if ((serviceProvider = ApplicationManagementService.getInstance().getServiceProvider(serviceProviderIdentifier, tenantDomainName)) == null) {
                throw new IdentityProvisioningException("Invalid service provider name : " + serviceProviderIdentifier);
            }
            ClaimMapping[] spClaimMappings = null;
            if (inboundClaimDialect == null && serviceProvider.getClaimConfig() != null) {
                spClaimMappings = serviceProvider.getClaimConfig().getClaimMappings();
            }
            Map<String, RuntimeProvisioningConfig> connectors = this.getOutboundProvisioningConnectors(serviceProvider, tenantDomainName);
            ExecutorService executors = null;
            if (MapUtils.isNotEmpty(connectors)) {
                executors = Executors.newFixedThreadPool(connectors.size());
            }
            for (Map.Entry<String, RuntimeProvisioningConfig> entry : connectors.entrySet()) {
                ProvisioningEntity outboundProEntity;
                Map.Entry<String, AbstractOutboundProvisioningConnector> connectorEntry = entry.getValue().getProvisioningConnectorEntry();
                AbstractOutboundProvisioningConnector connector = connectorEntry.getValue();
                String connectorType = connectorEntry.getKey();
                String idPName = entry.getKey();
                IdentityProvider provisioningIdp = IdentityProviderManager.getInstance().getIdPByName(idPName, tenantDomainName);
                if (provisioningIdp == null) {
                    throw new IdentityProvisioningException("Invalid identity provider name : " + idPName);
                }
                String outboundClaimDialect = connector.getClaimDialectUri();
                if (outboundClaimDialect == null && (provisioningIdp.getClaimConfig() == null || provisioningIdp.getClaimConfig().isLocalClaimDialect())) {
                    outboundClaimDialect = "http://wso2.org/claims";
                }
                ClaimMapping[] idpClaimMappings = null;
                if (provisioningIdp.getClaimConfig() != null) {
                    idpClaimMappings = provisioningIdp.getClaimConfig().getClaimMappings();
                }
                Map<ClaimMapping, List<String>> mapppedClaims = this.getMappedClaims(inboundClaimDialect, outboundClaimDialect, provisioningEntity, spClaimMappings, idpClaimMappings, tenantDomainName);
                if (provisioningIdp.getPermissionAndRoleConfig() != null) {
                    this.updateProvisioningUserWithMappedRoles(provisioningEntity, provisioningIdp.getPermissionAndRoleConfig().getRoleMappings());
                }
                ProvisionedIdentifier provisionedIdentifier = this.getProvisionedEntityIdentifier(idPName, connectorType, provisioningEntity, tenantDomainName);
                ProvisioningOperation provisioningOp = provisioningEntity.getOperation();
                if (ProvisioningOperation.DELETE.equals(provisioningOp) && (provisionedIdentifier == null || provisionedIdentifier.getIdentifier() == null)) {
                    return;
                }
                if (provisionedIdentifier == null || provisionedIdentifier.getIdentifier() == null) {
                    provisioningOp = ProvisioningOperation.POST;
                }
                String[] provisionByRoleList = new String[]{};
                if (provisioningIdp.getProvisioningRole() != null) {
                    provisionByRoleList = provisioningIdp.getProvisioningRole().trim().split("\\s*,[,\\s]*");
                }
                if (provisioningEntity.getEntityType() == ProvisioningEntityType.GROUP && Arrays.asList(provisionByRoleList).contains(provisioningEntity.getEntityName())) {
                    boolean isBlocking;
                    ProvisioningThread proThread;
                    Map<ClaimMapping, List<String>> mappedUserClaims;
                    ProvisionedIdentifier provisionedUserIdentifier;
                    ProvisioningEntity inboundProvisioningEntity;
                    Map<ClaimMapping, List<String>> attributes = provisioningEntity.getAttributes();
                    List<String> newUsersList = attributes.get(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:new:claim:user", null, null, (boolean)false));
                    List<String> deletedUsersList = attributes.get(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:deleted:claim:user", null, null, (boolean)false));
                    for (String user : newUsersList) {
                        inboundProvisioningEntity = this.getInboundProvisioningEntity(provisioningEntity, tenantDomainName, ProvisioningOperation.POST, user);
                        provisionedUserIdentifier = this.getProvisionedEntityIdentifier(idPName, connectorType, inboundProvisioningEntity, tenantDomainName);
                        if (provisionedUserIdentifier != null && provisionedUserIdentifier.getIdentifier() != null) continue;
                        mappedUserClaims = this.getMappedClaims(inboundClaimDialect, outboundClaimDialect, inboundProvisioningEntity, spClaimMappings, idpClaimMappings, tenantDomainName);
                        outboundProEntity = new ProvisioningEntity(ProvisioningEntityType.USER, user, ProvisioningOperation.POST, mappedUserClaims);
                        proThread = new ProvisioningThread(outboundProEntity, tenantDomainName, connector, connectorType, idPName, dao);
                        outboundProEntity.setIdentifier(provisionedIdentifier);
                        outboundProEntity.setJitProvisioning(jitProvisioning);
                        isBlocking = entry.getValue().isBlocking();
                        this.executeOutboundProvisioning(provisioningEntity, executors, connectorType, idPName, proThread, isBlocking);
                    }
                    for (String user : deletedUsersList) {
                        inboundProvisioningEntity = this.getInboundProvisioningEntity(provisioningEntity, tenantDomainName, ProvisioningOperation.DELETE, user);
                        provisionedUserIdentifier = this.getProvisionedEntityIdentifier(idPName, connectorType, inboundProvisioningEntity, tenantDomainName);
                        if (provisionedUserIdentifier == null || provisionedUserIdentifier.getIdentifier() == null) continue;
                        mappedUserClaims = this.getMappedClaims(inboundClaimDialect, outboundClaimDialect, inboundProvisioningEntity, spClaimMappings, idpClaimMappings, tenantDomainName);
                        outboundProEntity = new ProvisioningEntity(ProvisioningEntityType.USER, user, ProvisioningOperation.DELETE, mappedUserClaims);
                        proThread = new ProvisioningThread(outboundProEntity, tenantDomainName, connector, connectorType, idPName, dao);
                        outboundProEntity.setIdentifier(provisionedUserIdentifier);
                        outboundProEntity.setJitProvisioning(jitProvisioning);
                        isBlocking = entry.getValue().isBlocking();
                        this.executeOutboundProvisioning(provisioningEntity, executors, connectorType, idPName, proThread, isBlocking);
                    }
                    continue;
                }
                if (!this.canUserBeProvisioned(provisioningEntity, provisionByRoleList, tenantDomainName)) {
                    if (!this.canUserBeDeProvisioned(provisionedIdentifier)) continue;
                    provisioningOp = ProvisioningOperation.DELETE;
                }
                outboundProEntity = new ProvisioningEntity(provisioningEntity.getEntityType(), provisioningEntity.getEntityName(), provisioningOp, mapppedClaims);
                ProvisioningThread proThread = new ProvisioningThread(outboundProEntity, tenantDomainName, connector, connectorType, idPName, dao);
                outboundProEntity.setIdentifier(provisionedIdentifier);
                outboundProEntity.setJitProvisioning(jitProvisioning);
                boolean isAllowed = true;
                boolean isBlocking = entry.getValue().isBlocking();
                boolean isPolicyEnabled = entry.getValue().isPolicyEnabled();
                if (isPolicyEnabled) {
                    isAllowed = XACMLBasedRuleHandler.getInstance().isAllowedToProvision(tenantDomainName, provisioningEntity, serviceProvider, idPName, connectorType);
                }
                if (!isAllowed) continue;
                this.executeOutboundProvisioning(provisioningEntity, executors, connectorType, idPName, proThread, isBlocking);
            }
            if (executors != null) {
                executors.shutdown();
            }
        }
        catch (CarbonException | IdentityApplicationManagementException | IdentityProviderManagementException | UserStoreException e) {
            throw new IdentityProvisioningException("Error occurred while checking for user provisioning", e);
        }
    }

    private void executeOutboundProvisioning(ProvisioningEntity provisioningEntity, ExecutorService executors, String connectorType, String idPName, Callable<Boolean> proThread, boolean isBlocking) throws IdentityProvisioningException {
        if (!isBlocking) {
            executors.submit(proThread);
        } else {
            try {
                boolean success = proThread.call();
                if (!success) {
                    if (executors != null) {
                        executors.shutdown();
                    }
                    throw new IdentityProvisioningException(this.generateMessageOnFailureProvisioningOperation(idPName, connectorType, provisioningEntity));
                }
            }
            catch (Exception e) {
                this.handleException(idPName, connectorType, provisioningEntity, executors, e);
            }
        }
    }

    private ProvisioningEntity getInboundProvisioningEntity(ProvisioningEntity provisioningEntity, String tenantDomain, ProvisioningOperation operation, String userName) throws CarbonException, UserStoreException {
        List<String> roleListOfUser;
        HashMap<ClaimMapping, List<String>> outboundAttributes = new HashMap<ClaimMapping, List<String>>();
        if (userName != null) {
            outboundAttributes.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:username", null, null, (boolean)false), Arrays.asList(userName));
        }
        if ((roleListOfUser = this.getUserRoles(userName, tenantDomain)) != null) {
            outboundAttributes.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:group", null, null, (boolean)false), roleListOfUser);
        }
        String domainAwareName = userName;
        String domainName = this.getDomainFromName(provisioningEntity.getEntityName());
        if (domainName != null && !domainName.equals("Internal")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding domain name : " + domainName + " to user : " + userName));
            }
            domainAwareName = UserCoreUtil.addDomainToName((String)userName, (String)domainName);
        }
        ProvisioningEntity inboundProvisioningEntity = new ProvisioningEntity(ProvisioningEntityType.USER, domainAwareName, operation, outboundAttributes);
        inboundProvisioningEntity.setInboundAttributes(this.getUserClaims(userName, tenantDomain));
        return inboundProvisioningEntity;
    }

    private String generateMessageOnFailureProvisioningOperation(String idPName, String connectorType, ProvisioningEntity provisioningEntity) {
        if (log.isDebugEnabled()) {
            String errMsg = "Provisioning failed for IDP = " + idPName + " Connector Type =" + connectorType + " ";
            errMsg = errMsg + " Provisioned entity name = " + provisioningEntity.getEntityName() + " For operation = " + provisioningEntity.getOperation() + " failed  ";
            log.error((Object)errMsg);
        }
        return "Provisioning failed for IDP = " + idPName + " with Entity name=" + provisioningEntity.getEntityName();
    }

    private void updateProvisioningUserWithMappedRoles(ProvisioningEntity provisioningEntity, RoleMapping[] idPRoleMapping) {
        if (ArrayUtils.isEmpty((Object[])idPRoleMapping)) {
            return;
        }
        this.updateMappedGroupForAttribute(provisioningEntity, idPRoleMapping, "org:wso2:carbon:identity:provisioning:claim:group");
        this.updateMappedGroupForAttribute(provisioningEntity, idPRoleMapping, "org:wso2:carbon:identity:provisioning:new:claim:group");
        this.updateMappedGroupForAttribute(provisioningEntity, idPRoleMapping, "org:wso2:carbon:identity:provisioning:deleted:claim:group");
    }

    private List<String> getMappedGroups(List<String> groupList, RoleMapping[] idPRoleMapping) {
        if (CollectionUtils.isEmpty(groupList)) {
            return new ArrayList<String>();
        }
        HashMap<String, String> mappedRoles = new HashMap<String, String>();
        for (RoleMapping mapping : idPRoleMapping) {
            mappedRoles.put(mapping.getLocalRole().getLocalRoleName(), mapping.getRemoteRole());
        }
        ArrayList<String> mappedUserGroups = new ArrayList<String>();
        for (String userGroup : groupList) {
            String mappedGroup = null;
            mappedGroup = (String)mappedRoles.get(userGroup);
            if (mappedGroup == null) continue;
            mappedUserGroups.add(mappedGroup);
        }
        return mappedUserGroups;
    }

    private Map<ClaimMapping, List<String>> getMappedClaims(String inboundClaimDialect, String outboundClaimDialect, ProvisioningEntity provisioningEntity, ClaimMapping[] spClaimMappings, ClaimMapping[] idpClaimMappings, String tenantDomainName) throws IdentityApplicationManagementException {
        Map<String, String> inboundAttributes = provisioningEntity.getInboundAttributes();
        if (outboundClaimDialect != null) {
            if (inboundClaimDialect == null) {
                return ProvisioningUtil.getMappedClaims(outboundClaimDialect, inboundAttributes, spClaimMappings, provisioningEntity.getAttributes(), tenantDomainName);
            }
            return ProvisioningUtil.getMappedClaims(outboundClaimDialect, inboundAttributes, inboundClaimDialect, provisioningEntity.getAttributes(), tenantDomainName);
        }
        if (inboundClaimDialect == null) {
            return ProvisioningUtil.getMappedClaims(idpClaimMappings, inboundAttributes, spClaimMappings, provisioningEntity.getAttributes());
        }
        return ProvisioningUtil.getMappedClaims(idpClaimMappings, inboundAttributes, inboundClaimDialect, provisioningEntity.getAttributes(), tenantDomainName);
    }

    protected List<String> getGroupNames(Map<ClaimMapping, List<String>> attributeMap) {
        return ProvisioningUtil.getClaimValues(attributeMap, "org:wso2:carbon:identity:provisioning:claim:group", null);
    }

    private String getUserName(Map<ClaimMapping, List<String>> attributeMap) {
        List<String> userList = ProvisioningUtil.getClaimValues(attributeMap, "org:wso2:carbon:identity:provisioning:claim:username", null);
        if (CollectionUtils.isNotEmpty(userList)) {
            return userList.get(0);
        }
        return null;
    }

    protected boolean canUserBeProvisioned(ProvisioningEntity provisioningEntity, String[] provisionByRoleList, String tenantDomain) throws UserStoreException, CarbonException {
        if (provisioningEntity.getEntityType() != ProvisioningEntityType.USER || provisionByRoleList == null || provisionByRoleList.length == 0) {
            return true;
        }
        if (provisioningEntity.getAttributes() != null) {
            String userName = this.getUserName(provisioningEntity.getAttributes());
            List<String> provisioningRoleList = Arrays.asList(provisionByRoleList);
            List<String> roleListOfUser = this.getUserRoles(userName, tenantDomain);
            if (this.userHasProvisioningRoles(roleListOfUser, provisioningRoleList, userName)) {
                return true;
            }
            List<String> newRoleListOfUser = provisioningEntity.getAttributes().get(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:group", null, null, (boolean)false));
            if (this.userHasProvisioningRoles(newRoleListOfUser, provisioningRoleList, userName)) {
                return true;
            }
        }
        return false;
    }

    protected boolean canUserBeDeProvisioned(ProvisionedIdentifier provisionedIdentifier) throws UserStoreException, CarbonException, IdentityApplicationManagementException {
        return provisionedIdentifier != null && provisionedIdentifier.getIdentifier() != null;
    }

    private List<String> getUserRoles(String userName, String tenantDomain) throws CarbonException, UserStoreException {
        RegistryService registryService = IdentityProvisionServiceComponent.getRegistryService();
        RealmService realmService = IdentityProvisionServiceComponent.getRealmService();
        UserRealm realm = AnonymousSessionUtil.getRealmByTenantDomain((RegistryService)registryService, (RealmService)realmService, (String)tenantDomain);
        UserStoreManager userstore = null;
        userstore = realm.getUserStoreManager();
        String[] newRoles = userstore.getRoleListOfUser(userName);
        return Arrays.asList(newRoles);
    }

    private Map<String, String> getUserClaims(String userName, String tenantDomain) throws CarbonException, UserStoreException {
        HashMap<String, String> inboundAttributes = new HashMap<String, String>();
        RegistryService registryService = IdentityProvisionServiceComponent.getRegistryService();
        RealmService realmService = IdentityProvisionServiceComponent.getRealmService();
        UserRealm realm = AnonymousSessionUtil.getRealmByTenantDomain((RegistryService)registryService, (RealmService)realmService, (String)tenantDomain);
        UserStoreManager userstore = null;
        userstore = realm.getUserStoreManager();
        Claim[] claimArray = null;
        try {
            claimArray = userstore.getUserClaimValues(userName, null);
        }
        catch (UserStoreException e) {
            if (e.getMessage().contains("UserNotFound")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User " + userName + " not found in user store"));
                }
            }
            throw e;
        }
        if (claimArray != null) {
            for (Claim claim : claimArray) {
                inboundAttributes.put(claim.getClaimUri(), claim.getValue());
            }
        }
        return inboundAttributes;
    }

    private String getUserIdClaimValue(String userIdClaimURI, String tenantDomainName) {
        return null;
    }

    private ProvisionedIdentifier getProvisionedEntityIdentifier(String idpName, String connectorType, ProvisioningEntity provisioningEntity, String tenantDomain) throws IdentityApplicationManagementException {
        int tenantId = OutboundProvisioningManager.getTenantIdOfDomain(tenantDomain);
        return dao.getProvisionedIdentifier(idpName, connectorType, provisioningEntity, tenantId, tenantDomain);
    }

    private String getDomainFromName(String name) {
        int index = name.indexOf("/");
        if (index > 0) {
            String domain = name.substring(0, index);
            return domain;
        }
        return "PRIMARY";
    }

    protected void handleException(String idPName, String connectorType, ProvisioningEntity provisioningEntity, ExecutorService executors, Exception e) {
        if (log.isDebugEnabled()) {
            log.debug((Object)this.generateMessageOnFailureProvisioningOperation(idPName, connectorType, provisioningEntity), (Throwable)e);
        }
    }

    private ProvisioningEntity setProvisioningEntityName(ProvisioningEntity provisioningEntity) throws IdentityApplicationManagementException {
        String provisionedEntityName = dao.getProvisionedEntityNameByLocalId(ProvisioningUtil.getAttributeValue(provisioningEntity, "org:wso2:carbon:identity:provisioning:claim:id"));
        Map<ClaimMapping, List<String>> attributeList = provisioningEntity.getAttributes();
        ProvisioningEntityType provisioningEntityType = provisioningEntity.getEntityType();
        ProvisioningOperation provisioningOperation = provisioningEntity.getOperation();
        if (ProvisioningEntityType.USER.equals(provisioningEntityType)) {
            attributeList.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:username", null, null, (boolean)false), Arrays.asList(provisionedEntityName));
        } else if (ProvisioningEntityType.GROUP.equals(provisioningEntityType)) {
            String oldGroupName;
            if (ProvisioningOperation.PUT.equals(provisioningOperation)) {
                oldGroupName = provisionedEntityName;
                String currentGroupName = ProvisioningUtil.getAttributeValue(provisioningEntity, "org:wso2:carbon:identity:provisioning:claim:group");
                if (!oldGroupName.equals(currentGroupName)) {
                    attributeList.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:group:name:old", null, null, (boolean)false), Arrays.asList(oldGroupName));
                    attributeList.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:group:name:new", null, null, (boolean)false), Arrays.asList(currentGroupName));
                }
            } else if (ProvisioningOperation.PATCH.equals(provisioningOperation)) {
                oldGroupName = provisionedEntityName;
                String currentGroupName = ProvisioningUtil.getAttributeValue(provisioningEntity, "org:wso2:carbon:identity:provisioning:claim:group");
                if (currentGroupName == null) {
                    currentGroupName = oldGroupName;
                }
                if (!oldGroupName.equals(currentGroupName)) {
                    attributeList.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:group:name:old", null, null, (boolean)false), Arrays.asList(oldGroupName));
                    attributeList.put(ClaimMapping.build((String)"org:wso2:carbon:identity:provisioning:claim:group:name:new", null, null, (boolean)false), Arrays.asList(currentGroupName));
                }
            }
        }
        String userStoreDomain = ProvisioningUtil.getAttributeValue(provisioningEntity, "org:wso2:carbon:identity:provisioning:claim:domain");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding domain name : " + userStoreDomain + " to name : " + provisionedEntityName));
        }
        provisioningEntity.setEntityName(UserCoreUtil.addDomainToName((String)provisionedEntityName, (String)userStoreDomain));
        return provisioningEntity;
    }

    private void updateMappedGroupForAttribute(ProvisioningEntity provisioningEntity, RoleMapping[] idPRoleMapping, String groupAttributeName) {
        List<String> groupList = ProvisioningUtil.getClaimValues(provisioningEntity.getAttributes(), groupAttributeName, null);
        List<String> mappedGroups = this.getMappedGroups(groupList, idPRoleMapping);
        if (mappedGroups != null && !mappedGroups.isEmpty()) {
            ProvisioningUtil.setClaimValue(groupAttributeName, provisioningEntity.getAttributes(), mappedGroups);
        }
    }

    private boolean userHasProvisioningRoles(List<String> userRoles, List<String> provisioningRoles, String userName) {
        if (CollectionUtils.isNotEmpty(userRoles) && CollectionUtils.isNotEmpty(provisioningRoles)) {
            for (String provisioningRole : provisioningRoles) {
                if (!userRoles.contains(provisioningRole)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User with userName : " + userName + " has provisioning role(s) assigned."));
                }
                return true;
            }
        }
        return false;
    }
}

