/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provisioning;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.provisioning.AbstractOutboundProvisioningConnector;
import org.wso2.carbon.identity.provisioning.IdentityProvisioningException;
import org.wso2.carbon.identity.provisioning.cache.ProvisioningConnectorCache;
import org.wso2.carbon.identity.provisioning.cache.ProvisioningConnectorCacheEntry;
import org.wso2.carbon.identity.provisioning.cache.ProvisioningConnectorCacheKey;

public abstract class AbstractProvisioningConnectorFactory {
    private static final Log log = LogFactory.getLog(AbstractProvisioningConnectorFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractOutboundProvisioningConnector getConnector(String identityProviderName, Property[] provisoningProperties, String tenantDomain) throws IdentityProvisioningException {
        String tenantDomainName = null;
        int tenantId = -1234;
        if (CarbonContext.getThreadLocalCarbonContext() != null) {
            tenantDomainName = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        }
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(-1234);
            carbonContext.setTenantDomain("carbon.super");
            ProvisioningConnectorCacheKey cacheKey = new ProvisioningConnectorCacheKey(identityProviderName, tenantDomain);
            ProvisioningConnectorCacheEntry entry = (ProvisioningConnectorCacheEntry)((Object)ProvisioningConnectorCache.getInstance().getValueFromCache((Serializable)((Object)cacheKey)));
            if (entry != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Provisioning cache HIT for " + identityProviderName + " of " + tenantDomain));
                }
                AbstractOutboundProvisioningConnector abstractOutboundProvisioningConnector = entry.getProvisioningConnector();
                return abstractOutboundProvisioningConnector;
            }
            Property idpName = new Property();
            idpName.setName("identityProviderName");
            idpName.setValue(identityProviderName);
            ArrayList<Property> provisioningPropertiesList = new ArrayList<Property>(Arrays.asList(provisoningProperties));
            provisioningPropertiesList.add(idpName);
            Property[] provisioningProperties = new Property[provisioningPropertiesList.size()];
            provisioningProperties = provisioningPropertiesList.toArray(provisioningProperties);
            AbstractOutboundProvisioningConnector connector = this.buildConnector(provisioningProperties);
            entry = new ProvisioningConnectorCacheEntry();
            entry.setProvisioningConnector(connector);
            ProvisioningConnectorCache.getInstance().addToCache((Serializable)((Object)cacheKey), (Serializable)((Object)entry));
            AbstractOutboundProvisioningConnector abstractOutboundProvisioningConnector = connector;
            return abstractOutboundProvisioningConnector;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
            if (tenantDomain != null) {
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomainName);
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId);
            }
        }
    }

    protected abstract AbstractOutboundProvisioningConnector buildConnector(Property[] var1) throws IdentityProvisioningException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyConnector(String identityProviderName, String tenantDomain) throws IdentityProvisioningException {
        String tenantDomainName = null;
        int tenantId = -1234;
        if (CarbonContext.getThreadLocalCarbonContext() != null) {
            tenantDomainName = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        }
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(-1234);
            carbonContext.setTenantDomain("carbon.super");
            ProvisioningConnectorCacheKey cacheKey = new ProvisioningConnectorCacheKey(identityProviderName, tenantDomain);
            ProvisioningConnectorCacheEntry entry = (ProvisioningConnectorCacheEntry)((Object)ProvisioningConnectorCache.getInstance().getValueFromCache((Serializable)((Object)cacheKey)));
            if (entry != null) {
                ProvisioningConnectorCache.getInstance().clearCacheEntry((Serializable)((Object)cacheKey));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Provisioning cached entry removed for idp " + identityProviderName + " from the connector " + this.getConnectorType()));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Provisioning cached entry not found for idp " + identityProviderName + " from the connector " + this.getConnectorType()));
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
            if (tenantDomain != null) {
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomainName);
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId);
            }
        }
    }

    public List<Property> getConfigurationProperties() {
        return new ArrayList<Property>();
    }

    public abstract String getConnectorType();
}

