/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provisioning;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.provisioning.IdentityProvisioningException;
import org.wso2.carbon.identity.provisioning.ProvisionedIdentifier;
import org.wso2.carbon.identity.provisioning.ProvisioningEntity;
import org.wso2.carbon.identity.provisioning.ProvisioningUtil;

public abstract class AbstractOutboundProvisioningConnector
implements Serializable {
    private static final long serialVersionUID = 8619915839101228583L;
    private static final String PROVISIONING_IDP = "IDP";
    private static final String PROVISIONING_TENANT = "TD";
    private static final String PROVISIONING_DOMAIN = "UD";
    private static final String PROVISIONING_USER = "UN";
    protected boolean jitProvisioningEnabled;

    public abstract void init(Property[] var1) throws IdentityProvisioningException;

    public abstract ProvisionedIdentifier provision(ProvisioningEntity var1) throws IdentityProvisioningException;

    public String getClaimDialectUri() throws IdentityProvisioningException {
        return null;
    }

    protected boolean isJitProvisioningEnabled() throws IdentityProvisioningException {
        return this.jitProvisioningEnabled;
    }

    protected List<String> getUserNames(Map<ClaimMapping, List<String>> attributeMap) {
        return ProvisioningUtil.getClaimValues(attributeMap, "org:wso2:carbon:identity:provisioning:claim:username", this.getUserStoreDomainName());
    }

    protected List<String> getGroupNames(Map<ClaimMapping, List<String>> attributeMap) {
        return ProvisioningUtil.getClaimValues(attributeMap, "org:wso2:carbon:identity:provisioning:claim:group", this.getUserStoreDomainName());
    }

    protected String getPassword(Map<ClaimMapping, List<String>> attributeMap) {
        List<String> claimValue = ProvisioningUtil.getClaimValues(attributeMap, "org:wso2:carbon:identity:provisioning:claim:password", null);
        if (CollectionUtils.isNotEmpty(claimValue) && claimValue.get(0) != null) {
            return claimValue.get(0);
        }
        return UUID.randomUUID().toString();
    }

    protected Map<String, String> getSingleValuedClaims(Map<ClaimMapping, List<String>> attributeMap) {
        HashMap<String, String> claimValues = new HashMap<String, String>();
        for (Map.Entry<ClaimMapping, List<String>> entry : attributeMap.entrySet()) {
            String claimUri;
            ClaimMapping mapping = entry.getKey();
            if (mapping.getRemoteClaim() == null || mapping.getRemoteClaim().getClaimUri() == null || "org:wso2:carbon:identity:provisioning:claim:group".equals(claimUri = mapping.getRemoteClaim().getClaimUri()) || "org:wso2:carbon:identity:provisioning:claim:password".equals(claimUri) || "org:wso2:carbon:identity:provisioning:claim:username".equals(claimUri)) continue;
            if (CollectionUtils.isNotEmpty((Collection)entry.getValue()) && entry.getValue().get(0) != null) {
                claimValues.put(claimUri, entry.getValue().get(0));
                continue;
            }
            claimValues.put(claimUri, mapping.getDefaultValue());
        }
        return claimValues;
    }

    protected String getUserStoreDomainName() {
        return null;
    }

    protected String buildUserId(ProvisioningEntity provisioningEntity, String provisioningPattern, String separator, String idpName) throws IdentityProvisioningException {
        HashMap<String, String> provValues = new HashMap<String, String>();
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        String username = provisioningEntity.getEntityName();
        String userStoreDomain = this.getDomainFromUserName(username);
        if (separator == null) {
            separator = "";
        }
        String provIdentifier = "";
        provValues.put(PROVISIONING_TENANT, tenantDomain.replaceAll(separator, ""));
        if (username != null) {
            provValues.put(PROVISIONING_USER, this.removeDomainFromUserName(username));
        }
        provValues.put(PROVISIONING_IDP, idpName.replaceAll(separator, ""));
        if (userStoreDomain != null) {
            provValues.put(PROVISIONING_DOMAIN, userStoreDomain.replaceAll(separator, ""));
        }
        String[] provisioningEntries = this.buildProvisioningEntries(provisioningPattern);
        for (int i = 0; i < provisioningEntries.length; ++i) {
            if (!StringUtils.isNotBlank((String)provisioningEntries[i])) continue;
            provIdentifier = StringUtils.isBlank((String)provIdentifier) ? (String)provValues.get(provisioningEntries[i].trim()) : provIdentifier.concat(separator).concat((String)provValues.get(provisioningEntries[i].trim()));
        }
        return provIdentifier.toLowerCase();
    }

    private String[] buildProvisioningEntries(String provisioningPattern) throws IdentityProvisioningException {
        if (!provisioningPattern.contains("{") || !provisioningPattern.contains("}")) {
            throw new IdentityProvisioningException("Invalid Provisioning Pattern");
        }
        String provisioningPatternWithoutCurlBrace = provisioningPattern.replaceAll("\\{", "").replaceAll("\\}", "");
        return provisioningPatternWithoutCurlBrace.split(",");
    }

    private String getDomainFromUserName(String username) {
        String domain = "PRIMARY";
        if (StringUtils.isNotBlank((String)username)) {
            int index = username.indexOf("/");
            if (index > 0) {
                domain = username.substring(0, index);
            }
            return domain;
        }
        return domain;
    }

    private String removeDomainFromUserName(String username) {
        int index = username.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
        if (index >= 0) {
            username = username.substring(index + 1);
        }
        return username;
    }
}

