/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.deployment;

import java.io.File;
import java.util.HashSet;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.ServiceDeployer;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.utils.deployment.DeploymentFileDataWrapper;
import org.wso2.carbon.utils.deployment.GhostArtifactRepository;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;

public class GhostAwareAxis2ServiceDeployer
extends ServiceDeployer {
    private static Log log = LogFactory.getLog(GhostAwareAxis2ServiceDeployer.class);
    private boolean isGhostOn = GhostDeployerUtils.isGhostOn();
    private AxisConfiguration axisConfig;

    public void init(ConfigurationContext configCtx) {
        super.init(configCtx);
        this.axisConfig = configCtx.getAxisConfiguration();
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        String filePath = deploymentFileData.getAbsolutePath();
        GhostArtifactRepository ghostArtifactRepository = GhostDeployerUtils.getGhostArtifactRepository(this.axisConfig);
        DeploymentFileDataWrapper existingDfd = ghostArtifactRepository.getDeploymentFileData(filePath);
        boolean doGhostDeployment = true;
        if (existingDfd != null && existingDfd.isGhost()) {
            doGhostDeployment = false;
            ghostArtifactRepository.removeDeploymentFileData(filePath);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Doing actual service deployment: " + deploymentFileData.getAbsolutePath()));
            }
        }
        if (this.isGhostOn && doGhostDeployment) {
            String absoluteFilePath = deploymentFileData.getAbsolutePath();
            File ghostFile = GhostDeployerUtils.getGhostFile(absoluteFilePath, this.axisConfig);
            if (ghostFile == null || !ghostFile.exists()) {
                HashSet axisServicesBefore = new HashSet(this.axisConfig.getServices().values());
                super.deploy(deploymentFileData);
                ghostArtifactRepository.addDeploymentFileData(deploymentFileData, false);
                HashSet<AxisService> axisServicesAfter = new HashSet<AxisService>(this.axisConfig.getServices().values());
                axisServicesAfter.removeAll(axisServicesBefore);
                GhostDeployerUtils.serializeServiceGroup(axisServicesAfter, deploymentFileData, this.axisConfig);
            } else {
                GhostDeployerUtils.deployGhostServiceGroup(ghostFile, deploymentFileData, this.axisConfig);
            }
        } else {
            super.deploy(deploymentFileData);
            if (this.isGhostOn) {
                ghostArtifactRepository.addDeploymentFileData(deploymentFileData, false);
            }
        }
    }

    public void undeploy(String fileName) throws DeploymentException {
        if (this.isGhostOn) {
            GhostDeployerUtils.removeGhostFile(fileName, this.axisConfig);
        }
        super.undeploy(fileName);
    }
}

