/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.wso2.carbon.utils.ServerException;

public class FileListGenerator {
    public void generate(String sourceDirName, String outputFile) throws ServerException {
        File sourceDir = new File(sourceDirName);
        if (!sourceDir.exists()) {
            throw new ServerException("Source directory " + sourceDirName + " does not exist.");
        }
        if (!sourceDir.isDirectory()) {
            throw new ServerException("Source " + sourceDirName + " is not a directory.");
        }
        try {
            File outFile = new File(outputFile);
            if (outFile.exists() && !outFile.delete()) {
                throw new IOException("Fail to delete the file: " + outFile.getAbsolutePath());
            }
            if (!outFile.createNewFile()) {
                throw new IOException("Fail to create the file: " + outFile.getAbsolutePath());
            }
            try (FileWriter fileWriter = new FileWriter(outFile);
                 BufferedWriter buffWriter = new BufferedWriter(fileWriter);){
                String[] files = sourceDir.list();
                for (int i = 0; i < files.length; ++i) {
                    String file = files[i];
                    buffWriter.write(file);
                    if (i == files.length - 1) continue;
                    buffWriter.newLine();
                }
                buffWriter.flush();
            }
            catch (IOException iOException) {}
        }
        catch (IOException e) {
            throw new ServerException("Could not create new output file", e);
        }
    }

    public static void main(String[] args) throws ServerException {
        if (args.length < 2) {
            System.out.println("Usage: FileListGenerator <source-dir> <output-file>");
        }
        FileListGenerator fileListGenerator = new FileListGenerator();
        fileListGenerator.generate(args[0], args[1]);
    }
}

