/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

public class TopicDTO {
    private String id = null;
    private String name = null;
    private String mode = null;
    private String description = null;

    public TopicDTO id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="1222344", value="id")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TopicDTO name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="PizzaShackAPI", required=true, value="")
    @JsonProperty(value="name")
    @NotNull
    @Pattern(regexp="(^[^~!@#;:%^*()+={}|\\\\<>\"',&$\\s+\\[\\]/]*$)")
    @Size(min=1, max=50)
    public @NotNull @Pattern(regexp="(^[^~!@#;:%^*()+={}|\\\\<>\"',&$\\s+\\[\\]/]*$)") @Size(min=1, max=50) String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TopicDTO mode(String mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(example="This is a simple API for Pizza Shack online pizza delivery store.", required=true, value="")
    @JsonProperty(value="mode")
    @NotNull
    @Size(max=32766)
    public @NotNull @Size(max=32766) String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public TopicDTO description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="This is a simple API for Pizza Shack online pizza delivery store.", required=true, value="")
    @JsonProperty(value="description")
    @NotNull
    @Size(max=32766)
    public @NotNull @Size(max=32766) String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicDTO topic = (TopicDTO)o;
        return Objects.equals(this.id, topic.id) && Objects.equals(this.name, topic.name) && Objects.equals(this.mode, topic.mode) && Objects.equals(this.description, topic.description);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.mode, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TopicDTO {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

