/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;

public class ThrottlingPolicyDTO {
    private String name = null;
    private String description = null;
    private PolicyLevelEnum policyLevel = null;
    private String displayName = null;
    private Map<String, String> attributes = new HashMap<String, String>();
    private Long requestCount = null;
    private String dataUnit = null;
    private Long unitTime = null;
    private String timeUnit = null;
    private Integer rateLimitCount = 0;
    private String rateLimitTimeUnit = null;
    private QuotaPolicyTypeEnum quotaPolicyType = null;
    private TierPlanEnum tierPlan = null;
    private Boolean stopOnQuotaReach = null;
    private Map<String, String> monetizationProperties = new HashMap<String, String>();

    public ThrottlingPolicyDTO name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Platinum", required=true, value="")
    @JsonProperty(value="name")
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ThrottlingPolicyDTO description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="Allows 50 request(s) per minute.", value="")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ThrottlingPolicyDTO policyLevel(PolicyLevelEnum policyLevel) {
        this.policyLevel = policyLevel;
        return this;
    }

    @ApiModelProperty(example="api", value="")
    @JsonProperty(value="policyLevel")
    public PolicyLevelEnum getPolicyLevel() {
        return this.policyLevel;
    }

    public void setPolicyLevel(PolicyLevelEnum policyLevel) {
        this.policyLevel = policyLevel;
    }

    public ThrottlingPolicyDTO displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(example="Platinum", value="")
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ThrottlingPolicyDTO attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="{}", value="Custom attributes added to the policy policy ")
    @JsonProperty(value="attributes")
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public ThrottlingPolicyDTO requestCount(Long requestCount) {
        this.requestCount = requestCount;
        return this;
    }

    @ApiModelProperty(example="50", required=true, value="Maximum number of requests which can be sent within a provided unit time ")
    @JsonProperty(value="requestCount")
    @NotNull
    public Long getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(Long requestCount) {
        this.requestCount = requestCount;
    }

    public ThrottlingPolicyDTO dataUnit(String dataUnit) {
        this.dataUnit = dataUnit;
        return this;
    }

    @ApiModelProperty(example="KB", value="Unit of data allowed to be transfered. Allowed values are \"KB\", \"MB\" and \"GB\" ")
    @JsonProperty(value="dataUnit")
    public String getDataUnit() {
        return this.dataUnit;
    }

    public void setDataUnit(String dataUnit) {
        this.dataUnit = dataUnit;
    }

    public ThrottlingPolicyDTO unitTime(Long unitTime) {
        this.unitTime = unitTime;
        return this;
    }

    @ApiModelProperty(example="60000", required=true, value="")
    @JsonProperty(value="unitTime")
    @NotNull
    public Long getUnitTime() {
        return this.unitTime;
    }

    public void setUnitTime(Long unitTime) {
        this.unitTime = unitTime;
    }

    public ThrottlingPolicyDTO timeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
        return this;
    }

    @ApiModelProperty(example="min", value="")
    @JsonProperty(value="timeUnit")
    public String getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
    }

    public ThrottlingPolicyDTO rateLimitCount(Integer rateLimitCount) {
        this.rateLimitCount = rateLimitCount;
        return this;
    }

    @ApiModelProperty(example="10", value="Burst control request count")
    @JsonProperty(value="rateLimitCount")
    public Integer getRateLimitCount() {
        return this.rateLimitCount;
    }

    public void setRateLimitCount(Integer rateLimitCount) {
        this.rateLimitCount = rateLimitCount;
    }

    public ThrottlingPolicyDTO rateLimitTimeUnit(String rateLimitTimeUnit) {
        this.rateLimitTimeUnit = rateLimitTimeUnit;
        return this;
    }

    @ApiModelProperty(example="min", value="Burst control time unit")
    @JsonProperty(value="rateLimitTimeUnit")
    public String getRateLimitTimeUnit() {
        return this.rateLimitTimeUnit;
    }

    public void setRateLimitTimeUnit(String rateLimitTimeUnit) {
        this.rateLimitTimeUnit = rateLimitTimeUnit;
    }

    public ThrottlingPolicyDTO quotaPolicyType(QuotaPolicyTypeEnum quotaPolicyType) {
        this.quotaPolicyType = quotaPolicyType;
        return this;
    }

    @ApiModelProperty(example="REQUESTCOUNT", value="Default quota limit type")
    @JsonProperty(value="quotaPolicyType")
    public QuotaPolicyTypeEnum getQuotaPolicyType() {
        return this.quotaPolicyType;
    }

    public void setQuotaPolicyType(QuotaPolicyTypeEnum quotaPolicyType) {
        this.quotaPolicyType = quotaPolicyType;
    }

    public ThrottlingPolicyDTO tierPlan(TierPlanEnum tierPlan) {
        this.tierPlan = tierPlan;
        return this;
    }

    @ApiModelProperty(example="FREE", required=true, value="This attribute declares whether this policy is available under commercial or free ")
    @JsonProperty(value="tierPlan")
    @NotNull
    public TierPlanEnum getTierPlan() {
        return this.tierPlan;
    }

    public void setTierPlan(TierPlanEnum tierPlan) {
        this.tierPlan = tierPlan;
    }

    public ThrottlingPolicyDTO stopOnQuotaReach(Boolean stopOnQuotaReach) {
        this.stopOnQuotaReach = stopOnQuotaReach;
        return this;
    }

    @ApiModelProperty(example="true", required=true, value="By making this attribute to false, you are capabale of sending requests even if the request count exceeded within a unit time ")
    @JsonProperty(value="stopOnQuotaReach")
    @NotNull
    public Boolean isStopOnQuotaReach() {
        return this.stopOnQuotaReach;
    }

    public void setStopOnQuotaReach(Boolean stopOnQuotaReach) {
        this.stopOnQuotaReach = stopOnQuotaReach;
    }

    public ThrottlingPolicyDTO monetizationProperties(Map<String, String> monetizationProperties) {
        this.monetizationProperties = monetizationProperties;
        return this;
    }

    @ApiModelProperty(example="{}", value="Properties of a tier plan which are related to monetization")
    @JsonProperty(value="monetizationProperties")
    public Map<String, String> getMonetizationProperties() {
        return this.monetizationProperties;
    }

    public void setMonetizationProperties(Map<String, String> monetizationProperties) {
        this.monetizationProperties = monetizationProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThrottlingPolicyDTO throttlingPolicy = (ThrottlingPolicyDTO)o;
        return Objects.equals(this.name, throttlingPolicy.name) && Objects.equals(this.description, throttlingPolicy.description) && Objects.equals((Object)this.policyLevel, (Object)throttlingPolicy.policyLevel) && Objects.equals(this.displayName, throttlingPolicy.displayName) && Objects.equals(this.attributes, throttlingPolicy.attributes) && Objects.equals(this.requestCount, throttlingPolicy.requestCount) && Objects.equals(this.dataUnit, throttlingPolicy.dataUnit) && Objects.equals(this.unitTime, throttlingPolicy.unitTime) && Objects.equals(this.timeUnit, throttlingPolicy.timeUnit) && Objects.equals(this.rateLimitCount, throttlingPolicy.rateLimitCount) && Objects.equals(this.rateLimitTimeUnit, throttlingPolicy.rateLimitTimeUnit) && Objects.equals((Object)this.quotaPolicyType, (Object)throttlingPolicy.quotaPolicyType) && Objects.equals((Object)this.tierPlan, (Object)throttlingPolicy.tierPlan) && Objects.equals(this.stopOnQuotaReach, throttlingPolicy.stopOnQuotaReach) && Objects.equals(this.monetizationProperties, throttlingPolicy.monetizationProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.policyLevel, this.displayName, this.attributes, this.requestCount, this.dataUnit, this.unitTime, this.timeUnit, this.rateLimitCount, this.rateLimitTimeUnit, this.quotaPolicyType, this.tierPlan, this.stopOnQuotaReach, this.monetizationProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThrottlingPolicyDTO {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    policyLevel: ").append(this.toIndentedString((Object)this.policyLevel)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    requestCount: ").append(this.toIndentedString(this.requestCount)).append("\n");
        sb.append("    dataUnit: ").append(this.toIndentedString(this.dataUnit)).append("\n");
        sb.append("    unitTime: ").append(this.toIndentedString(this.unitTime)).append("\n");
        sb.append("    timeUnit: ").append(this.toIndentedString(this.timeUnit)).append("\n");
        sb.append("    rateLimitCount: ").append(this.toIndentedString(this.rateLimitCount)).append("\n");
        sb.append("    rateLimitTimeUnit: ").append(this.toIndentedString(this.rateLimitTimeUnit)).append("\n");
        sb.append("    quotaPolicyType: ").append(this.toIndentedString((Object)this.quotaPolicyType)).append("\n");
        sb.append("    tierPlan: ").append(this.toIndentedString((Object)this.tierPlan)).append("\n");
        sb.append("    stopOnQuotaReach: ").append(this.toIndentedString(this.stopOnQuotaReach)).append("\n");
        sb.append("    monetizationProperties: ").append(this.toIndentedString(this.monetizationProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @XmlType(name="TierPlanEnum")
    @XmlEnum(value=String.class)
    public static enum TierPlanEnum {
        FREE("FREE"),
        COMMERCIAL("COMMERCIAL");

        private String value;

        private TierPlanEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TierPlanEnum fromValue(String v) {
            for (TierPlanEnum b : TierPlanEnum.values()) {
                if (!String.valueOf(b.value).equals(v)) continue;
                return b;
            }
            return null;
        }
    }

    @XmlType(name="QuotaPolicyTypeEnum")
    @XmlEnum(value=String.class)
    public static enum QuotaPolicyTypeEnum {
        REQUESTCOUNT("REQUESTCOUNT"),
        BANDWIDTHVOLUME("BANDWIDTHVOLUME");

        private String value;

        private QuotaPolicyTypeEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static QuotaPolicyTypeEnum fromValue(String v) {
            for (QuotaPolicyTypeEnum b : QuotaPolicyTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(v)) continue;
                return b;
            }
            return null;
        }
    }

    @XmlType(name="PolicyLevelEnum")
    @XmlEnum(value=String.class)
    public static enum PolicyLevelEnum {
        SUBSCRIPTION("subscription"),
        API("api");

        private String value;

        private PolicyLevelEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PolicyLevelEnum fromValue(String v) {
            for (PolicyLevelEnum b : PolicyLevelEnum.values()) {
                if (!String.valueOf(b.value).equals(v)) continue;
                return b;
            }
            return null;
        }
    }
}

