/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class ThrottlePolicyDTO {
    private String policyId = null;
    private String policyName = null;
    private String displayName = null;
    private String description = null;
    private Boolean isDeployed = false;
    private String type = null;

    public ThrottlePolicyDTO policyId(String policyId) {
        this.policyId = policyId;
        return this;
    }

    @ApiModelProperty(example="0c6439fd-9b16-3c2e-be6e-1086e0b9aa93", value="Id of policy")
    @JsonProperty(value="policyId")
    public String getPolicyId() {
        return this.policyId;
    }

    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    public ThrottlePolicyDTO policyName(String policyName) {
        this.policyName = policyName;
        return this;
    }

    @ApiModelProperty(example="30PerMin", required=true, value="Name of policy")
    @JsonProperty(value="policyName")
    @NotNull
    @Size(min=1, max=60)
    public @NotNull @Size(min=1, max=60) String getPolicyName() {
        return this.policyName;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public ThrottlePolicyDTO displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(example="30PerMin", value="Display name of the policy")
    @JsonProperty(value="displayName")
    @Size(max=512)
    public @Size(max=512) String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ThrottlePolicyDTO description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="Allows 30 request per minute", value="Description of the policy")
    @JsonProperty(value="description")
    @Size(max=1024)
    public @Size(max=1024) String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ThrottlePolicyDTO isDeployed(Boolean isDeployed) {
        this.isDeployed = isDeployed;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the policy is deployed successfully or not.")
    @JsonProperty(value="isDeployed")
    public Boolean isIsDeployed() {
        return this.isDeployed;
    }

    public void setIsDeployed(Boolean isDeployed) {
        this.isDeployed = isDeployed;
    }

    public ThrottlePolicyDTO type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Indicates the type of throttle policy")
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThrottlePolicyDTO throttlePolicy = (ThrottlePolicyDTO)o;
        return Objects.equals(this.policyId, throttlePolicy.policyId) && Objects.equals(this.policyName, throttlePolicy.policyName) && Objects.equals(this.displayName, throttlePolicy.displayName) && Objects.equals(this.description, throttlePolicy.description) && Objects.equals(this.isDeployed, throttlePolicy.isDeployed) && Objects.equals(this.type, throttlePolicy.type);
    }

    public int hashCode() {
        return Objects.hash(this.policyId, this.policyName, this.displayName, this.description, this.isDeployed, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThrottlePolicyDTO {\n");
        sb.append("    policyId: ").append(this.toIndentedString(this.policyId)).append("\n");
        sb.append("    policyName: ").append(this.toIndentedString(this.policyName)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isDeployed: ").append(this.toIndentedString(this.isDeployed)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

