/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ApplicationInfoDTO;

public class SubscriptionDTO {
    private String subscriptionId = null;
    private ApplicationInfoDTO applicationInfo = null;
    private String throttlingPolicy = null;
    private SubscriptionStatusEnum subscriptionStatus = null;

    public SubscriptionDTO subscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    @ApiModelProperty(example="01234567-0123-0123-0123-012345678901", required=true, value="")
    @JsonProperty(value="subscriptionId")
    @NotNull
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public SubscriptionDTO applicationInfo(ApplicationInfoDTO applicationInfo) {
        this.applicationInfo = applicationInfo;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @Valid
    @JsonProperty(value="applicationInfo")
    @NotNull
    public ApplicationInfoDTO getApplicationInfo() {
        return this.applicationInfo;
    }

    public void setApplicationInfo(ApplicationInfoDTO applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    public SubscriptionDTO throttlingPolicy(String throttlingPolicy) {
        this.throttlingPolicy = throttlingPolicy;
        return this;
    }

    @ApiModelProperty(example="Unlimited", required=true, value="")
    @JsonProperty(value="throttlingPolicy")
    @NotNull
    public String getThrottlingPolicy() {
        return this.throttlingPolicy;
    }

    public void setThrottlingPolicy(String throttlingPolicy) {
        this.throttlingPolicy = throttlingPolicy;
    }

    public SubscriptionDTO subscriptionStatus(SubscriptionStatusEnum subscriptionStatus) {
        this.subscriptionStatus = subscriptionStatus;
        return this;
    }

    @ApiModelProperty(example="BLOCKED", required=true, value="")
    @JsonProperty(value="subscriptionStatus")
    @NotNull
    public SubscriptionStatusEnum getSubscriptionStatus() {
        return this.subscriptionStatus;
    }

    public void setSubscriptionStatus(SubscriptionStatusEnum subscriptionStatus) {
        this.subscriptionStatus = subscriptionStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionDTO subscription = (SubscriptionDTO)o;
        return Objects.equals(this.subscriptionId, subscription.subscriptionId) && Objects.equals(this.applicationInfo, subscription.applicationInfo) && Objects.equals(this.throttlingPolicy, subscription.throttlingPolicy) && Objects.equals((Object)this.subscriptionStatus, (Object)subscription.subscriptionStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.subscriptionId, this.applicationInfo, this.throttlingPolicy, this.subscriptionStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionDTO {\n");
        sb.append("    subscriptionId: ").append(this.toIndentedString(this.subscriptionId)).append("\n");
        sb.append("    applicationInfo: ").append(this.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    throttlingPolicy: ").append(this.toIndentedString(this.throttlingPolicy)).append("\n");
        sb.append("    subscriptionStatus: ").append(this.toIndentedString((Object)this.subscriptionStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @XmlType(name="SubscriptionStatusEnum")
    @XmlEnum(value=String.class)
    public static enum SubscriptionStatusEnum {
        BLOCKED("BLOCKED"),
        PROD_ONLY_BLOCKED("PROD_ONLY_BLOCKED"),
        UNBLOCKED("UNBLOCKED"),
        ON_HOLD("ON_HOLD"),
        REJECTED("REJECTED"),
        TIER_UPDATE_PENDING("TIER_UPDATE_PENDING");

        private String value;

        private SubscriptionStatusEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SubscriptionStatusEnum fromValue(String v) {
            for (SubscriptionStatusEnum b : SubscriptionStatusEnum.values()) {
                if (!String.valueOf(b.value).equals(v)) continue;
                return b;
            }
            return null;
        }
    }
}

