/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;

public class DocumentDTO {
    private String documentId = null;
    private String name = null;
    private TypeEnum type = null;
    private String summary = null;
    private SourceTypeEnum sourceType = null;
    private String sourceUrl = null;
    private String fileName = null;
    private String inlineContent = null;
    private String otherTypeName = null;
    private VisibilityEnum visibility = null;
    private String createdTime = null;
    private String createdBy = null;
    private String lastUpdatedTime = null;
    private String lastUpdatedBy = null;

    public DocumentDTO documentId(String documentId) {
        this.documentId = documentId;
        return this;
    }

    @ApiModelProperty(example="01234567-0123-0123-0123-012345678901", value="")
    @JsonProperty(value="documentId")
    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public DocumentDTO name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="PizzaShackDoc", required=true, value="")
    @JsonProperty(value="name")
    @NotNull
    @Size(min=1, max=60)
    public @NotNull @Size(min=1, max=60) String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DocumentDTO type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="HOWTO", required=true, value="")
    @JsonProperty(value="type")
    @NotNull
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public DocumentDTO summary(String summary) {
        this.summary = summary;
        return this;
    }

    @ApiModelProperty(example="Summary of PizzaShackAPI Documentation", value="")
    @JsonProperty(value="summary")
    @Size(min=1, max=32766)
    public @Size(min=1, max=32766) String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public DocumentDTO sourceType(SourceTypeEnum sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    @ApiModelProperty(example="INLINE", required=true, value="")
    @JsonProperty(value="sourceType")
    @NotNull
    public SourceTypeEnum getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(SourceTypeEnum sourceType) {
        this.sourceType = sourceType;
    }

    public DocumentDTO sourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="sourceUrl")
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public DocumentDTO fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="fileName")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public DocumentDTO inlineContent(String inlineContent) {
        this.inlineContent = inlineContent;
        return this;
    }

    @ApiModelProperty(example="This is doc content. This can have many lines.", value="")
    @JsonProperty(value="inlineContent")
    public String getInlineContent() {
        return this.inlineContent;
    }

    public void setInlineContent(String inlineContent) {
        this.inlineContent = inlineContent;
    }

    public DocumentDTO otherTypeName(String otherTypeName) {
        this.otherTypeName = otherTypeName;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="otherTypeName")
    public String getOtherTypeName() {
        return this.otherTypeName;
    }

    public void setOtherTypeName(String otherTypeName) {
        this.otherTypeName = otherTypeName;
    }

    public DocumentDTO visibility(VisibilityEnum visibility) {
        this.visibility = visibility;
        return this;
    }

    @ApiModelProperty(example="API_LEVEL", required=true, value="")
    @JsonProperty(value="visibility")
    @NotNull
    public VisibilityEnum getVisibility() {
        return this.visibility;
    }

    public void setVisibility(VisibilityEnum visibility) {
        this.visibility = visibility;
    }

    public DocumentDTO createdTime(String createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="createdTime")
    public String getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public DocumentDTO createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="admin", value="")
    @JsonProperty(value="createdBy")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public DocumentDTO lastUpdatedTime(String lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="lastUpdatedTime")
    public String getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void setLastUpdatedTime(String lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public DocumentDTO lastUpdatedBy(String lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @ApiModelProperty(example="admin", value="")
    @JsonProperty(value="lastUpdatedBy")
    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentDTO document = (DocumentDTO)o;
        return Objects.equals(this.documentId, document.documentId) && Objects.equals(this.name, document.name) && Objects.equals((Object)this.type, (Object)document.type) && Objects.equals(this.summary, document.summary) && Objects.equals((Object)this.sourceType, (Object)document.sourceType) && Objects.equals(this.sourceUrl, document.sourceUrl) && Objects.equals(this.fileName, document.fileName) && Objects.equals(this.inlineContent, document.inlineContent) && Objects.equals(this.otherTypeName, document.otherTypeName) && Objects.equals((Object)this.visibility, (Object)document.visibility) && Objects.equals(this.createdTime, document.createdTime) && Objects.equals(this.createdBy, document.createdBy) && Objects.equals(this.lastUpdatedTime, document.lastUpdatedTime) && Objects.equals(this.lastUpdatedBy, document.lastUpdatedBy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.documentId, this.name, this.type, this.summary, this.sourceType, this.sourceUrl, this.fileName, this.inlineContent, this.otherTypeName, this.visibility, this.createdTime, this.createdBy, this.lastUpdatedTime, this.lastUpdatedBy});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentDTO {\n");
        sb.append("    documentId: ").append(this.toIndentedString(this.documentId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString(this.summary)).append("\n");
        sb.append("    sourceType: ").append(this.toIndentedString((Object)this.sourceType)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    inlineContent: ").append(this.toIndentedString(this.inlineContent)).append("\n");
        sb.append("    otherTypeName: ").append(this.toIndentedString(this.otherTypeName)).append("\n");
        sb.append("    visibility: ").append(this.toIndentedString((Object)this.visibility)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    lastUpdatedTime: ").append(this.toIndentedString(this.lastUpdatedTime)).append("\n");
        sb.append("    lastUpdatedBy: ").append(this.toIndentedString(this.lastUpdatedBy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @XmlType(name="VisibilityEnum")
    @XmlEnum(value=String.class)
    public static enum VisibilityEnum {
        OWNER_ONLY("OWNER_ONLY"),
        PRIVATE("PRIVATE"),
        API_LEVEL("API_LEVEL");

        private String value;

        private VisibilityEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static VisibilityEnum fromValue(String v) {
            for (VisibilityEnum b : VisibilityEnum.values()) {
                if (!String.valueOf(b.value).equals(v)) continue;
                return b;
            }
            return null;
        }
    }

    @XmlType(name="SourceTypeEnum")
    @XmlEnum(value=String.class)
    public static enum SourceTypeEnum {
        INLINE("INLINE"),
        MARKDOWN("MARKDOWN"),
        URL("URL"),
        FILE("FILE");

        private String value;

        private SourceTypeEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceTypeEnum fromValue(String v) {
            for (SourceTypeEnum b : SourceTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(v)) continue;
                return b;
            }
            return null;
        }
    }

    @XmlType(name="TypeEnum")
    @XmlEnum(value=String.class)
    public static enum TypeEnum {
        HOWTO("HOWTO"),
        SAMPLES("SAMPLES"),
        PUBLIC_FORUM("PUBLIC_FORUM"),
        SUPPORT_FORUM("SUPPORT_FORUM"),
        API_MESSAGE_FORMAT("API_MESSAGE_FORMAT"),
        SWAGGER_DOC("SWAGGER_DOC"),
        OTHER("OTHER");

        private String value;

        private TypeEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String v) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(v)) continue;
                return b;
            }
            return null;
        }
    }
}

