/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;
import org.wso2.carbon.apimgt.rest.api.common.annotations.Scope;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIAdditionalPropertiesDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APICorsConfigurationDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIMonetizationInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIProductBusinessInformationDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIScopeDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ProductAPIDTO;

public class APIProductDTO {
    private String id = null;
    private String name = null;
    private String context = null;
    private String description = null;
    private String provider = null;
    private Boolean hasThumbnail = null;
    private StateEnum state = null;
    private Boolean enableSchemaValidation = null;
    private Boolean isRevision = null;
    private String revisionedApiProductId = null;
    private Integer revisionId = null;
    private Boolean responseCachingEnabled = null;
    private Integer cacheTimeout = null;
    private VisibilityEnum visibility = VisibilityEnum.PUBLIC;
    private List<String> visibleRoles = new ArrayList<String>();
    private List<String> visibleTenants = new ArrayList<String>();
    private AccessControlEnum accessControl = AccessControlEnum.NONE;
    private List<String> accessControlRoles = new ArrayList<String>();
    private ApiTypeEnum apiType = null;
    private List<String> transport = new ArrayList<String>();
    private List<String> tags = new ArrayList<String>();
    private List<String> policies = new ArrayList<String>();
    private String apiThrottlingPolicy = null;
    private String authorizationHeader = null;
    private List<String> securityScheme = new ArrayList<String>();
    private SubscriptionAvailabilityEnum subscriptionAvailability = SubscriptionAvailabilityEnum.ALL_TENANTS;
    @Scope(name="apim:api_publish", description="", value="")
    private List<String> subscriptionAvailableTenants = new ArrayList<String>();
    private List<APIAdditionalPropertiesDTO> additionalProperties = new ArrayList<APIAdditionalPropertiesDTO>();
    private APIMonetizationInfoDTO monetization = null;
    private APIProductBusinessInformationDTO businessInformation = null;
    private APICorsConfigurationDTO corsConfiguration = null;
    private String createdTime = null;
    private String lastUpdatedTime = null;
    private List<ProductAPIDTO> apis = new ArrayList<ProductAPIDTO>();
    private List<APIScopeDTO> scopes = new ArrayList<APIScopeDTO>();
    private List<String> categories = new ArrayList<String>();

    public APIProductDTO id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="01234567-0123-0123-0123-012345678901", value="UUID of the api product ")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public APIProductDTO name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="PizzaShackAPIProduct", required=true, value="Name of the API Product")
    @JsonProperty(value="name")
    @NotNull
    @Size(min=1, max=50)
    public @NotNull @Size(min=1, max=50) String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public APIProductDTO context(String context) {
        this.context = context;
        return this;
    }

    @ApiModelProperty(example="pizzaproduct", value="")
    @JsonProperty(value="context")
    @Size(min=1, max=60)
    public @Size(min=1, max=60) String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public APIProductDTO description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="This is a simple API for Pizza Shack online pizza delivery store", value="A brief description about the API")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public APIProductDTO provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="admin", value="If the provider value is not given, the user invoking the API will be used as the provider. ")
    @JsonProperty(value="provider")
    @Size(max=50)
    public @Size(max=50) String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public APIProductDTO hasThumbnail(Boolean hasThumbnail) {
        this.hasThumbnail = hasThumbnail;
        return this;
    }

    @ApiModelProperty(example="false", value="")
    @JsonProperty(value="hasThumbnail")
    public Boolean isHasThumbnail() {
        return this.hasThumbnail;
    }

    public void setHasThumbnail(Boolean hasThumbnail) {
        this.hasThumbnail = hasThumbnail;
    }

    public APIProductDTO state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="State of the API product. Only published api products are visible on the Developer Portal ")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public APIProductDTO enableSchemaValidation(Boolean enableSchemaValidation) {
        this.enableSchemaValidation = enableSchemaValidation;
        return this;
    }

    @ApiModelProperty(example="false", value="")
    @JsonProperty(value="enableSchemaValidation")
    public Boolean isEnableSchemaValidation() {
        return this.enableSchemaValidation;
    }

    public void setEnableSchemaValidation(Boolean enableSchemaValidation) {
        this.enableSchemaValidation = enableSchemaValidation;
    }

    public APIProductDTO isRevision(Boolean isRevision) {
        this.isRevision = isRevision;
        return this;
    }

    @ApiModelProperty(example="false", value="")
    @JsonProperty(value="isRevision")
    public Boolean isIsRevision() {
        return this.isRevision;
    }

    public void setIsRevision(Boolean isRevision) {
        this.isRevision = isRevision;
    }

    public APIProductDTO revisionedApiProductId(String revisionedApiProductId) {
        this.revisionedApiProductId = revisionedApiProductId;
        return this;
    }

    @ApiModelProperty(example="01234567-0123-0123-0123-012345678901", value="UUID of the api product registry artifact ")
    @JsonProperty(value="revisionedApiProductId")
    public String getRevisionedApiProductId() {
        return this.revisionedApiProductId;
    }

    public void setRevisionedApiProductId(String revisionedApiProductId) {
        this.revisionedApiProductId = revisionedApiProductId;
    }

    public APIProductDTO revisionId(Integer revisionId) {
        this.revisionId = revisionId;
        return this;
    }

    @ApiModelProperty(example="1", value="")
    @JsonProperty(value="revisionId")
    public Integer getRevisionId() {
        return this.revisionId;
    }

    public void setRevisionId(Integer revisionId) {
        this.revisionId = revisionId;
    }

    public APIProductDTO responseCachingEnabled(Boolean responseCachingEnabled) {
        this.responseCachingEnabled = responseCachingEnabled;
        return this;
    }

    @ApiModelProperty(example="true", value="")
    @JsonProperty(value="responseCachingEnabled")
    public Boolean isResponseCachingEnabled() {
        return this.responseCachingEnabled;
    }

    public void setResponseCachingEnabled(Boolean responseCachingEnabled) {
        this.responseCachingEnabled = responseCachingEnabled;
    }

    public APIProductDTO cacheTimeout(Integer cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
        return this;
    }

    @ApiModelProperty(example="300", value="")
    @JsonProperty(value="cacheTimeout")
    public Integer getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(Integer cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }

    public APIProductDTO visibility(VisibilityEnum visibility) {
        this.visibility = visibility;
        return this;
    }

    @ApiModelProperty(example="PUBLIC", value="The visibility level of the API. Accepts one of the following. PUBLIC, PRIVATE, RESTRICTED.")
    @JsonProperty(value="visibility")
    public VisibilityEnum getVisibility() {
        return this.visibility;
    }

    public void setVisibility(VisibilityEnum visibility) {
        this.visibility = visibility;
    }

    public APIProductDTO visibleRoles(List<String> visibleRoles) {
        this.visibleRoles = visibleRoles;
        return this;
    }

    @ApiModelProperty(example="[]", value="The user roles that are able to access the API")
    @JsonProperty(value="visibleRoles")
    public List<String> getVisibleRoles() {
        return this.visibleRoles;
    }

    public void setVisibleRoles(List<String> visibleRoles) {
        this.visibleRoles = visibleRoles;
    }

    public APIProductDTO visibleTenants(List<String> visibleTenants) {
        this.visibleTenants = visibleTenants;
        return this;
    }

    @ApiModelProperty(example="[]", value="")
    @JsonProperty(value="visibleTenants")
    public List<String> getVisibleTenants() {
        return this.visibleTenants;
    }

    public void setVisibleTenants(List<String> visibleTenants) {
        this.visibleTenants = visibleTenants;
    }

    public APIProductDTO accessControl(AccessControlEnum accessControl) {
        this.accessControl = accessControl;
        return this;
    }

    @ApiModelProperty(value="Defines whether the API Product is restricted to certain set of publishers or creators or is it visible to all the publishers and creators. If the accessControl restriction is none, this API Product can be modified by all the publishers and creators, if not it can only be viewable/modifiable by certain set of publishers and creators, based on the restriction. ")
    @JsonProperty(value="accessControl")
    public AccessControlEnum getAccessControl() {
        return this.accessControl;
    }

    public void setAccessControl(AccessControlEnum accessControl) {
        this.accessControl = accessControl;
    }

    public APIProductDTO accessControlRoles(List<String> accessControlRoles) {
        this.accessControlRoles = accessControlRoles;
        return this;
    }

    @ApiModelProperty(example="[]", value="The user roles that are able to view/modify as API Product publisher or creator.")
    @JsonProperty(value="accessControlRoles")
    public List<String> getAccessControlRoles() {
        return this.accessControlRoles;
    }

    public void setAccessControlRoles(List<String> accessControlRoles) {
        this.accessControlRoles = accessControlRoles;
    }

    public APIProductDTO apiType(ApiTypeEnum apiType) {
        this.apiType = apiType;
        return this;
    }

    @ApiModelProperty(example="APIPRODUCT", value="The API type to be used. Accepted values are API, APIPRODUCT")
    @JsonProperty(value="apiType")
    public ApiTypeEnum getApiType() {
        return this.apiType;
    }

    public void setApiType(ApiTypeEnum apiType) {
        this.apiType = apiType;
    }

    public APIProductDTO transport(List<String> transport) {
        this.transport = transport;
        return this;
    }

    @ApiModelProperty(example="[\"http\",\"https\"]", value="Supported transports for the API (http and/or https). ")
    @JsonProperty(value="transport")
    public List<String> getTransport() {
        return this.transport;
    }

    public void setTransport(List<String> transport) {
        this.transport = transport;
    }

    public APIProductDTO tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    @ApiModelProperty(example="[\"pizza\",\"food\"]", value="")
    @JsonProperty(value="tags")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public APIProductDTO policies(List<String> policies) {
        this.policies = policies;
        return this;
    }

    @ApiModelProperty(example="[\"Unlimited\"]", value="")
    @JsonProperty(value="policies")
    public List<String> getPolicies() {
        return this.policies;
    }

    public void setPolicies(List<String> policies) {
        this.policies = policies;
    }

    public APIProductDTO apiThrottlingPolicy(String apiThrottlingPolicy) {
        this.apiThrottlingPolicy = apiThrottlingPolicy;
        return this;
    }

    @ApiModelProperty(example="Unlimited", value="The API level throttling policy selected for the particular API Product")
    @JsonProperty(value="apiThrottlingPolicy")
    public String getApiThrottlingPolicy() {
        return this.apiThrottlingPolicy;
    }

    public void setApiThrottlingPolicy(String apiThrottlingPolicy) {
        this.apiThrottlingPolicy = apiThrottlingPolicy;
    }

    public APIProductDTO authorizationHeader(String authorizationHeader) {
        this.authorizationHeader = authorizationHeader;
        return this;
    }

    @ApiModelProperty(example="Authorization", value="Name of the Authorization header used for invoking the API. If it is not set, Authorization header name specified in tenant or system level will be used. ")
    @JsonProperty(value="authorizationHeader")
    public String getAuthorizationHeader() {
        return this.authorizationHeader;
    }

    public void setAuthorizationHeader(String authorizationHeader) {
        this.authorizationHeader = authorizationHeader;
    }

    public APIProductDTO securityScheme(List<String> securityScheme) {
        this.securityScheme = securityScheme;
        return this;
    }

    @ApiModelProperty(example="[\"oauth2\"]", value="Types of API security, the current API secured with. It can be either OAuth2 or mutual SSL or both. If it is not set OAuth2 will be set as the security for the current API. ")
    @JsonProperty(value="securityScheme")
    public List<String> getSecurityScheme() {
        return this.securityScheme;
    }

    public void setSecurityScheme(List<String> securityScheme) {
        this.securityScheme = securityScheme;
    }

    public APIProductDTO subscriptionAvailability(SubscriptionAvailabilityEnum subscriptionAvailability) {
        this.subscriptionAvailability = subscriptionAvailability;
        return this;
    }

    @ApiModelProperty(example="CURRENT_TENANT", value="The subscription availability. Accepts one of the following. CURRENT_TENANT, ALL_TENANTS or SPECIFIC_TENANTS.")
    @JsonProperty(value="subscriptionAvailability")
    public SubscriptionAvailabilityEnum getSubscriptionAvailability() {
        return this.subscriptionAvailability;
    }

    public void setSubscriptionAvailability(SubscriptionAvailabilityEnum subscriptionAvailability) {
        this.subscriptionAvailability = subscriptionAvailability;
    }

    public APIProductDTO subscriptionAvailableTenants(List<String> subscriptionAvailableTenants) {
        this.subscriptionAvailableTenants = subscriptionAvailableTenants;
        return this;
    }

    @ApiModelProperty(example="[]", value="")
    @JsonProperty(value="subscriptionAvailableTenants")
    public List<String> getSubscriptionAvailableTenants() {
        return this.subscriptionAvailableTenants;
    }

    public void setSubscriptionAvailableTenants(List<String> subscriptionAvailableTenants) {
        this.subscriptionAvailableTenants = subscriptionAvailableTenants;
    }

    public APIProductDTO additionalProperties(List<APIAdditionalPropertiesDTO> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @ApiModelProperty(value="Map of custom properties of API")
    @Valid
    @JsonProperty(value="additionalProperties")
    public List<APIAdditionalPropertiesDTO> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(List<APIAdditionalPropertiesDTO> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public APIProductDTO monetization(APIMonetizationInfoDTO monetization) {
        this.monetization = monetization;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="monetization")
    public APIMonetizationInfoDTO getMonetization() {
        return this.monetization;
    }

    public void setMonetization(APIMonetizationInfoDTO monetization) {
        this.monetization = monetization;
    }

    public APIProductDTO businessInformation(APIProductBusinessInformationDTO businessInformation) {
        this.businessInformation = businessInformation;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="businessInformation")
    public APIProductBusinessInformationDTO getBusinessInformation() {
        return this.businessInformation;
    }

    public void setBusinessInformation(APIProductBusinessInformationDTO businessInformation) {
        this.businessInformation = businessInformation;
    }

    public APIProductDTO corsConfiguration(APICorsConfigurationDTO corsConfiguration) {
        this.corsConfiguration = corsConfiguration;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="corsConfiguration")
    public APICorsConfigurationDTO getCorsConfiguration() {
        return this.corsConfiguration;
    }

    public void setCorsConfiguration(APICorsConfigurationDTO corsConfiguration) {
        this.corsConfiguration = corsConfiguration;
    }

    public APIProductDTO createdTime(String createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="createdTime")
    public String getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public APIProductDTO lastUpdatedTime(String lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="lastUpdatedTime")
    public String getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void setLastUpdatedTime(String lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public APIProductDTO apis(List<ProductAPIDTO> apis) {
        this.apis = apis;
        return this;
    }

    @ApiModelProperty(example="[{\"name\":\"PizzaShackAPI\",\"apiId\":\"01234567-0123-0123-0123-012345678901\",\"version\":\"1.0\",\"operations\":[{\"target\":\"/order/{orderId}\",\"verb\":\"POST\",\"authType\":\"Application & Application User\",\"throttlingPolicy\":\"Unlimited\"},{\"target\":\"/menu\",\"verb\":\"GET\",\"authType\":\"Application & Application User\",\"throttlingPolicy\":\"Unlimited\"}]}]", value="APIs and resources in the API Product. ")
    @Valid
    @JsonProperty(value="apis")
    public List<ProductAPIDTO> getApis() {
        return this.apis;
    }

    public void setApis(List<ProductAPIDTO> apis) {
        this.apis = apis;
    }

    public APIProductDTO scopes(List<APIScopeDTO> scopes) {
        this.scopes = scopes;
        return this;
    }

    @ApiModelProperty(example="[]", value="")
    @Valid
    @JsonProperty(value="scopes")
    public List<APIScopeDTO> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<APIScopeDTO> scopes) {
        this.scopes = scopes;
    }

    public APIProductDTO categories(List<String> categories) {
        this.categories = categories;
        return this;
    }

    @ApiModelProperty(example="[]", value="API categories ")
    @JsonProperty(value="categories")
    public List<String> getCategories() {
        return this.categories;
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIProductDTO apIProduct = (APIProductDTO)o;
        return Objects.equals(this.id, apIProduct.id) && Objects.equals(this.name, apIProduct.name) && Objects.equals(this.context, apIProduct.context) && Objects.equals(this.description, apIProduct.description) && Objects.equals(this.provider, apIProduct.provider) && Objects.equals(this.hasThumbnail, apIProduct.hasThumbnail) && Objects.equals((Object)this.state, (Object)apIProduct.state) && Objects.equals(this.enableSchemaValidation, apIProduct.enableSchemaValidation) && Objects.equals(this.isRevision, apIProduct.isRevision) && Objects.equals(this.revisionedApiProductId, apIProduct.revisionedApiProductId) && Objects.equals(this.revisionId, apIProduct.revisionId) && Objects.equals(this.responseCachingEnabled, apIProduct.responseCachingEnabled) && Objects.equals(this.cacheTimeout, apIProduct.cacheTimeout) && Objects.equals((Object)this.visibility, (Object)apIProduct.visibility) && Objects.equals(this.visibleRoles, apIProduct.visibleRoles) && Objects.equals(this.visibleTenants, apIProduct.visibleTenants) && Objects.equals((Object)this.accessControl, (Object)apIProduct.accessControl) && Objects.equals(this.accessControlRoles, apIProduct.accessControlRoles) && Objects.equals((Object)this.apiType, (Object)apIProduct.apiType) && Objects.equals(this.transport, apIProduct.transport) && Objects.equals(this.tags, apIProduct.tags) && Objects.equals(this.policies, apIProduct.policies) && Objects.equals(this.apiThrottlingPolicy, apIProduct.apiThrottlingPolicy) && Objects.equals(this.authorizationHeader, apIProduct.authorizationHeader) && Objects.equals(this.securityScheme, apIProduct.securityScheme) && Objects.equals((Object)this.subscriptionAvailability, (Object)apIProduct.subscriptionAvailability) && Objects.equals(this.subscriptionAvailableTenants, apIProduct.subscriptionAvailableTenants) && Objects.equals(this.additionalProperties, apIProduct.additionalProperties) && Objects.equals(this.monetization, apIProduct.monetization) && Objects.equals(this.businessInformation, apIProduct.businessInformation) && Objects.equals(this.corsConfiguration, apIProduct.corsConfiguration) && Objects.equals(this.createdTime, apIProduct.createdTime) && Objects.equals(this.lastUpdatedTime, apIProduct.lastUpdatedTime) && Objects.equals(this.apis, apIProduct.apis) && Objects.equals(this.scopes, apIProduct.scopes) && Objects.equals(this.categories, apIProduct.categories);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.context, this.description, this.provider, this.hasThumbnail, this.state, this.enableSchemaValidation, this.isRevision, this.revisionedApiProductId, this.revisionId, this.responseCachingEnabled, this.cacheTimeout, this.visibility, this.visibleRoles, this.visibleTenants, this.accessControl, this.accessControlRoles, this.apiType, this.transport, this.tags, this.policies, this.apiThrottlingPolicy, this.authorizationHeader, this.securityScheme, this.subscriptionAvailability, this.subscriptionAvailableTenants, this.additionalProperties, this.monetization, this.businessInformation, this.corsConfiguration, this.createdTime, this.lastUpdatedTime, this.apis, this.scopes, this.categories});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class APIProductDTO {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    hasThumbnail: ").append(this.toIndentedString(this.hasThumbnail)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    enableSchemaValidation: ").append(this.toIndentedString(this.enableSchemaValidation)).append("\n");
        sb.append("    isRevision: ").append(this.toIndentedString(this.isRevision)).append("\n");
        sb.append("    revisionedApiProductId: ").append(this.toIndentedString(this.revisionedApiProductId)).append("\n");
        sb.append("    revisionId: ").append(this.toIndentedString(this.revisionId)).append("\n");
        sb.append("    responseCachingEnabled: ").append(this.toIndentedString(this.responseCachingEnabled)).append("\n");
        sb.append("    cacheTimeout: ").append(this.toIndentedString(this.cacheTimeout)).append("\n");
        sb.append("    visibility: ").append(this.toIndentedString((Object)this.visibility)).append("\n");
        sb.append("    visibleRoles: ").append(this.toIndentedString(this.visibleRoles)).append("\n");
        sb.append("    visibleTenants: ").append(this.toIndentedString(this.visibleTenants)).append("\n");
        sb.append("    accessControl: ").append(this.toIndentedString((Object)this.accessControl)).append("\n");
        sb.append("    accessControlRoles: ").append(this.toIndentedString(this.accessControlRoles)).append("\n");
        sb.append("    apiType: ").append(this.toIndentedString((Object)this.apiType)).append("\n");
        sb.append("    transport: ").append(this.toIndentedString(this.transport)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    policies: ").append(this.toIndentedString(this.policies)).append("\n");
        sb.append("    apiThrottlingPolicy: ").append(this.toIndentedString(this.apiThrottlingPolicy)).append("\n");
        sb.append("    authorizationHeader: ").append(this.toIndentedString(this.authorizationHeader)).append("\n");
        sb.append("    securityScheme: ").append(this.toIndentedString(this.securityScheme)).append("\n");
        sb.append("    subscriptionAvailability: ").append(this.toIndentedString((Object)this.subscriptionAvailability)).append("\n");
        sb.append("    subscriptionAvailableTenants: ").append(this.toIndentedString(this.subscriptionAvailableTenants)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("    monetization: ").append(this.toIndentedString(this.monetization)).append("\n");
        sb.append("    businessInformation: ").append(this.toIndentedString(this.businessInformation)).append("\n");
        sb.append("    corsConfiguration: ").append(this.toIndentedString(this.corsConfiguration)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    lastUpdatedTime: ").append(this.toIndentedString(this.lastUpdatedTime)).append("\n");
        sb.append("    apis: ").append(this.toIndentedString(this.apis)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    categories: ").append(this.toIndentedString(this.categories)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @XmlType(name="SubscriptionAvailabilityEnum")
    @XmlEnum(value=String.class)
    public static enum SubscriptionAvailabilityEnum {
        CURRENT_TENANT("CURRENT_TENANT"),
        ALL_TENANTS("ALL_TENANTS"),
        SPECIFIC_TENANTS("SPECIFIC_TENANTS");

        private String value;

        private SubscriptionAvailabilityEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SubscriptionAvailabilityEnum fromValue(String v) {
            for (SubscriptionAvailabilityEnum b : SubscriptionAvailabilityEnum.values()) {
                if (!String.valueOf(b.value).equals(v)) continue;
                return b;
            }
            return null;
        }
    }

    @XmlType(name="ApiTypeEnum")
    @XmlEnum(value=String.class)
    public static enum ApiTypeEnum {
        API("API"),
        APIPRODUCT("APIPRODUCT");

        private String value;

        private ApiTypeEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ApiTypeEnum fromValue(String v) {
            for (ApiTypeEnum b : ApiTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(v)) continue;
                return b;
            }
            return null;
        }
    }

    @XmlType(name="AccessControlEnum")
    @XmlEnum(value=String.class)
    public static enum AccessControlEnum {
        NONE("NONE"),
        RESTRICTED("RESTRICTED");

        private String value;

        private AccessControlEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AccessControlEnum fromValue(String v) {
            for (AccessControlEnum b : AccessControlEnum.values()) {
                if (!String.valueOf(b.value).equals(v)) continue;
                return b;
            }
            return null;
        }
    }

    @XmlType(name="VisibilityEnum")
    @XmlEnum(value=String.class)
    public static enum VisibilityEnum {
        PUBLIC("PUBLIC"),
        PRIVATE("PRIVATE"),
        RESTRICTED("RESTRICTED");

        private String value;

        private VisibilityEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static VisibilityEnum fromValue(String v) {
            for (VisibilityEnum b : VisibilityEnum.values()) {
                if (!String.valueOf(b.value).equals(v)) continue;
                return b;
            }
            return null;
        }
    }

    @XmlType(name="StateEnum")
    @XmlEnum(value=String.class)
    public static enum StateEnum {
        CREATED("CREATED"),
        PUBLISHED("PUBLISHED");

        private String value;

        private StateEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String v) {
            for (StateEnum b : StateEnum.values()) {
                if (!String.valueOf(b.value).equals(v)) continue;
                return b;
            }
            return null;
        }
    }
}

