/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;
import org.wso2.carbon.apimgt.rest.api.common.annotations.Scope;
import org.wso2.carbon.apimgt.rest.api.common.annotations.Scopes;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIAdditionalPropertiesDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIBusinessInformationDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APICorsConfigurationDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIMaxTpsDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIMonetizationInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIOperationsDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIScopeDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIServiceInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIThreatProtectionPoliciesDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.AdvertiseInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.MediationPolicyDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.WSDLInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.WebsubSubscriptionConfigurationDTO;

@Scopes(value={@Scope(name="apim:api_create", description="", value=""), @Scope(name="apim:api_import_export", description="", value="")})
public class APIDTO {
    private String id = null;
    private String name = null;
    private String description = null;
    private String context = null;
    private String version = null;
    private String provider = null;
    @Scope(name="apim:api_publish", description="", value="")
    private String lifeCycleStatus = null;
    private WSDLInfoDTO wsdlInfo = null;
    private String wsdlUrl = null;
    private Boolean responseCachingEnabled = null;
    private Integer cacheTimeout = null;
    private Boolean hasThumbnail = null;
    private Boolean isDefaultVersion = null;
    private Boolean isRevision = null;
    private String revisionedApiId = null;
    private Integer revisionId = null;
    private Boolean enableSchemaValidation = null;
    private TypeEnum type = TypeEnum.HTTP;
    private List<String> transport = new ArrayList<String>();
    @Scope(name="apim:api_publish", description="", value="")
    private List<String> tags = new ArrayList<String>();
    @Scope(name="apim:api_publish", description="", value="")
    private List<String> policies = new ArrayList<String>();
    @Scope(name="apim:api_publish", description="", value="")
    private String apiThrottlingPolicy = null;
    private String authorizationHeader = null;
    private List<String> securityScheme = new ArrayList<String>();
    private APIMaxTpsDTO maxTps = null;
    @Scope(name="apim:api_publish", description="", value="")
    private VisibilityEnum visibility = VisibilityEnum.PUBLIC;
    @Scope(name="apim:api_publish", description="", value="")
    private List<String> visibleRoles = new ArrayList<String>();
    private List<String> visibleTenants = new ArrayList<String>();
    private List<MediationPolicyDTO> mediationPolicies = new ArrayList<MediationPolicyDTO>();
    @Scope(name="apim:api_publish", description="", value="")
    private SubscriptionAvailabilityEnum subscriptionAvailability = SubscriptionAvailabilityEnum.CURRENT_TENANT;
    private List<String> subscriptionAvailableTenants = new ArrayList<String>();
    @Scope(name="apim:api_publish", description="", value="")
    private List<APIAdditionalPropertiesDTO> additionalProperties = new ArrayList<APIAdditionalPropertiesDTO>();
    private APIMonetizationInfoDTO monetization = null;
    private AccessControlEnum accessControl = AccessControlEnum.NONE;
    private List<String> accessControlRoles = new ArrayList<String>();
    @Scope(name="apim:api_publish", description="", value="")
    private APIBusinessInformationDTO businessInformation = null;
    private APICorsConfigurationDTO corsConfiguration = null;
    private WebsubSubscriptionConfigurationDTO websubSubscriptionConfiguration = null;
    private String workflowStatus = null;
    private String createdTime = null;
    @Scope(name="apim:api_publish", description="", value="")
    private String lastUpdatedTime = null;
    private Object endpointConfig = null;
    private EndpointImplementationTypeEnum endpointImplementationType = EndpointImplementationTypeEnum.ENDPOINT;
    private List<APIScopeDTO> scopes = new ArrayList<APIScopeDTO>();
    private List<APIOperationsDTO> operations = new ArrayList<APIOperationsDTO>();
    private APIThreatProtectionPoliciesDTO threatProtectionPolicies = null;
    @Scope(name="apim:api_publish", description="", value="")
    private List<String> categories = new ArrayList<String>();
    private Object keyManagers = null;
    private APIServiceInfoDTO serviceInfo = null;
    private AdvertiseInfoDTO advertiseInfo = null;

    public APIDTO id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="01234567-0123-0123-0123-012345678901", value="UUID of the api registry artifact ")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public APIDTO name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="PizzaShackAPI", required=true, value="")
    @JsonProperty(value="name")
    @NotNull
    @Pattern(regexp="(^[^~!@#;:%^*()+={}|\\\\<>\"',&$\\s+\\[\\]/]*$)")
    @Size(min=1, max=50)
    public @NotNull @Pattern(regexp="(^[^~!@#;:%^*()+={}|\\\\<>\"',&$\\s+\\[\\]/]*$)") @Size(min=1, max=50) String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public APIDTO description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="This is a simple API for Pizza Shack online pizza delivery store.", value="")
    @JsonProperty(value="description")
    @Size(max=32766)
    public @Size(max=32766) String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public APIDTO context(String context) {
        this.context = context;
        return this;
    }

    @ApiModelProperty(example="pizza", required=true, value="")
    @JsonProperty(value="context")
    @NotNull
    @Size(min=1, max=82)
    public @NotNull @Size(min=1, max=82) String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public APIDTO version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="1.0.0", required=true, value="")
    @JsonProperty(value="version")
    @NotNull
    @Pattern(regexp="^[^~!@#;:%^*()+={}|\\\\<>\"',&/$\\[\\]\\s+/]+$")
    @Size(min=1, max=30)
    public @NotNull @Pattern(regexp="^[^~!@#;:%^*()+={}|\\\\<>\"',&/$\\[\\]\\s+/]+$") @Size(min=1, max=30) String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public APIDTO provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="admin", value="If the provider value is not given user invoking the api will be used as the provider. ")
    @JsonProperty(value="provider")
    @Size(max=50)
    public @Size(max=50) String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public APIDTO lifeCycleStatus(String lifeCycleStatus) {
        this.lifeCycleStatus = lifeCycleStatus;
        return this;
    }

    @ApiModelProperty(example="CREATED", value="")
    @JsonProperty(value="lifeCycleStatus")
    public String getLifeCycleStatus() {
        return this.lifeCycleStatus;
    }

    public void setLifeCycleStatus(String lifeCycleStatus) {
        this.lifeCycleStatus = lifeCycleStatus;
    }

    public APIDTO wsdlInfo(WSDLInfoDTO wsdlInfo) {
        this.wsdlInfo = wsdlInfo;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="wsdlInfo")
    public WSDLInfoDTO getWsdlInfo() {
        return this.wsdlInfo;
    }

    public void setWsdlInfo(WSDLInfoDTO wsdlInfo) {
        this.wsdlInfo = wsdlInfo;
    }

    public APIDTO wsdlUrl(String wsdlUrl) {
        this.wsdlUrl = wsdlUrl;
        return this;
    }

    @ApiModelProperty(example="/apimgt/applicationdata/wsdls/admin--soap1.wsdl", value="")
    @JsonProperty(value="wsdlUrl")
    public String getWsdlUrl() {
        return this.wsdlUrl;
    }

    public void setWsdlUrl(String wsdlUrl) {
        this.wsdlUrl = wsdlUrl;
    }

    public APIDTO responseCachingEnabled(Boolean responseCachingEnabled) {
        this.responseCachingEnabled = responseCachingEnabled;
        return this;
    }

    @ApiModelProperty(example="true", value="")
    @JsonProperty(value="responseCachingEnabled")
    public Boolean isResponseCachingEnabled() {
        return this.responseCachingEnabled;
    }

    public void setResponseCachingEnabled(Boolean responseCachingEnabled) {
        this.responseCachingEnabled = responseCachingEnabled;
    }

    public APIDTO cacheTimeout(Integer cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
        return this;
    }

    @ApiModelProperty(example="300", value="")
    @JsonProperty(value="cacheTimeout")
    public Integer getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(Integer cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }

    public APIDTO hasThumbnail(Boolean hasThumbnail) {
        this.hasThumbnail = hasThumbnail;
        return this;
    }

    @ApiModelProperty(example="false", value="")
    @JsonProperty(value="hasThumbnail")
    public Boolean isHasThumbnail() {
        return this.hasThumbnail;
    }

    public void setHasThumbnail(Boolean hasThumbnail) {
        this.hasThumbnail = hasThumbnail;
    }

    public APIDTO isDefaultVersion(Boolean isDefaultVersion) {
        this.isDefaultVersion = isDefaultVersion;
        return this;
    }

    @ApiModelProperty(example="false", value="")
    @JsonProperty(value="isDefaultVersion")
    public Boolean isIsDefaultVersion() {
        return this.isDefaultVersion;
    }

    public void setIsDefaultVersion(Boolean isDefaultVersion) {
        this.isDefaultVersion = isDefaultVersion;
    }

    public APIDTO isRevision(Boolean isRevision) {
        this.isRevision = isRevision;
        return this;
    }

    @ApiModelProperty(example="false", value="")
    @JsonProperty(value="isRevision")
    public Boolean isIsRevision() {
        return this.isRevision;
    }

    public void setIsRevision(Boolean isRevision) {
        this.isRevision = isRevision;
    }

    public APIDTO revisionedApiId(String revisionedApiId) {
        this.revisionedApiId = revisionedApiId;
        return this;
    }

    @ApiModelProperty(example="01234567-0123-0123-0123-012345678901", value="UUID of the api registry artifact ")
    @JsonProperty(value="revisionedApiId")
    public String getRevisionedApiId() {
        return this.revisionedApiId;
    }

    public void setRevisionedApiId(String revisionedApiId) {
        this.revisionedApiId = revisionedApiId;
    }

    public APIDTO revisionId(Integer revisionId) {
        this.revisionId = revisionId;
        return this;
    }

    @ApiModelProperty(example="1", value="")
    @JsonProperty(value="revisionId")
    public Integer getRevisionId() {
        return this.revisionId;
    }

    public void setRevisionId(Integer revisionId) {
        this.revisionId = revisionId;
    }

    public APIDTO enableSchemaValidation(Boolean enableSchemaValidation) {
        this.enableSchemaValidation = enableSchemaValidation;
        return this;
    }

    @ApiModelProperty(example="false", value="")
    @JsonProperty(value="enableSchemaValidation")
    public Boolean isEnableSchemaValidation() {
        return this.enableSchemaValidation;
    }

    public void setEnableSchemaValidation(Boolean enableSchemaValidation) {
        this.enableSchemaValidation = enableSchemaValidation;
    }

    public APIDTO type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="HTTP", value="The api creation type to be used. Accepted values are HTTP, WS, SOAPTOREST, GRAPHQL, WEBSUB, SSE")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public APIDTO transport(List<String> transport) {
        this.transport = transport;
        return this;
    }

    @ApiModelProperty(example="[\"http\",\"https\"]", value="Supported transports for the API (http and/or https). ")
    @JsonProperty(value="transport")
    public List<String> getTransport() {
        return this.transport;
    }

    public void setTransport(List<String> transport) {
        this.transport = transport;
    }

    public APIDTO tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    @ApiModelProperty(example="[\"pizza\",\"food\"]", value="")
    @JsonProperty(value="tags")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public APIDTO policies(List<String> policies) {
        this.policies = policies;
        return this;
    }

    @ApiModelProperty(example="[\"Unlimited\"]", value="")
    @JsonProperty(value="policies")
    public List<String> getPolicies() {
        return this.policies;
    }

    public void setPolicies(List<String> policies) {
        this.policies = policies;
    }

    public APIDTO apiThrottlingPolicy(String apiThrottlingPolicy) {
        this.apiThrottlingPolicy = apiThrottlingPolicy;
        return this;
    }

    @ApiModelProperty(example="Unlimited", value="The API level throttling policy selected for the particular API")
    @JsonProperty(value="apiThrottlingPolicy")
    public String getApiThrottlingPolicy() {
        return this.apiThrottlingPolicy;
    }

    public void setApiThrottlingPolicy(String apiThrottlingPolicy) {
        this.apiThrottlingPolicy = apiThrottlingPolicy;
    }

    public APIDTO authorizationHeader(String authorizationHeader) {
        this.authorizationHeader = authorizationHeader;
        return this;
    }

    @ApiModelProperty(example="Authorization", value="Name of the Authorization header used for invoking the API. If it is not set, Authorization header name specified in tenant or system level will be used. ")
    @JsonProperty(value="authorizationHeader")
    @Pattern(regexp="(^[^~!@#;:%^*()+={}|\\\\<>\"',&$\\s+]*$)")
    public @Pattern(regexp="(^[^~!@#;:%^*()+={}|\\\\<>\"',&$\\s+]*$)") String getAuthorizationHeader() {
        return this.authorizationHeader;
    }

    public void setAuthorizationHeader(String authorizationHeader) {
        this.authorizationHeader = authorizationHeader;
    }

    public APIDTO securityScheme(List<String> securityScheme) {
        this.securityScheme = securityScheme;
        return this;
    }

    @ApiModelProperty(example="[\"oauth2\"]", value="Types of API security, the current API secured with. It can be either OAuth2 or mutual SSL or both. If it is not set OAuth2 will be set as the security for the current API. ")
    @JsonProperty(value="securityScheme")
    public List<String> getSecurityScheme() {
        return this.securityScheme;
    }

    public void setSecurityScheme(List<String> securityScheme) {
        this.securityScheme = securityScheme;
    }

    public APIDTO maxTps(APIMaxTpsDTO maxTps) {
        this.maxTps = maxTps;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="maxTps")
    public APIMaxTpsDTO getMaxTps() {
        return this.maxTps;
    }

    public void setMaxTps(APIMaxTpsDTO maxTps) {
        this.maxTps = maxTps;
    }

    public APIDTO visibility(VisibilityEnum visibility) {
        this.visibility = visibility;
        return this;
    }

    @ApiModelProperty(example="PUBLIC", value="The visibility level of the API. Accepts one of the following. PUBLIC, PRIVATE, RESTRICTED.")
    @JsonProperty(value="visibility")
    public VisibilityEnum getVisibility() {
        return this.visibility;
    }

    public void setVisibility(VisibilityEnum visibility) {
        this.visibility = visibility;
    }

    public APIDTO visibleRoles(List<String> visibleRoles) {
        this.visibleRoles = visibleRoles;
        return this;
    }

    @ApiModelProperty(example="[]", value="The user roles that are able to access the API in Developer Portal")
    @JsonProperty(value="visibleRoles")
    public List<String> getVisibleRoles() {
        return this.visibleRoles;
    }

    public void setVisibleRoles(List<String> visibleRoles) {
        this.visibleRoles = visibleRoles;
    }

    public APIDTO visibleTenants(List<String> visibleTenants) {
        this.visibleTenants = visibleTenants;
        return this;
    }

    @ApiModelProperty(example="[]", value="")
    @JsonProperty(value="visibleTenants")
    public List<String> getVisibleTenants() {
        return this.visibleTenants;
    }

    public void setVisibleTenants(List<String> visibleTenants) {
        this.visibleTenants = visibleTenants;
    }

    public APIDTO mediationPolicies(List<MediationPolicyDTO> mediationPolicies) {
        this.mediationPolicies = mediationPolicies;
        return this;
    }

    @ApiModelProperty(example="[{\"name\":\"json_to_xml_in_message\",\"type\":\"in\"},{\"name\":\"xml_to_json_out_message\",\"type\":\"out\"},{\"name\":\"json_fault\",\"type\":\"fault\"}]", value="")
    @Valid
    @JsonProperty(value="mediationPolicies")
    public List<MediationPolicyDTO> getMediationPolicies() {
        return this.mediationPolicies;
    }

    public void setMediationPolicies(List<MediationPolicyDTO> mediationPolicies) {
        this.mediationPolicies = mediationPolicies;
    }

    public APIDTO subscriptionAvailability(SubscriptionAvailabilityEnum subscriptionAvailability) {
        this.subscriptionAvailability = subscriptionAvailability;
        return this;
    }

    @ApiModelProperty(example="CURRENT_TENANT", value="The subscription availability. Accepts one of the following. CURRENT_TENANT, ALL_TENANTS or SPECIFIC_TENANTS.")
    @JsonProperty(value="subscriptionAvailability")
    public SubscriptionAvailabilityEnum getSubscriptionAvailability() {
        return this.subscriptionAvailability;
    }

    public void setSubscriptionAvailability(SubscriptionAvailabilityEnum subscriptionAvailability) {
        this.subscriptionAvailability = subscriptionAvailability;
    }

    public APIDTO subscriptionAvailableTenants(List<String> subscriptionAvailableTenants) {
        this.subscriptionAvailableTenants = subscriptionAvailableTenants;
        return this;
    }

    @ApiModelProperty(example="[]", value="")
    @JsonProperty(value="subscriptionAvailableTenants")
    public List<String> getSubscriptionAvailableTenants() {
        return this.subscriptionAvailableTenants;
    }

    public void setSubscriptionAvailableTenants(List<String> subscriptionAvailableTenants) {
        this.subscriptionAvailableTenants = subscriptionAvailableTenants;
    }

    public APIDTO additionalProperties(List<APIAdditionalPropertiesDTO> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @ApiModelProperty(value="Map of custom properties of API")
    @Valid
    @JsonProperty(value="additionalProperties")
    public List<APIAdditionalPropertiesDTO> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(List<APIAdditionalPropertiesDTO> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public APIDTO monetization(APIMonetizationInfoDTO monetization) {
        this.monetization = monetization;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="monetization")
    public APIMonetizationInfoDTO getMonetization() {
        return this.monetization;
    }

    public void setMonetization(APIMonetizationInfoDTO monetization) {
        this.monetization = monetization;
    }

    public APIDTO accessControl(AccessControlEnum accessControl) {
        this.accessControl = accessControl;
        return this;
    }

    @ApiModelProperty(value="Is the API is restricted to certain set of publishers or creators or is it visible to all the publishers and creators. If the accessControl restriction is none, this API can be modified by all the publishers and creators, if not it can only be viewable/modifiable by certain set of publishers and creators,  based on the restriction. ")
    @JsonProperty(value="accessControl")
    public AccessControlEnum getAccessControl() {
        return this.accessControl;
    }

    public void setAccessControl(AccessControlEnum accessControl) {
        this.accessControl = accessControl;
    }

    public APIDTO accessControlRoles(List<String> accessControlRoles) {
        this.accessControlRoles = accessControlRoles;
        return this;
    }

    @ApiModelProperty(example="[]", value="The user roles that are able to view/modify as API publisher or creator.")
    @JsonProperty(value="accessControlRoles")
    public List<String> getAccessControlRoles() {
        return this.accessControlRoles;
    }

    public void setAccessControlRoles(List<String> accessControlRoles) {
        this.accessControlRoles = accessControlRoles;
    }

    public APIDTO businessInformation(APIBusinessInformationDTO businessInformation) {
        this.businessInformation = businessInformation;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="businessInformation")
    public APIBusinessInformationDTO getBusinessInformation() {
        return this.businessInformation;
    }

    public void setBusinessInformation(APIBusinessInformationDTO businessInformation) {
        this.businessInformation = businessInformation;
    }

    public APIDTO corsConfiguration(APICorsConfigurationDTO corsConfiguration) {
        this.corsConfiguration = corsConfiguration;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="corsConfiguration")
    public APICorsConfigurationDTO getCorsConfiguration() {
        return this.corsConfiguration;
    }

    public void setCorsConfiguration(APICorsConfigurationDTO corsConfiguration) {
        this.corsConfiguration = corsConfiguration;
    }

    public APIDTO websubSubscriptionConfiguration(WebsubSubscriptionConfigurationDTO websubSubscriptionConfiguration) {
        this.websubSubscriptionConfiguration = websubSubscriptionConfiguration;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="websubSubscriptionConfiguration")
    public WebsubSubscriptionConfigurationDTO getWebsubSubscriptionConfiguration() {
        return this.websubSubscriptionConfiguration;
    }

    public void setWebsubSubscriptionConfiguration(WebsubSubscriptionConfigurationDTO websubSubscriptionConfiguration) {
        this.websubSubscriptionConfiguration = websubSubscriptionConfiguration;
    }

    public APIDTO workflowStatus(String workflowStatus) {
        this.workflowStatus = workflowStatus;
        return this;
    }

    @ApiModelProperty(example="APPROVED", value="")
    @JsonProperty(value="workflowStatus")
    public String getWorkflowStatus() {
        return this.workflowStatus;
    }

    public void setWorkflowStatus(String workflowStatus) {
        this.workflowStatus = workflowStatus;
    }

    public APIDTO createdTime(String createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="createdTime")
    public String getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public APIDTO lastUpdatedTime(String lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="lastUpdatedTime")
    public String getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void setLastUpdatedTime(String lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public APIDTO endpointConfig(Object endpointConfig) {
        this.endpointConfig = endpointConfig;
        return this;
    }

    @ApiModelProperty(example="{\"endpoint_type\":\"http\",\"sandbox_endpoints\":{\"url\":\"https://localhost:9443/am/sample/pizzashack/v1/api/\"},\"production_endpoints\":{\"url\":\"https://localhost:9443/am/sample/pizzashack/v1/api/\"}}", value="Endpoint configuration of the API. This can be used to provide different types of endpoints including Simple REST Endpoints, Loadbalanced and Failover.  `Simple REST Endpoint`   {     \"endpoint_type\": \"http\",     \"sandbox_endpoints\":       {        \"url\": \"https://localhost:9443/am/sample/pizzashack/v1/api/\"     },     \"production_endpoints\":       {        \"url\": \"https://localhost:9443/am/sample/pizzashack/v1/api/\"     }   }  `Loadbalanced Endpoint`    {     \"endpoint_type\": \"load_balance\",     \"algoCombo\": \"org.apache.synapse.endpoints.algorithms.RoundRobin\",     \"sessionManagement\": \"\",     \"sandbox_endpoints\":       [                 {           \"url\": \"https://localhost:9443/am/sample/pizzashack/v1/api/1\"        },                 {           \"endpoint_type\": \"http\",           \"template_not_supported\": false,           \"url\": \"https://localhost:9443/am/sample/pizzashack/v1/api/2\"        }     ],     \"production_endpoints\":       [                 {           \"url\": \"https://localhost:9443/am/sample/pizzashack/v1/api/3\"        },                 {           \"endpoint_type\": \"http\",           \"template_not_supported\": false,           \"url\": \"https://localhost:9443/am/sample/pizzashack/v1/api/4\"        }     ],     \"sessionTimeOut\": \"\",     \"algoClassName\": \"org.apache.synapse.endpoints.algorithms.RoundRobin\"   }  `Failover Endpoint`    {     \"production_failovers\":[        {           \"endpoint_type\":\"http\",           \"template_not_supported\":false,           \"url\":\"https://localhost:9443/am/sample/pizzashack/v1/api/1\"        }     ],     \"endpoint_type\":\"failover\",     \"sandbox_endpoints\":{        \"url\":\"https://localhost:9443/am/sample/pizzashack/v1/api/2\"     },     \"production_endpoints\":{        \"url\":\"https://localhost:9443/am/sample/pizzashack/v1/api/3\"     },     \"sandbox_failovers\":[        {           \"endpoint_type\":\"http\",           \"template_not_supported\":false,           \"url\":\"https://localhost:9443/am/sample/pizzashack/v1/api/4\"        }     ]   }  `Default Endpoint`    {     \"endpoint_type\":\"default\",     \"sandbox_endpoints\":{        \"url\":\"default\"     },     \"production_endpoints\":{        \"url\":\"default\"     }   }  `Endpoint from Endpoint Registry`   {     \"endpoint_type\": \"Registry\",     \"endpoint_id\": \"{registry-name:entry-name:version}\",   } ")
    @Valid
    @JsonProperty(value="endpointConfig")
    public Object getEndpointConfig() {
        return this.endpointConfig;
    }

    public void setEndpointConfig(Object endpointConfig) {
        this.endpointConfig = endpointConfig;
    }

    public APIDTO endpointImplementationType(EndpointImplementationTypeEnum endpointImplementationType) {
        this.endpointImplementationType = endpointImplementationType;
        return this;
    }

    @ApiModelProperty(example="INLINE", value="")
    @JsonProperty(value="endpointImplementationType")
    public EndpointImplementationTypeEnum getEndpointImplementationType() {
        return this.endpointImplementationType;
    }

    public void setEndpointImplementationType(EndpointImplementationTypeEnum endpointImplementationType) {
        this.endpointImplementationType = endpointImplementationType;
    }

    public APIDTO scopes(List<APIScopeDTO> scopes) {
        this.scopes = scopes;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="scopes")
    public List<APIScopeDTO> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<APIScopeDTO> scopes) {
        this.scopes = scopes;
    }

    public APIDTO operations(List<APIOperationsDTO> operations) {
        this.operations = operations;
        return this;
    }

    @ApiModelProperty(example="[{\"target\":\"/order/{orderId}\",\"verb\":\"POST\",\"authType\":\"Application & Application User\",\"throttlingPolicy\":\"Unlimited\"},{\"target\":\"/menu\",\"verb\":\"GET\",\"authType\":\"Application & Application User\",\"throttlingPolicy\":\"Unlimited\"}]", value="")
    @Valid
    @JsonProperty(value="operations")
    public List<APIOperationsDTO> getOperations() {
        return this.operations;
    }

    public void setOperations(List<APIOperationsDTO> operations) {
        this.operations = operations;
    }

    public APIDTO threatProtectionPolicies(APIThreatProtectionPoliciesDTO threatProtectionPolicies) {
        this.threatProtectionPolicies = threatProtectionPolicies;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="threatProtectionPolicies")
    public APIThreatProtectionPoliciesDTO getThreatProtectionPolicies() {
        return this.threatProtectionPolicies;
    }

    public void setThreatProtectionPolicies(APIThreatProtectionPoliciesDTO threatProtectionPolicies) {
        this.threatProtectionPolicies = threatProtectionPolicies;
    }

    public APIDTO categories(List<String> categories) {
        this.categories = categories;
        return this;
    }

    @ApiModelProperty(value="API categories ")
    @JsonProperty(value="categories")
    public List<String> getCategories() {
        return this.categories;
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public APIDTO keyManagers(Object keyManagers) {
        this.keyManagers = keyManagers;
        return this;
    }

    @ApiModelProperty(value="API Key Managers ")
    @Valid
    @JsonProperty(value="keyManagers")
    public Object getKeyManagers() {
        return this.keyManagers;
    }

    public void setKeyManagers(Object keyManagers) {
        this.keyManagers = keyManagers;
    }

    public APIDTO serviceInfo(APIServiceInfoDTO serviceInfo) {
        this.serviceInfo = serviceInfo;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="serviceInfo")
    public APIServiceInfoDTO getServiceInfo() {
        return this.serviceInfo;
    }

    public void setServiceInfo(APIServiceInfoDTO serviceInfo) {
        this.serviceInfo = serviceInfo;
    }

    public APIDTO advertiseInfo(AdvertiseInfoDTO advertiseInfo) {
        this.advertiseInfo = advertiseInfo;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="advertiseInfo")
    public AdvertiseInfoDTO getAdvertiseInfo() {
        return this.advertiseInfo;
    }

    public void setAdvertiseInfo(AdvertiseInfoDTO advertiseInfo) {
        this.advertiseInfo = advertiseInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIDTO API2 = (APIDTO)o;
        return Objects.equals(this.id, API2.id) && Objects.equals(this.name, API2.name) && Objects.equals(this.description, API2.description) && Objects.equals(this.context, API2.context) && Objects.equals(this.version, API2.version) && Objects.equals(this.provider, API2.provider) && Objects.equals(this.lifeCycleStatus, API2.lifeCycleStatus) && Objects.equals(this.wsdlInfo, API2.wsdlInfo) && Objects.equals(this.wsdlUrl, API2.wsdlUrl) && Objects.equals(this.responseCachingEnabled, API2.responseCachingEnabled) && Objects.equals(this.cacheTimeout, API2.cacheTimeout) && Objects.equals(this.hasThumbnail, API2.hasThumbnail) && Objects.equals(this.isDefaultVersion, API2.isDefaultVersion) && Objects.equals(this.isRevision, API2.isRevision) && Objects.equals(this.revisionedApiId, API2.revisionedApiId) && Objects.equals(this.revisionId, API2.revisionId) && Objects.equals(this.enableSchemaValidation, API2.enableSchemaValidation) && Objects.equals((Object)this.type, (Object)API2.type) && Objects.equals(this.transport, API2.transport) && Objects.equals(this.tags, API2.tags) && Objects.equals(this.policies, API2.policies) && Objects.equals(this.apiThrottlingPolicy, API2.apiThrottlingPolicy) && Objects.equals(this.authorizationHeader, API2.authorizationHeader) && Objects.equals(this.securityScheme, API2.securityScheme) && Objects.equals(this.maxTps, API2.maxTps) && Objects.equals((Object)this.visibility, (Object)API2.visibility) && Objects.equals(this.visibleRoles, API2.visibleRoles) && Objects.equals(this.visibleTenants, API2.visibleTenants) && Objects.equals(this.mediationPolicies, API2.mediationPolicies) && Objects.equals((Object)this.subscriptionAvailability, (Object)API2.subscriptionAvailability) && Objects.equals(this.subscriptionAvailableTenants, API2.subscriptionAvailableTenants) && Objects.equals(this.additionalProperties, API2.additionalProperties) && Objects.equals(this.monetization, API2.monetization) && Objects.equals((Object)this.accessControl, (Object)API2.accessControl) && Objects.equals(this.accessControlRoles, API2.accessControlRoles) && Objects.equals(this.businessInformation, API2.businessInformation) && Objects.equals(this.corsConfiguration, API2.corsConfiguration) && Objects.equals(this.websubSubscriptionConfiguration, API2.websubSubscriptionConfiguration) && Objects.equals(this.workflowStatus, API2.workflowStatus) && Objects.equals(this.createdTime, API2.createdTime) && Objects.equals(this.lastUpdatedTime, API2.lastUpdatedTime) && Objects.equals(this.endpointConfig, API2.endpointConfig) && Objects.equals((Object)this.endpointImplementationType, (Object)API2.endpointImplementationType) && Objects.equals(this.scopes, API2.scopes) && Objects.equals(this.operations, API2.operations) && Objects.equals(this.threatProtectionPolicies, API2.threatProtectionPolicies) && Objects.equals(this.categories, API2.categories) && Objects.equals(this.keyManagers, API2.keyManagers) && Objects.equals(this.serviceInfo, API2.serviceInfo) && Objects.equals(this.advertiseInfo, API2.advertiseInfo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.context, this.version, this.provider, this.lifeCycleStatus, this.wsdlInfo, this.wsdlUrl, this.responseCachingEnabled, this.cacheTimeout, this.hasThumbnail, this.isDefaultVersion, this.isRevision, this.revisionedApiId, this.revisionId, this.enableSchemaValidation, this.type, this.transport, this.tags, this.policies, this.apiThrottlingPolicy, this.authorizationHeader, this.securityScheme, this.maxTps, this.visibility, this.visibleRoles, this.visibleTenants, this.mediationPolicies, this.subscriptionAvailability, this.subscriptionAvailableTenants, this.additionalProperties, this.monetization, this.accessControl, this.accessControlRoles, this.businessInformation, this.corsConfiguration, this.websubSubscriptionConfiguration, this.workflowStatus, this.createdTime, this.lastUpdatedTime, this.endpointConfig, this.endpointImplementationType, this.scopes, this.operations, this.threatProtectionPolicies, this.categories, this.keyManagers, this.serviceInfo, this.advertiseInfo});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class APIDTO {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    lifeCycleStatus: ").append(this.toIndentedString(this.lifeCycleStatus)).append("\n");
        sb.append("    wsdlInfo: ").append(this.toIndentedString(this.wsdlInfo)).append("\n");
        sb.append("    wsdlUrl: ").append(this.toIndentedString(this.wsdlUrl)).append("\n");
        sb.append("    responseCachingEnabled: ").append(this.toIndentedString(this.responseCachingEnabled)).append("\n");
        sb.append("    cacheTimeout: ").append(this.toIndentedString(this.cacheTimeout)).append("\n");
        sb.append("    hasThumbnail: ").append(this.toIndentedString(this.hasThumbnail)).append("\n");
        sb.append("    isDefaultVersion: ").append(this.toIndentedString(this.isDefaultVersion)).append("\n");
        sb.append("    isRevision: ").append(this.toIndentedString(this.isRevision)).append("\n");
        sb.append("    revisionedApiId: ").append(this.toIndentedString(this.revisionedApiId)).append("\n");
        sb.append("    revisionId: ").append(this.toIndentedString(this.revisionId)).append("\n");
        sb.append("    enableSchemaValidation: ").append(this.toIndentedString(this.enableSchemaValidation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    transport: ").append(this.toIndentedString(this.transport)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    policies: ").append(this.toIndentedString(this.policies)).append("\n");
        sb.append("    apiThrottlingPolicy: ").append(this.toIndentedString(this.apiThrottlingPolicy)).append("\n");
        sb.append("    authorizationHeader: ").append(this.toIndentedString(this.authorizationHeader)).append("\n");
        sb.append("    securityScheme: ").append(this.toIndentedString(this.securityScheme)).append("\n");
        sb.append("    maxTps: ").append(this.toIndentedString(this.maxTps)).append("\n");
        sb.append("    visibility: ").append(this.toIndentedString((Object)this.visibility)).append("\n");
        sb.append("    visibleRoles: ").append(this.toIndentedString(this.visibleRoles)).append("\n");
        sb.append("    visibleTenants: ").append(this.toIndentedString(this.visibleTenants)).append("\n");
        sb.append("    mediationPolicies: ").append(this.toIndentedString(this.mediationPolicies)).append("\n");
        sb.append("    subscriptionAvailability: ").append(this.toIndentedString((Object)this.subscriptionAvailability)).append("\n");
        sb.append("    subscriptionAvailableTenants: ").append(this.toIndentedString(this.subscriptionAvailableTenants)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("    monetization: ").append(this.toIndentedString(this.monetization)).append("\n");
        sb.append("    accessControl: ").append(this.toIndentedString((Object)this.accessControl)).append("\n");
        sb.append("    accessControlRoles: ").append(this.toIndentedString(this.accessControlRoles)).append("\n");
        sb.append("    businessInformation: ").append(this.toIndentedString(this.businessInformation)).append("\n");
        sb.append("    corsConfiguration: ").append(this.toIndentedString(this.corsConfiguration)).append("\n");
        sb.append("    websubSubscriptionConfiguration: ").append(this.toIndentedString(this.websubSubscriptionConfiguration)).append("\n");
        sb.append("    workflowStatus: ").append(this.toIndentedString(this.workflowStatus)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    lastUpdatedTime: ").append(this.toIndentedString(this.lastUpdatedTime)).append("\n");
        sb.append("    endpointConfig: ").append(this.toIndentedString(this.endpointConfig)).append("\n");
        sb.append("    endpointImplementationType: ").append(this.toIndentedString((Object)this.endpointImplementationType)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    operations: ").append(this.toIndentedString(this.operations)).append("\n");
        sb.append("    threatProtectionPolicies: ").append(this.toIndentedString(this.threatProtectionPolicies)).append("\n");
        sb.append("    categories: ").append(this.toIndentedString(this.categories)).append("\n");
        sb.append("    keyManagers: ").append(this.toIndentedString(this.keyManagers)).append("\n");
        sb.append("    serviceInfo: ").append(this.toIndentedString(this.serviceInfo)).append("\n");
        sb.append("    advertiseInfo: ").append(this.toIndentedString(this.advertiseInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @XmlType(name="EndpointImplementationTypeEnum")
    @XmlEnum(value=String.class)
    public static enum EndpointImplementationTypeEnum {
        INLINE("INLINE"),
        ENDPOINT("ENDPOINT");

        private String value;

        private EndpointImplementationTypeEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EndpointImplementationTypeEnum fromValue(String v) {
            for (EndpointImplementationTypeEnum b : EndpointImplementationTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(v)) continue;
                return b;
            }
            return null;
        }
    }

    @XmlType(name="AccessControlEnum")
    @XmlEnum(value=String.class)
    public static enum AccessControlEnum {
        NONE("NONE"),
        RESTRICTED("RESTRICTED");

        private String value;

        private AccessControlEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AccessControlEnum fromValue(String v) {
            for (AccessControlEnum b : AccessControlEnum.values()) {
                if (!String.valueOf(b.value).equals(v)) continue;
                return b;
            }
            return null;
        }
    }

    @XmlType(name="SubscriptionAvailabilityEnum")
    @XmlEnum(value=String.class)
    public static enum SubscriptionAvailabilityEnum {
        CURRENT_TENANT("CURRENT_TENANT"),
        ALL_TENANTS("ALL_TENANTS"),
        SPECIFIC_TENANTS("SPECIFIC_TENANTS");

        private String value;

        private SubscriptionAvailabilityEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SubscriptionAvailabilityEnum fromValue(String v) {
            for (SubscriptionAvailabilityEnum b : SubscriptionAvailabilityEnum.values()) {
                if (!String.valueOf(b.value).equals(v)) continue;
                return b;
            }
            return null;
        }
    }

    @XmlType(name="VisibilityEnum")
    @XmlEnum(value=String.class)
    public static enum VisibilityEnum {
        PUBLIC("PUBLIC"),
        PRIVATE("PRIVATE"),
        RESTRICTED("RESTRICTED");

        private String value;

        private VisibilityEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static VisibilityEnum fromValue(String v) {
            for (VisibilityEnum b : VisibilityEnum.values()) {
                if (!String.valueOf(b.value).equals(v)) continue;
                return b;
            }
            return null;
        }
    }

    @XmlType(name="TypeEnum")
    @XmlEnum(value=String.class)
    public static enum TypeEnum {
        HTTP("HTTP"),
        WS("WS"),
        SOAPTOREST("SOAPTOREST"),
        SOAP("SOAP"),
        GRAPHQL("GRAPHQL"),
        WEBSUB("WEBSUB"),
        SSE("SSE");

        private String value;

        private TypeEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String v) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(v)) continue;
                return b;
            }
            return null;
        }
    }
}

