/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.impl.template.APITemplateException;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.ConfigContext;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.ConfigContextDecorator;

public class TransportConfigContext
extends ConfigContextDecorator {
    private API api;
    private APIProduct apiProduct;

    public TransportConfigContext(ConfigContext context, API api) {
        super(context);
        this.api = api;
    }

    public TransportConfigContext(ConfigContext context, APIProduct apiProduct) {
        super(context);
        this.apiProduct = apiProduct;
    }

    @Override
    public void validate() throws APITemplateException, APIManagementException {
        super.validate();
    }

    @Override
    public VelocityContext getContext() {
        VelocityContext context = super.getContext();
        String transportsString = "";
        if (this.api != null) {
            transportsString = this.api.getTransports();
        } else if (this.apiProduct != null) {
            transportsString = this.apiProduct.getTransports();
        }
        this.setTransportInVelocityContext(context, transportsString);
        return context;
    }

    private void setTransportInVelocityContext(VelocityContext context, String transportsString) {
        String apiSecurity = null;
        if (this.api != null) {
            apiSecurity = this.api.getApiSecurity();
        } else if (this.apiProduct != null) {
            apiSecurity = this.apiProduct.getApiSecurity();
        }
        if (StringUtils.isNotEmpty((String)apiSecurity) && (apiSecurity.contains("mutualssl") || apiSecurity.contains("mutualssl_mandatory"))) {
            context.put("transport", (Object)"https");
            return;
        }
        if (transportsString.contains(",")) {
            ArrayList<String> transports = new ArrayList<String>(Arrays.asList(transportsString.split(",")));
            if (transports.contains("http") && transports.contains("https")) {
                context.put("transport", (Object)"");
            }
        } else {
            context.put("transport", (Object)transportsString);
        }
    }
}

