/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.api.model.APIProductResource;
import org.wso2.carbon.apimgt.api.model.EndpointSecurity;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.template.APITemplateException;
import org.wso2.carbon.apimgt.impl.utils.GatewayUtils;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.ConfigContext;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.ConfigContextDecorator;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.EndpointSecurityModel;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIDTO;

public class SecurityConfigContext
extends ConfigContextDecorator {
    private API api;
    private APIProduct apiProduct;
    private JSONObject productionEndpointSecurity;
    private JSONObject sandboxEndpointSecurity;
    private Map<String, APIDTO> associatedAPIMap;

    public SecurityConfigContext(ConfigContext context, API api) {
        super(context);
        this.api = api;
    }

    public SecurityConfigContext(ConfigContext context, APIProduct apiProduct, Map<String, APIDTO> associatedAPIMap) {
        super(context);
        this.apiProduct = apiProduct;
        this.associatedAPIMap = associatedAPIMap;
    }

    @Override
    public void validate() throws APITemplateException, APIManagementException {
        super.validate();
        if (this.api != null) {
            JSONParser parser = new JSONParser();
            String apiEndpointConfig = this.api.getEndpointConfig();
            if (StringUtils.isNotEmpty((CharSequence)apiEndpointConfig)) {
                try {
                    Object config = parser.parse(apiEndpointConfig);
                    JSONObject endpointConfig = (JSONObject)config;
                    if (endpointConfig.get((Object)"endpoint_security") != null) {
                        JSONObject endpointSecurity = (JSONObject)endpointConfig.get((Object)"endpoint_security");
                        if (endpointSecurity.get((Object)"production") != null) {
                            this.productionEndpointSecurity = (JSONObject)endpointSecurity.get((Object)"production");
                        }
                        if (endpointSecurity.get((Object)"sandbox") != null) {
                            this.sandboxEndpointSecurity = (JSONObject)endpointSecurity.get((Object)"sandbox");
                        }
                    }
                }
                catch (ParseException e) {
                    this.handleException("Unable to pass the endpoint JSON config");
                }
            }
        }
    }

    @Override
    public VelocityContext getContext() {
        VelocityContext context = super.getContext();
        boolean isSecureVaultEnabled = Boolean.parseBoolean(this.getApiManagerConfiguration().getFirstProperty("EnableSecureVault"));
        if (this.api != null) {
            HashMap<String, EndpointSecurityModel> endpointSecurityModelMap = new HashMap<String, EndpointSecurityModel>();
            endpointSecurityModelMap.put("production", new EndpointSecurityModel());
            endpointSecurityModelMap.put("sandbox", new EndpointSecurityModel());
            if (StringUtils.isNotEmpty((CharSequence)this.api.getEndpointConfig())) {
                EndpointSecurityModel endpointSecurityModel;
                if (this.productionEndpointSecurity != null) {
                    endpointSecurityModel = (EndpointSecurityModel)new ObjectMapper().convertValue((Object)this.productionEndpointSecurity, EndpointSecurityModel.class);
                    if ((endpointSecurityModel = this.retrieveEndpointSecurityModel(endpointSecurityModel, this.api.getId().getApiName(), this.api.getId().getVersion(), this.api.getUuid(), "production", null)) != null) {
                        endpointSecurityModelMap.put("production", endpointSecurityModel);
                    }
                }
                if (this.sandboxEndpointSecurity != null) {
                    endpointSecurityModel = (EndpointSecurityModel)new ObjectMapper().convertValue((Object)this.sandboxEndpointSecurity, EndpointSecurityModel.class);
                    if ((endpointSecurityModel = this.retrieveEndpointSecurityModel(endpointSecurityModel, this.api.getId().getApiName(), this.api.getId().getVersion(), this.api.getUuid(), "sandbox", null)) != null) {
                        endpointSecurityModelMap.put("sandbox", endpointSecurityModel);
                    }
                }
            }
            context.put("endpoint_security", endpointSecurityModelMap);
        } else if (this.apiProduct != null) {
            HashMap endpointSecurityModelMap = new HashMap();
            for (APIProductResource apiProductResource : this.apiProduct.getProductResources()) {
                APIDTO apidto = this.associatedAPIMap.get(apiProductResource.getApiId());
                String alias = this.apiProduct.getId().getName() + "--v" + this.apiProduct.getId().getVersion();
                HashMap stringEndpointSecurityModelMap = new HashMap();
                Map endpointSecurityMap = apiProductResource.getEndpointSecurityMap();
                for (Map.Entry endpointSecurityEntry : endpointSecurityMap.entrySet()) {
                    EndpointSecurityModel endpointSecurityModel = new EndpointSecurityModel((EndpointSecurity)endpointSecurityEntry.getValue());
                    endpointSecurityModel = this.retrieveEndpointSecurityModel(endpointSecurityModel, apidto.getName(), apidto.getVersion(), apidto.getId(), (String)endpointSecurityEntry.getKey(), alias);
                    stringEndpointSecurityModelMap.put(endpointSecurityEntry.getKey(), endpointSecurityModel);
                }
                endpointSecurityModelMap.put(apiProductResource.getApiId(), stringEndpointSecurityModelMap);
            }
            context.put("endpoint_security", endpointSecurityModelMap);
        }
        context.put("isSecureVaultEnabled", (Object)isSecureVaultEnabled);
        return context;
    }

    protected APIManagerConfiguration getApiManagerConfiguration() {
        return ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
    }

    private EndpointSecurityModel retrieveEndpointSecurityModel(EndpointSecurityModel endpointSecurityModel, String apiName, String version, String apiId, String type, String prefix) {
        if (endpointSecurityModel != null && endpointSecurityModel.isEnabled()) {
            if ("oauth".equalsIgnoreCase(endpointSecurityModel.getType())) {
                if (StringUtils.isNotEmpty((CharSequence)prefix)) {
                    endpointSecurityModel.setUniqueIdentifier(prefix.concat("--").concat(GatewayUtils.retrieveUniqueIdentifier((String)apiId, (String)type)));
                } else {
                    endpointSecurityModel.setUniqueIdentifier(GatewayUtils.retrieveUniqueIdentifier((String)apiId, (String)type));
                }
                if (StringUtils.isNotEmpty((CharSequence)prefix)) {
                    endpointSecurityModel.setClientSecretAlias(prefix.concat("--").concat(GatewayUtils.retrieveOauthClientSecretAlias((String)apiName, (String)version, (String)type)));
                } else {
                    endpointSecurityModel.setClientSecretAlias(GatewayUtils.retrieveOauthClientSecretAlias((String)apiName, (String)version, (String)type));
                }
                if (StringUtils.isNotEmpty((CharSequence)prefix)) {
                    endpointSecurityModel.setPasswordAlias(prefix.concat("--").concat(GatewayUtils.retrieveOAuthPasswordAlias((String)apiName, (String)version, (String)type)));
                } else {
                    endpointSecurityModel.setPasswordAlias(GatewayUtils.retrieveOAuthPasswordAlias((String)apiName, (String)version, (String)type));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)endpointSecurityModel.getUsername()) && StringUtils.isNotBlank((CharSequence)endpointSecurityModel.getPassword())) {
                endpointSecurityModel.setBase64EncodedPassword(new String(Base64.encodeBase64((byte[])endpointSecurityModel.getUsername().concat(":").concat(endpointSecurityModel.getPassword()).getBytes())));
            }
            if (StringUtils.isNotEmpty((CharSequence)prefix)) {
                endpointSecurityModel.setAlias(prefix.concat("--").concat(GatewayUtils.retrieveBasicAuthAlias((String)apiName, (String)version, (String)type)));
            } else {
                endpointSecurityModel.setAlias(GatewayUtils.retrieveBasicAuthAlias((String)apiName, (String)version, (String)type));
            }
            return endpointSecurityModel;
        }
        return null;
    }
}

