/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template;

import java.util.ArrayList;
import org.apache.velocity.VelocityContext;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.api.model.APIProductResource;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.ConfigContext;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.ConfigContextDecorator;

public class ResourceConfigContext
extends ConfigContextDecorator {
    private API api;
    private APIProduct apiProduct;
    private String faultSeqExt;

    public ResourceConfigContext(ConfigContext context, API api) {
        super(context);
        this.api = api;
    }

    public ResourceConfigContext(ConfigContext context, APIProduct apiProduct) {
        super(context);
        this.apiProduct = apiProduct;
    }

    @Override
    public void validate() throws APIManagementException {
        if (this.api != null) {
            if (this.api.getUriTemplates() == null || this.api.getUriTemplates().isEmpty()) {
                throw new APIManagementException("At least one resource is required");
            }
            this.faultSeqExt = APIUtil.getFaultSequenceName((API)this.api);
        }
    }

    @Override
    public VelocityContext getContext() {
        VelocityContext context = super.getContext();
        if (this.api != null) {
            context.put("resources", (Object)this.api.getUriTemplates());
            context.put("apiType", (Object)this.api.getType());
            context.put("faultSequence", (Object)(this.faultSeqExt != null ? this.faultSeqExt : this.api.getFaultSequence()));
        } else if (this.apiProduct != null) {
            ArrayList productResources = new ArrayList(this.apiProduct.getProductResources());
            ArrayList<APIProductResource> aggregateResources = new ArrayList<APIProductResource>();
            ArrayList<String> uriTemplateNames = new ArrayList<String>();
            for (APIProductResource productResource : productResources) {
                URITemplate uriTemplate = productResource.getUriTemplate();
                String productResourceKey = productResource.getApiIdentifier() + ":" + uriTemplate.getUriTemplate();
                if (uriTemplateNames.contains(productResourceKey)) {
                    for (APIProductResource resource : aggregateResources) {
                        String resourceKey = resource.getApiIdentifier() + ":" + resource.getUriTemplate().getUriTemplate();
                        if (!resourceKey.equals(productResourceKey)) continue;
                        resource.getUriTemplate().setHttpVerbs(uriTemplate.getHTTPVerb());
                    }
                    continue;
                }
                uriTemplate.setHttpVerbs(uriTemplate.getHTTPVerb());
                aggregateResources.add(productResource);
                uriTemplateNames.add(productResourceKey);
            }
            context.put("apiType", (Object)this.apiProduct.getType());
            context.put("aggregates", aggregateResources);
        }
        return context;
    }
}

