/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.CommonsLogLogChute;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.json.simple.JSONArray;
import org.wso2.carbon.apimgt.impl.APIManagerConfigurationService;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.SOAPToRESTConfigContext;

public class RESTToSOAPMsgTemplate {
    private static final Log log = LogFactory.getLog(RESTToSOAPMsgTemplate.class);
    private String velocityLogPath = null;
    private static final String IN_SEQ_TEMPLATE_FILE = "soap_to_rest_in_seq_template";
    private static final String OUT_SEQ_TEMPLATE_FILE = "soap_to_rest_out_seq_template";

    public String getMappingInSequence(Map<String, String> mapping, String method, String soapAction, String namespace, String soapNamespace, JSONArray array) {
        SOAPToRESTConfigContext configcontext = new SOAPToRESTConfigContext(mapping, method, soapAction, namespace, soapNamespace, array);
        StringWriter writer = new StringWriter();
        try {
            VelocityContext context = configcontext.getContext();
            context.internalGetKeys();
            VelocityEngine velocityengine = new VelocityEngine();
            if (!"not-defined".equalsIgnoreCase(this.getVelocityLogger())) {
                velocityengine.setProperty("runtime.log.logsystem.class", (Object)CommonsLogLogChute.class.getName());
                velocityengine.setProperty("resource.loader", (Object)"classpath");
                velocityengine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            }
            velocityengine.init();
            Template t = velocityengine.getTemplate(this.getInSeqTemplatePath());
            t.merge((Context)context, (Writer)writer);
        }
        catch (Exception e) {
            log.error((Object)"Velocity Error", (Throwable)e);
        }
        return writer.toString();
    }

    public String getMappingOutSequence() {
        SOAPToRESTConfigContext configcontext = new SOAPToRESTConfigContext();
        StringWriter writer = new StringWriter();
        try {
            VelocityContext context = configcontext.getContext();
            context.internalGetKeys();
            VelocityEngine velocityengine = new VelocityEngine();
            if (!"not-defined".equalsIgnoreCase(this.getVelocityLogger())) {
                velocityengine.setProperty("runtime.log.logsystem.class", (Object)CommonsLogLogChute.class.getName());
                velocityengine.setProperty("resource.loader", (Object)"classpath");
                velocityengine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            }
            velocityengine.init();
            Template template = velocityengine.getTemplate(this.getOutSeqTemplatePath());
            template.merge((Context)context, (Writer)writer);
        }
        catch (Exception e) {
            log.error((Object)"Velocity Error", (Throwable)e);
        }
        return writer.toString();
    }

    private String getInSeqTemplatePath() {
        return "repository" + File.separator + "resources" + File.separator + "api_templates" + File.separator + IN_SEQ_TEMPLATE_FILE + ".xml";
    }

    private String getOutSeqTemplatePath() {
        return "repository" + File.separator + "resources" + File.separator + "api_templates" + File.separator + OUT_SEQ_TEMPLATE_FILE + ".xml";
    }

    private String getVelocityLogger() {
        if (this.velocityLogPath != null) {
            return this.velocityLogPath;
        }
        APIManagerConfigurationService config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService();
        String velocityLogPath = config.getAPIManagerConfiguration().getFirstProperty("VelocityLogger");
        this.velocityLogPath = velocityLogPath != null && velocityLogPath.length() > 1 ? velocityLogPath : "not-defined";
        return this.velocityLogPath;
    }
}

