/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template;

import org.apache.velocity.VelocityContext;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.impl.template.APITemplateException;
import org.wso2.carbon.apimgt.impl.utils.GatewayUtils;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.ConfigContext;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.ConfigContextDecorator;

public class EndpointConfigContext
extends ConfigContextDecorator {
    private API api;
    private APIProduct apiProduct;
    private JSONObject endpointConfig;

    public EndpointConfigContext(ConfigContext context, API api) {
        super(context);
        this.api = api;
    }

    public EndpointConfigContext(ConfigContext configcontext, APIProduct apiProduct, API api) {
        super(configcontext);
        this.api = api;
        this.apiProduct = apiProduct;
    }

    @Override
    public void validate() throws APITemplateException, APIManagementException {
        super.validate();
        JSONParser parser = new JSONParser();
        String configJson = this.api.getEndpointConfig();
        if (configJson != null && !"".equals(configJson)) {
            try {
                Object config = parser.parse(configJson);
                JSONObject epConfig = (JSONObject)config;
                if ("awslambda".equals(epConfig.get((Object)"endpoint_type"))) {
                    this.processLambdaConfig(this.api, epConfig);
                }
                this.endpointConfig = epConfig;
            }
            catch (ParseException e) {
                this.handleException("Unable to pass the endpoint JSON config");
            }
        }
    }

    @Override
    public VelocityContext getContext() {
        VelocityContext context = super.getContext();
        context.put("endpoint_config", (Object)this.endpointConfig);
        if (this.apiProduct == null) {
            context.put("endpointKey", (Object)this.getEndpointKey(this.api));
        } else {
            context.put("endpointKey", (Object)this.getEndpointKey(this.apiProduct, this.api));
        }
        return context;
    }

    private String getEndpointKey(APIProduct apiProduct, API api) {
        return this.getEndpointKey(apiProduct.getId().getName(), apiProduct.getId().getVersion()).concat("--").concat(api.getUuid());
    }

    private String getEndpointKey(API api) {
        return this.getEndpointKey(api.getId().getApiName(), api.getId().getVersion());
    }

    private String getEndpointKey(String name, String version) {
        return name + "--v" + version;
    }

    private JSONObject processLambdaConfig(API api, JSONObject awsConfig) {
        String awsAlias = GatewayUtils.retrieveAWSCredAlias((String)api.getId().getApiName(), (String)api.getId().getVersion(), (String)"awslambda");
        awsConfig.put((Object)"awsAlias", (Object)awsAlias);
        return awsConfig;
    }
}

