/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.CommonsLogLogChute;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.api.model.Environment;
import org.wso2.carbon.apimgt.impl.APIConstants;
import org.wso2.carbon.apimgt.impl.APIManagerConfigurationService;
import org.wso2.carbon.apimgt.impl.dto.SoapToRestMediationDto;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.template.APITemplateBuilder;
import org.wso2.carbon.apimgt.impl.template.APITemplateException;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.SequenceUtils;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.APIConfigContext;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.ConfigContext;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.EndpointBckConfigContext;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.EndpointConfigContext;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.EnvironmentConfigContext;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.HandlerConfig;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.HandlerConfigContex;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.JwtConfigContext;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.ResourceConfigContext;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.ResponseCacheConfigContext;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.SecurityConfigContext;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.TemplateUtilContext;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.TransportConfigContext;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIDTO;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.CarbonUtils;

public class APITemplateBuilderImpl
implements APITemplateBuilder {
    public static final String TEMPLATE_TYPE_VELOCITY = "velocity_template";
    public static final String TEMPLATE_WEBSUB_API = "websub_api_template";
    public static final String TEMPLATE_TYPE_PROTOTYPE = "prototype_template";
    public static final String TEMPLATE_DEFAULT_API = "default_api_template";
    public static final String TEMPLATE_DEFAULT_WS_API = "default_ws_api_template";
    private static final Log log = LogFactory.getLog(APITemplateBuilderImpl.class);
    private static final String TEMPLATE_TYPE_ENDPOINT = "endpoint_template";
    private static final String TEMPLATE_TYPE_API_PRODUCT = "api_product_template";
    private List<SoapToRestMediationDto> soapToRestOutMediationDtoList;
    private List<SoapToRestMediationDto> soapToRestInMediationDtoList;
    private API api;
    private APIProduct apiProduct;
    private String velocityLogPath = null;
    private List<HandlerConfig> handlers = new ArrayList<HandlerConfig>();
    private Map<String, APIDTO> associatedAPIMap = new HashMap<String, APIDTO>();

    public APITemplateBuilderImpl(API api) {
        this.api = api;
    }

    public APITemplateBuilderImpl(APIProduct apiProduct, Map<String, APIDTO> associatedAPIMap) {
        this.apiProduct = apiProduct;
        this.associatedAPIMap = associatedAPIMap;
    }

    public APITemplateBuilderImpl(API api, List<SoapToRestMediationDto> soapToRestInMediationDtoList, List<SoapToRestMediationDto> soapToRestOutMediationDtoList) {
        this(api);
        this.soapToRestInMediationDtoList = soapToRestInMediationDtoList;
        this.soapToRestOutMediationDtoList = soapToRestOutMediationDtoList;
    }

    public APITemplateBuilderImpl(API api, APIProduct apiProduct) {
        this.api = api;
        this.apiProduct = apiProduct;
    }

    public String getConfigStringForTemplate(Environment environment) throws APITemplateException {
        StringWriter writer = new StringWriter();
        try {
            ConfigContext configcontext = null;
            configcontext = this.api != null ? this.createConfigContext(this.api, environment) : this.createConfigContext(this.apiProduct, environment);
            configcontext.validate();
            VelocityContext context = configcontext.getContext();
            context.internalGetKeys();
            VelocityEngine velocityengine = new VelocityEngine();
            if (!"not-defined".equalsIgnoreCase(this.getVelocityLogger())) {
                velocityengine.setProperty("runtime.log.logsystem.class", (Object)CommonsLogLogChute.class.getName());
                velocityengine.setProperty("resource.loader", (Object)"classpath");
                velocityengine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            }
            velocityengine.setProperty("file.resource.loader.path", (Object)CarbonUtils.getCarbonHome());
            this.initVelocityEngine(velocityengine);
            Template t = null;
            if (this.api != null) {
                t = velocityengine.getTemplate(this.getTemplatePath());
                if (APIConstants.APITransportType.WS.toString().equals(this.api.getType())) {
                    context.put("topicMappings", (Object)this.api.getWebSocketTopicMappingConfiguration().getMappings());
                } else if (APIConstants.APITransportType.WEBSUB.toString().equals(this.api.getType())) {
                    String signingAlgorithm = this.api.getWebsubSubscriptionConfiguration().getSigningAlgorithm();
                    context.put("signingAlgorithm", (Object)(signingAlgorithm.toLowerCase() + "="));
                    context.put("secret", (Object)this.api.getWebsubSubscriptionConfiguration().getSecret());
                    context.put("hmacSignatureGenerationAlgorithm", (Object)("Hmac" + signingAlgorithm));
                    context.put("signatureHeader", (Object)this.api.getWebsubSubscriptionConfiguration().getSignatureHeader());
                    context.put("isSecurityEnabled", (Object)(!StringUtils.isEmpty((CharSequence)this.api.getWebsubSubscriptionConfiguration().getSecret()) ? 1 : 0));
                }
            } else {
                t = velocityengine.getTemplate(this.getApiProductTemplatePath());
            }
            t.merge((Context)context, (Writer)writer);
        }
        catch (Exception e) {
            log.error((Object)"Velocity Error", (Throwable)e);
            throw new APITemplateException("Velocity Error", (Throwable)e);
        }
        return writer.toString();
    }

    public String getConfigStringForPrototypeScriptAPI(Environment environment) throws APITemplateException {
        StringWriter writer = new StringWriter();
        try {
            ConfigContext configcontext = new APIConfigContext(this.api);
            configcontext = new TransportConfigContext(configcontext, this.api);
            configcontext = new ResourceConfigContext(configcontext, this.api);
            configcontext = new EndpointBckConfigContext(configcontext, this.api);
            configcontext = new EndpointConfigContext(configcontext, this.api);
            configcontext = new SecurityConfigContext(configcontext, this.api);
            configcontext = new JwtConfigContext(configcontext);
            configcontext = new ResponseCacheConfigContext(configcontext, this.api);
            configcontext = new HandlerConfigContex(configcontext, this.handlers);
            configcontext = new EnvironmentConfigContext(configcontext, environment);
            configcontext = new TemplateUtilContext(configcontext);
            configcontext.validate();
            VelocityContext context = configcontext.getContext();
            context.internalGetKeys();
            VelocityEngine velocityengine = new VelocityEngine();
            if (!"not-defined".equalsIgnoreCase(this.getVelocityLogger())) {
                velocityengine.setProperty("runtime.log.logsystem.class", (Object)CommonsLogLogChute.class.getName());
                velocityengine.setProperty("resource.loader", (Object)"classpath");
                velocityengine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            }
            velocityengine.setProperty("file.resource.loader.path", (Object)CarbonUtils.getCarbonHome());
            this.initVelocityEngine(velocityengine);
            Template t = velocityengine.getTemplate(this.getPrototypeTemplatePath());
            t.merge((Context)context, (Writer)writer);
        }
        catch (Exception e) {
            log.error((Object)"Velocity Error", (Throwable)e);
            throw new APITemplateException("Velocity Error", (Throwable)e);
        }
        return writer.toString();
    }

    public String getConfigStringForEndpointTemplate(String endpointType) throws APITemplateException {
        StringWriter writer = new StringWriter();
        try {
            ConfigContext configcontext = new APIConfigContext(this.api);
            configcontext = new EndpointConfigContext(configcontext, this.apiProduct, this.api);
            configcontext = new TemplateUtilContext(configcontext);
            configcontext.validate();
            VelocityContext context = configcontext.getContext();
            context.internalGetKeys();
            VelocityEngine velocityengine = new VelocityEngine();
            if (!"not-defined".equalsIgnoreCase(this.getVelocityLogger())) {
                velocityengine.setProperty("runtime.log.logsystem.class", (Object)CommonsLogLogChute.class.getName());
                velocityengine.setProperty("resource.loader", (Object)"classpath");
                velocityengine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            }
            velocityengine.setProperty("file.resource.loader.path", (Object)CarbonUtils.getCarbonHome());
            this.initVelocityEngine(velocityengine);
            context.put("type", (Object)endpointType);
            Template template = velocityengine.getTemplate(this.getEndpointTemplatePath());
            template.merge((Context)context, (Writer)writer);
        }
        catch (Exception e) {
            log.error((Object)"Velocity Error");
            throw new APITemplateException("Velocity Error", (Throwable)e);
        }
        return writer.toString();
    }

    public String getConfigStringForWebSocketEndpointTemplate(String endpointType, String resourceKey, String endpointUrl) throws APITemplateException {
        StringWriter writer = new StringWriter();
        try {
            ConfigContext configcontext = new APIConfigContext(this.api);
            configcontext = new EndpointBckConfigContext(configcontext, this.api);
            configcontext = new EndpointConfigContext(configcontext, this.api);
            configcontext = new TemplateUtilContext(configcontext);
            configcontext.validate();
            VelocityContext context = configcontext.getContext();
            context.internalGetKeys();
            VelocityEngine velocityengine = new VelocityEngine();
            if (!"not-defined".equalsIgnoreCase(this.getVelocityLogger())) {
                velocityengine.setProperty("runtime.log.logsystem.class", (Object)CommonsLogLogChute.class.getName());
                velocityengine.setProperty("resource.loader", (Object)"classpath");
                velocityengine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            }
            velocityengine.setProperty("file.resource.loader.path", (Object)CarbonUtils.getCarbonHome());
            this.initVelocityEngine(velocityengine);
            context.put("type", (Object)(endpointType + "_endpoints"));
            context.put("websocketResourceKey", (Object)resourceKey);
            context.put("endpointUrl", (Object)endpointUrl);
            Template template = velocityengine.getTemplate(this.getEndpointTemplatePath());
            template.merge((Context)context, (Writer)writer);
        }
        catch (Exception e) {
            log.error((Object)"Velocity Error");
            throw new APITemplateException("Velocity Error", (Throwable)e);
        }
        return writer.toString();
    }

    private ConfigContext createConfigContext(API api, Environment environment) throws UserStoreException, RegistryException {
        ConfigContext configcontext = new APIConfigContext(api);
        configcontext = new TransportConfigContext(configcontext, api);
        configcontext = new ResourceConfigContext(configcontext, api);
        configcontext = new EndpointBckConfigContext(configcontext, api);
        configcontext = new EndpointConfigContext(configcontext, api);
        configcontext = new SecurityConfigContext(configcontext, api);
        configcontext = new JwtConfigContext(configcontext);
        configcontext = new ResponseCacheConfigContext(configcontext, api);
        configcontext = new HandlerConfigContex(configcontext, this.handlers);
        configcontext = new EnvironmentConfigContext(configcontext, environment);
        configcontext = new TemplateUtilContext(configcontext);
        if ("SOAPTOREST".equals(api.getType()) || !StringUtils.isEmpty((CharSequence)api.getWsdlUrl())) {
            configcontext = SequenceUtils.getSequenceTemplateConfigContext(this.soapToRestInMediationDtoList, "in_sequences", configcontext);
            configcontext = SequenceUtils.getSequenceTemplateConfigContext(this.soapToRestOutMediationDtoList, "out_sequences", configcontext);
        }
        return configcontext;
    }

    public ConfigContext createConfigContext(APIProduct apiProduct, Environment environment) {
        StringWriter writer = new StringWriter();
        ConfigContext configcontext = new APIConfigContext(apiProduct);
        configcontext = new TransportConfigContext(configcontext, apiProduct);
        configcontext = new ResourceConfigContext(configcontext, apiProduct);
        configcontext = new ResponseCacheConfigContext(configcontext, apiProduct);
        configcontext = new HandlerConfigContex(configcontext, this.handlers);
        configcontext = new EnvironmentConfigContext(configcontext, environment);
        configcontext = new TemplateUtilContext(configcontext);
        configcontext = new SecurityConfigContext(configcontext, apiProduct, this.associatedAPIMap);
        return configcontext;
    }

    public void addHandler(String handlerName, Map<String, String> properties) {
        this.addHandlerPriority(handlerName, properties, this.handlers.size());
    }

    public void addHandlerPriority(String handlerName, Map<String, String> properties, int priority) {
        HandlerConfig handler = new HandlerConfig(handlerName, properties);
        this.handlers.add(priority, handler);
    }

    public String getTemplatePath() {
        if (APIConstants.APITransportType.WEBSUB.toString().equals(this.api.getType())) {
            return "repository" + File.separator + "resources" + File.separator + "api_templates" + File.separator + TEMPLATE_WEBSUB_API + ".xml";
        }
        return "repository" + File.separator + "resources" + File.separator + "api_templates" + File.separator + TEMPLATE_TYPE_VELOCITY + ".xml";
    }

    public String getPrototypeTemplatePath() {
        return "repository" + File.separator + "resources" + File.separator + "api_templates" + File.separator + TEMPLATE_TYPE_PROTOTYPE + ".xml";
    }

    public String getDefaultAPITemplatePath() {
        if (APIConstants.APITransportType.WS.toString().equals(this.api.getType())) {
            return "repository" + File.separator + "resources" + File.separator + "api_templates" + File.separator + TEMPLATE_DEFAULT_WS_API + ".xml";
        }
        return "repository" + File.separator + "resources" + File.separator + "api_templates" + File.separator + TEMPLATE_DEFAULT_API + ".xml";
    }

    public String getEndpointTemplatePath() {
        return "repository" + File.separator + "resources" + File.separator + "api_templates" + File.separator + TEMPLATE_TYPE_ENDPOINT + ".xml";
    }

    public String getApiProductTemplatePath() {
        return "repository" + File.separator + "resources" + File.separator + "api_templates" + File.separator + TEMPLATE_TYPE_API_PRODUCT + ".xml";
    }

    public String getVelocityLogger() {
        if (this.velocityLogPath != null) {
            return this.velocityLogPath;
        }
        APIManagerConfigurationService config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService();
        String velocityLogPath = config.getAPIManagerConfiguration().getFirstProperty("VelocityLogger");
        this.velocityLogPath = velocityLogPath != null && velocityLogPath.length() > 1 ? velocityLogPath : "not-defined";
        return this.velocityLogPath;
    }

    private void initVelocityEngine(VelocityEngine velocityengine) throws APITemplateException {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.getClass().getClassLoader());
        try {
            velocityengine.init();
        }
        catch (Exception e) {
            String msg = "Error while initiating the Velocity engine";
            log.error((Object)msg, (Throwable)e);
            throw new APITemplateException(msg, (Throwable)e);
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }
}

