/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template;

import org.apache.velocity.VelocityContext;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.api.model.APIProductIdentifier;
import org.wso2.carbon.apimgt.impl.template.APITemplateException;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.ConfigContext;

public class APIConfigContext
extends ConfigContext {
    private API api;
    private APIProduct apiProduct;
    private static final String PRODUCT_PREFIX = "prod";

    public APIConfigContext(API api) {
        this.api = api;
    }

    public APIConfigContext(APIProduct apiProduct) {
        this.apiProduct = apiProduct;
    }

    @Override
    public void validate() throws APITemplateException {
    }

    @Override
    public VelocityContext getContext() {
        VelocityContext context = new VelocityContext();
        if (this.api != null) {
            this.setApiVelocityContext(this.api, context);
        } else if (this.apiProduct != null) {
            this.setApiProductVelocityContext(this.apiProduct, context);
        }
        return context;
    }

    private void setApiVelocityContext(API api, VelocityContext context) {
        context.put("apiName", (Object)this.getAPIName(api));
        context.put("apiVersion", (Object)api.getId().getVersion());
        context.put("UUID", (Object)api.getUUID());
        context.put("apiContext", (Object)api.getContextTemplate());
        context.put("apiObj", (Object)api);
        String apiSecurity = api.getApiSecurity();
        if (apiSecurity == null || apiSecurity.contains("oauth2")) {
            context.put("apiIsOauthProtected", (Object)Boolean.TRUE);
        } else {
            context.put("apiIsOauthProtected", (Object)Boolean.FALSE);
        }
        if (api.isEnabledSchemaValidation()) {
            context.put("enableSchemaValidation", (Object)Boolean.TRUE);
        } else {
            context.put("enableSchemaValidation", (Object)Boolean.FALSE);
        }
        if (api.isEnableStore()) {
            context.put("enableStore", (Object)Boolean.TRUE);
        } else {
            context.put("enableStore", (Object)Boolean.FALSE);
        }
        context.put("testKey", (Object)api.getTestKey());
    }

    private void setApiProductVelocityContext(APIProduct apiProduct, VelocityContext context) {
        APIProductIdentifier id = apiProduct.getId();
        context.put("apiName", (Object)id.getName());
        context.put("apiVersion", (Object)"1.0.0");
        context.put("apiContext", (Object)apiProduct.getContext());
        context.put("apiObj", (Object)apiProduct);
        context.put("apiIsBlocked", (Object)Boolean.FALSE);
        String apiSecurity = apiProduct.getApiSecurity();
        if (apiSecurity == null || apiSecurity.contains("oauth2")) {
            context.put("apiIsOauthProtected", (Object)Boolean.TRUE);
        } else {
            context.put("apiIsOauthProtected", (Object)Boolean.FALSE);
        }
        if (apiProduct.isEnabledSchemaValidation()) {
            context.put("enableSchemaValidation", (Object)Boolean.TRUE);
        } else {
            context.put("enableSchemaValidation", (Object)Boolean.FALSE);
        }
        if (apiProduct.isEnableStore()) {
            context.put("enableStore", (Object)Boolean.TRUE);
        } else {
            context.put("enableStore", (Object)Boolean.FALSE);
        }
        context.put("testKey", (Object)apiProduct.getTestKey());
    }

    public String getAPIName(API api) {
        return api.getId().getApiName();
    }
}

