/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.wso2.carbon.apimgt.api.model.Tier;
import org.wso2.carbon.apimgt.api.model.policy.EventCountLimit;
import org.wso2.carbon.apimgt.api.model.policy.SubscriptionPolicy;
import org.wso2.carbon.apimgt.rest.api.common.RestApiCommonUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.CommonMappingUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.EventCountLimitDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.PaginationDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.SubscriptionPolicyDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ThrottleLimitDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ThrottlingPolicyDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ThrottlingPolicyListDTO;

public class ThrottlingPolicyMappingUtil {
    public static ThrottlingPolicyListDTO fromTierListToDTO(List<Tier> tiers, String tierLevel, int limit, int offset) {
        int size;
        ThrottlingPolicyListDTO throttlingPolicyListDTO = new ThrottlingPolicyListDTO();
        List<ThrottlingPolicyDTO> throttlingPolicyListDTOList = throttlingPolicyListDTO.getList();
        if (throttlingPolicyListDTOList == null) {
            throttlingPolicyListDTOList = new ArrayList<ThrottlingPolicyDTO>();
            throttlingPolicyListDTO.setList(throttlingPolicyListDTOList);
        }
        int start = offset < (size = tiers.size()) && offset >= 0 ? offset : Integer.MAX_VALUE;
        int end = Math.min(offset + limit - 1, size - 1);
        for (int i = start; i <= end; ++i) {
            Tier tier = tiers.get(i);
            throttlingPolicyListDTOList.add(ThrottlingPolicyMappingUtil.fromTierToDTO(tier, tierLevel));
        }
        throttlingPolicyListDTO.setCount(throttlingPolicyListDTOList.size());
        return throttlingPolicyListDTO;
    }

    public static void setPaginationParams(ThrottlingPolicyListDTO throttlingPolicyListDTO, String tierLevel, int limit, int offset, int size) {
        String paginatedPrevious = "";
        String paginatedNext = "";
        Map paginatedParams = RestApiCommonUtil.getPaginationParams((Integer)offset, (Integer)limit, (Integer)size);
        if (paginatedParams.get("previous_offset") != null) {
            paginatedPrevious = RestApiCommonUtil.getTiersPaginatedURL((String)tierLevel, (Integer)((Integer)paginatedParams.get("previous_offset")), (Integer)((Integer)paginatedParams.get("previous_limit")));
        }
        if (paginatedParams.get("next_offset") != null) {
            paginatedNext = RestApiCommonUtil.getTiersPaginatedURL((String)tierLevel, (Integer)((Integer)paginatedParams.get("next_offset")), (Integer)((Integer)paginatedParams.get("next_limit")));
        }
        PaginationDTO paginationDTO = CommonMappingUtil.getPaginationDTO(limit, offset, size, paginatedNext, paginatedPrevious);
        throttlingPolicyListDTO.setPagination(paginationDTO);
    }

    public static ThrottlingPolicyDTO fromTierToDTO(Tier tier, String tierLevel) {
        ThrottlingPolicyDTO dto = new ThrottlingPolicyDTO();
        dto.setName(tier.getName());
        dto.setDescription(tier.getDescription());
        if (StringUtils.isEmpty((CharSequence)tier.getDisplayName())) {
            dto.setDisplayName(tier.getName());
        } else {
            dto.setDisplayName(tier.getDisplayName());
        }
        dto.setRequestCount(tier.getRequestCount());
        dto.setUnitTime(tier.getUnitTime());
        dto.setStopOnQuotaReach(tier.isStopOnQuotaReached());
        dto.setPolicyLevel(ThrottlingPolicyDTO.PolicyLevelEnum.fromValue(tierLevel));
        dto.setTimeUnit(tier.getTimeUnit());
        dto.setRateLimitCount(tier.getRateLimitCount());
        dto.setRateLimitTimeUnit(tier.getRateLimitTimeUnit());
        dto.setDataUnit(tier.getBandwidthDataUnit());
        if (tier.getQuotaPolicyType() != null) {
            dto.setQuotaPolicyType(ThrottlingPolicyMappingUtil.mapQuotaPolicyTypeFromModeltoDTO(tier.getQuotaPolicyType()));
        }
        if (tier.getTierPlan() != null) {
            dto.setTierPlan(ThrottlingPolicyDTO.TierPlanEnum.fromValue(tier.getTierPlan()));
        }
        if (tier.getTierAttributes() != null) {
            HashMap<String, String> additionalProperties = new HashMap<String, String>();
            for (String key : tier.getTierAttributes().keySet()) {
                additionalProperties.put(key, tier.getTierAttributes().get(key).toString());
            }
            dto.setAttributes(additionalProperties);
        }
        return dto;
    }

    private static ThrottlingPolicyDTO.QuotaPolicyTypeEnum mapQuotaPolicyTypeFromModeltoDTO(String quotaPolicyType) {
        switch (quotaPolicyType) {
            case "requestCount": {
                return ThrottlingPolicyDTO.QuotaPolicyTypeEnum.fromValue("requestCount".toUpperCase());
            }
            case "bandwidthVolume": {
                return ThrottlingPolicyDTO.QuotaPolicyTypeEnum.fromValue("bandwidthVolume".toUpperCase());
            }
        }
        return null;
    }

    public static SubscriptionPolicyDTO fromSubscriptionToDTO(SubscriptionPolicy subscriptionPolicy, int position) {
        SubscriptionPolicyDTO dto = new SubscriptionPolicyDTO();
        dto.setRateLimitCount(subscriptionPolicy.getRateLimitCount());
        dto.setRateLimitTimeUnit(subscriptionPolicy.getRateLimitTimeUnit());
        dto.setStopOnQuotaReach(subscriptionPolicy.isStopOnQuotaReach());
        ThrottleLimitDTO limitDTO = new ThrottleLimitDTO();
        limitDTO.setType(ThrottleLimitDTO.TypeEnum.EVENTCOUNTLIMIT);
        EventCountLimit eventCountLimit = (EventCountLimit)subscriptionPolicy.getDefaultQuotaPolicy().getLimit();
        EventCountLimitDTO eventCountLimitDTO = new EventCountLimitDTO();
        eventCountLimitDTO.setEventCount(eventCountLimit.getEventCount());
        eventCountLimitDTO.setTimeUnit(eventCountLimit.getTimeUnit());
        eventCountLimitDTO.setUnitTime(eventCountLimit.getUnitTime());
        limitDTO.setEventCount(eventCountLimitDTO);
        dto.setDefaultLimit(limitDTO);
        dto.setSubscriberCount(subscriptionPolicy.getSubscriberCount());
        dto.setDisplayName(subscriptionPolicy.getDisplayName());
        dto.setDescription(subscriptionPolicy.getDescription());
        dto.setIsDeployed(subscriptionPolicy.isDeployed());
        dto.setPolicyName(subscriptionPolicy.getPolicyName());
        dto.setBillingPlan(subscriptionPolicy.getBillingPlan());
        dto.setPolicyId(position);
        dto.setUuid(subscriptionPolicy.getUUID());
        dto.setIsDeployed(subscriptionPolicy.isDeployed());
        dto.setTenantDomain(subscriptionPolicy.getTenantDomain());
        dto.setTenantId(subscriptionPolicy.getTenantId());
        return dto;
    }
}

