/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIProvider;
import org.wso2.carbon.apimgt.api.dto.UserApplicationAPIUsage;
import org.wso2.carbon.apimgt.api.model.Application;
import org.wso2.carbon.apimgt.api.model.SubscribedAPI;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.rest.api.common.RestApiCommonUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.ApplicationMappingUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ApplicationInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ClaimDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.PaginationDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.SubscriberInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.SubscriptionDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.SubscriptionListDTO;

public class SubscriptionMappingUtil {
    public static SubscriptionDTO fromSubscriptionToDTO(SubscribedAPI subscription) throws APIManagementException {
        SubscriptionDTO subscriptionDTO = new SubscriptionDTO();
        subscriptionDTO.setSubscriptionId(subscription.getUUID());
        subscriptionDTO.setApplicationInfo(SubscriptionMappingUtil.fromApplicationToApplicationInfoDTO(subscription.getApplication()));
        subscriptionDTO.setSubscriptionStatus(SubscriptionDTO.SubscriptionStatusEnum.valueOf(subscription.getSubStatus()));
        subscriptionDTO.setThrottlingPolicy(subscription.getTier().getName());
        return subscriptionDTO;
    }

    public static SubscriptionListDTO fromSubscriptionListToDTO(List<SubscribedAPI> subscriptions, Integer limit, Integer offset) throws APIManagementException {
        SubscriptionListDTO subscriptionListDTO = new SubscriptionListDTO();
        List<SubscriptionDTO> subscriptionDTOs = subscriptionListDTO.getList();
        if (subscriptionDTOs == null) {
            subscriptionDTOs = new ArrayList<SubscriptionDTO>();
            subscriptionListDTO.setList(subscriptionDTOs);
        }
        int size = subscriptions.size();
        int start = offset < size && offset >= 0 ? offset : Integer.MAX_VALUE;
        int end = offset + limit - 1 <= size - 1 ? offset + limit - 1 : size - 1;
        for (int i = start; i <= end; ++i) {
            SubscribedAPI subscription = subscriptions.get(i);
            subscriptionDTOs.add(SubscriptionMappingUtil.fromSubscriptionToDTO(subscription));
        }
        subscriptionListDTO.setCount(subscriptionDTOs.size());
        return subscriptionListDTO;
    }

    public static SubscriptionListDTO fromSubscriptionListToDTO(List<SubscribedAPI> subscriptions, String query) throws APIManagementException {
        SubscriptionListDTO subscriptionListDTO = new SubscriptionListDTO();
        List<SubscriptionDTO> subscriptionDTOs = subscriptionListDTO.getList();
        if (subscriptionDTOs == null) {
            subscriptionDTOs = new ArrayList<SubscriptionDTO>();
            subscriptionListDTO.setList(subscriptionDTOs);
        }
        query = query.toLowerCase().trim();
        for (SubscribedAPI sub : subscriptions) {
            SubscriptionDTO subscription = SubscriptionMappingUtil.fromSubscriptionToDTO(sub);
            if (!subscription.getApplicationInfo().getName().toLowerCase().contains(query) && !subscription.getApplicationInfo().getSubscriber().toLowerCase().contains(query) && !subscription.getThrottlingPolicy().toLowerCase().contains(query)) continue;
            subscriptionDTOs.add(subscription);
        }
        subscriptionListDTO.setCount(subscriptionDTOs.size());
        return subscriptionListDTO;
    }

    public static SubscriptionListDTO getPaginatedSubscriptions(SubscriptionListDTO subscriptionListDTO, Integer limit, Integer offset) {
        SubscriptionListDTO paginatedSubscriptionListDTO = new SubscriptionListDTO();
        List<SubscriptionDTO> subscriptionDTOs = paginatedSubscriptionListDTO.getList();
        if (subscriptionDTOs == null) {
            subscriptionDTOs = new ArrayList<SubscriptionDTO>();
            paginatedSubscriptionListDTO.setList(subscriptionDTOs);
        }
        int size = subscriptionListDTO.getCount();
        int start = offset < size && offset >= 0 ? offset : Integer.MAX_VALUE;
        int end = offset + limit - 1 <= size - 1 ? offset + limit - 1 : size - 1;
        List<SubscriptionDTO> subscriptions = subscriptionListDTO.getList();
        for (int i = start; i <= end; ++i) {
            subscriptionDTOs.add(subscriptions.get(i));
        }
        paginatedSubscriptionListDTO.setCount(subscriptionDTOs.size());
        return paginatedSubscriptionListDTO;
    }

    public static void setPaginationParams(SubscriptionListDTO subscriptionListDTO, String apiId, String groupId, int limit, int offset, int size) {
        String paginatedPrevious = "";
        String paginatedNext = "";
        Map paginatedParams = RestApiCommonUtil.getPaginationParams((Integer)offset, (Integer)limit, (Integer)size);
        if (paginatedParams.get("previous_offset") != null) {
            paginatedPrevious = RestApiCommonUtil.getSubscriptionPaginatedURLForAPIId((Integer)((Integer)paginatedParams.get("previous_offset")), (Integer)((Integer)paginatedParams.get("previous_limit")), (String)apiId, (String)groupId);
        }
        if (paginatedParams.get("next_offset") != null) {
            paginatedNext = RestApiCommonUtil.getSubscriptionPaginatedURLForAPIId((Integer)((Integer)paginatedParams.get("next_offset")), (Integer)((Integer)paginatedParams.get("next_limit")), (String)apiId, (String)groupId);
        }
        PaginationDTO pagination = new PaginationDTO();
        pagination.setOffset(offset);
        pagination.setLimit(limit);
        pagination.setNext(paginatedNext);
        pagination.setPrevious(paginatedPrevious);
        pagination.setTotal(size);
        subscriptionListDTO.setPagination(pagination);
    }

    public static List<SubscribedAPI> fromUserApplicationAPIUsageArrayToSubscribedAPIList(UserApplicationAPIUsage[] allApiUsage) {
        ArrayList<SubscribedAPI> subscribedAPIs = new ArrayList<SubscribedAPI>();
        for (UserApplicationAPIUsage usage : allApiUsage) {
            Collections.addAll(subscribedAPIs, usage.getApiSubscriptions());
        }
        return subscribedAPIs;
    }

    private static ApplicationInfoDTO fromApplicationToApplicationInfoDTO(Application application) throws APIManagementException {
        APIProvider apiProvider = RestApiCommonUtil.getLoggedInUserProvider();
        application = apiProvider.getLightweightApplicationByUUID(application.getUUID());
        return ApplicationMappingUtil.fromApplicationToInfoDTO(application);
    }

    public static SubscriberInfoDTO fromSubscriberClaimsToDTO(Map<String, String> subscriberClaims, String subscriberName) throws APIManagementException {
        SubscriberInfoDTO subscriberInfoDTO = new SubscriberInfoDTO();
        subscriberInfoDTO.setName(subscriberName);
        ArrayList<ClaimDTO> claimDTOList = new ArrayList<ClaimDTO>();
        for (String key : subscriberClaims.keySet()) {
            ClaimDTO claimDTO = new ClaimDTO();
            claimDTO.setName(APIUtil.getClaimDisplayName((String)key, (String)subscriberName));
            claimDTO.setURI(key);
            claimDTO.setValue(subscriberClaims.get(key));
            claimDTOList.add(claimDTO);
        }
        subscriberInfoDTO.setClaims(claimDTOList);
        return subscriberInfoDTO;
    }
}

