/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.Scope;
import org.wso2.carbon.apimgt.api.model.SharedScopeUsage;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import org.wso2.carbon.apimgt.rest.api.common.RestApiCommonUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.CommonMappingUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.PaginationDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ScopeDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ScopeListDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.SharedScopeUsageDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.SharedScopeUsedAPIInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.SharedScopeUsedAPIResourceInfoDTO;

public class SharedScopeMappingUtil {
    private SharedScopeMappingUtil() {
        throw new IllegalStateException("SharedScope Mapping Utility class");
    }

    public static ScopeDTO fromScopeToDTO(Scope scope) {
        ScopeDTO scopeDTO = new ScopeDTO();
        scopeDTO.setName(scope.getKey());
        scopeDTO.setDisplayName(scope.getName());
        scopeDTO.setUsageCount(scope.getUsageCount());
        scopeDTO.setDescription(scope.getDescription());
        scopeDTO.setId(scope.getId());
        String roles = scope.getRoles();
        if (StringUtils.isEmpty((CharSequence)roles)) {
            scopeDTO.setBindings(Collections.emptyList());
        } else {
            scopeDTO.setBindings(Arrays.asList(roles.split(",")));
        }
        return scopeDTO;
    }

    public static SharedScopeUsageDTO fromSharedScopeUsageToDTO(SharedScopeUsage sharedScopeUsage) {
        SharedScopeUsageDTO sharedScopeUsageDTO = new SharedScopeUsageDTO();
        sharedScopeUsageDTO.setId(sharedScopeUsage.getId());
        sharedScopeUsageDTO.setName(sharedScopeUsage.getName());
        ArrayList<SharedScopeUsedAPIInfoDTO> usedAPIInfoDTOList = new ArrayList<SharedScopeUsedAPIInfoDTO>();
        for (API api : sharedScopeUsage.getApis()) {
            APIIdentifier apiIdentifier = api.getId();
            SharedScopeUsedAPIInfoDTO usedAPIInfoDTO = new SharedScopeUsedAPIInfoDTO();
            usedAPIInfoDTO.setName(apiIdentifier.getName());
            usedAPIInfoDTO.setVersion(apiIdentifier.getVersion());
            usedAPIInfoDTO.setProvider(apiIdentifier.getProviderName());
            usedAPIInfoDTO.setContext(api.getContext());
            ArrayList<SharedScopeUsedAPIResourceInfoDTO> usedAPIResourceInfoDTOList = new ArrayList<SharedScopeUsedAPIResourceInfoDTO>();
            for (URITemplate uriTemplate : api.getUriTemplates()) {
                SharedScopeUsedAPIResourceInfoDTO usedAPIResourceInfoDTO = new SharedScopeUsedAPIResourceInfoDTO();
                usedAPIResourceInfoDTO.setTarget(uriTemplate.getUriTemplate());
                usedAPIResourceInfoDTO.setVerb(uriTemplate.getHTTPVerb());
                usedAPIResourceInfoDTOList.add(usedAPIResourceInfoDTO);
            }
            usedAPIInfoDTO.setUsedResourceList(usedAPIResourceInfoDTOList);
            usedAPIInfoDTOList.add(usedAPIInfoDTO);
        }
        sharedScopeUsageDTO.setUsedApiList(usedAPIInfoDTOList);
        return sharedScopeUsageDTO;
    }

    public static Scope fromDTOToScope(ScopeDTO scopeDTO) {
        Scope scope = new Scope();
        scope.setId(scopeDTO.getId());
        scope.setDescription(scopeDTO.getDescription());
        scope.setKey(scopeDTO.getName());
        scope.setName(scopeDTO.getDisplayName());
        if (scopeDTO.getBindings() != null) {
            scope.setRoles(String.join((CharSequence)",", scopeDTO.getBindings()));
        }
        return scope;
    }

    public static ScopeListDTO fromScopeListToDTO(List<Scope> scopeList, int offset, int limit) {
        int size;
        ScopeListDTO sharedScopeListDTO = new ScopeListDTO();
        List<ScopeDTO> scopeDTOList = sharedScopeListDTO.getList();
        if (scopeList == null) {
            scopeList = new ArrayList<Scope>();
            sharedScopeListDTO.setList(scopeDTOList);
        }
        int start = offset < (size = scopeList.size()) && offset >= 0 ? offset : Integer.MAX_VALUE;
        int end = Math.min(offset + limit - 1, size - 1);
        for (int i = start; i <= end; ++i) {
            scopeDTOList.add(SharedScopeMappingUtil.fromScopeToDTO(scopeList.get(i)));
        }
        sharedScopeListDTO.setCount(scopeDTOList.size());
        return sharedScopeListDTO;
    }

    public static void setPaginationParams(ScopeListDTO sharedScopeListDTO, int limit, int offset, int size) {
        String paginatedPrevious = "";
        String paginatedNext = "";
        Map paginatedParams = RestApiCommonUtil.getPaginationParams((Integer)offset, (Integer)limit, (Integer)size);
        if (paginatedParams.get("previous_offset") != null) {
            paginatedPrevious = RestApiCommonUtil.getScopesPaginatedURL((Integer)((Integer)paginatedParams.get("previous_offset")), (Integer)((Integer)paginatedParams.get("previous_limit")));
        }
        if (paginatedParams.get("next_offset") != null) {
            paginatedNext = RestApiCommonUtil.getScopesPaginatedURL((Integer)((Integer)paginatedParams.get("next_offset")), (Integer)((Integer)paginatedParams.get("next_limit")));
        }
        PaginationDTO paginationDTO = CommonMappingUtil.getPaginationDTO(limit, offset, size, paginatedNext, paginatedPrevious);
        sharedScopeListDTO.setPagination(paginationDTO);
    }
}

