/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIProvider;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.rest.api.common.RestApiCommonUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.EnvironmentMappingUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.EnvironmentListDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.MonetizationAttributeDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.SecurityAuditAttributeDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.SettingsDTO;

public class SettingsMappingUtil {
    private static final Log log = LogFactory.getLog(SettingsMappingUtil.class);

    public SettingsDTO fromSettingstoDTO(Boolean isUserAvailable) throws APIManagementException {
        SettingsDTO settingsDTO = new SettingsDTO();
        EnvironmentListDTO environmentListDTO = new EnvironmentListDTO();
        if (isUserAvailable.booleanValue()) {
            Iterator entries;
            Map environments = APIUtil.getEnvironments();
            if (environments != null) {
                environmentListDTO = EnvironmentMappingUtil.fromEnvironmentCollectionToDTO(environments.values());
            }
            settingsDTO.setEnvironment(environmentListDTO.getList());
            String storeUrl = APIUtil.getStoreUrl();
            String loggedInUserTenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
            Map domainMappings = APIUtil.getDomainMappings((String)loggedInUserTenantDomain, (String)"store");
            if (domainMappings.size() != 0 && (entries = domainMappings.entrySet().iterator()).hasNext()) {
                Map.Entry thisEntry = entries.next();
                storeUrl = "https://" + thisEntry.getValue();
            }
            settingsDTO.setDevportalUrl(storeUrl);
            settingsDTO.setMonetizationAttributes(this.getMonetizationAttributes());
            settingsDTO.setSecurityAuditProperties(this.getSecurityAuditProperties());
            settingsDTO.setExternalStoresEnabled(APIUtil.isExternalStoresEnabled((String)RestApiCommonUtil.getLoggedInUserTenantDomain()));
            settingsDTO.setDocVisibilityEnabled(APIUtil.isDocVisibilityLevelsEnabled());
            settingsDTO.setCrossTenantSubscriptionEnabled(APIUtil.isCrossTenantSubscriptionsEnabled());
        }
        return settingsDTO;
    }

    private List<MonetizationAttributeDTO> getMonetizationAttributes() {
        ArrayList<MonetizationAttributeDTO> monetizationAttributeDTOSList = new ArrayList<MonetizationAttributeDTO>();
        JSONArray monetizationAttributes = APIUtil.getMonetizationAttributes();
        for (int i = 0; i < monetizationAttributes.size(); ++i) {
            JSONObject monetizationAttribute = (JSONObject)monetizationAttributes.get(i);
            MonetizationAttributeDTO monetizationAttributeDTO = new MonetizationAttributeDTO();
            monetizationAttributeDTO.setName((String)monetizationAttribute.get((Object)"Attribute"));
            monetizationAttributeDTO.setDisplayName((String)monetizationAttribute.get((Object)"DisplayName"));
            monetizationAttributeDTO.setDescription((String)monetizationAttribute.get((Object)"Description"));
            monetizationAttributeDTO.setRequired((Boolean)monetizationAttribute.get((Object)"Required"));
            monetizationAttributeDTO.setHidden((Boolean)monetizationAttribute.get((Object)"Hidden"));
            monetizationAttributeDTOSList.add(monetizationAttributeDTO);
        }
        return monetizationAttributeDTOSList;
    }

    private SecurityAuditAttributeDTO getSecurityAuditProperties() throws APIManagementException {
        SecurityAuditAttributeDTO properties = new SecurityAuditAttributeDTO();
        String username = RestApiCommonUtil.getLoggedInUsername();
        APIProvider apiProvider = RestApiCommonUtil.getProvider((String)username);
        JSONObject securityAuditPropertyObject = apiProvider.getSecurityAuditAttributesFromConfig(username);
        if (securityAuditPropertyObject != null) {
            String apiToken = (String)securityAuditPropertyObject.get((Object)"apiToken");
            String collectionId = (String)securityAuditPropertyObject.get((Object)"collectionId");
            String baseUrl = (String)securityAuditPropertyObject.get((Object)"baseUrl");
            properties.setApiToken(apiToken);
            properties.setCollectionId(collectionId);
            properties.setBaseUrl(baseUrl);
        }
        return properties;
    }
}

