/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.ErrorHandler;
import org.wso2.carbon.apimgt.api.ExceptionCodes;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.api.model.APIProductIdentifier;
import org.wso2.carbon.apimgt.api.model.Documentation;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.rest.api.common.RestApiCommonUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIProductSearchResultDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APISearchResultDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.DocumentSearchResultDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.PaginationDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.SearchResultDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.SearchResultListDTO;

public class SearchResultMappingUtil {
    private static final Log log = LogFactory.getLog(SearchResultMappingUtil.class);

    public static APISearchResultDTO fromAPIToAPIResultDTO(API api) {
        APISearchResultDTO apiResultDTO = new APISearchResultDTO();
        apiResultDTO.setId(api.getUUID());
        APIIdentifier apiId = api.getId();
        apiResultDTO.setName(apiId.getApiName());
        apiResultDTO.setVersion(apiId.getVersion());
        apiResultDTO.setProvider(APIUtil.replaceEmailDomainBack((String)apiId.getProviderName()));
        String context = api.getContextTemplate();
        if (context.endsWith("/{version}")) {
            context = context.replace("/{version}", "");
        }
        apiResultDTO.setContext(context);
        apiResultDTO.setType(SearchResultDTO.TypeEnum.API);
        apiResultDTO.setTransportType(api.getType());
        apiResultDTO.setDescription(api.getDescription());
        apiResultDTO.setStatus(api.getStatus());
        apiResultDTO.setThumbnailUri(api.getThumbnailUrl());
        return apiResultDTO;
    }

    public static APIProductSearchResultDTO fromAPIProductToAPIResultDTO(APIProduct apiProduct) {
        APIProductSearchResultDTO apiProductResultDTO = new APIProductSearchResultDTO();
        apiProductResultDTO.setId(apiProduct.getUuid());
        APIProductIdentifier apiproductId = apiProduct.getId();
        apiProductResultDTO.setName(apiproductId.getName());
        apiProductResultDTO.setVersion(apiproductId.getVersion());
        apiProductResultDTO.setProvider(APIUtil.replaceEmailDomainBack((String)apiproductId.getProviderName()));
        String context = apiProduct.getContextTemplate();
        if (context.endsWith("/{version}")) {
            context = context.replace("/{version}", "");
        }
        apiProductResultDTO.setContext(context);
        apiProductResultDTO.setType(SearchResultDTO.TypeEnum.APIPRODUCT);
        apiProductResultDTO.setDescription(apiProduct.getDescription());
        apiProductResultDTO.setStatus(apiProduct.getState());
        apiProductResultDTO.setThumbnailUri(apiProduct.getThumbnailUrl());
        return apiProductResultDTO;
    }

    public static DocumentSearchResultDTO fromDocumentationToDocumentResultDTO(Documentation document, API api) throws APIManagementException {
        DocumentSearchResultDTO docResultDTO = new DocumentSearchResultDTO();
        docResultDTO.setId(document.getId());
        docResultDTO.setName(document.getName());
        docResultDTO.setDocType(DocumentSearchResultDTO.DocTypeEnum.valueOf(document.getType().toString()));
        docResultDTO.setType(SearchResultDTO.TypeEnum.DOC);
        docResultDTO.setSummary(document.getSummary());
        docResultDTO.associatedType("API");
        docResultDTO.setVisibility(SearchResultMappingUtil.mapVisibilityFromDocumentToDTO(document.getVisibility()));
        docResultDTO.setSourceType(SearchResultMappingUtil.mapSourceTypeFromDocumentToDTO(document.getSourceType()));
        docResultDTO.setOtherTypeName(document.getOtherTypeName());
        APIIdentifier apiId = api.getId();
        docResultDTO.setApiName(apiId.getApiName());
        docResultDTO.setApiVersion(apiId.getVersion());
        docResultDTO.setApiProvider(APIUtil.replaceEmailDomainBack((String)apiId.getProviderName()));
        docResultDTO.setApiUUID(api.getUUID());
        return docResultDTO;
    }

    public static DocumentSearchResultDTO fromDocumentationToProductDocumentResultDTO(Documentation document, APIProduct apiProduct) throws APIManagementException {
        DocumentSearchResultDTO docResultDTO = new DocumentSearchResultDTO();
        docResultDTO.setId(document.getId());
        docResultDTO.setName(document.getName());
        docResultDTO.setDocType(DocumentSearchResultDTO.DocTypeEnum.valueOf(document.getType().toString()));
        docResultDTO.setType(SearchResultDTO.TypeEnum.DOC);
        docResultDTO.associatedType("APIProduct");
        docResultDTO.setSummary(document.getSummary());
        docResultDTO.setVisibility(SearchResultMappingUtil.mapVisibilityFromDocumentToDTO(document.getVisibility()));
        docResultDTO.setSourceType(SearchResultMappingUtil.mapSourceTypeFromDocumentToDTO(document.getSourceType()));
        docResultDTO.setOtherTypeName(document.getOtherTypeName());
        APIProductIdentifier apiId = apiProduct.getId();
        docResultDTO.setApiName(apiId.getName());
        docResultDTO.setApiVersion(apiId.getVersion());
        docResultDTO.setApiProvider(APIUtil.replaceEmailDomainBack((String)apiId.getProviderName()));
        docResultDTO.setApiUUID(apiProduct.getUuid());
        return docResultDTO;
    }

    public static void setPaginationParams(SearchResultListDTO resultListDTO, String query, int offset, int limit, int size) {
        Map paginatedParams = RestApiCommonUtil.getPaginationParams((Integer)offset, (Integer)limit, (Integer)size);
        String paginatedPrevious = "";
        String paginatedNext = "";
        if (paginatedParams.get("previous_offset") != null) {
            paginatedPrevious = RestApiCommonUtil.getAPIPaginatedURL((Integer)((Integer)paginatedParams.get("previous_offset")), (Integer)((Integer)paginatedParams.get("previous_limit")), (String)query);
        }
        if (paginatedParams.get("next_offset") != null) {
            paginatedNext = RestApiCommonUtil.getAPIPaginatedURL((Integer)((Integer)paginatedParams.get("next_offset")), (Integer)((Integer)paginatedParams.get("next_limit")), (String)query);
        }
        PaginationDTO paginationDTO = new PaginationDTO();
        paginationDTO.setNext(paginatedNext);
        paginationDTO.setPrevious(paginatedPrevious);
        paginationDTO.setOffset(offset);
        paginationDTO.setLimit(limit);
        paginationDTO.setTotal(size);
        resultListDTO.setPagination(paginationDTO);
    }

    public static DocumentSearchResultDTO.SourceTypeEnum mapSourceTypeFromDocumentToDTO(Documentation.DocumentSourceType sourceType) throws APIManagementException {
        switch (sourceType) {
            case URL: {
                return DocumentSearchResultDTO.SourceTypeEnum.URL;
            }
            case FILE: {
                return DocumentSearchResultDTO.SourceTypeEnum.FILE;
            }
            case INLINE: {
                return DocumentSearchResultDTO.SourceTypeEnum.INLINE;
            }
            case MARKDOWN: {
                return DocumentSearchResultDTO.SourceTypeEnum.MARKDOWN;
            }
        }
        throw new APIManagementException(ExceptionCodes.from((ErrorHandler)ExceptionCodes.DOCUMENT_INVALID_SOURCE_TYPE, (String[])new String[]{sourceType.toString()}));
    }

    public static DocumentSearchResultDTO.VisibilityEnum mapVisibilityFromDocumentToDTO(Documentation.DocumentVisibility visibility) throws APIManagementException {
        switch (visibility) {
            case API_LEVEL: {
                return DocumentSearchResultDTO.VisibilityEnum.API_LEVEL;
            }
            case OWNER_ONLY: {
                return DocumentSearchResultDTO.VisibilityEnum.OWNER_ONLY;
            }
            case PRIVATE: {
                return DocumentSearchResultDTO.VisibilityEnum.PRIVATE;
            }
        }
        throw new APIManagementException(ExceptionCodes.from((ErrorHandler)ExceptionCodes.DOCUMENT_INVALID_VISIBILITY, (String[])new String[]{visibility.toString()}));
    }
}

