/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.TypeDefinition;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.UnExecutableSchemaGenerator;
import graphql.schema.idl.errors.SchemaProblem;
import graphql.schema.validation.SchemaValidator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.apimgt.api.APIDefinition;
import org.wso2.carbon.apimgt.api.APIDefinitionValidationResponse;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIProvider;
import org.wso2.carbon.apimgt.api.ErrorHandler;
import org.wso2.carbon.apimgt.api.ExceptionCodes;
import org.wso2.carbon.apimgt.api.FaultGatewaysException;
import org.wso2.carbon.apimgt.api.doc.model.APIResource;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.api.model.APIProductIdentifier;
import org.wso2.carbon.apimgt.api.model.Documentation;
import org.wso2.carbon.apimgt.api.model.DocumentationContent;
import org.wso2.carbon.apimgt.api.model.Identifier;
import org.wso2.carbon.apimgt.api.model.Mediation;
import org.wso2.carbon.apimgt.api.model.ResourceFile;
import org.wso2.carbon.apimgt.api.model.ServiceEntry;
import org.wso2.carbon.apimgt.api.model.SwaggerData;
import org.wso2.carbon.apimgt.api.model.Tier;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import org.wso2.carbon.apimgt.api.model.policy.APIPolicy;
import org.wso2.carbon.apimgt.impl.APIConstants;
import org.wso2.carbon.apimgt.impl.definitions.AsyncApiParser;
import org.wso2.carbon.apimgt.impl.definitions.GraphQLSchemaDefinition;
import org.wso2.carbon.apimgt.impl.definitions.OAS2Parser;
import org.wso2.carbon.apimgt.impl.definitions.OAS3Parser;
import org.wso2.carbon.apimgt.impl.definitions.OASParserUtil;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.impl.wsdl.SequenceGenerator;
import org.wso2.carbon.apimgt.rest.api.common.RestApiCommonUtil;
import org.wso2.carbon.apimgt.rest.api.common.annotations.Scope;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.APIMappingUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.DocumentationMappingUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIAdditionalPropertiesDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIOperationsDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIProductDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.DocumentDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.GraphQLSchemaDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.GraphQLValidationResponseDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.GraphQLValidationResponseGraphQLInfoDTO;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;

public class PublisherCommonUtils {
    private static final Log log = LogFactory.getLog(PublisherCommonUtils.class);

    public static API updateApi(API originalAPI, APIDTO apiDtoToUpdate, APIProvider apiProvider, String[] tokenScopes) throws ParseException, CryptoException, APIManagementException, FaultGatewaysException {
        String oldDefinition;
        String errorMessage;
        Set definedTiers;
        List<String> invalidTiers;
        String secretKey;
        APIIdentifier apiIdentifier = originalAPI.getId();
        if (tokenScopes == null) {
            throw new APIManagementException("Error occurred while updating the  API " + originalAPI.getUUID() + " as the token information hasn't been correctly set internally", (ErrorHandler)ExceptionCodes.TOKEN_SCOPES_NOT_SET);
        }
        boolean isGraphql = originalAPI.getType() != null && APIConstants.APITransportType.GRAPHQL.toString().equals(originalAPI.getType());
        boolean isAsyncAPI = originalAPI.getType() != null && (APIConstants.APITransportType.WS.toString().equals(originalAPI.getType()) || APIConstants.APITransportType.WEBSUB.toString().equals(originalAPI.getType()) || APIConstants.APITransportType.SSE.toString().equals(originalAPI.getType()));
        Scope[] apiDtoClassAnnotatedScopes = (Scope[])APIDTO.class.getAnnotationsByType(Scope.class);
        boolean hasClassLevelScope = PublisherCommonUtils.checkClassScopeAnnotation(apiDtoClassAnnotatedScopes, tokenScopes);
        JSONParser parser = new JSONParser();
        String oldEndpointConfigString = originalAPI.getEndpointConfig();
        JSONObject oldEndpointConfig = null;
        if (StringUtils.isNotBlank((CharSequence)oldEndpointConfigString)) {
            oldEndpointConfig = (JSONObject)parser.parse(oldEndpointConfigString);
        }
        String oldProductionApiSecret = null;
        String oldSandboxApiSecret = null;
        if (oldEndpointConfig != null && oldEndpointConfig.containsKey((Object)"endpoint_security")) {
            JSONObject oldEndpointSecuritySandbox;
            JSONObject oldEndpointSecurityProduction;
            JSONObject oldEndpointSecurity = (JSONObject)oldEndpointConfig.get((Object)"endpoint_security");
            if (oldEndpointSecurity.containsKey((Object)"production") && (oldEndpointSecurityProduction = (JSONObject)oldEndpointSecurity.get((Object)"production")).get((Object)"clientId") != null && oldEndpointSecurityProduction.get((Object)"clientSecret") != null) {
                oldProductionApiSecret = oldEndpointSecurityProduction.get((Object)"clientSecret").toString();
            }
            if (oldEndpointSecurity.containsKey((Object)"sandbox") && (oldEndpointSecuritySandbox = (JSONObject)oldEndpointSecurity.get((Object)"sandbox")).get((Object)"clientId") != null && oldEndpointSecuritySandbox.get((Object)"clientSecret") != null) {
                oldSandboxApiSecret = oldEndpointSecuritySandbox.get((Object)"clientSecret").toString();
            }
        }
        Map endpointConfig = (Map)apiDtoToUpdate.getEndpointConfig();
        CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
        String customParametersString = "{}";
        if (endpointConfig != null && endpointConfig.get("endpoint_security") != null) {
            String encryptedApiSecret;
            String apiSecret;
            Map customParametersHashMap;
            Map endpointSecurity = (Map)endpointConfig.get("endpoint_security");
            if (endpointSecurity.get("production") != null) {
                Map endpointSecurityProduction = (Map)endpointSecurity.get("production");
                String productionEndpointType = (String)endpointSecurityProduction.get("type");
                if (!(endpointSecurityProduction.get("customParameters") instanceof String)) {
                    customParametersHashMap = (LinkedHashMap)endpointSecurityProduction.get("customParameters");
                    customParametersString = JSONObject.toJSONString((Map)customParametersHashMap);
                }
                endpointSecurityProduction.put("customParameters", customParametersString);
                if ("OAUTH".equals(productionEndpointType)) {
                    apiSecret = endpointSecurityProduction.get("clientSecret").toString();
                    if (StringUtils.isNotEmpty((CharSequence)apiSecret)) {
                        encryptedApiSecret = cryptoUtil.encryptAndBase64Encode(apiSecret.getBytes());
                        endpointSecurityProduction.put("clientSecret", encryptedApiSecret);
                    } else {
                        endpointSecurityProduction.put("clientSecret", oldProductionApiSecret);
                    }
                }
                endpointSecurity.put("production", endpointSecurityProduction);
                endpointConfig.put("endpoint_security", endpointSecurity);
                apiDtoToUpdate.setEndpointConfig(endpointConfig);
            }
            if (endpointSecurity.get("sandbox") != null) {
                Map endpointSecuritySandbox = (Map)endpointSecurity.get("sandbox");
                String sandboxEndpointType = (String)endpointSecuritySandbox.get("type");
                if (!(endpointSecuritySandbox.get("customParameters") instanceof String)) {
                    customParametersHashMap = (Map)endpointSecuritySandbox.get("customParameters");
                    customParametersString = JSONObject.toJSONString((Map)customParametersHashMap);
                }
                endpointSecuritySandbox.put("customParameters", customParametersString);
                if ("OAUTH".equals(sandboxEndpointType)) {
                    apiSecret = endpointSecuritySandbox.get("clientSecret").toString();
                    if (StringUtils.isNotEmpty((CharSequence)apiSecret)) {
                        encryptedApiSecret = cryptoUtil.encryptAndBase64Encode(apiSecret.getBytes());
                        endpointSecuritySandbox.put("clientSecret", encryptedApiSecret);
                    } else {
                        endpointSecuritySandbox.put("clientSecret", oldSandboxApiSecret);
                    }
                }
                endpointSecurity.put("sandbox", endpointSecuritySandbox);
                endpointConfig.put("endpoint_security", endpointSecurity);
                apiDtoToUpdate.setEndpointConfig(endpointConfig);
            }
        }
        if (apiDtoToUpdate.getEndpointConfig() != null && endpointConfig.containsKey("amznSecretKey") && !StringUtils.isEmpty((CharSequence)(secretKey = (String)endpointConfig.get("amznSecretKey")))) {
            if (!"AWS_SECRET_KEY".equals(secretKey)) {
                String encryptedSecretKey = cryptoUtil.encryptAndBase64Encode(secretKey.getBytes());
                endpointConfig.put("amznSecretKey", encryptedSecretKey);
                apiDtoToUpdate.setEndpointConfig(endpointConfig);
            } else {
                JSONParser jsonParser = new JSONParser();
                JSONObject originalEndpointConfig = (JSONObject)jsonParser.parse(originalAPI.getEndpointConfig());
                String encryptedSecretKey = (String)originalEndpointConfig.get((Object)"amznSecretKey");
                endpointConfig.put("amznSecretKey", encryptedSecretKey);
                apiDtoToUpdate.setEndpointConfig(endpointConfig);
            }
        }
        if (!hasClassLevelScope) {
            apiDtoToUpdate = PublisherCommonUtils.getFieldOverriddenAPIDTO(apiDtoToUpdate, originalAPI, tokenScopes);
        }
        apiDtoToUpdate.setName(apiIdentifier.getApiName());
        apiDtoToUpdate.setVersion(apiIdentifier.getVersion());
        apiDtoToUpdate.setProvider(apiIdentifier.getProviderName());
        apiDtoToUpdate.setContext(originalAPI.getContextTemplate());
        apiDtoToUpdate.setLifeCycleStatus(originalAPI.getStatus());
        apiDtoToUpdate.setType(APIDTO.TypeEnum.fromValue(originalAPI.getType()));
        List<APIResource> removedProductResources = PublisherCommonUtils.getRemovedProductResources(apiDtoToUpdate, originalAPI);
        if (!removedProductResources.isEmpty()) {
            throw new APIManagementException("Cannot remove following resource paths " + removedProductResources.toString() + " because they are used by one or more API Products", ExceptionCodes.from((ErrorHandler)ExceptionCodes.API_PRODUCT_USED_RESOURCES, (String[])new String[]{originalAPI.getId().getApiName(), originalAPI.getId().getVersion()}));
        }
        List<String> apiSecurity = apiDtoToUpdate.getSecurityScheme();
        List<String> tiersFromDTO = apiDtoToUpdate.getPolicies();
        String originalStatus = originalAPI.getStatus();
        if ((apiSecurity.contains("oauth2") || apiSecurity.contains("api_key")) && (tiersFromDTO == null || tiersFromDTO.isEmpty() && !"CREATED".equals(originalStatus) && !"PROTOTYPED".equals(originalStatus))) {
            throw new APIManagementException("A tier should be defined if the API is not in CREATED or PROTOTYPED state", (ErrorHandler)ExceptionCodes.TIER_CANNOT_BE_NULL);
        }
        if (tiersFromDTO != null && !tiersFromDTO.isEmpty() && (invalidTiers = PublisherCommonUtils.getInvalidTierNames(definedTiers = apiProvider.getTiers(), tiersFromDTO)).size() > 0) {
            throw new APIManagementException("Specified tier(s) " + Arrays.toString(invalidTiers.toArray()) + " are invalid", (ErrorHandler)ExceptionCodes.TIER_NAME_INVALID);
        }
        if (apiDtoToUpdate.getAccessControlRoles() != null && !(errorMessage = PublisherCommonUtils.validateUserRoles(apiDtoToUpdate.getAccessControlRoles())).isEmpty()) {
            throw new APIManagementException(errorMessage, (ErrorHandler)ExceptionCodes.INVALID_USER_ROLES);
        }
        if (apiDtoToUpdate.getVisibleRoles() != null && !(errorMessage = PublisherCommonUtils.validateRoles(apiDtoToUpdate.getVisibleRoles())).isEmpty()) {
            throw new APIManagementException(errorMessage, (ErrorHandler)ExceptionCodes.INVALID_USER_ROLES);
        }
        if (apiDtoToUpdate.getAdditionalProperties() != null && !(errorMessage = PublisherCommonUtils.validateAdditionalProperties(apiDtoToUpdate.getAdditionalProperties())).isEmpty()) {
            throw new APIManagementException(errorMessage, ExceptionCodes.from((ErrorHandler)ExceptionCodes.INVALID_ADDITIONAL_PROPERTIES, (String[])new String[]{apiDtoToUpdate.getName(), apiDtoToUpdate.getVersion()}));
        }
        if (apiDtoToUpdate.getOperations() == null || apiDtoToUpdate.getOperations().isEmpty()) {
            throw new APIManagementException((ErrorHandler)ExceptionCodes.NO_RESOURCES_FOUND);
        }
        API apiToUpdate = APIMappingUtil.fromDTOtoAPI(apiDtoToUpdate, apiIdentifier.getProviderName());
        if ("public".equals(apiToUpdate.getVisibility())) {
            apiToUpdate.setVisibleRoles("");
        }
        apiToUpdate.setUUID(originalAPI.getUUID());
        PublisherCommonUtils.validateScopes(apiToUpdate);
        apiToUpdate.setThumbnailUrl(originalAPI.getThumbnailUrl());
        if (apiDtoToUpdate.getKeyManagers() instanceof List) {
            apiToUpdate.setKeyManagers((List)apiDtoToUpdate.getKeyManagers());
        } else {
            apiToUpdate.setKeyManagers(Collections.singletonList("all"));
        }
        String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        apiIdentifier.setUuid(apiToUpdate.getUuid());
        if (!isAsyncAPI) {
            oldDefinition = apiProvider.getOpenAPIDefinition((Identifier)apiIdentifier, tenantDomain);
            APIDefinition apiDefinition = OASParserUtil.getOASParser((String)oldDefinition);
            SwaggerData swaggerData = new SwaggerData(apiToUpdate);
            String newDefinition = apiDefinition.generateAPIDefinition(swaggerData, oldDefinition);
            apiProvider.saveSwaggerDefinition(apiToUpdate, newDefinition, tenantDomain);
            if (!isGraphql) {
                apiToUpdate.setUriTemplates(apiDefinition.getURITemplates(newDefinition));
            }
        } else {
            oldDefinition = apiProvider.getAsyncAPIDefinition(apiIdentifier.getUUID(), tenantDomain);
            AsyncApiParser asyncApiParser = new AsyncApiParser();
            String updateAsyncAPIDefinition = asyncApiParser.updateAsyncAPIDefinition(oldDefinition, apiToUpdate);
            apiProvider.saveAsyncApiDefinition(originalAPI, updateAsyncAPIDefinition);
        }
        apiToUpdate.setWsdlUrl(apiDtoToUpdate.getWsdlUrl());
        List apiCategories = apiToUpdate.getApiCategories();
        if (apiCategories != null && apiCategories.size() > 0 && !APIUtil.validateAPICategories((List)apiCategories, (String)RestApiCommonUtil.getLoggedInUserTenantDomain())) {
            throw new APIManagementException("Invalid API Category name(s) defined", ExceptionCodes.from((ErrorHandler)ExceptionCodes.API_CATEGORY_INVALID, (String[])new String[0]));
        }
        apiProvider.updateAPI(apiToUpdate, originalAPI);
        return apiProvider.getAPIbyUUID(originalAPI.getUuid(), CarbonContext.getThreadLocalCarbonContext().getTenantDomain());
    }

    private static boolean checkClassScopeAnnotation(Scope[] apiDtoClassAnnotatedScopes, String[] tokenScopes) {
        for (Scope classAnnotation : apiDtoClassAnnotatedScopes) {
            for (String tokenScope : tokenScopes) {
                if (!classAnnotation.name().equals(tokenScope)) continue;
                return true;
            }
        }
        return false;
    }

    private static JSONObject overrideDTOValues(JSONObject originalApiDtoJson, JSONObject newApiDtoJson, Field field, String[] tokenScopes, Scope[] fieldAnnotatedScopes) throws APIManagementException {
        for (String tokenScope : tokenScopes) {
            for (Scope scopeAnt : fieldAnnotatedScopes) {
                if (!scopeAnt.name().equals(tokenScope)) continue;
                originalApiDtoJson.put((Object)field.getName(), newApiDtoJson.get((Object)field.getName()));
                return originalApiDtoJson;
            }
        }
        throw new APIManagementException("User is not authorized to update one or more API fields. None of the required scopes found in user token to update the field. So the request will be failed.", (ErrorHandler)ExceptionCodes.INVALID_SCOPE);
    }

    private static APIDTO getFieldOverriddenAPIDTO(APIDTO apidto, API originalAPI, String[] tokenScopes) throws APIManagementException {
        APIDTO updatedAPIDTO;
        try {
            APIDTO originalApiDTO = APIMappingUtil.fromAPItoDTO(originalAPI);
            Field[] fields = APIDTO.class.getDeclaredFields();
            ObjectMapper mapper = new ObjectMapper();
            String newApiDtoJsonString = mapper.writeValueAsString((Object)apidto);
            JSONParser parser = new JSONParser();
            JSONObject newApiDtoJson = (JSONObject)parser.parse(newApiDtoJsonString);
            String originalApiDtoJsonString = mapper.writeValueAsString((Object)originalApiDTO);
            JSONObject originalApiDtoJson = (JSONObject)parser.parse(originalApiDtoJsonString);
            for (Field field : fields) {
                String newElementValue;
                Scope[] fieldAnnotatedScopes = (Scope[])field.getAnnotationsByType(Scope.class);
                String originalElementValue = mapper.writeValueAsString(originalApiDtoJson.get((Object)field.getName()));
                if (StringUtils.equals((CharSequence)originalElementValue, (CharSequence)(newElementValue = mapper.writeValueAsString(newApiDtoJson.get((Object)field.getName()))))) continue;
                originalApiDtoJson = PublisherCommonUtils.overrideDTOValues(originalApiDtoJson, newApiDtoJson, field, tokenScopes, fieldAnnotatedScopes);
            }
            updatedAPIDTO = (APIDTO)mapper.readValue(originalApiDtoJson.toJSONString(), APIDTO.class);
        }
        catch (IOException | ParseException e) {
            String msg = "Error while processing API DTO json strings";
            throw new APIManagementException(msg, e, (ErrorHandler)ExceptionCodes.JSON_PARSE_ERROR);
        }
        return updatedAPIDTO;
    }

    private static List<APIResource> getRemovedProductResources(APIDTO updatedDTO, API existingAPI) {
        List<APIOperationsDTO> updatedOperations = updatedDTO.getOperations();
        Set existingUriTemplates = existingAPI.getUriTemplates();
        ArrayList<APIResource> removedReusedResources = new ArrayList<APIResource>();
        for (URITemplate existingUriTemplate : existingUriTemplates) {
            if (existingUriTemplate.retrieveUsedByProducts().isEmpty()) continue;
            String existingVerb = existingUriTemplate.getHTTPVerb();
            String existingPath = existingUriTemplate.getUriTemplate();
            boolean isReusedResourceRemoved = true;
            for (APIOperationsDTO updatedOperation : updatedOperations) {
                String updatedVerb = updatedOperation.getVerb();
                String updatedPath = updatedOperation.getTarget();
                if (!existingVerb.equalsIgnoreCase(updatedVerb) || !existingPath.equalsIgnoreCase(updatedPath)) continue;
                isReusedResourceRemoved = false;
                break;
            }
            if (!isReusedResourceRemoved) continue;
            APIResource removedResource = new APIResource(existingVerb, existingPath);
            removedReusedResources.add(removedResource);
        }
        return removedReusedResources;
    }

    public static String validateUserRoles(List<String> inputRoles) throws APIManagementException {
        String userName = RestApiCommonUtil.getLoggedInUsername();
        String[] tenantRoleList = APIUtil.getRoleNames((String)userName);
        boolean isMatched = false;
        String[] userRoleList = null;
        if (APIUtil.hasPermission((String)userName, (String)"/permission/admin/manage/apim_admin")) {
            isMatched = true;
        } else {
            userRoleList = APIUtil.getListOfRoles((String)userName);
        }
        if (inputRoles != null && !inputRoles.isEmpty()) {
            if (tenantRoleList != null || userRoleList != null) {
                for (String inputRole : inputRoles) {
                    if (!isMatched && userRoleList != null && APIUtil.compareRoleList((String[])userRoleList, (String)inputRole)) {
                        isMatched = true;
                    }
                    if (tenantRoleList == null || APIUtil.compareRoleList((String[])tenantRoleList, (String)inputRole)) continue;
                    return "Invalid user roles found in accessControlRole list";
                }
                return isMatched ? "" : "This user does not have at least one role specified in API access control.";
            }
            return "Invalid user roles found";
        }
        return "";
    }

    public static String validateRoles(List<String> inputRoles) throws APIManagementException {
        String roleString;
        String userName = RestApiCommonUtil.getLoggedInUsername();
        boolean isMatched = false;
        if (inputRoles != null && !inputRoles.isEmpty() && !(isMatched = APIUtil.isRoleNameExist((String)userName, (String)(roleString = String.join((CharSequence)",", inputRoles))))) {
            return "Invalid user roles found in visibleRoles list";
        }
        return "";
    }

    public static String validateAdditionalProperties(List<APIAdditionalPropertiesDTO> additionalProperties) {
        if (additionalProperties != null) {
            for (APIAdditionalPropertiesDTO property : additionalProperties) {
                String propertyKey = property.getName();
                String propertyValue = property.getValue();
                if (propertyKey.contains(" ")) {
                    return "Property names should not contain space character. Property '" + propertyKey + "' contains space in it.";
                }
                if (Arrays.asList(APIConstants.API_SEARCH_PREFIXES).contains(propertyKey.toLowerCase())) {
                    return "Property '" + propertyKey + "' conflicts with the reserved keywords. Reserved keywords are [" + Arrays.toString(APIConstants.API_SEARCH_PREFIXES) + "]";
                }
                if (propertyKey.length() > 80) {
                    return "Property name can have maximum of 80 characters. Property '" + propertyKey + "' + contains " + propertyKey.length() + "characters";
                }
                if (propertyValue.length() <= 900) continue;
                return "Property value can have maximum of 900 characters. Property '" + propertyKey + "' + contains a value with " + propertyValue.length() + "characters";
            }
        }
        return "";
    }

    public static void validateScopes(API api) throws APIManagementException {
        APIIdentifier apiId = api.getId();
        String username = RestApiCommonUtil.getLoggedInUsername();
        String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        int tenantId = APIUtil.getTenantIdFromTenantDomain((String)tenantDomain);
        APIProvider apiProvider = RestApiCommonUtil.getProvider((String)username);
        HashSet<org.wso2.carbon.apimgt.api.model.Scope> sharedAPIScopes = new HashSet<org.wso2.carbon.apimgt.api.model.Scope>();
        for (org.wso2.carbon.apimgt.api.model.Scope scope : api.getScopes()) {
            String scopeName = scope.getKey();
            if (!APIUtil.isAllowedScope((String)scopeName)) {
                if (apiProvider.isScopeKeyAssignedLocally(apiId, scopeName, tenantId)) {
                    throw new APIManagementException("Scope " + scopeName + " is already assigned locally by another API", (ErrorHandler)ExceptionCodes.SCOPE_ALREADY_ASSIGNED);
                }
                if (apiProvider.isSharedScopeNameExists(scopeName, tenantDomain)) {
                    sharedAPIScopes.add(scope);
                    continue;
                }
            }
            if (StringUtils.isBlank((CharSequence)scope.getName())) {
                scope.setName(scopeName);
            }
            if (StringUtils.isBlank((CharSequence)scope.getDescription())) {
                scope.setDescription("");
            }
            if (scope.getRoles() == null) continue;
            for (String aRole : scope.getRoles().split(",")) {
                boolean isValidRole = APIUtil.isRoleNameExist((String)username, (String)aRole);
                if (isValidRole) continue;
                throw new APIManagementException("Role '" + aRole + "' does not exist.", (ErrorHandler)ExceptionCodes.ROLE_DOES_NOT_EXIST);
            }
        }
        apiProvider.validateSharedScopes(sharedAPIScopes, tenantDomain);
    }

    public static API addAPIWithGeneratedSwaggerDefinition(APIDTO apiDto, String oasVersion, String username) throws APIManagementException, CryptoException {
        AsyncApiParser asyncApiParser;
        String secretKey;
        Map endpointConfig;
        boolean isWSAPI = APIDTO.TypeEnum.WS.equals((Object)apiDto.getType());
        boolean isAsyncAPI = isWSAPI || APIDTO.TypeEnum.WEBSUB.equals((Object)apiDto.getType()) || APIDTO.TypeEnum.SSE.equals((Object)apiDto.getType());
        username = StringUtils.isEmpty((CharSequence)username) ? RestApiCommonUtil.getLoggedInUsername() : username;
        APIProvider apiProvider = RestApiCommonUtil.getProvider((String)username);
        if (isWSAPI && !PublisherCommonUtils.isValidWSAPI(apiDto)) {
            throw new APIManagementException("Endpoint URLs should be valid web socket URLs", (ErrorHandler)ExceptionCodes.INVALID_ENDPOINT_URL);
        }
        if (apiDto.getEndpointConfig() != null && (endpointConfig = (Map)apiDto.getEndpointConfig()).containsKey("amznSecretKey") && !StringUtils.isEmpty((CharSequence)(secretKey = (String)endpointConfig.get("amznSecretKey")))) {
            CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
            String encryptedSecretKey = cryptoUtil.encryptAndBase64Encode(secretKey.getBytes());
            endpointConfig.put("amznSecretKey", encryptedSecretKey);
            apiDto.setEndpointConfig(endpointConfig);
        }
        API apiToAdd = PublisherCommonUtils.prepareToCreateAPIByDTO(apiDto, apiProvider, username);
        PublisherCommonUtils.validateScopes(apiToAdd);
        List apiCategories = apiToAdd.getApiCategories();
        if (apiCategories != null && apiCategories.size() > 0 && !APIUtil.validateAPICategories((List)apiCategories, (String)RestApiCommonUtil.getLoggedInUserTenantDomain())) {
            throw new APIManagementException("Invalid API Category name(s) defined", ExceptionCodes.from((ErrorHandler)ExceptionCodes.API_CATEGORY_INVALID, (String[])new String[0]));
        }
        if (!isAsyncAPI) {
            Object oasParser = "v2".equalsIgnoreCase(oasVersion) ? new OAS2Parser() : new OAS3Parser();
            SwaggerData swaggerData = new SwaggerData(apiToAdd);
            String apiDefinition = oasParser.generateAPIDefinition(swaggerData);
            apiToAdd.setSwaggerDefinition(apiDefinition);
        } else {
            asyncApiParser = new AsyncApiParser();
            String asyncApiDefinition = asyncApiParser.generateAsyncAPIDefinition(apiToAdd);
            apiToAdd.setAsyncApiDefinition(asyncApiDefinition);
        }
        if (isAsyncAPI) {
            asyncApiParser = new AsyncApiParser();
            String apiDefinition = asyncApiParser.generateAsyncAPIDefinition(apiToAdd);
            apiProvider.saveAsyncApiDefinition(apiToAdd, apiDefinition);
        }
        apiProvider.addAPI(apiToAdd);
        return apiToAdd;
    }

    public static boolean isValidWSAPI(APIDTO api) {
        boolean isValid = false;
        if (api.getEndpointConfig() != null) {
            Map endpointConfig = (Map)api.getEndpointConfig();
            String prodEndpointUrl = String.valueOf(((Map)endpointConfig.get("production_endpoints")).get("url"));
            String sandboxEndpointUrl = String.valueOf(((Map)endpointConfig.get("sandbox_endpoints")).get("url"));
            boolean bl = isValid = prodEndpointUrl.startsWith("ws://") || prodEndpointUrl.startsWith("wss://");
            if (isValid) {
                isValid = sandboxEndpointUrl.startsWith("ws://") || sandboxEndpointUrl.startsWith("wss://");
            }
        }
        return isValid;
    }

    public static String constructEndpointConfigForService(String serviceUrl, String protocol) {
        StringBuilder sb = new StringBuilder();
        String endpointType = APIDTO.TypeEnum.HTTP.value().toLowerCase();
        if (StringUtils.isNotEmpty((CharSequence)protocol) && (APIDTO.TypeEnum.SSE.equals(protocol.toUpperCase()) || APIDTO.TypeEnum.WS.equals(protocol.toUpperCase()))) {
            endpointType = "ws";
        }
        if (StringUtils.isNotEmpty((CharSequence)serviceUrl)) {
            sb.append("{\"endpoint_type\": \"").append(endpointType).append("\",").append("\"production_endpoints\": {\"url\": \"").append(serviceUrl).append("\"}}");
        }
        return sb.toString();
    }

    public static APIDTO.TypeEnum getAPIType(ServiceEntry.DefinitionType definitionType, String protocol) throws APIManagementException {
        if (ServiceEntry.DefinitionType.ASYNC_API.equals((Object)definitionType)) {
            if (protocol.isEmpty()) {
                throw new APIManagementException("A protocol should be specified in the Async API definition", (ErrorHandler)ExceptionCodes.MISSING_PROTOCOL_IN_ASYNC_API_DEFINITION);
            }
            if (!("WEBSUB".equals(protocol.toUpperCase()) || "SSE".equals(protocol.toUpperCase()) || "WS".equals(protocol.toUpperCase()))) {
                throw new APIManagementException("Unsupported protocol specified in Async API Definition", (ErrorHandler)ExceptionCodes.UNSUPPORTED_PROTOCOL_SPECIFIED_IN_ASYNC_API_DEFINITION);
            }
        }
        switch (definitionType) {
            case WSDL1: 
            case WSDL2: {
                return APIDTO.TypeEnum.SOAP;
            }
            case GRAPHQL_SDL: {
                return APIDTO.TypeEnum.GRAPHQL;
            }
            case ASYNC_API: {
                return APIDTO.TypeEnum.fromValue(protocol.toUpperCase());
            }
        }
        return APIDTO.TypeEnum.HTTP;
    }

    public static API prepareToCreateAPIByDTO(APIDTO body, APIProvider apiProvider, String username) throws APIManagementException {
        String provider;
        String errorMessage;
        String context = body.getContext();
        String string = context = context.startsWith("/") ? context : "/" + context;
        if (body.getAccessControlRoles() != null && !(errorMessage = PublisherCommonUtils.validateUserRoles(body.getAccessControlRoles())).isEmpty()) {
            throw new APIManagementException(errorMessage, (ErrorHandler)ExceptionCodes.INVALID_USER_ROLES);
        }
        if (body.getAdditionalProperties() != null && !(errorMessage = PublisherCommonUtils.validateAdditionalProperties(body.getAdditionalProperties())).isEmpty()) {
            throw new APIManagementException(errorMessage, ExceptionCodes.from((ErrorHandler)ExceptionCodes.INVALID_ADDITIONAL_PROPERTIES, (String[])new String[]{body.getName(), body.getVersion()}));
        }
        if (body.getContext() == null) {
            throw new APIManagementException("Parameter: \"context\" cannot be null", (ErrorHandler)ExceptionCodes.PARAMETER_NOT_PROVIDED);
        }
        if (body.getContext().endsWith("/")) {
            throw new APIManagementException("Context cannot end with '/' character", (ErrorHandler)ExceptionCodes.INVALID_CONTEXT);
        }
        if (apiProvider.isApiNameWithDifferentCaseExist(body.getName())) {
            throw new APIManagementException("Error occurred while adding API. API with name " + body.getName() + " already exists.", ExceptionCodes.from((ErrorHandler)ExceptionCodes.API_NAME_ALREADY_EXISTS, (String[])new String[]{body.getName()}));
        }
        if (body.getAuthorizationHeader() == null) {
            body.setAuthorizationHeader(APIUtil.getOAuthConfigurationFromAPIMConfig((String)"AuthorizationHeader"));
        }
        if (body.getAuthorizationHeader() == null) {
            body.setAuthorizationHeader("Authorization");
        }
        if (body.getVisibility() == APIDTO.VisibilityEnum.RESTRICTED && body.getVisibleRoles().isEmpty()) {
            throw new APIManagementException("Valid roles should be added under 'visibleRoles' to restrict the visibility", (ErrorHandler)ExceptionCodes.USER_ROLES_CANNOT_BE_NULL);
        }
        if (body.getVisibleRoles() != null && !(errorMessage = PublisherCommonUtils.validateRoles(body.getVisibleRoles())).isEmpty()) {
            throw new APIManagementException(errorMessage, (ErrorHandler)ExceptionCodes.INVALID_USER_ROLES);
        }
        List apiVersions = apiProvider.getApiVersionsMatchingApiName(body.getName(), username);
        if (apiVersions.size() > 0) {
            for (String version : apiVersions) {
                if (!version.equalsIgnoreCase(body.getVersion())) continue;
                throw new APIManagementException("Error occurred while adding the API. The version already exists: " + version, ExceptionCodes.from((ErrorHandler)ExceptionCodes.API_VERSION_ALREADY_EXISTS, (String[])new String[]{version, body.getName()}));
            }
        } else if (apiProvider.isDuplicateContextTemplate(context)) {
            throw new APIManagementException("Error occurred while adding the API. A duplicate API context already exists for " + context, ExceptionCodes.from((ErrorHandler)ExceptionCodes.API_CONTEXT_ALREADY_EXISTS, (String[])new String[]{context}));
        }
        if (!StringUtils.isBlank((CharSequence)(provider = body.getProvider())) && !provider.equals(username)) {
            if (!APIUtil.hasPermission((String)username, (String)"/permission/admin/manage/apim_admin")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User " + username + " does not have admin permission (" + "/permission/admin/manage/apim_admin" + ") hence provider (" + provider + ") overridden with current user (" + username + ")"));
                }
                provider = username;
            } else if (!APIUtil.isUserExist((String)provider)) {
                throw new APIManagementException("Specified provider " + provider + " not exist.", (ErrorHandler)ExceptionCodes.PARAMETER_NOT_PROVIDED);
            }
        } else {
            provider = username;
        }
        List<String> tiersFromDTO = body.getPolicies();
        Set definedTiers = apiProvider.getTiers();
        List<String> invalidTiers = PublisherCommonUtils.getInvalidTierNames(definedTiers, tiersFromDTO);
        if (invalidTiers.size() > 0) {
            throw new APIManagementException("Specified tier(s) " + Arrays.toString(invalidTiers.toArray()) + " are invalid", (ErrorHandler)ExceptionCodes.TIER_NAME_INVALID);
        }
        APIPolicy apiPolicy = apiProvider.getAPIPolicy(username, body.getApiThrottlingPolicy());
        if (apiPolicy == null && body.getApiThrottlingPolicy() != null) {
            throw new APIManagementException("Specified policy " + body.getApiThrottlingPolicy() + " is invalid", (ErrorHandler)ExceptionCodes.UNSUPPORTED_THROTTLE_LIMIT_TYPE);
        }
        API apiToAdd = APIMappingUtil.fromDTOtoAPI(body, provider);
        if (!"PROTOTYPED".equals(apiToAdd.getStatus())) {
            apiToAdd.setStatus("CREATED");
        }
        if (!apiToAdd.isAdvertiseOnly() || StringUtils.isBlank((CharSequence)apiToAdd.getApiOwner())) {
            apiToAdd.setApiOwner(provider);
        }
        if (body.getKeyManagers() instanceof List) {
            apiToAdd.setKeyManagers((List)body.getKeyManagers());
        } else if (body.getKeyManagers() == null) {
            apiToAdd.setKeyManagers(Collections.singletonList("all"));
        } else {
            throw new APIManagementException("KeyManagers value need to be an array");
        }
        return apiToAdd;
    }

    public static String updateAPIDefinition(String apiId, APIDefinitionValidationResponse response, ServiceEntry service) throws APIManagementException, FaultGatewaysException {
        if (ServiceEntry.DefinitionType.OAS2.equals((Object)service.getDefinitionType()) || ServiceEntry.DefinitionType.OAS3.equals((Object)service.getDefinitionType())) {
            return PublisherCommonUtils.updateSwagger(apiId, response, true);
        }
        if (ServiceEntry.DefinitionType.ASYNC_API.equals((Object)service.getDefinitionType())) {
            return PublisherCommonUtils.updateAsyncAPIDefinition(apiId, response);
        }
        return null;
    }

    public static String updateAsyncAPIDefinition(String apiId, APIDefinitionValidationResponse response) throws APIManagementException, FaultGatewaysException {
        APIProvider apiProvider = RestApiCommonUtil.getLoggedInUserProvider();
        String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        API existingAPI = apiProvider.getAPIbyUUID(apiId, tenantDomain);
        AsyncApiParser asyncApiParser = new AsyncApiParser();
        String apiDefinition = response.getJsonContent();
        Set uriTemplates = asyncApiParser.getURITemplates(apiDefinition, "WS".equals(existingAPI.getType()));
        if (uriTemplates == null || uriTemplates.isEmpty()) {
            throw new APIManagementException((ErrorHandler)ExceptionCodes.NO_RESOURCES_FOUND);
        }
        existingAPI.setUriTemplates(uriTemplates);
        existingAPI.setWsUriMapping(asyncApiParser.buildWSUriMapping(apiDefinition));
        apiProvider.saveAsyncApiDefinition(existingAPI, apiDefinition);
        apiProvider.updateAPI(existingAPI);
        return apiProvider.getAsyncAPIDefinition((Identifier)existingAPI.getId());
    }

    public static String updateSwagger(String apiId, APIDefinitionValidationResponse response, boolean isServiceAPI) throws APIManagementException, FaultGatewaysException {
        APIProvider apiProvider = RestApiCommonUtil.getLoggedInUserProvider();
        String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        API existingAPI = apiProvider.getAPIbyUUID(apiId, tenantDomain);
        APIDefinition oasParser = response.getParser();
        String apiDefinition = response.getJsonContent();
        apiDefinition = isServiceAPI ? oasParser.copyVendorExtensions(existingAPI.getSwaggerDefinition(), apiDefinition) : OASParserUtil.preProcess((String)apiDefinition);
        if ("SOAPTOREST".equals(existingAPI.getType())) {
            List sequenceList = SequenceGenerator.generateSequencesFromSwagger((String)apiDefinition, (APIIdentifier)existingAPI.getId());
            existingAPI.setSoapToRestSequences(sequenceList);
        }
        Set uriTemplates = null;
        uriTemplates = oasParser.getURITemplates(apiDefinition);
        if (uriTemplates == null || uriTemplates.isEmpty()) {
            throw new APIManagementException((ErrorHandler)ExceptionCodes.NO_RESOURCES_FOUND);
        }
        Set scopes = oasParser.getScopes(apiDefinition);
        for (org.wso2.carbon.apimgt.api.model.Scope scope : scopes) {
            String roles = scope.getRoles();
            if (roles == null) continue;
            for (String aRole : roles.split(",")) {
                boolean isValidRole = APIUtil.isRoleNameExist((String)RestApiCommonUtil.getLoggedInUsername(), (String)aRole);
                if (isValidRole) continue;
                throw new APIManagementException("Role '" + aRole + "' Does not exist.");
            }
        }
        List removedProductResources = apiProvider.getRemovedProductResources(uriTemplates, existingAPI);
        if (!removedProductResources.isEmpty()) {
            throw new APIManagementException("Cannot remove following resource paths " + removedProductResources.toString() + " because they are used by one or more API Products", ExceptionCodes.from((ErrorHandler)ExceptionCodes.API_PRODUCT_USED_RESOURCES, (String[])new String[]{existingAPI.getId().getApiName(), existingAPI.getId().getVersion()}));
        }
        existingAPI.setUriTemplates(uriTemplates);
        existingAPI.setScopes(scopes);
        PublisherCommonUtils.validateScopes(existingAPI);
        SwaggerData swaggerData = new SwaggerData(existingAPI);
        String updatedApiDefinition = oasParser.populateCustomManagementInfo(apiDefinition, swaggerData);
        apiProvider.saveSwaggerDefinition(existingAPI, updatedApiDefinition, tenantDomain);
        existingAPI.setSwaggerDefinition(updatedApiDefinition);
        API unModifiedAPI = apiProvider.getAPIbyUUID(apiId, tenantDomain);
        existingAPI.setStatus(unModifiedAPI.getStatus());
        apiProvider.updateAPI(existingAPI, unModifiedAPI);
        String apiSwagger = apiProvider.getOpenAPIDefinition(apiId, tenantDomain);
        return oasParser.getOASDefinitionForPublisher(existingAPI, apiSwagger);
    }

    public static API addGraphQLSchema(API originalAPI, String schemaDefinition, APIProvider apiProvider) throws APIManagementException, FaultGatewaysException {
        List<APIOperationsDTO> operationListWithOldData = APIMappingUtil.getOperationListWithOldData(originalAPI.getUriTemplates(), PublisherCommonUtils.extractGraphQLOperationList(schemaDefinition));
        Set<URITemplate> uriTemplates = APIMappingUtil.getURITemplates(originalAPI, operationListWithOldData);
        originalAPI.setUriTemplates(uriTemplates);
        apiProvider.saveGraphqlSchemaDefinition(originalAPI, schemaDefinition);
        apiProvider.updateAPI(originalAPI);
        return originalAPI;
    }

    public static List<APIOperationsDTO> extractGraphQLOperationList(String schema) {
        ArrayList<APIOperationsDTO> operationArray = new ArrayList<APIOperationsDTO>();
        SchemaParser schemaParser = new SchemaParser();
        TypeDefinitionRegistry typeRegistry = schemaParser.parse(schema);
        Map operationList = typeRegistry.types();
        for (Map.Entry entry : operationList.entrySet()) {
            if (!((TypeDefinition)entry.getValue()).getName().equals("Query") && !((TypeDefinition)entry.getValue()).getName().equals("Mutation") && !((TypeDefinition)entry.getValue()).getName().equals("Subscription")) continue;
            for (FieldDefinition fieldDef : ((ObjectTypeDefinition)entry.getValue()).getFieldDefinitions()) {
                APIOperationsDTO operation = new APIOperationsDTO();
                operation.setVerb((String)entry.getKey());
                operation.setTarget(fieldDef.getName());
                operationArray.add(operation);
            }
        }
        return operationArray;
    }

    public static GraphQLValidationResponseDTO validateGraphQLSchema(String filename, String schema) throws APIManagementException {
        String errorMessage;
        GraphQLValidationResponseDTO validationResponse = new GraphQLValidationResponseDTO();
        boolean isValid = false;
        try {
            if (filename.endsWith(".graphql") || filename.endsWith(".txt") || filename.endsWith(".sdl")) {
                if (schema.isEmpty()) {
                    throw new APIManagementException("GraphQL Schema cannot be empty or null to validate it", (ErrorHandler)ExceptionCodes.GRAPHQL_SCHEMA_CANNOT_BE_NULL);
                }
                SchemaValidator schemaValidation = new SchemaValidator();
                SchemaParser schemaParser = new SchemaParser();
                TypeDefinitionRegistry typeRegistry = schemaParser.parse(schema);
                GraphQLSchema graphQLSchema = UnExecutableSchemaGenerator.makeUnExecutableSchema((TypeDefinitionRegistry)typeRegistry);
                Set validationErrors = schemaValidation.validateSchema(graphQLSchema);
                if (validationErrors.toArray().length > 0) {
                    errorMessage = "InValid Schema";
                    validationResponse.isValid(Boolean.FALSE);
                    validationResponse.errorMessage(errorMessage);
                } else {
                    validationResponse.setIsValid(Boolean.TRUE);
                    GraphQLValidationResponseGraphQLInfoDTO graphQLInfo = new GraphQLValidationResponseGraphQLInfoDTO();
                    GraphQLSchemaDefinition graphql = new GraphQLSchemaDefinition();
                    List operationList = graphql.extractGraphQLOperationList(schema, null);
                    List<APIOperationsDTO> operationArray = APIMappingUtil.fromURITemplateListToOprationList(operationList);
                    graphQLInfo.setOperations(operationArray);
                    GraphQLSchemaDTO schemaObj = new GraphQLSchemaDTO();
                    schemaObj.setSchemaDefinition(schema);
                    graphQLInfo.setGraphQLSchema(schemaObj);
                    validationResponse.setGraphQLInfo(graphQLInfo);
                }
            } else {
                throw new APIManagementException("Unsupported extension type of file: " + filename, (ErrorHandler)ExceptionCodes.UNSUPPORTED_GRAPHQL_FILE_EXTENSION);
            }
            isValid = validationResponse.isIsValid();
            errorMessage = validationResponse.getErrorMessage();
        }
        catch (SchemaProblem e) {
            errorMessage = e.getMessage();
        }
        if (!isValid) {
            validationResponse.setIsValid(isValid);
            validationResponse.setErrorMessage(errorMessage);
        }
        return validationResponse;
    }

    public static void updateThumbnail(InputStream fileInputStream, String fileContentType, APIProvider apiProvider, String apiId, String tenantDomain) throws APIManagementException {
        ResourceFile apiImage = new ResourceFile(fileInputStream, fileContentType);
        apiProvider.setThumbnailToAPI(apiId, apiImage, tenantDomain);
    }

    public static Documentation addDocumentationToAPI(DocumentDTO documentDto, String apiId) throws APIManagementException {
        APIProvider apiProvider = RestApiCommonUtil.getLoggedInUserProvider();
        Documentation documentation = DocumentationMappingUtil.fromDTOtoDocumentation(documentDto);
        String documentName = documentDto.getName();
        String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        if (documentDto.getType() == null) {
            throw new APIManagementException("Documentation type cannot be empty", (ErrorHandler)ExceptionCodes.PARAMETER_NOT_PROVIDED);
        }
        if (documentDto.getType() == DocumentDTO.TypeEnum.OTHER && StringUtils.isBlank((CharSequence)documentDto.getOtherTypeName())) {
            throw new APIManagementException("otherTypeName cannot be empty if type is OTHER.", (ErrorHandler)ExceptionCodes.PARAMETER_NOT_PROVIDED);
        }
        String sourceUrl = documentDto.getSourceUrl();
        if (documentDto.getSourceType() == DocumentDTO.SourceTypeEnum.URL && (StringUtils.isBlank((CharSequence)sourceUrl) || !RestApiCommonUtil.isURL((String)sourceUrl))) {
            throw new APIManagementException("Invalid document sourceUrl Format", (ErrorHandler)ExceptionCodes.PARAMETER_NOT_PROVIDED);
        }
        if (apiProvider.isDocumentationExist(apiId, documentName, tenantDomain)) {
            throw new APIManagementException("Requested document '" + documentName + "' already exists", (ErrorHandler)ExceptionCodes.DOCUMENT_ALREADY_EXISTS);
        }
        documentation = apiProvider.addDocumentation(apiId, documentation, tenantDomain);
        return documentation;
    }

    public static void addDocumentationContent(Documentation documentation, APIProvider apiProvider, String apiId, String documentId, String tenantDomain, String inlineContent) throws APIManagementException {
        DocumentationContent content = new DocumentationContent();
        content.setSourceType(DocumentationContent.ContentSourceType.valueOf((String)documentation.getSourceType().toString()));
        content.setTextContent(inlineContent);
        apiProvider.addDocumentationContent(apiId, documentId, tenantDomain, content);
    }

    public static void addDocumentationContentForFile(InputStream inputStream, String mediaType, String filename, APIProvider apiProvider, String apiId, String documentId, String tenantDomain) throws APIManagementException {
        DocumentationContent content = new DocumentationContent();
        ResourceFile resourceFile = new ResourceFile(inputStream, mediaType);
        resourceFile.setName(filename);
        content.setResourceFile(resourceFile);
        content.setSourceType(DocumentationContent.ContentSourceType.FILE);
        apiProvider.addDocumentationContent(apiId, documentId, tenantDomain, content);
    }

    public static List<String> getInvalidTierNames(Set<Tier> allTiers, List<String> currentTiers) {
        ArrayList<String> invalidTiers = new ArrayList<String>();
        for (String tierName : currentTiers) {
            boolean isTierValid = false;
            for (Tier definedTier : allTiers) {
                if (!tierName.equals(definedTier.getName())) continue;
                isTierValid = true;
                break;
            }
            if (isTierValid) continue;
            invalidTiers.add(tierName);
        }
        return invalidTiers;
    }

    public static APIProduct updateApiProduct(APIProduct originalAPIProduct, APIProductDTO apiProductDtoToUpdate, APIProvider apiProvider, String username, String orgId) throws APIManagementException, FaultGatewaysException {
        String errorMessage;
        List<String> apiSecurity = apiProductDtoToUpdate.getSecurityScheme();
        List<String> tiersFromDTO = apiProductDtoToUpdate.getPolicies();
        if ((apiSecurity.contains("oauth2") || apiSecurity.contains("api_key")) && (tiersFromDTO == null || tiersFromDTO.isEmpty())) {
            throw new APIManagementException("No tier defined for the API Product", (ErrorHandler)ExceptionCodes.TIER_CANNOT_BE_NULL);
        }
        Set definedTiers = apiProvider.getTiers();
        List<String> invalidTiers = PublisherCommonUtils.getInvalidTierNames(definedTiers, tiersFromDTO);
        if (!invalidTiers.isEmpty()) {
            throw new APIManagementException("Specified tier(s) " + Arrays.toString(invalidTiers.toArray()) + " are invalid", (ErrorHandler)ExceptionCodes.TIER_NAME_INVALID);
        }
        if (apiProductDtoToUpdate.getAdditionalProperties() != null && !(errorMessage = PublisherCommonUtils.validateAdditionalProperties(apiProductDtoToUpdate.getAdditionalProperties())).isEmpty()) {
            throw new APIManagementException(errorMessage, ExceptionCodes.from((ErrorHandler)ExceptionCodes.INVALID_ADDITIONAL_PROPERTIES, (String[])new String[]{originalAPIProduct.getId().getName(), originalAPIProduct.getId().getVersion()}));
        }
        if (APIProductDTO.StateEnum.PUBLISHED.equals((Object)apiProductDtoToUpdate.getState()) && originalAPIProduct.getAvailableTiers() == null && apiProductDtoToUpdate.getPolicies() == null) {
            throw new APIManagementException("Policy needs to be defined before publishing the API Product", (ErrorHandler)ExceptionCodes.THROTTLING_POLICY_CANNOT_BE_NULL);
        }
        APIProduct product = APIMappingUtil.fromDTOtoAPIProduct(apiProductDtoToUpdate, username);
        APIProductIdentifier productIdentifier = originalAPIProduct.getId();
        product.setID(productIdentifier);
        product.setUuid(originalAPIProduct.getUuid());
        Map apiToProductResourceMapping = apiProvider.updateAPIProduct(product);
        apiProvider.updateAPIProductSwagger(originalAPIProduct.getUuid(), apiToProductResourceMapping, product, orgId);
        apiProvider.configureMonetizationInAPIProductArtifact(product);
        return apiProvider.getAPIProduct(productIdentifier);
    }

    public static APIProduct addAPIProductWithGeneratedSwaggerDefinition(APIProductDTO apiProductDTO, String username) throws APIManagementException, FaultGatewaysException {
        String errorMessage;
        username = StringUtils.isEmpty((CharSequence)username) ? RestApiCommonUtil.getLoggedInUsername() : username;
        String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        APIProvider apiProvider = RestApiCommonUtil.getProvider((String)username);
        String provider = apiProductDTO.getProvider();
        String context = apiProductDTO.getContext();
        if (!StringUtils.isBlank((CharSequence)provider) && !provider.equals(username)) {
            if (!APIUtil.hasPermission((String)username, (String)"/permission/admin/manage/apim_admin")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User " + username + " does not have admin permission (" + "/permission/admin/manage/apim_admin" + ") hence provider (" + provider + ") overridden with current user (" + username + ")"));
                }
                provider = username;
            }
        } else {
            provider = username;
        }
        List<String> tiersFromDTO = apiProductDTO.getPolicies();
        Set definedTiers = apiProvider.getTiers();
        List<String> invalidTiers = PublisherCommonUtils.getInvalidTierNames(definedTiers, tiersFromDTO);
        if (!invalidTiers.isEmpty()) {
            throw new APIManagementException("Specified tier(s) " + Arrays.toString(invalidTiers.toArray()) + " are invalid", (ErrorHandler)ExceptionCodes.TIER_NAME_INVALID);
        }
        if (apiProductDTO.getAdditionalProperties() != null && !(errorMessage = PublisherCommonUtils.validateAdditionalProperties(apiProductDTO.getAdditionalProperties())).isEmpty()) {
            throw new APIManagementException(errorMessage, ExceptionCodes.from((ErrorHandler)ExceptionCodes.INVALID_ADDITIONAL_PROPERTIES, (String[])new String[]{apiProductDTO.getName()}));
        }
        if (apiProductDTO.getVisibility() == null) {
            apiProductDTO.setVisibility(APIProductDTO.VisibilityEnum.PUBLIC);
        }
        if (apiProductDTO.getAuthorizationHeader() == null) {
            apiProductDTO.setAuthorizationHeader(APIUtil.getOAuthConfigurationFromAPIMConfig((String)"AuthorizationHeader"));
        }
        if (apiProductDTO.getAuthorizationHeader() == null) {
            apiProductDTO.setAuthorizationHeader("Authorization");
        }
        if (context.endsWith("/{version}")) {
            context = context.replace("/{version}", "");
        }
        String string = context = context.startsWith("/") ? context : "/" + context;
        if (apiProvider.isContextExist(context)) {
            throw new APIManagementException("Error occurred while adding API Product. API Product with the context " + context + " already exists.", ExceptionCodes.from((ErrorHandler)ExceptionCodes.API_PRODUCT_CONTEXT_ALREADY_EXISTS, (String[])new String[]{context}));
        }
        APIProduct productToBeAdded = APIMappingUtil.fromDTOtoAPIProduct(apiProductDTO, provider);
        APIProductIdentifier createdAPIProductIdentifier = productToBeAdded.getId();
        Map apiToProductResourceMapping = apiProvider.addAPIProductWithoutPublishingToGateway(productToBeAdded);
        APIProduct createdProduct = apiProvider.getAPIProduct(createdAPIProductIdentifier);
        apiProvider.addAPIProductSwagger(createdProduct.getUuid(), apiToProductResourceMapping, createdProduct, tenantDomain);
        createdProduct = apiProvider.getAPIProduct(createdAPIProductIdentifier);
        return createdProduct;
    }

    public static boolean isStreamingAPI(APIDTO apidto) {
        return APIDTO.TypeEnum.WS.equals((Object)apidto.getType()) || APIDTO.TypeEnum.SSE.equals((Object)apidto.getType()) || APIDTO.TypeEnum.WEBSUB.equals((Object)apidto.getType());
    }

    public static void addWsdl(String fileContentType, InputStream fileInputStream, API api, APIProvider apiProvider, String tenantDomain) throws APIManagementException {
        ResourceFile wsdlResource = "application/zip".equals(fileContentType) || "application/x-zip-compressed".equals(fileContentType) ? new ResourceFile(fileInputStream, "application/zip") : new ResourceFile(fileInputStream, fileContentType);
        api.setWsdlResource(wsdlResource);
        apiProvider.addWSDLResource(api.getUuid(), wsdlResource, null, tenantDomain);
    }

    public static API updateAPIBySettingGenerateSequencesFromSwagger(String swaggerContent, API api, APIProvider apiProvider, String tenantDomain) throws APIManagementException, FaultGatewaysException {
        List list = SequenceGenerator.generateSequencesFromSwagger((String)swaggerContent, (APIIdentifier)api.getId());
        API updatedAPI = apiProvider.getAPIbyUUID(api.getUuid(), tenantDomain);
        updatedAPI.setSoapToRestSequences(list);
        return apiProvider.updateAPI(updatedAPI, api);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Mediation addMediationPolicyFromFile(String content, String type, APIProvider apiProvider, String apiId, String tenantDomain, List<Mediation> existingMediations, boolean isAPISpecific) throws Exception {
        Mediation existingMediation;
        if (!StringUtils.isNotEmpty((CharSequence)content)) return null;
        OMElement seqElement = APIUtil.buildOMElement((InputStream)new ByteArrayInputStream(content.getBytes()));
        String localName = seqElement.getLocalName();
        String fileName = seqElement.getAttributeValue(new QName("name"));
        Mediation mediation = existingMediation = existingMediations != null ? PublisherCommonUtils.checkInExistingMediations(existingMediations, fileName, type) : null;
        if (!isAPISpecific) {
            if (existingMediation == null) return PublisherCommonUtils.addApiSpecificMediationPolicyFromFile(localName, content, fileName, type, apiProvider, apiId, tenantDomain);
            log.debug((Object)("Sequence" + fileName + " already exists"));
            return null;
        } else {
            if (existingMediation == null) return PublisherCommonUtils.addApiSpecificMediationPolicyFromFile(localName, content, fileName, type, apiProvider, apiId, tenantDomain);
            apiProvider.deleteApiSpecificMediationPolicy(apiId, existingMediation.getUuid(), tenantDomain);
            return PublisherCommonUtils.addApiSpecificMediationPolicyFromFile(localName, content, fileName, type, apiProvider, apiId, tenantDomain);
        }
    }

    private static Mediation addApiSpecificMediationPolicyFromFile(String localName, String content, String fileName, String type, APIProvider apiProvider, String apiId, String tenantDomain) throws APIManagementException {
        if ("sequence".equals(localName)) {
            Mediation mediationPolicy = new Mediation();
            mediationPolicy.setConfig(content);
            mediationPolicy.setName(fileName);
            mediationPolicy.setType(type);
            return apiProvider.addApiSpecificMediationPolicy(apiId, mediationPolicy, tenantDomain);
        }
        throw new APIManagementException("Sequence is malformed");
    }

    public static Mediation checkInExistingMediations(List<Mediation> existingMediations, String mediationName, String type) {
        for (Mediation mediation : existingMediations) {
            if (!StringUtils.equals((CharSequence)mediation.getName(), (CharSequence)mediationName) || !StringUtils.equals((CharSequence)type.toLowerCase(), (CharSequence)mediation.getType().toLowerCase())) continue;
            return mediation;
        }
        return null;
    }
}

