/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings;

import java.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIProvider;
import org.wso2.carbon.apimgt.api.ErrorHandler;
import org.wso2.carbon.apimgt.api.ExceptionCodes;
import org.wso2.carbon.apimgt.rest.api.common.RestApiCommonUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class PublisherAlertsAPIUtils {
    private static final Log log = LogFactory.getLog(PublisherAlertsAPIUtils.class);

    public static boolean validateConfigParameters(String configId) throws APIManagementException {
        String decodedConfigurationId = new String(Base64.getDecoder().decode(configId.getBytes()));
        String[] parameters = decodedConfigurationId.split("#");
        if (parameters.length < 2) {
            throw new APIManagementException("The configuration id validation failed. Should be {apiName}#{apiVersion}#{tenantDomain}", (ErrorHandler)ExceptionCodes.INVALID_CONFIGURATION_ID);
        }
        try {
            APIProvider apiProvider = RestApiCommonUtil.getLoggedInUserProvider();
            if (!apiProvider.isApiNameExist(parameters[0])) {
                throw new APIManagementException("Invalid API Name", (ErrorHandler)ExceptionCodes.INVALID_API_NAME);
            }
        }
        catch (APIManagementException e) {
            throw new APIManagementException("Error while validating payload", (Throwable)e, (ErrorHandler)ExceptionCodes.INTERNAL_ERROR);
        }
        return true;
    }

    public static String getTenantAwareUserName(String userName) {
        String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
        if ("carbon.super".equals(tenantDomain)) {
            return userName + "@" + tenantDomain;
        }
        return userName;
    }
}

