/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings;

import java.util.ArrayList;
import java.util.List;
import org.wso2.carbon.apimgt.api.model.Mediation;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.MediationDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.MediationInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.MediationListDTO;

public class MediationMappingUtil {
    public static MediationListDTO fromMediationListToDTO(List<Mediation> mediation, int offset, int limit) {
        int size;
        MediationListDTO mediationListDTO = new MediationListDTO();
        List<MediationInfoDTO> mediationDTOs = mediationListDTO.getList();
        if (mediationDTOs == null) {
            mediationDTOs = new ArrayList<MediationInfoDTO>();
            mediationListDTO.setList(mediationDTOs);
        }
        int start = offset < (size = mediation.size()) && offset >= 0 ? offset : Integer.MAX_VALUE;
        int end = offset + limit - 1 <= size - 1 ? offset + limit - 1 : size - 1;
        for (int i = start; i <= end; ++i) {
            mediationDTOs.add(MediationMappingUtil.fromMediationInfoToDTO(mediation.get(i)));
        }
        mediationListDTO.setCount(mediationDTOs.size());
        return mediationListDTO;
    }

    public static MediationInfoDTO fromMediationInfoToDTO(Mediation mediation) {
        MediationInfoDTO mediationInfoDTO = new MediationInfoDTO();
        mediationInfoDTO.setId(mediation.getUuid());
        mediationInfoDTO.setName(mediation.getName());
        mediationInfoDTO.setType(MediationInfoDTO.TypeEnum.valueOf(mediation.getType().toUpperCase()));
        return mediationInfoDTO;
    }

    public static MediationDTO fromMediationToDTO(Mediation mediation) {
        MediationDTO mediationDTO = new MediationDTO();
        mediationDTO.setId(mediation.getUuid());
        mediationDTO.setName(mediation.getName());
        mediationDTO.setType(MediationDTO.TypeEnum.valueOf(mediation.getType().toUpperCase()));
        return mediationDTO;
    }
}

