/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.json.simple.parser.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.apimgt.api.APIDefinition;
import org.wso2.carbon.apimgt.api.APIDefinitionValidationResponse;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIMgtAuthorizationFailedException;
import org.wso2.carbon.apimgt.api.APIMgtResourceNotFoundException;
import org.wso2.carbon.apimgt.api.APIProvider;
import org.wso2.carbon.apimgt.api.ErrorHandler;
import org.wso2.carbon.apimgt.api.ExceptionCodes;
import org.wso2.carbon.apimgt.api.FaultGatewaysException;
import org.wso2.carbon.apimgt.api.dto.ClientCertificateDTO;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.api.model.APIProductIdentifier;
import org.wso2.carbon.apimgt.api.model.APIRevision;
import org.wso2.carbon.apimgt.api.model.APIRevisionDeployment;
import org.wso2.carbon.apimgt.api.model.APIStatus;
import org.wso2.carbon.apimgt.api.model.ApiTypeWrapper;
import org.wso2.carbon.apimgt.api.model.Documentation;
import org.wso2.carbon.apimgt.api.model.Environment;
import org.wso2.carbon.apimgt.api.model.Identifier;
import org.wso2.carbon.apimgt.api.model.Mediation;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import org.wso2.carbon.apimgt.api.model.VHost;
import org.wso2.carbon.apimgt.api.model.graphql.queryanalysis.GraphqlComplexityInfo;
import org.wso2.carbon.apimgt.impl.APIConstants;
import org.wso2.carbon.apimgt.impl.certificatemgt.ResponseCode;
import org.wso2.carbon.apimgt.impl.definitions.AsyncApiParserUtil;
import org.wso2.carbon.apimgt.impl.definitions.OASParserUtil;
import org.wso2.carbon.apimgt.impl.dto.SoapToRestMediationDto;
import org.wso2.carbon.apimgt.impl.importexport.APIImportExportException;
import org.wso2.carbon.apimgt.impl.importexport.ImportExportConstants;
import org.wso2.carbon.apimgt.impl.importexport.lifecycle.LifeCycle;
import org.wso2.carbon.apimgt.impl.importexport.lifecycle.LifeCycleTransition;
import org.wso2.carbon.apimgt.impl.importexport.utils.CommonUtil;
import org.wso2.carbon.apimgt.impl.utils.APIMWSDLReader;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.impl.utils.VHostUtils;
import org.wso2.carbon.apimgt.impl.wsdl.WSDLProcessor;
import org.wso2.carbon.apimgt.impl.wsdl.model.WSDLValidationResponse;
import org.wso2.carbon.apimgt.rest.api.common.RestApiCommonUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.APIControllerUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.APIMappingUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.GraphqlQueryAnalysisMappingUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.PublisherCommonUtils;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIOperationsDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIProductDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.DocumentDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.GraphQLQueryComplexityInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.GraphQLValidationResponseDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ProductAPIDTO;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.xml.sax.SAXException;

public class ImportUtils {
    public static final String IN = "in";
    public static final String OUT = "out";
    private static final Log log = LogFactory.getLog(ImportUtils.class);
    private static final String SOAPTOREST = "SoapToRest";

    public static API importApi(String extractedFolderPath, APIDTO importedApiDTO, Boolean preserveProvider, Boolean rotateRevision, Boolean overwrite, Boolean dependentAPIFromProduct, String[] tokenScopes, JsonObject dependentAPIParamsConfigObject) throws APIManagementException {
        String userName = RestApiCommonUtil.getLoggedInUsername();
        APIDefinitionValidationResponse validationResponse = null;
        String graphQLSchema = null;
        API importedApi = null;
        GraphqlComplexityInfo graphqlComplexityInfo = null;
        int tenantId = 0;
        JsonArray deploymentInfoArray = null;
        try {
            List<APIRevisionDeployment> apiRevisionDeployments;
            String currentStatus;
            JsonElement deploymentsParam;
            JsonObject paramsConfigObject;
            if (importedApiDTO == null) {
                JsonElement jsonObject = ImportUtils.retrieveValidatedDTOObject(extractedFolderPath, preserveProvider, userName, "api");
                importedApiDTO = (APIDTO)new Gson().fromJson(jsonObject, APIDTO.class);
            }
            JsonObject jsonObject = paramsConfigObject = dependentAPIParamsConfigObject != null ? dependentAPIParamsConfigObject : APIControllerUtil.resolveAPIControllerEnvParams(extractedFolderPath);
            if (paramsConfigObject != null && !ImportUtils.isAdvertiseOnlyAPI(importedApiDTO = APIControllerUtil.injectEnvParamsToAPI(importedApiDTO, paramsConfigObject, extractedFolderPath)) && (deploymentsParam = paramsConfigObject.get("deploymentEnvironments")) != null && !deploymentsParam.isJsonNull()) {
                deploymentInfoArray = deploymentsParam.getAsJsonArray();
            }
            String apiType = importedApiDTO.getType().toString();
            APIProvider apiProvider = RestApiCommonUtil.getProvider((String)importedApiDTO.getProvider());
            if (!PublisherCommonUtils.isStreamingAPI(importedApiDTO) && !APIConstants.APITransportType.GRAPHQL.toString().equalsIgnoreCase(apiType)) {
                validationResponse = ImportUtils.retrieveValidatedSwaggerDefinitionFromArchive(extractedFolderPath);
            }
            if (APIConstants.APITransportType.GRAPHQL.toString().equalsIgnoreCase(apiType)) {
                graphQLSchema = ImportUtils.retrieveValidatedGraphqlSchemaFromArchive(extractedFolderPath);
            }
            if ("SOAP".equalsIgnoreCase(apiType)) {
                ImportUtils.validateWSDLFromArchive(extractedFolderPath, importedApiDTO);
            }
            if (PublisherCommonUtils.isStreamingAPI(importedApiDTO)) {
                validationResponse = ImportUtils.retrieveValidatedAsyncApiDefinitionFromArchive(extractedFolderPath);
            }
            String currentTenantDomain = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack((String)userName));
            String targetStatus = importedApiDTO.getLifeCycleStatus();
            API targetApi = ImportUtils.retrieveApiToOverwrite(importedApiDTO.getName(), importedApiDTO.getVersion(), currentTenantDomain, apiProvider, Boolean.TRUE);
            if (ImportUtils.isAdvertiseOnlyAPI(importedApiDTO)) {
                ImportUtils.processAdvertiseOnlyPropertiesInDTO(importedApiDTO, tokenScopes);
            }
            if (Boolean.TRUE.equals(overwrite) && targetApi != null) {
                log.info((Object)"Existing API found, attempting to update it...");
                currentStatus = targetApi.getStatus();
                importedApiDTO.setLifeCycleStatus(currentStatus);
                if (importedApiDTO.getOperations().isEmpty()) {
                    ImportUtils.setOperationsToDTO(importedApiDTO, validationResponse);
                }
                importedApi = PublisherCommonUtils.updateApi(targetApi, importedApiDTO, RestApiCommonUtil.getLoggedInUserProvider(), tokenScopes);
            } else {
                if (targetApi == null && Boolean.TRUE.equals(overwrite)) {
                    log.info((Object)("Cannot find : " + importedApiDTO.getName() + "-" + importedApiDTO.getVersion() + ". Creating it."));
                }
                currentStatus = APIStatus.CREATED.toString();
                importedApiDTO.setLifeCycleStatus(currentStatus);
                importedApi = PublisherCommonUtils.addAPIWithGeneratedSwaggerDefinition(importedApiDTO, "v3", importedApiDTO.getProvider());
            }
            String lifecycleAction = ImportUtils.getLifeCycleAction(currentTenantDomain, currentStatus, targetStatus, apiProvider);
            if (!PublisherCommonUtils.isStreamingAPI(importedApiDTO) && !APIConstants.APITransportType.GRAPHQL.toString().equalsIgnoreCase(apiType)) {
                PublisherCommonUtils.updateSwagger(importedApi.getUuid(), validationResponse, false);
            }
            if (APIConstants.APITransportType.GRAPHQL.toString().equalsIgnoreCase(apiType)) {
                PublisherCommonUtils.addGraphQLSchema(importedApi, graphQLSchema, apiProvider);
                graphqlComplexityInfo = ImportUtils.retrieveGraphqlComplexityInfoFromArchive(extractedFolderPath, graphQLSchema);
                if (graphqlComplexityInfo != null && graphqlComplexityInfo.getList().size() != 0) {
                    apiProvider.addOrUpdateComplexityDetails(importedApi.getId(), graphqlComplexityInfo);
                }
            }
            if (PublisherCommonUtils.isStreamingAPI(importedApiDTO)) {
                PublisherCommonUtils.updateAsyncAPIDefinition(importedApi.getUuid(), validationResponse);
            }
            tenantId = APIUtil.getTenantId((String)RestApiCommonUtil.getLoggedInUsername());
            ApiTypeWrapper apiTypeWrapperWithUpdatedApi = new ApiTypeWrapper(importedApi);
            ImportUtils.addThumbnailImage(extractedFolderPath, apiTypeWrapperWithUpdatedApi, apiProvider);
            ImportUtils.addDocumentation(extractedFolderPath, apiTypeWrapperWithUpdatedApi, apiProvider);
            ImportUtils.addAPIWsdl(extractedFolderPath, importedApi, apiProvider);
            ImportUtils.addSOAPToREST(importedApi, validationResponse.getContent(), apiProvider);
            if (!ImportUtils.isAdvertiseOnlyAPI(importedApiDTO)) {
                ImportUtils.addAPISequences(extractedFolderPath, importedApi, apiProvider);
                ImportUtils.addAPISpecificSequences(extractedFolderPath, importedApi, apiProvider);
                ImportUtils.addEndpointCertificates(extractedFolderPath, importedApi, apiProvider, tenantId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Mutual SSL enabled. Importing client certificates.");
                }
                ImportUtils.addClientCertificates(extractedFolderPath, apiProvider, preserveProvider, importedApi.getId().getProviderName());
            }
            if (StringUtils.isNotEmpty((CharSequence)lifecycleAction)) {
                apiProvider = RestApiCommonUtil.getLoggedInUserProvider();
                log.info((Object)("Changing lifecycle from " + currentStatus + " to " + targetStatus));
                if (StringUtils.equals((CharSequence)lifecycleAction, (CharSequence)"Publish")) {
                    apiProvider.changeAPILCCheckListItems(importedApi.getId(), 1, true);
                }
                apiProvider.changeLifeCycleStatus(importedApi.getId(), lifecycleAction);
            }
            importedApi.setStatus(targetStatus);
            String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
            if (deploymentInfoArray == null && !ImportUtils.isAdvertiseOnlyAPI(importedApiDTO)) {
                deploymentInfoArray = ImportUtils.retrieveDeploymentLabelsFromArchive(extractedFolderPath, dependentAPIFromProduct);
            }
            if ((apiRevisionDeployments = ImportUtils.getValidatedDeploymentsList(deploymentInfoArray, tenantDomain, apiProvider)).size() > 0) {
                String revisionId;
                String importedAPIUuid = importedApi.getUuid();
                APIRevision apiRevision = new APIRevision();
                apiRevision.setApiUUID(importedAPIUuid);
                apiRevision.setDescription("Revision created after importing the API");
                try {
                    revisionId = apiProvider.addAPIRevision(apiRevision, tenantDomain);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("A new revision has been created for API " + importedApi.getId().getApiName() + "_" + importedApi.getId().getVersion()));
                    }
                }
                catch (APIManagementException e) {
                    if (e.getErrorHandler().getErrorCode() == ExceptionCodes.from((ErrorHandler)ExceptionCodes.MAXIMUM_REVISIONS_REACHED, (String[])new String[0]).getErrorCode() && rotateRevision.booleanValue()) {
                        String earliestRevisionUuid = apiProvider.getEarliestRevisionUUID(importedAPIUuid);
                        List deploymentsList = apiProvider.getAPIRevisionDeploymentList(earliestRevisionUuid);
                        apiProvider.undeployAPIRevisionDeployment(importedAPIUuid, earliestRevisionUuid, deploymentsList);
                        apiProvider.deleteAPIRevision(importedAPIUuid, earliestRevisionUuid, tenantDomain);
                        revisionId = apiProvider.addAPIRevision(apiRevision, tenantDomain);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Revision ID: " + earliestRevisionUuid + " has been undeployed from " + deploymentsList.size() + " gateway environments and created a new revision ID: " + revisionId + " for API " + importedApi.getId().getApiName() + "_" + importedApi.getId().getVersion()));
                        }
                    }
                    throw new APIManagementException("Error occurred while creating a new revision for the API: " + importedApi.getId().getApiName(), (Throwable)e);
                }
                apiProvider.deployAPIRevision(importedAPIUuid, revisionId, apiRevisionDeployments);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("API: " + importedApi.getId().getApiName() + "_" + importedApi.getId().getVersion() + " was deployed in " + apiRevisionDeployments.size() + " gateway environments."));
                }
            } else {
                log.info((Object)"Valid deployment environments were not found for the imported artifact. Only working copy was updated and not deployed in any of the gateway environments.");
            }
            return importedApi;
        }
        catch (IOException | CryptoException e) {
            throw new APIManagementException("Error while reading API meta information from path: " + extractedFolderPath, e, (ErrorHandler)ExceptionCodes.ERROR_READING_META_DATA);
        }
        catch (FaultGatewaysException e) {
            throw new APIManagementException("Error while updating API: " + importedApi.getId().getApiName(), (Throwable)e);
        }
        catch (APIMgtAuthorizationFailedException e) {
            throw new APIManagementException("Please enable preserveProvider property for cross tenant API Import.", (Throwable)e, (ErrorHandler)ExceptionCodes.TENANT_MISMATCH);
        }
        catch (ParseException e) {
            throw new APIManagementException("Error while parsing the endpoint configuration of the API", (ErrorHandler)ExceptionCodes.JSON_PARSE_ERROR);
        }
        catch (APIManagementException e) {
            String errorMessage = "Error while importing API: ";
            if (importedApi != null) {
                errorMessage = errorMessage + importedApi.getId().getApiName() + " " + "version" + ": " + importedApi.getId().getVersion();
            }
            throw new APIManagementException(errorMessage + " " + e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isAdvertiseOnlyAPI(APIDTO importedApiDTO) {
        return importedApiDTO.getAdvertiseInfo() != null && importedApiDTO.getAdvertiseInfo().isAdvertised() != false;
    }

    private static void processAdvertiseOnlyPropertiesInDTO(APIDTO importedApiDTO, String[] tokenScopes) {
        if (!Arrays.asList(tokenScopes).contains("apim:admin")) {
            log.debug((Object)("Since the user does not have the required scope: apim:admin. Original DevPortal URL (redirect URL):" + importedApiDTO.getAdvertiseInfo().getOriginalDevPortalUrl() + " of " + importedApiDTO.getName() + "-" + importedApiDTO.getVersion() + " will be removed."));
            importedApiDTO.getAdvertiseInfo().setOriginalDevPortalUrl(null);
        }
    }

    private static List<APIRevisionDeployment> getValidatedDeploymentsList(JsonArray deploymentInfoArray, String tenantDomain, APIProvider apiProvider) throws APIManagementException {
        ArrayList<APIRevisionDeployment> apiRevisionDeployments = new ArrayList<APIRevisionDeployment>();
        if (deploymentInfoArray != null && deploymentInfoArray.size() > 0) {
            Map gatewayEnvironments = APIUtil.getEnvironments();
            for (int i = 0; i < deploymentInfoArray.size(); ++i) {
                JsonObject deploymentJson = deploymentInfoArray.get(i).getAsJsonObject();
                JsonElement deploymentNameElement = deploymentJson.get("deploymentEnvironment");
                if (deploymentNameElement == null) continue;
                String deploymentName = deploymentNameElement.getAsString();
                Environment gatewayEnvironment = (Environment)gatewayEnvironments.get(deploymentName);
                if (gatewayEnvironment != null) {
                    String deploymentVhost;
                    JsonElement deploymentVhostElement = deploymentJson.get("deploymentVhost");
                    if (deploymentVhostElement != null) {
                        deploymentVhost = deploymentVhostElement.getAsString();
                    } else {
                        if (gatewayEnvironment.getVhosts().isEmpty()) {
                            throw new APIManagementException("No VHosts defined for the environment: " + deploymentName);
                        }
                        deploymentVhost = ((VHost)gatewayEnvironment.getVhosts().get(0)).getHost();
                    }
                    deploymentVhost = VHostUtils.resolveIfDefaultVhostToNull((String)deploymentName, (String)deploymentVhost);
                    JsonElement displayOnDevportalElement = deploymentJson.get("displayOnDevportal");
                    boolean displayOnDevportal = displayOnDevportalElement == null || displayOnDevportalElement.getAsBoolean();
                    APIRevisionDeployment apiRevisionDeployment = new APIRevisionDeployment();
                    apiRevisionDeployment.setDeployment(deploymentName);
                    apiRevisionDeployment.setVhost(deploymentVhost);
                    apiRevisionDeployment.setDisplayOnDevportal(displayOnDevportal);
                    apiRevisionDeployments.add(apiRevisionDeployment);
                    continue;
                }
                throw new APIManagementException("Label " + deploymentName + " is not a defined gateway environment. Hence skipped without deployment", ExceptionCodes.from((ErrorHandler)ExceptionCodes.GATEWAY_ENVIRONMENT_NOT_FOUND, (String[])new String[]{String.format("label '%s'", deploymentName)}));
            }
        }
        return apiRevisionDeployments;
    }

    private static void setOperationsToDTO(APIDTO apiDto, APIDefinitionValidationResponse response) throws APIManagementException {
        ArrayList<URITemplate> uriTemplates = new ArrayList<URITemplate>();
        uriTemplates.addAll(response.getParser().getURITemplates(response.getJsonContent()));
        List<APIOperationsDTO> apiOperationsDtos = APIMappingUtil.fromURITemplateListToOprationList(uriTemplates);
        apiDto.setOperations(apiOperationsDtos);
    }

    private static API retrieveApiToOverwrite(String apiName, String apiVersion, String currentTenantDomain, APIProvider apiProvider, Boolean ignoreAndImport) throws APIManagementException {
        String provider = APIUtil.getAPIProviderFromAPINameVersionTenant((String)apiName, (String)apiVersion, (String)currentTenantDomain);
        APIIdentifier apiIdentifier = new APIIdentifier(APIUtil.replaceEmailDomain((String)provider), apiName, apiVersion);
        if (!apiProvider.isAPIAvailable(apiIdentifier)) {
            if (ignoreAndImport.booleanValue()) {
                return null;
            }
            throw new APIMgtResourceNotFoundException("Error occurred while retrieving the API. API: " + apiName + " " + "version" + ": " + apiVersion + " not found", ExceptionCodes.from((ErrorHandler)ExceptionCodes.API_NOT_FOUND, (String[])new String[]{apiIdentifier.getApiName() + "-" + apiIdentifier.getVersion()}));
        }
        return apiProvider.getAPI(apiIdentifier);
    }

    public static String preprocessImportedArtifact(String tempDirectory) throws APIImportExportException {
        String tempDirectoryAbsolutePath = tempDirectory + File.separator;
        String paramsFileName = ImportExportConstants.INTERMEDIATE_PARAMS_FILE_LOCATION + ".yaml";
        boolean isParamsFileAvailable = CommonUtil.checkFileExistence((String)(tempDirectoryAbsolutePath + paramsFileName));
        boolean isDeploymentDirectoryAvailable = CommonUtil.checkFileExistence((String)(tempDirectoryAbsolutePath + "Deployment"));
        if (isParamsFileAvailable) {
            if (!CommonUtil.checkFileExistence((String)(tempDirectoryAbsolutePath + "SourceArchive.zip"))) {
                throw new APIImportExportException("The source artifact is not provided properly");
            }
            String newExtractedFolderName = CommonUtil.extractArchive((File)new File(tempDirectoryAbsolutePath + "SourceArchive.zip"), (String)tempDirectoryAbsolutePath);
            String srcParamsFilePath = tempDirectoryAbsolutePath + paramsFileName;
            String destParamsFilePath = tempDirectoryAbsolutePath + newExtractedFolderName + File.separator + paramsFileName;
            CommonUtil.copyFile((String)srcParamsFilePath, (String)destParamsFilePath);
            return tempDirectoryAbsolutePath + newExtractedFolderName;
        }
        if (isDeploymentDirectoryAvailable) {
            if (!CommonUtil.checkFileExistence((String)(tempDirectoryAbsolutePath + "SourceArchive.zip"))) {
                throw new APIImportExportException("The source artifact is not provided properly");
            }
            String newExtractedFolderName = CommonUtil.extractArchive((File)new File(tempDirectoryAbsolutePath + "SourceArchive.zip"), (String)tempDirectoryAbsolutePath);
            String srcParamsFilePath = tempDirectoryAbsolutePath + "Deployment" + File.separator + paramsFileName;
            String destParamsFilePath = tempDirectoryAbsolutePath + newExtractedFolderName + File.separator + paramsFileName;
            CommonUtil.copyFile((String)srcParamsFilePath, (String)destParamsFilePath);
            String srcDeploymentDirectoryPath = tempDirectoryAbsolutePath + "Deployment";
            String destDeploymentDirectoryPath = tempDirectoryAbsolutePath + newExtractedFolderName + File.separator + "Deployment";
            CommonUtil.copyDirectory((String)srcDeploymentDirectoryPath, (String)destDeploymentDirectoryPath);
            return tempDirectoryAbsolutePath + newExtractedFolderName;
        }
        return tempDirectory;
    }

    public static String getArchivePathOfExtractedDirectory(String baseDirectory, InputStream uploadedInputStream) throws APIImportExportException {
        String uploadFileName = "APIArchive.zip";
        String absolutePath = baseDirectory + File.separator;
        CommonUtil.transferFile((InputStream)uploadedInputStream, (String)uploadFileName, (String)absolutePath);
        String extractedFolderName = CommonUtil.extractArchive((File)new File(absolutePath + uploadFileName), (String)absolutePath);
        return ImportUtils.preprocessImportedArtifact(absolutePath + extractedFolderName);
    }

    public static String getArchivePathOfExtractedDirectory(InputStream uploadedInputStream) throws APIImportExportException {
        File importFolder = CommonUtil.createTempDirectory(null);
        String uploadFileName = "APIArchive.zip";
        String absolutePath = importFolder.getAbsolutePath() + File.separator;
        CommonUtil.transferFile((InputStream)uploadedInputStream, (String)uploadFileName, (String)absolutePath);
        String extractedFolderName = CommonUtil.extractArchive((File)new File(absolutePath + uploadFileName), (String)absolutePath);
        return ImportUtils.preprocessImportedArtifact(absolutePath + extractedFolderName);
    }

    private static JsonElement retrieveValidatedDTOObject(String pathToArchive, Boolean isDefaultProviderAllowed, String currentUser, String type) throws IOException, APIManagementException {
        JsonObject configObject = StringUtils.equals((CharSequence)type, (CharSequence)"api") ? ImportUtils.retrievedAPIDtoJson(pathToArchive) : ImportUtils.retrievedAPIProductDtoJson(pathToArchive);
        configObject = ImportUtils.validatePreserveProvider(configObject, isDefaultProviderAllowed, currentUser);
        return configObject;
    }

    @NotNull
    private static JsonObject retrievedAPIDtoJson(String pathToArchive) throws IOException, APIManagementException {
        String jsonContent = ImportUtils.getFileContentAsJson(pathToArchive + ImportExportConstants.API_FILE_LOCATION);
        if (jsonContent == null) {
            throw new APIManagementException("Cannot find API definition. api.yaml or api.json should present", (ErrorHandler)ExceptionCodes.ERROR_FETCHING_DEFINITION_FILE);
        }
        return ImportUtils.processRetrievedDefinition(jsonContent);
    }

    @NotNull
    private static JsonObject retrievedAPIProductDtoJson(String pathToArchive) throws IOException, APIManagementException {
        String jsonContent = ImportUtils.getFileContentAsJson(pathToArchive + ImportExportConstants.API_PRODUCT_FILE_LOCATION);
        if (jsonContent == null) {
            throw new APIManagementException("Cannot find API Product definition. api_product.yaml or api_product.json should present", (ErrorHandler)ExceptionCodes.ERROR_FETCHING_DEFINITION_FILE);
        }
        return ImportUtils.processRetrievedDefinition(jsonContent);
    }

    private static JsonObject processRetrievedDefinition(String jsonContent) throws IOException {
        JsonElement configElement = new JsonParser().parse(jsonContent).getAsJsonObject().get("data");
        JsonObject configObject = configElement.getAsJsonObject();
        configObject = ImportUtils.preProcessEndpointConfig(configObject);
        String apiName = configObject.get("name").getAsString();
        String apiVersion = configObject.has("version") ? configObject.get("version").getAsString() : "1.0.0";
        if (apiName != null && apiVersion != null) {
            configObject.remove(apiName);
            configObject.addProperty("name", apiName.replace(" ", ""));
            if (configObject.has("version")) {
                configObject.remove("version");
                configObject.addProperty("version", apiVersion.replace(" ", ""));
            }
        } else {
            throw new IOException("API/API Product name and version must be provided in API/API Product definition");
        }
        return configObject;
    }

    public static APIDTO retrievedAPIDto(String pathToArchive) throws IOException, APIManagementException {
        JsonObject jsonObject = ImportUtils.retrievedAPIDtoJson(pathToArchive);
        return (APIDTO)new Gson().fromJson((JsonElement)jsonObject, APIDTO.class);
    }

    public static APIProductDTO retrieveAPIProductDto(String pathToArchive) throws IOException, APIManagementException {
        JsonObject jsonObject = ImportUtils.retrievedAPIProductDtoJson(pathToArchive);
        return (APIProductDTO)new Gson().fromJson((JsonElement)jsonObject, APIProductDTO.class);
    }

    private static JsonObject preProcessEndpointConfig(JsonObject configObject) {
        JsonObject endpointConfig;
        if (configObject.has("endpointConfig") && (endpointConfig = configObject.get("endpointConfig").getAsJsonObject()).has("endpoint_security")) {
            String customParameters;
            JsonObject endpointSecuritySandbox;
            JsonObject endpointSecurity = endpointConfig.get("endpoint_security").getAsJsonObject();
            if (endpointSecurity.has("sandbox") && (endpointSecuritySandbox = endpointSecurity.get("sandbox").getAsJsonObject()).has("customParameters")) {
                customParameters = endpointSecuritySandbox.get("customParameters").toString();
                endpointSecuritySandbox.remove("customParameters");
                endpointSecuritySandbox.addProperty("customParameters", customParameters);
            }
            if (endpointSecurity.has("production") && (endpointSecuritySandbox = endpointSecurity.get("production").getAsJsonObject()).has("customParameters")) {
                customParameters = endpointSecuritySandbox.get("customParameters").toString();
                endpointSecuritySandbox.remove("customParameters");
                endpointSecuritySandbox.addProperty("customParameters", customParameters);
            }
        }
        return configObject;
    }

    private static JsonObject validatePreserveProvider(JsonObject configObject, Boolean isDefaultProviderAllowed, String currentUser) throws APIMgtAuthorizationFailedException {
        String prevProvider = configObject.get("provider").getAsString();
        String prevTenantDomain = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack((String)prevProvider));
        String currentTenantDomain = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack((String)currentUser));
        if (isDefaultProviderAllowed.booleanValue()) {
            if (!StringUtils.equals((CharSequence)prevTenantDomain, (CharSequence)currentTenantDomain)) {
                throw new APIMgtAuthorizationFailedException("Tenant mismatch! Please enable preserveProvider property for cross tenant API Import.");
            }
        } else {
            String prevProviderWithDomain = APIUtil.replaceEmailDomain((String)prevProvider);
            String currentUserWithDomain = APIUtil.replaceEmailDomain((String)currentUser);
            configObject.remove("provider");
            configObject.addProperty("provider", currentUser);
            if (configObject.get("wsdlUrl") != null) {
                configObject.addProperty("wsdlUrl", configObject.get("wsdlUrl").getAsString().replace(prevProviderWithDomain, currentUserWithDomain));
            }
            configObject = ImportUtils.setCurrentProviderToContext(configObject, currentTenantDomain, prevTenantDomain);
        }
        return configObject;
    }

    public static JsonObject setCurrentProviderToContext(JsonObject jsonObject, String currentDomain, String previousDomain) {
        String context = jsonObject.get("context").getAsString();
        if ("carbon.super".equalsIgnoreCase(currentDomain) && !"carbon.super".equalsIgnoreCase(previousDomain)) {
            jsonObject.remove("context");
            jsonObject.addProperty("context", context.replace("/t/" + previousDomain, ""));
        } else if (!"carbon.super".equalsIgnoreCase(currentDomain) && "carbon.super".equalsIgnoreCase(previousDomain)) {
            jsonObject.remove("context");
            jsonObject.addProperty("context", "/t/" + currentDomain + context);
        } else if (!StringUtils.equalsIgnoreCase((CharSequence)currentDomain, (CharSequence)previousDomain)) {
            jsonObject.remove("context");
            jsonObject.addProperty("context", context.replace(previousDomain, currentDomain));
        }
        return jsonObject;
    }

    public static String getFileContentAsJson(String pathToArchive) throws IOException {
        String jsonContent = null;
        String pathToYamlFile = pathToArchive + ".yaml";
        String pathToJsonFile = pathToArchive + ".json";
        if (CommonUtil.checkFileExistence((String)pathToYamlFile)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found api definition file " + pathToYamlFile));
            }
            String yamlContent = FileUtils.readFileToString((File)new File(pathToYamlFile));
            jsonContent = CommonUtil.yamlToJson((String)yamlContent);
        } else if (CommonUtil.checkFileExistence((String)pathToJsonFile)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found api definition file " + pathToJsonFile));
            }
            jsonContent = FileUtils.readFileToString((File)new File(pathToJsonFile));
        }
        return jsonContent;
    }

    public static APIDefinitionValidationResponse retrieveValidatedAsyncApiDefinitionFromArchive(String pathToArchive) throws APIManagementException {
        try {
            String asyncApiDefinition = ImportUtils.loadAsyncApiDefinitionFromFile(pathToArchive);
            APIDefinitionValidationResponse validationResponse = AsyncApiParserUtil.validateAsyncAPISpecification((String)asyncApiDefinition, (boolean)true);
            if (!validationResponse.isValid()) {
                throw new APIManagementException("Error occurred while importing the API. Invalid AsyncAPI definition found. " + validationResponse.getErrorItems());
            }
            return validationResponse;
        }
        catch (IOException e) {
            throw new APIManagementException("Error while reading API meta information from path: " + pathToArchive, (Throwable)e, (ErrorHandler)ExceptionCodes.ERROR_READING_META_DATA);
        }
    }

    private static String loadAsyncApiDefinitionFromFile(String pathToArchive) throws IOException {
        if (CommonUtil.checkFileExistence((String)(pathToArchive + ImportExportConstants.JSON_ASYNCAPI_DEFINITION_LOCATION))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found AsyncAPI file " + pathToArchive + ImportExportConstants.JSON_ASYNCAPI_DEFINITION_LOCATION));
            }
            return FileUtils.readFileToString((File)new File(pathToArchive, ImportExportConstants.JSON_ASYNCAPI_DEFINITION_LOCATION));
        }
        if (CommonUtil.checkFileExistence((String)(pathToArchive + ImportExportConstants.YAML_ASYNCAPI_DEFINITION_LOCATION))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found AsyncAPI file " + pathToArchive + ImportExportConstants.YAML_ASYNCAPI_DEFINITION_LOCATION));
            }
            return CommonUtil.yamlToJson((String)FileUtils.readFileToString((File)new File(pathToArchive + ImportExportConstants.YAML_ASYNCAPI_DEFINITION_LOCATION)));
        }
        throw new IOException("Missing AsyncAPI definition file.");
    }

    public static String retrieveValidatedGraphqlSchemaFromArchive(String pathToArchive) throws APIManagementException {
        File file = new File(pathToArchive + ImportExportConstants.GRAPHQL_SCHEMA_DEFINITION_LOCATION);
        try {
            String schemaDefinition = ImportUtils.loadGraphqlSDLFile(pathToArchive);
            GraphQLValidationResponseDTO graphQLValidationResponseDTO = PublisherCommonUtils.validateGraphQLSchema(file.getName(), schemaDefinition);
            if (!graphQLValidationResponseDTO.isIsValid().booleanValue()) {
                throw new APIManagementException("Error occurred while importing the API. Invalid GraphQL schema definition found. " + graphQLValidationResponseDTO.getErrorMessage());
            }
            return schemaDefinition;
        }
        catch (IOException e) {
            throw new APIManagementException("Error while reading API meta information from path: " + pathToArchive, (Throwable)e, (ErrorHandler)ExceptionCodes.ERROR_READING_META_DATA);
        }
    }

    private static GraphqlComplexityInfo retrieveGraphqlComplexityInfoFromArchive(String pathToArchive, String schema) throws APIManagementException {
        try {
            String jsonContent = ImportUtils.getFileContentAsJson(pathToArchive + ImportExportConstants.GRAPHQL_COMPLEXITY_INFO_LOCATION);
            if (jsonContent == null) {
                return null;
            }
            JsonElement configElement = new JsonParser().parse(jsonContent).getAsJsonObject().get("data");
            GraphQLQueryComplexityInfoDTO complexityDTO = (GraphQLQueryComplexityInfoDTO)new Gson().fromJson(String.valueOf(configElement), GraphQLQueryComplexityInfoDTO.class);
            GraphqlComplexityInfo graphqlComplexityInfo = GraphqlQueryAnalysisMappingUtil.fromDTOtoValidatedGraphqlComplexityInfo(complexityDTO, schema);
            return graphqlComplexityInfo;
        }
        catch (IOException e) {
            throw new APIManagementException("Error while reading graphql complexity info from path: " + pathToArchive, (Throwable)e, (ErrorHandler)ExceptionCodes.ERROR_READING_META_DATA);
        }
    }

    private static JsonArray retrieveDeploymentLabelsFromArchive(String pathToArchive, boolean dependentAPIFromProduct) throws APIManagementException {
        try {
            String jsonContent;
            String string = jsonContent = dependentAPIFromProduct ? ImportUtils.getFileContentAsJson(new File(pathToArchive).getParentFile().getParent() + File.separator + ImportExportConstants.DEPLOYMENT_INFO_LOCATION) : ImportUtils.getFileContentAsJson(pathToArchive + ImportExportConstants.DEPLOYMENT_INFO_LOCATION);
            if (jsonContent == null) {
                return null;
            }
            JsonElement configElement = new JsonParser().parse(jsonContent).getAsJsonObject().get("data");
            return configElement.getAsJsonArray();
        }
        catch (IOException e) {
            throw new APIManagementException("Error while reading deployment environments info from path: " + pathToArchive, (Throwable)e, (ErrorHandler)ExceptionCodes.ERROR_READING_META_DATA);
        }
    }

    private static void validateWSDLFromArchive(String pathToArchive, APIDTO apiDto) throws APIManagementException {
        try {
            byte[] wsdlDefinition = ImportUtils.loadWsdlFile(pathToArchive, apiDto);
            WSDLValidationResponse wsdlValidationResponse = APIMWSDLReader.getWsdlValidationResponse((WSDLProcessor)APIMWSDLReader.getWSDLProcessor((byte[])wsdlDefinition));
            if (!wsdlValidationResponse.isValid()) {
                throw new APIManagementException("Error occurred while importing the API. Invalid WSDL definition found. " + wsdlValidationResponse.getError());
            }
        }
        catch (IOException | APIManagementException e) {
            throw new APIManagementException("Error while reading API meta information from path: " + pathToArchive, e, (ErrorHandler)ExceptionCodes.ERROR_READING_META_DATA);
        }
    }

    private static String loadGraphqlSDLFile(String pathToArchive) throws IOException {
        if (CommonUtil.checkFileExistence((String)(pathToArchive + ImportExportConstants.GRAPHQL_SCHEMA_DEFINITION_LOCATION))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found graphQL sdl file " + pathToArchive + ImportExportConstants.GRAPHQL_SCHEMA_DEFINITION_LOCATION));
            }
            return FileUtils.readFileToString((File)new File(pathToArchive, ImportExportConstants.GRAPHQL_SCHEMA_DEFINITION_LOCATION));
        }
        throw new IOException("Missing graphQL schema definition file. schema.graphql should be present.");
    }

    private static String loadGraphqlComplexityInfoFile(String pathToArchive) throws IOException {
        if (CommonUtil.checkFileExistence((String)(pathToArchive + ImportExportConstants.GRAPHQL_COMPLEXITY_INFO_LOCATION))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found graphQL complexity info file " + pathToArchive + ImportExportConstants.GRAPHQL_COMPLEXITY_INFO_LOCATION));
            }
            return FileUtils.readFileToString((File)new File(pathToArchive, ImportExportConstants.GRAPHQL_COMPLEXITY_INFO_LOCATION));
        }
        return null;
    }

    private static byte[] loadWsdlFile(String pathToArchive, APIDTO apiDto) throws IOException {
        String wsdlFileName = apiDto.getName() + "-" + apiDto.getVersion() + ".wsdl";
        String pathToFile = pathToArchive + ImportExportConstants.WSDL_LOCATION + wsdlFileName;
        if (CommonUtil.checkFileExistence((String)pathToFile)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found WSDL file " + pathToFile));
            }
            return FileUtils.readFileToByteArray((File)new File(pathToFile));
        }
        throw new IOException("Missing WSDL file. It should be present.");
    }

    public static APIDefinitionValidationResponse retrieveValidatedSwaggerDefinitionFromArchive(String pathToArchive) throws APIManagementException {
        try {
            String swaggerContent = ImportUtils.loadSwaggerFile(pathToArchive);
            APIDefinitionValidationResponse validationResponse = OASParserUtil.validateAPIDefinition((String)swaggerContent, (boolean)Boolean.TRUE);
            if (!validationResponse.isValid()) {
                throw new APIManagementException("Error occurred while importing the API. Invalid Swagger definition found. " + validationResponse.getErrorItems(), (ErrorHandler)ExceptionCodes.ERROR_READING_META_DATA);
            }
            return validationResponse;
        }
        catch (IOException e) {
            throw new APIManagementException("Error while reading API meta information from path: " + pathToArchive, (Throwable)e, (ErrorHandler)ExceptionCodes.ERROR_READING_META_DATA);
        }
    }

    public static String loadSwaggerFile(String pathToArchive) throws IOException {
        if (CommonUtil.checkFileExistence((String)(pathToArchive + ImportExportConstants.YAML_SWAGGER_DEFINITION_LOCATION))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found swagger file " + pathToArchive + ImportExportConstants.YAML_SWAGGER_DEFINITION_LOCATION));
            }
            String yamlContent = FileUtils.readFileToString((File)new File(pathToArchive + ImportExportConstants.YAML_SWAGGER_DEFINITION_LOCATION));
            return CommonUtil.yamlToJson((String)yamlContent);
        }
        if (CommonUtil.checkFileExistence((String)(pathToArchive + ImportExportConstants.JSON_SWAGGER_DEFINITION_LOCATION))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found swagger file " + pathToArchive + ImportExportConstants.JSON_SWAGGER_DEFINITION_LOCATION));
            }
            return FileUtils.readFileToString((File)new File(pathToArchive + ImportExportConstants.JSON_SWAGGER_DEFINITION_LOCATION));
        }
        throw new IOException("Missing swagger file. Either swagger.json or swagger.yaml should present");
    }

    private static void addThumbnailImage(String pathToArchive, ApiTypeWrapper apiTypeWrapper, APIProvider apiProvider) throws APIManagementException {
        File imageFolder = new File(pathToArchive + ImportExportConstants.IMAGE_FILE_LOCATION);
        File[] fileArray = imageFolder.listFiles();
        if (imageFolder.isDirectory() && fileArray != null) {
            for (File imageFile : fileArray) {
                if (imageFile == null) continue;
                ImportUtils.updateWithThumbnail(imageFile, apiTypeWrapper, apiProvider);
                break;
            }
        }
    }

    private static void updateWithThumbnail(File imageFile, ApiTypeWrapper apiTypeWrapper, APIProvider apiProvider) throws APIManagementException {
        Identifier identifier = apiTypeWrapper.getId();
        String fileName = imageFile.getName();
        String mimeType = URLConnection.guessContentTypeFromName(fileName);
        String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        if (StringUtils.isBlank((CharSequence)mimeType)) {
            try {
                new JsonParser().parse((Reader)new FileReader(imageFile));
                mimeType = "application/json";
            }
            catch (JsonParseException e) {
                log.error((Object)"Failed to read the thumbnail file. ", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                log.error((Object)"Failed to find the thumbnail file. ", (Throwable)e);
            }
        }
        try (FileInputStream inputStream = new FileInputStream(imageFile.getAbsolutePath());){
            String apiOrApiProductId = !apiTypeWrapper.isAPIProduct() ? apiTypeWrapper.getApi().getUuid() : apiTypeWrapper.getApiProduct().getUuid();
            PublisherCommonUtils.updateThumbnail(inputStream, mimeType, apiProvider, apiOrApiProductId, tenantDomain);
        }
        catch (FileNotFoundException e) {
            throw new APIManagementException("Icon for API/API Product: " + identifier.getName() + " is not found.", (Throwable)e, ExceptionCodes.from((ErrorHandler)ExceptionCodes.ERROR_UPLOADING_THUMBNAIL, (String[])new String[]{identifier.getName(), identifier.getVersion()}));
        }
        catch (IOException e) {
            throw new APIManagementException("Failed to read the image file of API/API Product: " + identifier.getName() + " from the archive.", (Throwable)e, ExceptionCodes.from((ErrorHandler)ExceptionCodes.ERROR_UPLOADING_THUMBNAIL, (String[])new String[]{identifier.getName(), identifier.getVersion()}));
        }
    }

    private static void addDocumentation(String pathToArchive, ApiTypeWrapper apiTypeWrapper, APIProvider apiProvider) {
        block38: {
            String jsonContent = null;
            Identifier identifier = apiTypeWrapper.getId();
            String docDirectoryPath = pathToArchive + File.separator + "Docs";
            File documentsFolder = new File(docDirectoryPath);
            File[] fileArray = documentsFolder.listFiles();
            String provider = apiTypeWrapper.isAPIProduct() ? apiTypeWrapper.getApiProduct().getId().getProviderName() : apiTypeWrapper.getApi().getId().getProviderName();
            String tenantDomain = MultitenantUtils.getTenantDomain((String)provider);
            try {
                List documents = apiProvider.getAllDocumentation(identifier);
                if (documents != null) {
                    for (Documentation documentation : documents) {
                        apiProvider.removeDocumentation(identifier, documentation.getId(), tenantDomain);
                    }
                }
                if (!documentsFolder.isDirectory() || fileArray == null) break block38;
                for (File documentFile : fileArray) {
                    String apiOrApiProductId;
                    String folderName = documentFile.getName();
                    String individualDocumentFilePath = docDirectoryPath + File.separator + folderName;
                    String pathToYamlFile = individualDocumentFilePath + ImportExportConstants.DOCUMENT_FILE_NAME + ".yaml";
                    String pathToJsonFile = individualDocumentFilePath + ImportExportConstants.DOCUMENT_FILE_NAME + ".json";
                    if (CommonUtil.checkFileExistence((String)pathToYamlFile)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Found documents definition file " + pathToYamlFile));
                        }
                        String yamlContent = FileUtils.readFileToString((File)new File(pathToYamlFile));
                        jsonContent = CommonUtil.yamlToJson((String)yamlContent);
                    } else if (CommonUtil.checkFileExistence((String)pathToJsonFile)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Found documents definition file " + pathToJsonFile));
                        }
                        jsonContent = FileUtils.readFileToString((File)new File(pathToJsonFile));
                    }
                    JsonElement configElement = new JsonParser().parse(jsonContent).getAsJsonObject().get("data");
                    DocumentDTO documentDTO = (DocumentDTO)new Gson().fromJson((JsonElement)configElement.getAsJsonObject(), DocumentDTO.class);
                    Documentation documentation = apiTypeWrapper.isAPIProduct() ? PublisherCommonUtils.addDocumentationToAPI(documentDTO, apiTypeWrapper.getApiProduct().getUuid()) : PublisherCommonUtils.addDocumentationToAPI(documentDTO, apiTypeWrapper.getApi().getUuid());
                    String docSourceType = documentation.getSourceType().toString();
                    boolean docContentExists = Documentation.DocumentSourceType.INLINE.toString().equalsIgnoreCase(docSourceType) || Documentation.DocumentSourceType.MARKDOWN.toString().equalsIgnoreCase(docSourceType);
                    String string = apiOrApiProductId = !apiTypeWrapper.isAPIProduct() ? apiTypeWrapper.getApi().getUuid() : apiTypeWrapper.getApiProduct().getUuid();
                    if (docContentExists) {
                        try (FileInputStream inputStream = new FileInputStream(individualDocumentFilePath + File.separator + folderName);){
                            String inlineContent = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
                            PublisherCommonUtils.addDocumentationContent(documentation, apiProvider, apiOrApiProductId, documentation.getId(), tenantDomain, inlineContent);
                            continue;
                        }
                    }
                    if (!"FILE".equalsIgnoreCase(docSourceType)) continue;
                    String filePath = documentation.getFilePath();
                    try (FileInputStream inputStream = new FileInputStream(individualDocumentFilePath + File.separator + filePath);){
                        String docExtension = FilenameUtils.getExtension((String)(pathToArchive + File.separator + "Docs" + File.separator + filePath));
                        PublisherCommonUtils.addDocumentationContentForFile(inputStream, docExtension, documentation.getFilePath(), apiProvider, apiOrApiProductId, documentation.getId(), tenantDomain);
                    }
                    catch (FileNotFoundException e) {
                        log.error((Object)("Failed to locate the document files of the API/API Product: " + apiTypeWrapper.getId().getName()), (Throwable)e);
                    }
                }
            }
            catch (FileNotFoundException e) {
                log.error((Object)("Failed to locate the document files of the API/API Product: " + identifier.getName()), (Throwable)e);
            }
            catch (IOException | APIManagementException e) {
                log.error((Object)("Failed to add Documentations to API/API Product: " + identifier.getName()), e);
            }
        }
    }

    private static void addAPISequences(String pathToArchive, API importedApi, APIProvider apiProvider) throws APIManagementException {
        String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        List existingMediationsList = apiProvider.getAllGlobalMediationPolicies();
        try {
            String sequenceContent = ImportUtils.retrieveSequenceContent(pathToArchive, false, IN, importedApi.getInSequence());
            PublisherCommonUtils.addMediationPolicyFromFile(sequenceContent, IN, apiProvider, importedApi.getUuid(), tenantDomain, existingMediationsList, Boolean.FALSE);
            sequenceContent = ImportUtils.retrieveSequenceContent(pathToArchive, false, OUT, importedApi.getOutSequence());
            PublisherCommonUtils.addMediationPolicyFromFile(sequenceContent, OUT, apiProvider, importedApi.getUuid(), tenantDomain, existingMediationsList, Boolean.FALSE);
            sequenceContent = ImportUtils.retrieveSequenceContent(pathToArchive, false, "fault", importedApi.getFaultSequence());
            PublisherCommonUtils.addMediationPolicyFromFile(sequenceContent, "fault", apiProvider, importedApi.getUuid(), tenantDomain, existingMediationsList, Boolean.FALSE);
        }
        catch (Exception e) {
            throw new APIManagementException("An Error has occurred while adding mediation policy " + e.getMessage(), (Throwable)e);
        }
    }

    public static String retrieveSequenceContent(String pathToArchive, boolean specific, String type, String sequenceName) {
        String sequenceFileName = sequenceName + ".xml";
        String sequenceFileLocation = null;
        if (IN.equals(type)) {
            sequenceFileLocation = pathToArchive + ImportExportConstants.IN_SEQUENCE_LOCATION;
        } else if (OUT.equals(type)) {
            sequenceFileLocation = pathToArchive + ImportExportConstants.OUT_SEQUENCE_LOCATION;
        } else if ("fault".equals(type)) {
            sequenceFileLocation = pathToArchive + ImportExportConstants.FAULT_SEQUENCE_LOCATION;
        }
        if (sequenceFileLocation != null) {
            if (specific) {
                sequenceFileLocation = sequenceFileLocation.endsWith(File.separator) ? sequenceFileLocation + "Custom" : sequenceFileLocation + File.separator + "Custom";
            }
            sequenceFileLocation = sequenceFileLocation + File.separator + sequenceFileName;
            try {
                return ImportUtils.retrieveSequenceContentFromLocation(sequenceFileLocation);
            }
            catch (IOException e) {
                log.error((Object)("Failed to add sequences into the registry : " + sequenceFileLocation), (Throwable)e);
            }
        }
        return null;
    }

    private static String retrieveSequenceContentFromLocation(String sequenceFileLocation) throws IOException {
        if (CommonUtil.checkFileExistence((String)sequenceFileLocation)) {
            File sequenceFile = new File(sequenceFileLocation);
            try (FileInputStream seqStream = new FileInputStream(sequenceFile);){
                String string = IOUtils.toString((InputStream)seqStream);
                return string;
            }
        }
        return null;
    }

    private static void addAPISpecificSequences(String pathToArchive, API importedApi, APIProvider apiProvider) throws APIManagementException {
        String sequencesDirectoryPath = pathToArchive + File.separator + "Sequences";
        String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        List existingAPISpecificMediationsList = apiProvider.getAllApiSpecificMediationPolicies(importedApi.getUuid(), tenantDomain);
        ImportUtils.addCustomSequencesToRegistry(sequencesDirectoryPath, IN, importedApi, apiProvider, tenantDomain, existingAPISpecificMediationsList);
        ImportUtils.addCustomSequencesToRegistry(sequencesDirectoryPath, OUT, importedApi, apiProvider, tenantDomain, existingAPISpecificMediationsList);
        ImportUtils.addCustomSequencesToRegistry(sequencesDirectoryPath, "fault", importedApi, apiProvider, tenantDomain, existingAPISpecificMediationsList);
    }

    private static void addCustomSequencesToRegistry(String sequencesDirectoryPath, String type, API importedApi, APIProvider apiProvider, String tenantDomain, List<Mediation> existingAPISpecificMediationsList) throws APIManagementException {
        File apiSpecificSequencesDirectory;
        File[] apiSpecificSequencesDirectoryListing;
        String apiSpecificSequenceFilePath = sequencesDirectoryPath + File.separator + type + "-sequence" + File.separator + "Custom";
        if (CommonUtil.checkFileExistence((String)apiSpecificSequenceFilePath) && (apiSpecificSequencesDirectoryListing = (apiSpecificSequencesDirectory = new File(apiSpecificSequenceFilePath)).listFiles()) != null) {
            for (File apiSpecificSequence : apiSpecificSequencesDirectoryListing) {
                String individualSequenceLocation = apiSpecificSequenceFilePath + File.separator + apiSpecificSequence.getName();
                try {
                    String sequenceContent = ImportUtils.retrieveSequenceContentFromLocation(individualSequenceLocation);
                    PublisherCommonUtils.addMediationPolicyFromFile(sequenceContent, type, apiProvider, importedApi.getUuid(), tenantDomain, existingAPISpecificMediationsList, Boolean.TRUE);
                }
                catch (IOException e) {
                    log.error((Object)("I/O error while writing sequence data to the registry : " + individualSequenceLocation), (Throwable)e);
                }
                catch (Exception e) {
                    throw new APIManagementException("An Error has occurred while adding mediation policy " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static void addAPIWsdl(String pathToArchive, API importedApi, APIProvider apiProvider) throws APIManagementException {
        String wsdlFileName = importedApi.getId().getApiName() + "-" + importedApi.getId().getVersion() + ".wsdl";
        String wsdlPath = pathToArchive + ImportExportConstants.WSDL_LOCATION + wsdlFileName;
        if (CommonUtil.checkFileExistence((String)wsdlPath)) {
            try (FileInputStream inputStream = new FileInputStream(wsdlPath);){
                String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
                String fileExtension = FilenameUtils.getExtension((String)wsdlPath);
                PublisherCommonUtils.addWsdl(fileExtension, inputStream, importedApi, apiProvider, tenantDomain);
            }
            catch (FileNotFoundException e) {
                throw new APIManagementException("WSDL file of the API: " + importedApi.getId().getName() + " is not found.", (Throwable)e, (ErrorHandler)ExceptionCodes.NO_WSDL_FOUND_IN_WSDL_ARCHIVE);
            }
            catch (IOException e) {
                throw new APIManagementException("Error reading the WSDL file of the API: " + importedApi.getId().getName(), (Throwable)e, (ErrorHandler)ExceptionCodes.CANNOT_PROCESS_WSDL_CONTENT);
            }
        }
    }

    private static void addEndpointCertificates(String pathToArchive, API importedApi, APIProvider apiProvider, int tenantId) throws APIManagementException {
        String jsonContent = null;
        String pathToEndpointsCertificatesDirectory = pathToArchive + File.separator + "Endpoint-certificates";
        String pathToYamlFile = pathToEndpointsCertificatesDirectory + ImportExportConstants.ENDPOINTS_CERTIFICATE_FILE + ".yaml";
        String pathToJsonFile = pathToEndpointsCertificatesDirectory + ImportExportConstants.ENDPOINTS_CERTIFICATE_FILE + ".json";
        try {
            if (CommonUtil.checkFileExistence((String)pathToYamlFile)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found certificate file " + pathToYamlFile));
                }
                String yamlContent = FileUtils.readFileToString((File)new File(pathToYamlFile));
                jsonContent = CommonUtil.yamlToJson((String)yamlContent);
            } else if (CommonUtil.checkFileExistence((String)pathToJsonFile)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found certificate file " + pathToJsonFile));
                }
                jsonContent = FileUtils.readFileToString((File)new File(pathToJsonFile));
            }
            if (jsonContent == null) {
                log.debug((Object)"No certificate file found to be added, skipping certificate import.");
                return;
            }
            JsonElement configElement = new JsonParser().parse(jsonContent).getAsJsonObject().get("data");
            JsonArray certificates = ImportUtils.addFileContentToCertificates(configElement.getAsJsonArray(), pathToEndpointsCertificatesDirectory);
            for (JsonElement certificate : certificates) {
                ImportUtils.updateAPIWithCertificate(certificate, apiProvider, importedApi, tenantId);
            }
        }
        catch (IOException e) {
            throw new APIManagementException("Error in reading certificates file", (Throwable)e);
        }
    }

    private static JsonArray addFileContentToCertificates(JsonArray certificates, String pathToCertificatesDirectory) throws IOException {
        JsonArray modifiedCertificates = new JsonArray();
        for (JsonElement certificate : certificates) {
            JsonObject certificateObject = certificate.getAsJsonObject();
            String certificateFileName = certificateObject.get("certificate").getAsString();
            String certificateContent = ImportUtils.getFileContentOfCertificate(certificateFileName, pathToCertificatesDirectory);
            if (certificateObject.has("certificate")) {
                certificateObject.remove("certificate");
            }
            certificateObject.addProperty("certificate", certificateContent);
            modifiedCertificates.add((JsonElement)certificateObject);
        }
        return modifiedCertificates;
    }

    private static String getFileContentOfCertificate(String certificateFileName, String pathToCertificatesDirectory) throws IOException {
        String certificateContent = null;
        File certificatesDirectory = new File(pathToCertificatesDirectory);
        File[] certificatesDirectoryListing = certificatesDirectory.listFiles();
        if (certificatesDirectoryListing != null) {
            for (File endpointsCertificate : certificatesDirectoryListing) {
                if (!StringUtils.equals((CharSequence)certificateFileName, (CharSequence)endpointsCertificate.getName())) continue;
                certificateContent = FileUtils.readFileToString((File)new File(pathToCertificatesDirectory + File.separator + certificateFileName));
                certificateContent = StringUtils.substringBetween((String)certificateContent, (String)"-----BEGIN CERTIFICATE-----\n", (String)"-----END CERTIFICATE-----");
            }
        }
        return certificateContent;
    }

    private static void updateAPIWithCertificate(JsonElement certificate, APIProvider apiProvider, API importedApi, int tenantId) throws APIManagementException {
        String certificateFileName = certificate.getAsJsonObject().get("certificate").getAsString();
        String certificateContent = certificate.getAsJsonObject().get("certificate").getAsString();
        if (certificateContent == null) {
            throw new APIManagementException("Certificate " + certificateFileName + "is null");
        }
        String alias = certificate.getAsJsonObject().get("alias").getAsString();
        String endpoint = certificate.getAsJsonObject().get("endpoint").getAsString();
        try {
            if (apiProvider.isCertificatePresent(tenantId, alias) || ResponseCode.ALIAS_EXISTS_IN_TRUST_STORE.getResponseCode() == apiProvider.addCertificate(APIUtil.replaceEmailDomainBack((String)importedApi.getId().getProviderName()), certificateContent, alias, endpoint)) {
                apiProvider.updateCertificate(certificateContent, alias);
            }
        }
        catch (APIManagementException e) {
            log.error((Object)("Error while importing certificate endpoint [" + endpoint + " ]alias [" + alias + " ] tenant user [" + APIUtil.replaceEmailDomainBack((String)importedApi.getId().getProviderName()) + "]"), (Throwable)e);
        }
    }

    private static void addClientCertificates(String pathToArchive, APIProvider apiProvider, Boolean preserveProvider, String provider) throws APIManagementException {
        try {
            List<ClientCertificateDTO> certificateMetadataDTOS = ImportUtils.retrieveClientCertificates(pathToArchive);
            for (ClientCertificateDTO certDTO : certificateMetadataDTOS) {
                APIIdentifier apiIdentifier = preserveProvider == false ? new APIIdentifier(provider, certDTO.getApiIdentifier().getApiName(), certDTO.getApiIdentifier().getVersion()) : certDTO.getApiIdentifier();
                apiProvider.addClientCertificate(APIUtil.replaceEmailDomainBack((String)provider), apiIdentifier, certDTO.getCertificate(), certDTO.getAlias(), certDTO.getTierName());
            }
        }
        catch (APIManagementException e) {
            throw new APIManagementException("Error while importing client certificate", (Throwable)e);
        }
    }

    public static List<ClientCertificateDTO> retrieveClientCertificates(String pathToArchive) throws APIManagementException {
        String jsonContent = null;
        String pathToClientCertificatesDirectory = pathToArchive + File.separator + "Client-certificates";
        String pathToYamlFile = pathToClientCertificatesDirectory + ImportExportConstants.CLIENT_CERTIFICATE_FILE + ".yaml";
        String pathToJsonFile = pathToClientCertificatesDirectory + ImportExportConstants.CLIENT_CERTIFICATE_FILE + ".json";
        try {
            if (CommonUtil.checkFileExistence((String)pathToYamlFile)) {
                log.debug((Object)("Found client certificate file " + pathToYamlFile));
                String yamlContent = FileUtils.readFileToString((File)new File(pathToYamlFile));
                jsonContent = CommonUtil.yamlToJson((String)yamlContent);
            } else if (CommonUtil.checkFileExistence((String)pathToJsonFile)) {
                log.debug((Object)("Found client certificate file " + pathToJsonFile));
                jsonContent = FileUtils.readFileToString((File)new File(pathToJsonFile));
            }
            if (jsonContent == null) {
                log.debug((Object)"No client certificate file found to be added, skipping");
                return new ArrayList<ClientCertificateDTO>();
            }
            JsonElement configElement = new JsonParser().parse(jsonContent).getAsJsonObject().get("data");
            JsonArray modifiedCertificatesData = ImportUtils.addFileContentToCertificates(configElement.getAsJsonArray(), pathToClientCertificatesDirectory);
            Gson gson = new Gson();
            return (List)gson.fromJson((JsonElement)modifiedCertificatesData, new TypeToken<ArrayList<ClientCertificateDTO>>(){}.getType());
        }
        catch (IOException e) {
            throw new APIManagementException("Error in reading certificates file", (Throwable)e);
        }
    }

    private static void addSOAPToREST(API importedApi, String swaggerContent, APIProvider apiProvider) throws APIManagementException, FaultGatewaysException {
        if (StringUtils.equals((CharSequence)importedApi.getType().toLowerCase(), (CharSequence)"SOAPTOREST".toLowerCase())) {
            String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
            PublisherCommonUtils.updateAPIBySettingGenerateSequencesFromSwagger(swaggerContent, importedApi, apiProvider, tenantDomain);
        }
    }

    public static List<SoapToRestMediationDto> retrieveSoapToRestFlowMediations(String pathToArchive, String type) throws APIManagementException {
        ArrayList<SoapToRestMediationDto> soapToRestMediationDtoList = new ArrayList<SoapToRestMediationDto>();
        String fileLocation = null;
        if (IN.equals(type)) {
            fileLocation = pathToArchive + File.separator + SOAPTOREST + File.separator + IN;
        } else if (OUT.equals(type)) {
            fileLocation = pathToArchive + File.separator + SOAPTOREST + File.separator + OUT;
        }
        if (CommonUtil.checkFileExistence(fileLocation)) {
            Path flowDirectory = Paths.get(fileLocation, new String[0]);
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(flowDirectory);){
                for (Path file : stream) {
                    String fileName = file.getFileName().toString();
                    String method = "";
                    String resource = "";
                    if (fileName.split(".xml").length != 0) {
                        method = fileName.split(".xml")[0].substring(file.getFileName().toString().lastIndexOf("_") + 1);
                        resource = fileName.substring(0, fileName.indexOf("_"));
                    }
                    FileInputStream inputFlowStream = new FileInputStream(file.toFile());
                    Throwable throwable = null;
                    try {
                        String content = IOUtils.toString((InputStream)inputFlowStream);
                        SoapToRestMediationDto soapToRestMediationDto = new SoapToRestMediationDto(resource, method, content);
                        soapToRestMediationDtoList.add(soapToRestMediationDto);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputFlowStream == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)inputFlowStream).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)inputFlowStream).close();
                    }
                }
            }
            catch (IOException e) {
                throw new APIManagementException("Error while reading mediation content", (Throwable)e);
            }
        }
        return soapToRestMediationDtoList;
    }

    private static void importMediationLogic(SoapToRestMediationDto sequenceData, Registry registry, String soapToRestLocation) throws APIManagementException {
        String fileName = sequenceData.getResource().concat("_").concat(sequenceData.getMethod()).concat(".xml");
        try {
            byte[] inSeqData = sequenceData.getContent().getBytes();
            Resource inSeqResource = registry.newResource();
            inSeqResource.setContent((Object)inSeqData);
            inSeqResource.addProperty("method", sequenceData.getMethod());
            inSeqResource.setMediaType("text/xml");
            registry.put(soapToRestLocation + "/" + fileName, inSeqResource);
        }
        catch (DirectoryIteratorException e) {
            throw new APIManagementException("Error in importing SOAP to REST mediation logic", (Throwable)e);
        }
        catch (RegistryException e) {
            throw new APIManagementException("Error in storing imported SOAP to REST mediation logic", (Throwable)e);
        }
    }

    public static String getLifeCycleAction(String tenantDomain, String currentStatus, String targetStatus, APIProvider provider) throws APIManagementException {
        if (StringUtils.equalsIgnoreCase((CharSequence)currentStatus, (CharSequence)targetStatus)) {
            return null;
        }
        LifeCycle lifeCycle = new LifeCycle();
        try {
            String data = provider.getLifecycleConfiguration(tenantDomain);
            DocumentBuilderFactory factory = APIUtil.getSecuredDocumentBuilder();
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
            Document doc = builder.parse(inputStream);
            Element root = doc.getDocumentElement();
            NodeList states = root.getElementsByTagName("state");
            int nStates = states.getLength();
            for (int i = 0; i < nStates; ++i) {
                Node node = states.item(i);
                Node id = node.getAttributes().getNamedItem("id");
                if (id == null || id.getNodeValue().isEmpty()) continue;
                LifeCycleTransition lifeCycleTransition = new LifeCycleTransition();
                NodeList transitions = node.getChildNodes();
                int nTransitions = transitions.getLength();
                for (int j = 0; j < nTransitions; ++j) {
                    Node transition = transitions.item(j);
                    if (!"transition".equals(transition.getNodeName())) continue;
                    Node target = transition.getAttributes().getNamedItem("target");
                    Node action = transition.getAttributes().getNamedItem("event");
                    if (target == null || action == null) continue;
                    lifeCycleTransition.addTransition(target.getNodeValue().toLowerCase(), action.getNodeValue());
                }
                lifeCycle.addLifeCycleState(id.getNodeValue().toLowerCase(), lifeCycleTransition);
            }
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new APIManagementException("Error parsing APILifeCycle for tenant: " + tenantDomain, (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new APIManagementException("Error parsing unsupported encoding for APILifeCycle in tenant: " + tenantDomain, (Throwable)e);
        }
        catch (IOException e) {
            throw new APIManagementException("Error reading APILifeCycle for tenant: " + tenantDomain, (Throwable)e);
        }
        LifeCycleTransition transition = lifeCycle.getTransition(currentStatus.toLowerCase());
        if (transition != null) {
            return transition.getAction(targetStatus.toLowerCase());
        }
        return null;
    }

    public static APIProduct importApiProduct(String extractedFolderPath, Boolean preserveProvider, Boolean rotateRevision, Boolean overwriteAPIProduct, Boolean overwriteAPIs, Boolean importAPIs, String[] tokenScopes) throws APIManagementException {
        String userName = RestApiCommonUtil.getLoggedInUsername();
        String currentTenantDomain = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack((String)userName));
        APIProduct importedApiProduct = null;
        JsonArray deploymentInfoArray = null;
        try {
            List<APIRevisionDeployment> apiProductRevisionDeployments;
            JsonElement jsonObject = ImportUtils.retrieveValidatedDTOObject(extractedFolderPath, preserveProvider, userName, "api_product");
            APIProductDTO importedApiProductDTO = (APIProductDTO)new Gson().fromJson(jsonObject, APIProductDTO.class);
            JsonObject paramsConfigObject = APIControllerUtil.resolveAPIControllerEnvParams(extractedFolderPath);
            if (paramsConfigObject != null) {
                importedApiProductDTO = APIControllerUtil.injectEnvParamsToAPIProduct(importedApiProductDTO, paramsConfigObject, extractedFolderPath);
                JsonElement deploymentsParam = paramsConfigObject.get("deploymentEnvironments");
                if (deploymentsParam != null && !deploymentsParam.isJsonNull()) {
                    deploymentInfoArray = deploymentsParam.getAsJsonArray();
                }
            }
            APIProvider apiProvider = RestApiCommonUtil.getProvider((String)importedApiProductDTO.getProvider());
            ImportUtils.checkAPIProductResourcesValid(extractedFolderPath, userName, apiProvider, importedApiProductDTO, preserveProvider);
            importedApiProductDTO = importAPIs != false ? ImportUtils.importDependentAPIs(extractedFolderPath, userName, preserveProvider, apiProvider, overwriteAPIs, rotateRevision, importedApiProductDTO, tokenScopes) : ImportUtils.updateDependentApiUuids(importedApiProductDTO, apiProvider, currentTenantDomain);
            APIProduct targetApiProduct = ImportUtils.retrieveApiProductToOverwrite(importedApiProductDTO.getName(), currentTenantDomain, apiProvider, Boolean.TRUE);
            if (Boolean.TRUE.equals(overwriteAPIProduct) && targetApiProduct != null) {
                log.info((Object)"Existing API Product found, attempting to update it...");
                importedApiProduct = PublisherCommonUtils.updateApiProduct(targetApiProduct, importedApiProductDTO, RestApiCommonUtil.getLoggedInUserProvider(), userName, currentTenantDomain);
            } else {
                if (targetApiProduct == null && Boolean.TRUE.equals(overwriteAPIProduct)) {
                    log.info((Object)("Cannot find : " + importedApiProductDTO.getName() + ". Creating it."));
                }
                importedApiProduct = PublisherCommonUtils.addAPIProductWithGeneratedSwaggerDefinition(importedApiProductDTO, importedApiProductDTO.getProvider());
            }
            importedApiProduct = ImportUtils.updateApiProductSwagger(extractedFolderPath, importedApiProduct.getUuid(), importedApiProduct, apiProvider, currentTenantDomain);
            ApiTypeWrapper apiTypeWrapperWithUpdatedApiProduct = new ApiTypeWrapper(importedApiProduct);
            ImportUtils.addThumbnailImage(extractedFolderPath, apiTypeWrapperWithUpdatedApiProduct, apiProvider);
            ImportUtils.addDocumentation(extractedFolderPath, apiTypeWrapperWithUpdatedApiProduct, apiProvider);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Mutual SSL enabled. Importing client certificates.");
            }
            ImportUtils.addClientCertificates(extractedFolderPath, apiProvider, preserveProvider, importedApiProduct.getId().getProviderName());
            if (deploymentInfoArray == null) {
                deploymentInfoArray = ImportUtils.retrieveDeploymentLabelsFromArchive(extractedFolderPath, false);
            }
            if ((apiProductRevisionDeployments = ImportUtils.getValidatedDeploymentsList(deploymentInfoArray, currentTenantDomain, apiProvider)).size() > 0) {
                String revisionId;
                String importedAPIUuid = importedApiProduct.getUuid();
                APIRevision apiProductRevision = new APIRevision();
                apiProductRevision.setApiUUID(importedAPIUuid);
                apiProductRevision.setDescription("Revision created after importing the API Product");
                try {
                    revisionId = apiProvider.addAPIProductRevision(apiProductRevision);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("A new revision has been created for API Product " + importedApiProduct.getId().getName() + "_" + importedApiProduct.getId().getVersion() + " with ID: " + revisionId));
                    }
                }
                catch (APIManagementException e) {
                    if (e.getErrorHandler().getErrorCode() == ExceptionCodes.from((ErrorHandler)ExceptionCodes.MAXIMUM_REVISIONS_REACHED, (String[])new String[0]).getErrorCode() && rotateRevision.booleanValue()) {
                        String earliestRevisionUuid = apiProvider.getEarliestRevisionUUID(importedAPIUuid);
                        List deploymentsList = apiProvider.getAPIRevisionDeploymentList(earliestRevisionUuid);
                        apiProvider.undeployAPIProductRevisionDeployment(importedAPIUuid, earliestRevisionUuid, deploymentsList);
                        apiProvider.deleteAPIProductRevision(importedAPIUuid, earliestRevisionUuid);
                        revisionId = apiProvider.addAPIProductRevision(apiProductRevision);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Revision ID: " + earliestRevisionUuid + " has been undeployed from " + deploymentsList.size() + " gateway environments and created a new revision ID: " + revisionId + " for API Product " + importedApiProduct.getId().getName() + "_" + importedApiProduct.getId().getVersion()));
                        }
                    }
                    throw new APIManagementException((Throwable)e);
                }
                apiProvider.deployAPIProductRevision(importedAPIUuid, revisionId, apiProductRevisionDeployments);
            } else {
                log.info((Object)"Valid deployment environments were not found for the imported artifact. Hence not deployed in any of the gateway environments.");
            }
            return importedApiProduct;
        }
        catch (IOException e) {
            throw new APIManagementException("Error while reading API Product meta information from path: " + extractedFolderPath, (Throwable)e);
        }
        catch (FaultGatewaysException e) {
            throw new APIManagementException("Error while updating API Product: " + importedApiProduct.getId().getName(), (Throwable)e);
        }
        catch (APIManagementException e) {
            String errorMessage = "Error while importing API Product: ";
            if (importedApiProduct != null) {
                errorMessage = errorMessage + importedApiProduct.getId().getName() + " " + "version" + ": " + importedApiProduct.getId().getVersion();
            }
            throw new APIManagementException(errorMessage + " " + e.getMessage(), (Throwable)e);
        }
    }

    private static void checkAPIProductResourcesValid(String path, String currentUser, APIProvider apiProvider, APIProductDTO apiProductDto, Boolean preserveProvider) throws IOException, APIManagementException {
        List<ProductAPIDTO> apis = apiProductDto.getApis();
        String apisDirectoryPath = path + File.separator + "APIs";
        File apisDirectory = new File(apisDirectoryPath);
        File[] apisDirectoryListing = apisDirectory.listFiles();
        if (apisDirectoryListing != null) {
            for (File apiDirectory : apisDirectoryListing) {
                String apiDirectoryPath = path + File.separator + "APIs" + File.separator + apiDirectory.getName();
                JsonElement jsonObject = ImportUtils.retrieveValidatedDTOObject(apiDirectoryPath, preserveProvider, currentUser, "api");
                APIDTO apiDto = (APIDTO)new Gson().fromJson(jsonObject, APIDTO.class);
                String apiName = apiDto.getName();
                String apiVersion = apiDto.getVersion();
                String swaggerContent = ImportUtils.loadSwaggerFile(apiDirectoryPath);
                APIDefinition apiDefinition = OASParserUtil.getOASParser((String)swaggerContent);
                Set apiUriTemplates = apiDefinition.getURITemplates(swaggerContent);
                for (ProductAPIDTO apiFromProduct : apis) {
                    if (!StringUtils.equals((CharSequence)apiFromProduct.getName(), (CharSequence)apiName) || !StringUtils.equals((CharSequence)apiFromProduct.getVersion(), (CharSequence)apiVersion)) continue;
                    List<APIOperationsDTO> invalidApiOperations = ImportUtils.filterInvalidProductResources(apiFromProduct.getOperations(), apiUriTemplates);
                    if (!invalidApiOperations.isEmpty()) {
                        API api = ImportUtils.retrieveApiToOverwrite(apiName, apiVersion, MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack((String)currentUser)), apiProvider, Boolean.FALSE);
                        invalidApiOperations = ImportUtils.filterInvalidProductResources(invalidApiOperations, api.getUriTemplates());
                    }
                    if (invalidApiOperations.isEmpty()) continue;
                    throw new APIMgtResourceNotFoundException("Cannot find API resources for some API Product resources.");
                }
            }
        }
    }

    private static List<APIOperationsDTO> filterInvalidProductResources(List<APIOperationsDTO> apiProductOperations, Set<URITemplate> apiUriTemplates) {
        ArrayList<APIOperationsDTO> apiOperations = new ArrayList<APIOperationsDTO>(apiProductOperations);
        for (URITemplate apiUriTemplate : apiUriTemplates) {
            apiOperations.removeIf(apiOperation -> StringUtils.equals((CharSequence)apiOperation.getVerb(), (CharSequence)apiUriTemplate.getHTTPVerb()) && StringUtils.equals((CharSequence)apiOperation.getTarget(), (CharSequence)apiUriTemplate.getUriTemplate()));
        }
        return apiOperations;
    }

    private static APIProductDTO importDependentAPIs(String path, String currentUser, boolean isDefaultProviderAllowed, APIProvider apiProvider, boolean overwriteAPIs, Boolean rotateRevision, APIProductDTO apiProductDto, String[] tokenScopes) throws IOException, APIManagementException {
        JsonObject dependentAPIParamsConfigObject = null;
        JsonObject dependentAPIsParams = APIControllerUtil.getDependentAPIsParams(path);
        String apisDirectoryPath = path + File.separator + "APIs";
        File apisDirectory = new File(apisDirectoryPath);
        File[] apisDirectoryListing = apisDirectory.listFiles();
        if (apisDirectoryListing != null) {
            for (File apiDirectory : apisDirectoryListing) {
                String apiDirectoryPath = path + File.separator + "APIs" + File.separator + apiDirectory.getName();
                if (dependentAPIsParams != null) {
                    dependentAPIParamsConfigObject = APIControllerUtil.getDependentAPIParams(dependentAPIsParams, apiDirectory.getName());
                    String deploymentCertificatesDirectoryPath = path + ImportExportConstants.DEPLOYMENT_DIRECTORY + ImportExportConstants.CERTIFICATE_DIRECTORY;
                    if (CommonUtil.checkFileExistence((String)deploymentCertificatesDirectoryPath)) {
                        try {
                            CommonUtil.copyDirectory((String)deploymentCertificatesDirectoryPath, (String)(apiDirectoryPath + ImportExportConstants.DEPLOYMENT_DIRECTORY + ImportExportConstants.CERTIFICATE_DIRECTORY));
                        }
                        catch (APIImportExportException e) {
                            throw new APIManagementException("Error while copying the directory " + deploymentCertificatesDirectoryPath, (Throwable)e);
                        }
                    }
                }
                JsonElement jsonObject = ImportUtils.retrieveValidatedDTOObject(apiDirectoryPath, isDefaultProviderAllowed, currentUser, "api");
                APIDTO apiDtoToImport = (APIDTO)new Gson().fromJson(jsonObject, APIDTO.class);
                API importedApi = null;
                String apiName = apiDtoToImport.getName();
                String apiVersion = apiDtoToImport.getVersion();
                if (isDefaultProviderAllowed) {
                    APIIdentifier apiIdentifier = new APIIdentifier(APIUtil.replaceEmailDomain((String)apiDtoToImport.getProvider()), apiName, apiVersion);
                    if (apiProvider.isAPIAvailable(apiIdentifier)) {
                        if (Boolean.TRUE.equals(overwriteAPIs)) {
                            importedApi = ImportUtils.importApi(apiDirectoryPath, apiDtoToImport, isDefaultProviderAllowed, rotateRevision, Boolean.TRUE, Boolean.TRUE, tokenScopes, dependentAPIParamsConfigObject);
                        }
                    } else {
                        importedApi = ImportUtils.importApi(apiDirectoryPath, apiDtoToImport, isDefaultProviderAllowed, rotateRevision, Boolean.FALSE, Boolean.TRUE, tokenScopes, dependentAPIParamsConfigObject);
                    }
                } else {
                    String currentTenantDomain = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack((String)currentUser));
                    String apiProviderInCurrentTenantDomain = APIUtil.getAPIProviderFromAPINameVersionTenant((String)apiName, (String)apiVersion, (String)currentTenantDomain);
                    if (StringUtils.isBlank((CharSequence)apiProviderInCurrentTenantDomain)) {
                        importedApi = ImportUtils.importApi(apiDirectoryPath, apiDtoToImport, isDefaultProviderAllowed, rotateRevision, Boolean.FALSE, Boolean.TRUE, tokenScopes, dependentAPIParamsConfigObject);
                    } else if (Boolean.TRUE.equals(overwriteAPIs)) {
                        importedApi = ImportUtils.importApi(apiDirectoryPath, apiDtoToImport, isDefaultProviderAllowed, rotateRevision, Boolean.TRUE, Boolean.TRUE, tokenScopes, dependentAPIParamsConfigObject);
                    }
                }
                if (importedApi == null) {
                    importedApi = ImportUtils.retrieveApiToOverwrite(apiDtoToImport.getName(), apiDtoToImport.getVersion(), MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack((String)currentUser)), apiProvider, Boolean.FALSE);
                }
                ImportUtils.updateApiUuidInApiProduct(apiProductDto, importedApi);
            }
        } else {
            String msg = "No dependent APIs supplied. Continuing ...";
            log.info((Object)msg);
        }
        return apiProductDto;
    }

    private static APIProductDTO updateApiUuidInApiProduct(APIProductDTO apiProductDto, API importedApi) {
        APIIdentifier importedApiIdentifier = importedApi.getId();
        List<ProductAPIDTO> apis = apiProductDto.getApis();
        for (ProductAPIDTO api : apis) {
            if (!StringUtils.equals((CharSequence)api.getName(), (CharSequence)importedApiIdentifier.getName()) || !StringUtils.equals((CharSequence)api.getVersion(), (CharSequence)importedApiIdentifier.getVersion())) continue;
            api.setApiId(importedApi.getUuid());
            break;
        }
        return apiProductDto;
    }

    private static APIProductDTO updateDependentApiUuids(APIProductDTO importedApiProductDtO, APIProvider apiProvider, String currentTenantDomain) throws APIManagementException {
        List<ProductAPIDTO> apis = importedApiProductDtO.getApis();
        for (ProductAPIDTO api : apis) {
            API targetApi = ImportUtils.retrieveApiToOverwrite(api.getName(), api.getVersion(), currentTenantDomain, apiProvider, Boolean.FALSE);
            if (targetApi == null) continue;
            api.setApiId(targetApi.getUuid());
        }
        return importedApiProductDtO;
    }

    private static APIProduct retrieveApiProductToOverwrite(String apiProductName, String currentTenantDomain, APIProvider apiProvider, Boolean ignoreAndImport) throws APIManagementException {
        String provider = APIUtil.getAPIProviderFromAPINameVersionTenant((String)apiProductName, (String)"1.0.0", (String)currentTenantDomain);
        APIProductIdentifier apiProductIdentifier = new APIProductIdentifier(APIUtil.replaceEmailDomain((String)provider), apiProductName, "1.0.0");
        if (!apiProvider.isAPIProductAvailable(apiProductIdentifier)) {
            if (ignoreAndImport.booleanValue()) {
                return null;
            }
            throw new APIMgtResourceNotFoundException("Error occurred while retrieving the API Product. API Product: " + apiProductName + " " + "version" + ": " + "1.0.0" + " not found");
        }
        return apiProvider.getAPIProduct(apiProductIdentifier);
    }

    private static APIProduct updateApiProductSwagger(String pathToArchive, String apiProductId, APIProduct importedApiProduct, APIProvider apiProvider, String orgId) throws APIManagementException, FaultGatewaysException, IOException {
        String swaggerContent = ImportUtils.loadSwaggerFile(pathToArchive);
        APIDefinition apiDefinition = OASParserUtil.getOASParser((String)swaggerContent);
        Set scopes = apiDefinition.getScopes(swaggerContent);
        importedApiProduct.setScopes(scopes);
        Map apiToProductResourceMapping = apiProvider.updateAPIProduct(importedApiProduct);
        apiProvider.updateAPIProductSwagger(apiProductId, apiToProductResourceMapping, importedApiProduct, orgId);
        return importedApiProduct;
    }
}

