/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings;

import graphql.schema.idl.SchemaParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.model.graphql.queryanalysis.CustomComplexityDetails;
import org.wso2.carbon.apimgt.api.model.graphql.queryanalysis.GraphqlComplexityInfo;
import org.wso2.carbon.apimgt.api.model.graphql.queryanalysis.GraphqlSchemaType;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.GraphQLCustomComplexityInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.GraphQLQueryComplexityInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.GraphQLSchemaTypeDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.GraphQLSchemaTypeListDTO;

public class GraphqlQueryAnalysisMappingUtil {
    private static final Log log = LogFactory.getLog(GraphqlQueryAnalysisMappingUtil.class);

    public static GraphQLQueryComplexityInfoDTO fromGraphqlComplexityInfotoDTO(GraphqlComplexityInfo graphqlComplexityInfo) {
        GraphQLQueryComplexityInfoDTO graphQLQueryComplexityInfoDTO = new GraphQLQueryComplexityInfoDTO();
        ArrayList<GraphQLCustomComplexityInfoDTO> graphQLCustomComplexityInfoDTOList = new ArrayList<GraphQLCustomComplexityInfoDTO>();
        for (CustomComplexityDetails customComplexityDetails : graphqlComplexityInfo.getList()) {
            GraphQLCustomComplexityInfoDTO graphQLCustomComplexityInfoDTO = new GraphQLCustomComplexityInfoDTO();
            graphQLCustomComplexityInfoDTO.setType(customComplexityDetails.getType());
            graphQLCustomComplexityInfoDTO.setField(customComplexityDetails.getField());
            graphQLCustomComplexityInfoDTO.setComplexityValue(customComplexityDetails.getComplexityValue());
            graphQLCustomComplexityInfoDTOList.add(graphQLCustomComplexityInfoDTO);
        }
        graphQLQueryComplexityInfoDTO.setList(graphQLCustomComplexityInfoDTOList);
        return graphQLQueryComplexityInfoDTO;
    }

    public static GraphqlComplexityInfo fromDTOtoValidatedGraphqlComplexityInfo(GraphQLQueryComplexityInfoDTO graphQLQueryComplexityInfoDTO, String schema) {
        SchemaParser schemaParser = new SchemaParser();
        Set complexityInfoTypeSet = schemaParser.parse(schema).types().keySet();
        GraphqlComplexityInfo graphqlComplexityInfo = new GraphqlComplexityInfo();
        ArrayList<CustomComplexityDetails> customComplexityDetailsList = new ArrayList<CustomComplexityDetails>();
        for (GraphQLCustomComplexityInfoDTO graphQLCustomComplexityInfoDTO : graphQLQueryComplexityInfoDTO.getList()) {
            String complexityType = graphQLCustomComplexityInfoDTO.getType();
            if (complexityInfoTypeSet.contains(complexityType)) {
                CustomComplexityDetails customComplexityDetails = new CustomComplexityDetails();
                customComplexityDetails.setType(complexityType);
                customComplexityDetails.setField(graphQLCustomComplexityInfoDTO.getField());
                customComplexityDetails.setComplexityValue(graphQLCustomComplexityInfoDTO.getComplexityValue().intValue());
                customComplexityDetailsList.add(customComplexityDetails);
                continue;
            }
            log.error((Object)("Complexity Type : " + complexityType + " is not included in the original schema. Hence skipped."));
        }
        graphqlComplexityInfo.setList(customComplexityDetailsList);
        return graphqlComplexityInfo;
    }

    public static GraphQLSchemaTypeListDTO fromGraphqlSchemaTypeListtoDTO(List<GraphqlSchemaType> typeList) {
        GraphQLSchemaTypeListDTO graphQLSchemaTypeListDTO = new GraphQLSchemaTypeListDTO();
        ArrayList<GraphQLSchemaTypeDTO> graphQLSchemaTypeDTOList = new ArrayList<GraphQLSchemaTypeDTO>();
        for (GraphqlSchemaType graphqlSchemaType : typeList) {
            GraphQLSchemaTypeDTO graphQLSchemaTypeDTO = new GraphQLSchemaTypeDTO();
            ArrayList<String> fieldList = new ArrayList<String>(graphqlSchemaType.getFieldList());
            graphQLSchemaTypeDTO.setType(graphqlSchemaType.getType());
            graphQLSchemaTypeDTO.setFieldList(fieldList);
            graphQLSchemaTypeDTOList.add(graphQLSchemaTypeDTO);
        }
        graphQLSchemaTypeListDTO.setTypeList(graphQLSchemaTypeDTOList);
        return graphQLSchemaTypeListDTO;
    }
}

