/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.wso2.carbon.apimgt.api.model.APIStore;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIExternalStoreDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIExternalStoreListDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ExternalStoreDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ExternalStoreListDTO;

public class ExternalStoreMappingUtil {
    private ExternalStoreMappingUtil() {
        throw new IllegalStateException("Utility class to map ExternalStore Objects");
    }

    public static ExternalStoreDTO fromExternalStoreToDTO(APIStore apiStore) {
        ExternalStoreDTO externalStoreDTO = new ExternalStoreDTO();
        externalStoreDTO.setDisplayName(apiStore.getDisplayName());
        externalStoreDTO.setId(apiStore.getName());
        externalStoreDTO.setType(apiStore.getType());
        externalStoreDTO.setEndpoint(apiStore.getEndpoint());
        return externalStoreDTO;
    }

    public static ExternalStoreListDTO fromExternalStoreCollectionToDTO(Collection<APIStore> externalStoreCollection) {
        ExternalStoreListDTO externalStoreListDTO = new ExternalStoreListDTO();
        List<ExternalStoreDTO> externalStoreDTOS = externalStoreListDTO.getList();
        if (externalStoreCollection == null) {
            externalStoreCollection = new HashSet<APIStore>();
        }
        for (APIStore externalStore : externalStoreCollection) {
            externalStoreDTOS.add(ExternalStoreMappingUtil.fromExternalStoreToDTO(externalStore));
        }
        externalStoreListDTO.setList(externalStoreDTOS);
        externalStoreListDTO.setCount(externalStoreDTOS.size());
        return externalStoreListDTO;
    }

    public static APIExternalStoreListDTO fromAPIExternalStoreCollectionToDTO(Collection<APIStore> externalStoreCollection) {
        APIExternalStoreListDTO apiExternalStoreListDTO = new APIExternalStoreListDTO();
        List<APIExternalStoreDTO> apiExternalStoreDTOS = apiExternalStoreListDTO.getList();
        if (externalStoreCollection == null) {
            externalStoreCollection = new HashSet<APIStore>();
        }
        for (APIStore externalStore : externalStoreCollection) {
            apiExternalStoreDTOS.add(ExternalStoreMappingUtil.fromAPIExternalStoreToDTO(externalStore));
        }
        apiExternalStoreListDTO.setList(apiExternalStoreDTOS);
        apiExternalStoreListDTO.setCount(apiExternalStoreDTOS.size());
        return apiExternalStoreListDTO;
    }

    public static APIExternalStoreDTO fromAPIExternalStoreToDTO(APIStore apiStore) {
        APIExternalStoreDTO apiExternalStoreDTO = new APIExternalStoreDTO();
        apiExternalStoreDTO.setId(apiStore.getName());
        if (apiStore.getLastUpdated() != null) {
            Date lastUpdateDate = apiStore.getLastUpdated();
            Timestamp timeStamp = new Timestamp(lastUpdateDate.getTime());
            apiExternalStoreDTO.setLastUpdatedTime(String.valueOf(timeStamp));
        }
        return apiExternalStoreDTO;
    }
}

