/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIMgtAuthorizationFailedException;
import org.wso2.carbon.apimgt.api.APIMgtResourceNotFoundException;
import org.wso2.carbon.apimgt.api.APIProvider;
import org.wso2.carbon.apimgt.api.ErrorHandler;
import org.wso2.carbon.apimgt.api.ExceptionCodes;
import org.wso2.carbon.apimgt.api.dto.CertificateMetadataDTO;
import org.wso2.carbon.apimgt.api.dto.ClientCertificateDTO;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIProductIdentifier;
import org.wso2.carbon.apimgt.api.model.APIRevisionDeployment;
import org.wso2.carbon.apimgt.api.model.Documentation;
import org.wso2.carbon.apimgt.api.model.DocumentationContent;
import org.wso2.carbon.apimgt.api.model.Identifier;
import org.wso2.carbon.apimgt.api.model.Mediation;
import org.wso2.carbon.apimgt.api.model.ResourceFile;
import org.wso2.carbon.apimgt.api.model.graphql.queryanalysis.GraphqlComplexityInfo;
import org.wso2.carbon.apimgt.impl.APIConstants;
import org.wso2.carbon.apimgt.impl.certificatemgt.CertificateManager;
import org.wso2.carbon.apimgt.impl.certificatemgt.CertificateManagerImpl;
import org.wso2.carbon.apimgt.impl.definitions.AsyncApiParser;
import org.wso2.carbon.apimgt.impl.importexport.APIImportExportException;
import org.wso2.carbon.apimgt.impl.importexport.ExportFormat;
import org.wso2.carbon.apimgt.impl.importexport.ImportExportConstants;
import org.wso2.carbon.apimgt.impl.importexport.utils.CommonUtil;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.impl.wsdl.util.SequenceUtils;
import org.wso2.carbon.apimgt.rest.api.common.RestApiCommonUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.APIMappingUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.DocumentationMappingUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.GraphqlQueryAnalysisMappingUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.ImportUtils;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.PublisherCommonUtils;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIProductDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.AdvertiseInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.GraphQLQueryComplexityInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ProductAPIDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ResourcePolicyInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ResourcePolicyListDTO;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class ExportUtils {
    private static final Log log = LogFactory.getLog(ExportUtils.class);
    private static final String IN = "in";
    private static final String OUT = "out";
    private static final String SOAPTOREST = "SoapToRest";

    public static String validateExportParams(String name, String version, String providerName) throws APIManagementException {
        if (name == null || version == null) {
            throw new APIManagementException("'name' (" + name + ") or 'version' (" + version + ") should not be null.", (ErrorHandler)ExceptionCodes.API_NAME_OR_VERSION_NOT_NULL);
        }
        String apiRequesterDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        if (StringUtils.isBlank((CharSequence)providerName) && (providerName = APIUtil.getAPIProviderFromAPINameVersionTenant((String)name, (String)version, (String)apiRequesterDomain)) == null) {
            throw new APIMgtResourceNotFoundException("Error occurred while exporting. API: " + name + " version: " + version + " not found");
        }
        if (!StringUtils.equals((CharSequence)MultitenantUtils.getTenantDomain((String)providerName), (CharSequence)apiRequesterDomain)) {
            throw new APIMgtAuthorizationFailedException("API name:" + name + " version:" + version + " provider:" + providerName);
        }
        return providerName;
    }

    public static File exportApi(APIProvider apiProvider, APIIdentifier apiIdentifier, APIDTO apiDtoToReturn, API api, String userName, ExportFormat exportFormat, boolean preserveStatus, boolean preserveDocs, String originalDevPortalUrl) throws APIManagementException, APIImportExportException {
        if (StringUtils.isNotBlank((CharSequence)originalDevPortalUrl)) {
            ExportUtils.setAdvertiseOnlySpecificPropertiesToDTO(apiDtoToReturn, originalDevPortalUrl);
        }
        File exportFolder = CommonUtil.createTempDirectory((Identifier)apiIdentifier);
        String exportAPIBasePath = exportFolder.toString();
        String archivePath = exportAPIBasePath.concat(File.separator + apiIdentifier.getApiName() + "-" + apiIdentifier.getVersion());
        int tenantId = APIUtil.getTenantId((String)userName);
        CommonUtil.createDirectory((String)archivePath);
        if (preserveDocs) {
            ExportUtils.addThumbnailToArchive(archivePath, (Identifier)apiIdentifier, apiProvider);
            ExportUtils.addDocumentationToArchive(archivePath, (Identifier)apiIdentifier, exportFormat, apiProvider, "API");
        } else if (StringUtils.equals((CharSequence)apiDtoToReturn.getType().toString().toLowerCase(), (CharSequence)"SOAPTOREST".toLowerCase())) {
            ExportUtils.addSOAPToRESTMediationToArchive(archivePath, api);
        }
        if (StringUtils.equals((CharSequence)apiDtoToReturn.getType().toString().toLowerCase(), (CharSequence)"SOAP".toLowerCase()) && preserveDocs) {
            ExportUtils.addWSDLtoArchive(archivePath, apiIdentifier, apiProvider);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No WSDL URL found for API: " + apiIdentifier + ". Skipping WSDL export."));
        }
        if (!preserveStatus) {
            apiDtoToReturn.setLifeCycleStatus("CREATED");
        }
        ExportUtils.addGatewayEnvironmentsToArchive(archivePath, apiDtoToReturn.getId(), exportFormat, apiProvider);
        if (!ImportUtils.isAdvertiseOnlyAPI(apiDtoToReturn)) {
            ExportUtils.addEndpointCertificatesToArchive(archivePath, apiDtoToReturn, tenantId, exportFormat);
            ExportUtils.addRuntimeSequencesToArchive(archivePath, api);
            if (preserveDocs) {
                ExportUtils.addMultipleAPISpecificSequencesToArchive(archivePath, api, apiProvider);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Mutual SSL enabled. Exporting client certificates.");
            }
            ExportUtils.addClientCertificatesToArchive(archivePath, (Identifier)apiIdentifier, tenantId, apiProvider, exportFormat);
        }
        ExportUtils.addAPIMetaInformationToArchive(archivePath, apiDtoToReturn, exportFormat, apiProvider, apiIdentifier);
        CommonUtil.archiveDirectory((String)exportAPIBasePath);
        FileUtils.deleteQuietly((File)new File(exportAPIBasePath));
        return new File(exportAPIBasePath + ".zip");
    }

    private static void setAdvertiseOnlySpecificPropertiesToDTO(APIDTO apiDto, String originalDevPortalUrl) {
        AdvertiseInfoDTO advertiseInfoDTO = new AdvertiseInfoDTO();
        advertiseInfoDTO.setAdvertised(Boolean.TRUE);
        advertiseInfoDTO.setApiOwner(apiDto.getProvider());
        advertiseInfoDTO.setOriginalDevPortalUrl(originalDevPortalUrl);
        apiDto.setAdvertiseInfo(advertiseInfoDTO);
        apiDto.setMediationPolicies(null);
    }

    public static File exportApiProduct(APIProvider apiProvider, APIProductIdentifier apiProductIdentifier, APIProductDTO apiProductDtoToReturn, String userName, ExportFormat exportFormat, Boolean preserveStatus, boolean preserveDocs, boolean preserveCredentials) throws APIManagementException, APIImportExportException {
        int tenantId = 0;
        File exportFolder = CommonUtil.createTempDirectory((Identifier)apiProductIdentifier);
        String exportAPIBasePath = exportFolder.toString();
        String archivePath = exportAPIBasePath.concat(File.separator + apiProductIdentifier.getName() + "-" + apiProductIdentifier.getVersion());
        tenantId = APIUtil.getTenantId((String)userName);
        CommonUtil.createDirectory((String)archivePath);
        if (preserveDocs) {
            ExportUtils.addThumbnailToArchive(archivePath, (Identifier)apiProductIdentifier, apiProvider);
            ExportUtils.addDocumentationToArchive(archivePath, (Identifier)apiProductIdentifier, exportFormat, apiProvider, "API Product");
        }
        ExportUtils.addGatewayEnvironmentsToArchive(archivePath, apiProductDtoToReturn.getId(), exportFormat, apiProvider);
        ExportUtils.addAPIProductMetaInformationToArchive(archivePath, apiProductDtoToReturn, exportFormat, apiProvider);
        ExportUtils.addDependentAPIsToArchive(archivePath, apiProductDtoToReturn, exportFormat, apiProvider, userName, preserveStatus, preserveDocs, preserveCredentials);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Mutual SSL enabled. Exporting client certificates.");
        }
        ExportUtils.addClientCertificatesToArchive(archivePath, (Identifier)apiProductIdentifier, tenantId, apiProvider, exportFormat);
        CommonUtil.archiveDirectory((String)exportAPIBasePath);
        FileUtils.deleteQuietly((File)new File(exportAPIBasePath));
        return new File(exportAPIBasePath + ".zip");
    }

    public static void addThumbnailToArchive(String archivePath, Identifier identifier, APIProvider apiProvider) throws APIImportExportException, APIManagementException {
        block30: {
            String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
            String localImagePath = archivePath + File.separator + "Image";
            try {
                ResourceFile thumbnailResource = apiProvider.getIcon(identifier.getUUID(), tenantDomain);
                if (thumbnailResource != null) {
                    String mediaType = thumbnailResource.getContentType();
                    String extension = (String)ImportExportConstants.fileExtensionMapping.get(mediaType);
                    if (extension != null) {
                        CommonUtil.createDirectory((String)localImagePath);
                        try (InputStream imageDataStream = thumbnailResource.getContent();
                             FileOutputStream outputStream = new FileOutputStream(localImagePath + File.separator + "icon" + "." + extension);){
                            IOUtils.copy((InputStream)imageDataStream, (OutputStream)outputStream);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Thumbnail image retrieved successfully for API/API Product: " + identifier.getName() + " " + "version" + ": " + identifier.getVersion()));
                            }
                            break block30;
                        }
                    }
                    log.error((Object)("Unsupported media type for icon " + mediaType + ". Skipping thumbnail export."));
                    break block30;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Thumbnail URL does not exists in registry for API/API Product: " + identifier.getName() + " " + "version" + ": " + identifier.getVersion() + ". Skipping thumbnail export."));
                }
            }
            catch (IOException e) {
                log.error((Object)"I/O error while writing API/API Product Thumbnail to file", (Throwable)e);
            }
        }
    }

    public static void addSOAPToRESTMediationToArchive(String archivePath, API api) throws APIImportExportException, APIManagementException {
        String sequencePathInArchive = archivePath + File.separator + SOAPTOREST;
        CommonUtil.createDirectory((String)sequencePathInArchive);
        ExportUtils.writeSOAPToRESTSequencesToArchive(api, sequencePathInArchive, IN);
        ExportUtils.writeSOAPToRESTSequencesToArchive(api, sequencePathInArchive, OUT);
    }

    private static void writeSOAPToRESTSequencesToArchive(API api, String sequencePathInArchive, String type) throws APIManagementException, APIImportExportException {
        String resourcePolicy = SequenceUtils.getRestToSoapConvertedSequence((API)api, (String)type);
        ResourcePolicyListDTO resourcePolicyInListDTO = APIMappingUtil.fromResourcePolicyStrToDTO(resourcePolicy);
        String individualSequencePathInArchive = sequencePathInArchive + File.separator + type;
        CommonUtil.createDirectory((String)individualSequencePathInArchive);
        for (ResourcePolicyInfoDTO resourcePolicyInfoDTO : resourcePolicyInListDTO.getList()) {
            String sequenceContent = resourcePolicyInfoDTO.getContent();
            String sequenceName = resourcePolicyInfoDTO.getResourcePath() + "_" + resourcePolicyInfoDTO.getHttpVerb();
            ExportUtils.writeSequenceToArchive(sequenceContent, individualSequencePathInArchive, sequenceName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addDocumentationToArchive(String archivePath, Identifier identifier, ExportFormat exportFormat, APIProvider apiProvider, String type) throws APIImportExportException, APIManagementException {
        List docList;
        String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        List list = docList = StringUtils.equals((CharSequence)type, (CharSequence)"API") ? apiProvider.getAllDocumentation(identifier.getUUID(), tenantDomain) : apiProvider.getAllDocumentation(identifier);
        if (!docList.isEmpty()) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String docDirectoryPath = archivePath + File.separator + "Docs";
            CommonUtil.createDirectory((String)docDirectoryPath);
            try {
                for (Documentation doc : docList) {
                    Documentation individualDocument = apiProvider.getDocumentation(identifier.getUUID(), doc.getId(), tenantDomain);
                    String sourceType = individualDocument.getSourceType().name();
                    String resourcePath = null;
                    InputStream inputStream = null;
                    String localFileName = null;
                    String individualDocDirectoryPath = docDirectoryPath + File.separator + ExportUtils.cleanFolderName(individualDocument.getName());
                    CommonUtil.createDirectory((String)individualDocDirectoryPath);
                    DocumentationContent documentationContent = apiProvider.getDocumentationContent(identifier.getUUID(), doc.getId(), tenantDomain);
                    if (documentationContent != null) {
                        if (Documentation.DocumentSourceType.FILE.toString().equalsIgnoreCase(sourceType)) {
                            localFileName = individualDocument.getFilePath().substring(individualDocument.getFilePath().lastIndexOf("/") + 1);
                            inputStream = documentationContent.getResourceFile().getContent();
                            individualDocument.setFilePath(localFileName);
                        } else if (Documentation.DocumentSourceType.INLINE.toString().equalsIgnoreCase(sourceType) || Documentation.DocumentSourceType.MARKDOWN.toString().equalsIgnoreCase(sourceType)) {
                            localFileName = individualDocument.getName();
                            inputStream = new ByteArrayInputStream(documentationContent.getTextContent().getBytes());
                        }
                    }
                    CommonUtil.writeDtoToFile((String)(individualDocDirectoryPath + ImportExportConstants.DOCUMENT_FILE_NAME), (ExportFormat)exportFormat, (String)"document", (Object)DocumentationMappingUtil.fromDocumentationToDTO(individualDocument));
                    if (inputStream != null) {
                        FileOutputStream outputStream = new FileOutputStream(individualDocDirectoryPath + File.separator + localFileName);
                        Throwable throwable = null;
                        try {
                            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (outputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    ((OutputStream)outputStream).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            ((OutputStream)outputStream).close();
                            continue;
                        }
                    }
                    log.error((Object)("Documentation resource for API/API Product: " + identifier.getName() + " not found in " + resourcePath));
                }
                if (!log.isDebugEnabled()) return;
                log.debug((Object)("Documentation retrieved successfully for API/API Product: " + identifier.getName() + " " + "version" + ": " + identifier.getVersion()));
                return;
            }
            catch (IOException e) {
                throw new APIImportExportException("I/O error while writing documentation to file for API/API Product: " + identifier.getName() + " " + "version" + ": " + identifier.getVersion(), (Throwable)e);
            }
        }
        if (!log.isDebugEnabled()) return;
        log.debug((Object)("No documentation found for API/API Product: " + identifier + ". Skipping documentation export."));
    }

    private static String cleanFolderName(String name) {
        return name.replaceAll("[^a-zA-Z0-9\\.\\-]", "_");
    }

    public static void addWSDLtoArchive(String archivePath, APIIdentifier apiIdentifier, APIProvider apiProvider) throws APIImportExportException {
        block29: {
            String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
            String wsdlPath = "/apimgt/applicationdata/wsdls/" + apiIdentifier.getProviderName() + "--" + apiIdentifier.getApiName() + apiIdentifier.getVersion() + ".wsdl";
            try {
                ResourceFile wsdlResource = apiProvider.getWSDL(apiIdentifier.getUUID(), tenantDomain);
                if (wsdlResource != null) {
                    CommonUtil.createDirectory((String)(archivePath + File.separator + "WSDL"));
                    try (InputStream wsdlStream = wsdlResource.getContent();
                         FileOutputStream outputStream = new FileOutputStream(archivePath + File.separator + "WSDL" + File.separator + apiIdentifier.getApiName() + "-" + apiIdentifier.getVersion() + ".wsdl");){
                        IOUtils.copy((InputStream)wsdlStream, (OutputStream)outputStream);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("WSDL file: " + wsdlPath + " retrieved successfully"));
                        }
                        break block29;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("WSDL resource does not exists in path: " + wsdlPath + ". Skipping WSDL export."));
                }
            }
            catch (IOException | APIManagementException e) {
                throw new APIImportExportException("I/O error while writing WSDL: " + wsdlPath + " to file", e);
            }
        }
    }

    public static void addRuntimeSequencesToArchive(String archivePath, API api) throws APIImportExportException, APIManagementException {
        String seqArchivePath = archivePath.concat(File.separator + "Sequences");
        Mediation inSequenceMediation = api.getInSequenceMediation();
        Mediation outSequenceMediation = api.getOutSequenceMediation();
        Mediation faultSequenceMediation = api.getFaultSequenceMediation();
        if (inSequenceMediation != null || outSequenceMediation != null || faultSequenceMediation != null) {
            String individualSequenceExportPath;
            CommonUtil.createDirectory((String)seqArchivePath);
            if (inSequenceMediation != null) {
                individualSequenceExportPath = inSequenceMediation.isGlobal() ? seqArchivePath + File.separator + IN + "-sequence" : seqArchivePath + File.separator + IN + "-sequence" + File.separator + "Custom";
                if (!CommonUtil.checkFileExistence((String)individualSequenceExportPath)) {
                    CommonUtil.createDirectory((String)individualSequenceExportPath);
                }
                ExportUtils.writeSequenceToArchive(inSequenceMediation.getConfig(), individualSequenceExportPath, inSequenceMediation.getName());
            }
            if (outSequenceMediation != null) {
                individualSequenceExportPath = outSequenceMediation.isGlobal() ? seqArchivePath + File.separator + OUT + "-sequence" : seqArchivePath + File.separator + OUT + "-sequence" + File.separator + "Custom";
                if (!CommonUtil.checkFileExistence((String)individualSequenceExportPath)) {
                    CommonUtil.createDirectory((String)individualSequenceExportPath);
                }
                ExportUtils.writeSequenceToArchive(outSequenceMediation.getConfig(), individualSequenceExportPath, outSequenceMediation.getName());
            }
            if (faultSequenceMediation != null) {
                individualSequenceExportPath = faultSequenceMediation.isGlobal() ? seqArchivePath + File.separator + "fault" + "-sequence" : seqArchivePath + File.separator + "fault" + "-sequence" + File.separator + "Custom";
                if (!CommonUtil.checkFileExistence((String)individualSequenceExportPath)) {
                    CommonUtil.createDirectory((String)individualSequenceExportPath);
                }
                ExportUtils.writeSequenceToArchive(faultSequenceMediation.getConfig(), individualSequenceExportPath, faultSequenceMediation.getName());
            }
        }
    }

    private static void addMultipleAPISpecificSequencesToArchive(String archivePath, API api, APIProvider apiProvider) throws APIManagementException, APIImportExportException {
        List apiSpecificMediationList;
        String seqArchivePath = archivePath.concat(File.separator + "Sequences");
        String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        if (!CommonUtil.checkFileExistence((String)seqArchivePath)) {
            CommonUtil.createDirectory((String)seqArchivePath);
        }
        if (!(apiSpecificMediationList = apiProvider.getAllApiSpecificMediationPolicies(api.getUuid(), tenantDomain)).isEmpty()) {
            for (Mediation mediation : apiSpecificMediationList) {
                Mediation mediationResource = apiProvider.getApiSpecificMediationPolicyByPolicyId(api.getUuid(), mediation.getUuid(), tenantDomain);
                String individualSequenceExportPath = seqArchivePath + File.separator + mediation.getType().toLowerCase() + "-sequence" + File.separator + "Custom";
                if (!CommonUtil.checkFileExistence((String)individualSequenceExportPath)) {
                    CommonUtil.createDirectory((String)individualSequenceExportPath);
                }
                ExportUtils.writeSequenceToArchive(mediationResource.getConfig(), individualSequenceExportPath, mediation.getName());
            }
        }
    }

    private static void writeSequenceToArchive(String mediation, String individualSequenceExportPath, String mediationName) throws APIManagementException {
        String mediationFilePath = individualSequenceExportPath + File.separator + mediationName + "." + "xml";
        if (StringUtils.isNotBlank((CharSequence)mediation) && !CommonUtil.checkFileExistence((String)mediationFilePath)) {
            try (FileOutputStream outputStream = new FileOutputStream(mediationFilePath);
                 ByteArrayInputStream fileInputStream = new ByteArrayInputStream(mediation.getBytes());){
                IOUtils.copy((InputStream)fileInputStream, (OutputStream)outputStream);
            }
            catch (IOException e) {
                throw new APIManagementException("Error while writing the mediation sequence" + mediationName + "to file", (Throwable)e);
            }
        }
    }

    public static void addEndpointCertificatesToArchive(String archivePath, APIDTO apiDto, int tenantId, ExportFormat exportFormat) throws APIImportExportException {
        HashSet<String> uniqueEndpointURLs = new HashSet<String>();
        JsonArray endpointCertificatesDetails = new JsonArray();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String endpointConfigString = gson.toJson(apiDto.getEndpointConfig());
        String endpointCertsDirectoryPath = archivePath + File.separator + "Endpoint-certificates";
        CommonUtil.createDirectory((String)endpointCertsDirectoryPath);
        if (StringUtils.isEmpty((CharSequence)endpointConfigString) || "null".equals(endpointConfigString)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Endpoint Details are empty for API: " + apiDto.getName() + " " + "version" + ": " + apiDto.getVersion()));
            }
            return;
        }
        try {
            JSONTokener tokener = new JSONTokener(endpointConfigString);
            JSONObject endpointConfig = new JSONObject(tokener);
            List<String> productionEndpoints = ExportUtils.getEndpointURLs(endpointConfig, "production_endpoints", apiDto.getName());
            List<String> sandboxEndpoints = ExportUtils.getEndpointURLs(endpointConfig, "sandbox_endpoints", apiDto.getName());
            uniqueEndpointURLs.addAll(productionEndpoints);
            uniqueEndpointURLs.addAll(sandboxEndpoints);
            for (String url : uniqueEndpointURLs) {
                JsonArray certificateListOfUrl = ExportUtils.getEndpointCertificateContentAndMetaData(tenantId, url, endpointCertsDirectoryPath);
                endpointCertificatesDetails.addAll(certificateListOfUrl);
            }
            if (endpointCertificatesDetails.size() > 0) {
                CommonUtil.writeDtoToFile((String)(endpointCertsDirectoryPath + ImportExportConstants.ENDPOINTS_CERTIFICATE_FILE), (ExportFormat)exportFormat, (String)"endpoint_certificates", (Object)endpointCertificatesDetails);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("No endpoint certificates available for API: " + apiDto.getName() + " " + "version" + ": " + apiDto.getVersion() + ". Skipping certificate export."));
            }
        }
        catch (JSONException e) {
            throw new APIImportExportException("Error in converting Endpoint config to JSON object in API: " + apiDto.getName(), (Throwable)e);
        }
        catch (IOException e) {
            throw new APIImportExportException("Error while retrieving saving endpoint certificate details for API: " + apiDto.getName() + " as YAML", (Throwable)e);
        }
    }

    public static void addGatewayEnvironmentsToArchive(String archivePath, String apiID, ExportFormat exportFormat, APIProvider apiProvider) throws APIManagementException {
        try {
            List deploymentsList = apiProvider.getAPIRevisionDeploymentList(apiID);
            JsonArray deploymentsArray = new JsonArray();
            for (APIRevisionDeployment deployment : deploymentsList) {
                JsonObject deploymentObject = new JsonObject();
                deploymentObject.addProperty("deploymentEnvironment", deployment.getDeployment());
                deploymentObject.addProperty("displayOnDevportal", Boolean.valueOf(deployment.isDisplayOnDevportal()));
                deploymentsArray.add((JsonElement)deploymentObject);
            }
            if (deploymentsArray.size() > 0) {
                CommonUtil.writeDtoToFile((String)(archivePath + ImportExportConstants.DEPLOYMENT_INFO_LOCATION), (ExportFormat)exportFormat, (String)"deployment_environments", (Object)deploymentsArray);
            }
        }
        catch (APIImportExportException e) {
            throw new APIManagementException("Error in converting deployment environment details to JSON object in API: " + apiID, (Throwable)e);
        }
        catch (IOException e) {
            throw new APIManagementException("Error while saving deployment environment details for API: " + apiID + " as YAML", (Throwable)e);
        }
    }

    private static JsonArray getEndpointCertificateContentAndMetaData(int tenantId, String url, String certDirectoryPath) throws APIImportExportException {
        List certificateMetadataDTOS;
        CertificateManagerImpl certificateManager = CertificateManagerImpl.getInstance();
        try {
            certificateMetadataDTOS = certificateManager.getCertificates(tenantId, null, url);
        }
        catch (APIManagementException e) {
            throw new APIImportExportException("Error retrieving certificate meta data. For tenantId: " + tenantId + " hostname: " + url, (Throwable)e);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonArray certificatesList = new JsonArray();
        certificateMetadataDTOS.forEach(arg_0 -> ExportUtils.lambda$getEndpointCertificateContentAndMetaData$0((CertificateManager)certificateManager, certDirectoryPath, gson, certificatesList, tenantId, url, arg_0));
        return certificatesList;
    }

    private static List<String> getEndpointURLs(JSONObject endpointConfig, String type, String apiName) throws APIImportExportException {
        ArrayList<String> urls = new ArrayList<String>();
        if (endpointConfig != null) {
            try {
                if (endpointConfig.has(type)) {
                    Object item = endpointConfig.get(type);
                    if (item instanceof JSONArray) {
                        JSONArray endpointsJSON = new JSONArray(endpointConfig.getJSONArray(type).toString());
                        for (int i = 0; i < endpointsJSON.length(); ++i) {
                            try {
                                String urlValue = endpointsJSON.getJSONObject(i).get("url").toString();
                                urls.add(urlValue);
                                continue;
                            }
                            catch (JSONException ex) {
                                log.error((Object)("Endpoint URL extraction from endpoints JSON object failed in API: " + apiName), (Throwable)ex);
                            }
                        }
                    } else if (item instanceof JSONObject) {
                        JSONObject endpointJSON = new JSONObject(endpointConfig.getJSONObject(type).toString());
                        try {
                            String urlValue = endpointJSON.get("url").toString();
                            urls.add(urlValue);
                        }
                        catch (JSONException ex) {
                            log.error((Object)("Endpoint URL extraction from endpoint JSON object failed in API: " + apiName), (Throwable)ex);
                        }
                    }
                }
            }
            catch (JSONException ex) {
                throw new APIImportExportException("Endpoint type: " + type + " not found in API: " + apiName);
            }
        }
        return urls;
    }

    public static void addAPIMetaInformationToArchive(String archivePath, APIDTO apiDtoToReturn, ExportFormat exportFormat, APIProvider apiProvider, APIIdentifier apiIdentifier) throws APIImportExportException {
        CommonUtil.createDirectory((String)(archivePath + File.separator + "Definitions"));
        try {
            String apiType = apiDtoToReturn.getType().toString();
            if (!PublisherCommonUtils.isStreamingAPI(apiDtoToReturn)) {
                if (StringUtils.equals((CharSequence)apiType, (CharSequence)APIConstants.APITransportType.GRAPHQL.toString())) {
                    String schemaContent = apiProvider.getGraphqlSchema(apiIdentifier);
                    CommonUtil.writeFile((String)(archivePath + ImportExportConstants.GRAPHQL_SCHEMA_DEFINITION_LOCATION), (String)schemaContent);
                    GraphqlComplexityInfo graphqlComplexityInfo = apiProvider.getComplexityDetails(apiIdentifier);
                    if (graphqlComplexityInfo.getList().size() != 0) {
                        GraphQLQueryComplexityInfoDTO graphQLQueryComplexityInfoDTO = GraphqlQueryAnalysisMappingUtil.fromGraphqlComplexityInfotoDTO(graphqlComplexityInfo);
                        CommonUtil.writeDtoToFile((String)(archivePath + ImportExportConstants.GRAPHQL_COMPLEXITY_INFO_LOCATION), (ExportFormat)exportFormat, (String)"graphql-complexity", (Object)graphQLQueryComplexityInfoDTO);
                    }
                }
                if (!APIConstants.APITransportType.GRAPHQL.toString().equalsIgnoreCase(apiType)) {
                    String formattedSwaggerJson = RestApiCommonUtil.retrieveSwaggerDefinition((API)APIMappingUtil.fromDTOtoAPI(apiDtoToReturn, apiDtoToReturn.getProvider()), (APIProvider)apiProvider);
                    CommonUtil.writeToYamlOrJson((String)(archivePath + ImportExportConstants.SWAGGER_DEFINITION_LOCATION), (ExportFormat)exportFormat, (String)formattedSwaggerJson);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Meta information retrieved successfully for API: " + apiDtoToReturn.getName() + " " + "version" + ": " + apiDtoToReturn.getVersion()));
                }
            } else {
                String asyncApiJson = new AsyncApiParser().generateAsyncAPIDefinition(APIMappingUtil.fromDTOtoAPI(apiDtoToReturn, apiDtoToReturn.getProvider()));
                CommonUtil.writeToYamlOrJson((String)(archivePath + ImportExportConstants.ASYNCAPI_DEFINITION_LOCATION), (ExportFormat)exportFormat, (String)asyncApiJson);
            }
            CommonUtil.writeDtoToFile((String)(archivePath + ImportExportConstants.API_FILE_LOCATION), (ExportFormat)exportFormat, (String)"api", (Object)apiDtoToReturn);
        }
        catch (APIManagementException e) {
            throw new APIImportExportException("Error while retrieving Swagger definition for API: " + apiDtoToReturn.getName() + " " + "version" + ": " + apiDtoToReturn.getVersion(), (Throwable)e);
        }
        catch (IOException e) {
            throw new APIImportExportException("Error while retrieving saving as YAML for API: " + apiDtoToReturn.getName() + " " + "version" + ": " + apiDtoToReturn.getVersion(), (Throwable)e);
        }
    }

    public static void addClientCertificatesToArchive(String archivePath, Identifier identifier, int tenantId, APIProvider provider, ExportFormat exportFormat) throws APIImportExportException {
        try {
            List certificateMetadataDTOs = identifier instanceof APIProductIdentifier ? provider.searchClientCertificates(tenantId, null, (APIProductIdentifier)identifier) : provider.searchClientCertificates(tenantId, null, (APIIdentifier)identifier);
            if (!certificateMetadataDTOs.isEmpty()) {
                String clientCertsDirectoryPath = archivePath + File.separator + "Client-certificates";
                CommonUtil.createDirectory((String)clientCertsDirectoryPath);
                JsonArray certificateList = ExportUtils.getClientCertificateContentAndMetaData(certificateMetadataDTOs, clientCertsDirectoryPath);
                if (certificateList.size() > 0) {
                    CommonUtil.writeDtoToFile((String)(clientCertsDirectoryPath + ImportExportConstants.CLIENT_CERTIFICATE_FILE), (ExportFormat)exportFormat, (String)"client_certificates", (Object)certificateList);
                }
            }
        }
        catch (IOException e) {
            throw new APIImportExportException("Error while saving as YAML or JSON", (Throwable)e);
        }
        catch (APIManagementException e) {
            throw new APIImportExportException("Error retrieving certificate meta data. tenantId [" + tenantId + "] api [" + tenantId + "]", (Throwable)e);
        }
    }

    private static JsonArray getClientCertificateContentAndMetaData(List<ClientCertificateDTO> clientCertificateDTOs, String certDirectoryPath) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonArray certificatesList = new JsonArray();
        clientCertificateDTOs.forEach(metadataDTO -> {
            try {
                String certificateContent = metadataDTO.getCertificate();
                String certificateContentEncoded = "-----BEGIN CERTIFICATE-----\n".concat(certificateContent).concat("\n").concat("-----END CERTIFICATE-----");
                CommonUtil.writeFile((String)(certDirectoryPath + File.separator + metadataDTO.getAlias() + ".crt"), (String)certificateContentEncoded);
                metadataDTO.setCertificate(metadataDTO.getAlias() + ".crt");
                JsonObject certificateMetadata = (JsonObject)gson.toJsonTree(metadataDTO);
                certificatesList.add((JsonElement)certificateMetadata);
            }
            catch (APIImportExportException e) {
                log.error((Object)("Error while writing the certificate content. For alias: " + metadataDTO.getAlias()), (Throwable)e);
            }
        });
        return certificatesList;
    }

    public static void addAPIProductMetaInformationToArchive(String archivePath, APIProductDTO apiProductDtoToReturn, ExportFormat exportFormat, APIProvider apiProvider) throws APIImportExportException {
        CommonUtil.createDirectory((String)(archivePath + File.separator + "Definitions"));
        try {
            String formattedSwaggerJson = apiProvider.getAPIDefinitionOfAPIProduct(APIMappingUtil.fromDTOtoAPIProduct(apiProductDtoToReturn, apiProductDtoToReturn.getProvider()));
            CommonUtil.writeToYamlOrJson((String)(archivePath + ImportExportConstants.SWAGGER_DEFINITION_LOCATION), (ExportFormat)exportFormat, (String)formattedSwaggerJson);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Meta information retrieved successfully for API Product: " + apiProductDtoToReturn.getName()));
            }
            CommonUtil.writeDtoToFile((String)(archivePath + ImportExportConstants.API_PRODUCT_FILE_LOCATION), (ExportFormat)exportFormat, (String)"api_product", (Object)apiProductDtoToReturn);
        }
        catch (APIManagementException e) {
            throw new APIImportExportException("Error while retrieving Swagger definition for API Product: " + apiProductDtoToReturn.getName(), (Throwable)e);
        }
        catch (IOException e) {
            throw new APIImportExportException("Error while saving as YAML for API Product: " + apiProductDtoToReturn.getName(), (Throwable)e);
        }
    }

    public static void addDependentAPIsToArchive(String archivePath, APIProductDTO apiProductDtoToReturn, ExportFormat exportFormat, APIProvider provider, String userName, Boolean isStatusPreserved, boolean preserveDocs, boolean preserveCredentials) throws APIImportExportException, APIManagementException {
        String apisDirectoryPath = archivePath + File.separator + "APIs";
        CommonUtil.createDirectory((String)apisDirectoryPath);
        List<ProductAPIDTO> apisList = apiProductDtoToReturn.getApis();
        for (ProductAPIDTO productAPIDTO : apisList) {
            String apiProductRequesterDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
            API api = provider.getAPIbyUUID(productAPIDTO.getApiId(), apiProductRequesterDomain);
            APIDTO apiDtoToReturn = APIMappingUtil.fromAPItoDTO(api, preserveCredentials, null);
            File dependentAPI = ExportUtils.exportApi(provider, api.getId(), apiDtoToReturn, api, userName, exportFormat, isStatusPreserved, preserveDocs, "");
            CommonUtil.extractArchive((File)dependentAPI, (String)apisDirectoryPath);
        }
    }

    private static /* synthetic */ void lambda$getEndpointCertificateContentAndMetaData$0(CertificateManager certificateManager, String certDirectoryPath, Gson gson, JsonArray certificatesList, int tenantId, String url, CertificateMetadataDTO metadataDTO) {
        try (ByteArrayInputStream certificate = certificateManager.getCertificateContent(metadataDTO.getAlias());){
            byte[] certificateContent = IOUtils.toByteArray((InputStream)certificate);
            String certificateContentEncoded = "-----BEGIN CERTIFICATE-----\n".concat(new String(Base64.encodeBase64((byte[])certificateContent))).concat("\n").concat("-----END CERTIFICATE-----");
            CommonUtil.writeFile((String)(certDirectoryPath + File.separator + metadataDTO.getAlias() + ".crt"), (String)certificateContentEncoded);
            JsonObject modifiedCertificateMetadata = (JsonObject)gson.toJsonTree((Object)metadataDTO);
            modifiedCertificateMetadata.addProperty("certificate", metadataDTO.getAlias() + ".crt");
            certificatesList.add((JsonElement)modifiedCertificateMetadata);
        }
        catch (APIManagementException e) {
            log.error((Object)("Error retrieving certificate content. For tenantId: " + tenantId + " hostname: " + url + " alias: " + metadataDTO.getAlias()), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Error while converting certificate content to Byte Array. For tenantId: " + tenantId + " hostname: " + url + " alias: " + metadataDTO.getAlias()), (Throwable)e);
        }
        catch (APIImportExportException e) {
            log.error((Object)("Error while writing the certificate content. For tenantId: " + tenantId + " hostname: " + url + " alias: " + metadataDTO.getAlias()), (Throwable)e);
        }
    }
}

