/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.wso2.carbon.apimgt.api.model.Environment;
import org.wso2.carbon.apimgt.api.model.VHost;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.EnvironmentDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.EnvironmentListDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.VHostDTO;

public class EnvironmentMappingUtil {
    public static EnvironmentDTO fromEnvironmentToDTO(Environment environment) {
        EnvironmentDTO environmentDTO = new EnvironmentDTO();
        environmentDTO.setName(environment.getName());
        environmentDTO.setDisplayName(environment.getDisplayName());
        environmentDTO.setType(environment.getType());
        environmentDTO.setServerUrl(environment.getServerURL());
        environmentDTO.setShowInApiConsole(environment.isShowInConsole());
        environmentDTO.setVhosts(environment.getVhosts().stream().map(EnvironmentMappingUtil::fromVHostToVHostDTO).collect(Collectors.toList()));
        return environmentDTO;
    }

    public static EnvironmentListDTO fromEnvironmentCollectionToDTO(Collection<Environment> environmentCollection) {
        EnvironmentListDTO environmentListDTO = new EnvironmentListDTO();
        List<EnvironmentDTO> environmentDTOs = environmentListDTO.getList();
        if (environmentDTOs == null) {
            environmentDTOs = new ArrayList<EnvironmentDTO>();
            environmentListDTO.setList(environmentDTOs);
        }
        for (Environment environment : environmentCollection) {
            environmentDTOs.add(EnvironmentMappingUtil.fromEnvironmentToDTO(environment));
        }
        environmentListDTO.setCount(environmentDTOs.size());
        return environmentListDTO;
    }

    public static VHostDTO fromVHostToVHostDTO(VHost vHost) {
        VHostDTO vHostDTO = new VHostDTO();
        vHostDTO.setHost(vHost.getHost());
        vHostDTO.setHttpContext(vHost.getHttpContext());
        vHostDTO.setHttpPort(vHost.getHttpPort());
        vHostDTO.setHttpsPort(vHost.getHttpsPort());
        vHostDTO.setWsPort(vHost.getWsPort());
        vHostDTO.setWssPort(vHost.getWssPort());
        vHostDTO.setWebsubHttpPort(vHost.getWebsubHttpPort());
        vHostDTO.setWebsubHttpsPort(vHost.getWebsubHttpsPort());
        return vHostDTO;
    }

    private static boolean isHttpURL(String url) {
        return url.matches("^http://.*");
    }

    private static boolean isHttpsURL(String url) {
        return url.matches("^https://.*");
    }

    private static boolean isWebSocketURL(String url) {
        return url.matches("^ws://.*");
    }

    private static boolean isSecureWebsocketURL(String url) {
        return url.matches("^wss://.*");
    }
}

