/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.apimgt.api.model.Documentation;
import org.wso2.carbon.apimgt.api.model.DocumentationType;
import org.wso2.carbon.apimgt.rest.api.common.RestApiCommonUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.CommonMappingUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.DocumentDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.DocumentListDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.PaginationDTO;

public class DocumentationMappingUtil {
    public static DocumentDTO fromDocumentationToDTO(Documentation documentation) {
        DocumentDTO documentDTO = new DocumentDTO();
        documentDTO.setDocumentId(documentation.getId());
        documentDTO.setName(documentation.getName());
        documentDTO.setSummary(documentation.getSummary());
        documentDTO.setType(DocumentDTO.TypeEnum.fromValue(documentation.getType().toString()));
        documentDTO.setOtherTypeName(documentation.getOtherTypeName());
        documentDTO.setFileName(documentation.getFilePath());
        if (documentation.getSourceType() != null) {
            documentDTO.setSourceType(DocumentDTO.SourceTypeEnum.fromValue(documentation.getSourceType().toString()));
        }
        documentDTO.setSourceUrl(documentation.getSourceUrl());
        if (documentation.getVisibility() != null) {
            documentDTO.setVisibility(DocumentDTO.VisibilityEnum.fromValue(documentation.getVisibility().toString()));
        }
        return documentDTO;
    }

    public static Documentation fromDTOtoDocumentation(DocumentDTO documentDTO) {
        Documentation documentation = new Documentation(DocumentationType.valueOf((String)documentDTO.getType().toString()), documentDTO.getName());
        documentation.setSummary(documentDTO.getSummary());
        if (documentDTO.getSourceType() != null) {
            documentation.setSourceType(Documentation.DocumentSourceType.valueOf((String)documentDTO.getSourceType().toString()));
        }
        documentation.setSourceUrl(documentDTO.getSourceUrl());
        documentation.setOtherTypeName(documentDTO.getOtherTypeName());
        documentation.setFilePath(documentDTO.getFileName());
        if (documentDTO.getVisibility() != null) {
            documentation.setVisibility(Documentation.DocumentVisibility.valueOf((String)documentDTO.getVisibility().toString()));
        }
        return documentation;
    }

    public static DocumentListDTO fromDocumentationListToDTO(List<Documentation> documentations, int offset, int limit) {
        DocumentListDTO documentListDTO = new DocumentListDTO();
        List<DocumentDTO> documentDTOs = documentListDTO.getList();
        if (documentDTOs == null) {
            documentDTOs = new ArrayList<DocumentDTO>();
            documentListDTO.setList(documentDTOs);
        }
        int start = offset < documentations.size() && offset >= 0 ? offset : Integer.MAX_VALUE;
        int end = offset + limit - 1 <= documentations.size() - 1 ? offset + limit - 1 : documentations.size() - 1;
        for (int i = start; i <= end; ++i) {
            documentDTOs.add(DocumentationMappingUtil.fromDocumentationToDTO(documentations.get(i)));
        }
        documentListDTO.setCount(documentDTOs.size());
        return documentListDTO;
    }

    public static void setPaginationParams(DocumentListDTO documentListDTO, String apiId, int offset, int limit, int size) {
        Map paginatedParams = RestApiCommonUtil.getPaginationParams((Integer)offset, (Integer)limit, (Integer)size);
        String paginatedPrevious = "";
        String paginatedNext = "";
        if (paginatedParams.get("previous_offset") != null) {
            paginatedPrevious = RestApiCommonUtil.getDocumentationPaginatedURL((Integer)((Integer)paginatedParams.get("previous_offset")), (Integer)((Integer)paginatedParams.get("previous_limit")), (String)apiId);
        }
        if (paginatedParams.get("next_offset") != null) {
            paginatedNext = RestApiCommonUtil.getDocumentationPaginatedURL((Integer)((Integer)paginatedParams.get("next_offset")), (Integer)((Integer)paginatedParams.get("next_limit")), (String)apiId);
        }
        PaginationDTO paginationDTO = CommonMappingUtil.getPaginationDTO(limit, offset, size, paginatedNext, paginatedPrevious);
        documentListDTO.setPagination(paginationDTO);
    }

    public static void setProductDocListPaginationParams(DocumentListDTO documentListDTO, String productId, int offset, int limit, int size) {
        Map paginatedParams = RestApiCommonUtil.getPaginationParams((Integer)offset, (Integer)limit, (Integer)size);
        String paginatedPrevious = "";
        String paginatedNext = "";
        if (paginatedParams.get("previous_offset") != null) {
            paginatedPrevious = RestApiCommonUtil.getProductDocumentPaginatedURL((Integer)((Integer)paginatedParams.get("previous_limit")), (Integer)((Integer)paginatedParams.get("previous_offset")), (String)productId);
        }
        if (paginatedParams.get("next_offset") != null) {
            paginatedNext = RestApiCommonUtil.getProductDocumentPaginatedURL((Integer)((Integer)paginatedParams.get("next_offset")), (Integer)((Integer)paginatedParams.get("next_limit")), (String)productId);
        }
        PaginationDTO paginationDTO = CommonMappingUtil.getPaginationDTO(limit, offset, size, paginatedNext, paginatedPrevious);
        documentListDTO.setPagination(paginationDTO);
    }
}

