/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.Comment;
import org.wso2.carbon.apimgt.api.model.CommentList;
import org.wso2.carbon.apimgt.impl.APIConstants;
import org.wso2.carbon.apimgt.impl.utils.APIRealmUtils;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.CommentDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.CommentListDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.CommenterInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.PaginationDTO;

public class CommentMappingUtil {
    private static final Logger log = LoggerFactory.getLogger(CommentMappingUtil.class);

    public static CommentDTO fromCommentToDTO(Comment comment) throws APIManagementException {
        CommentDTO commentDTO = new CommentDTO();
        commentDTO.setId(comment.getId());
        commentDTO.setContent(comment.getText());
        commentDTO.setCreatedBy(comment.getUser());
        commentDTO.setCreatedTime(comment.getCreatedTime().toString());
        if (comment.getUpdatedTime() != null) {
            commentDTO.setUpdatedTime(comment.getUpdatedTime().toString());
        }
        commentDTO.setCategory(comment.getCategory());
        commentDTO.setParentCommentId(comment.getParentCommentID());
        if (APIConstants.CommentEntryPoint.DEVPORTAL.toString().equals(comment.getEntryPoint())) {
            commentDTO.setEntryPoint(CommentDTO.EntryPointEnum.DEVPORTAL);
        } else if (APIConstants.CommentEntryPoint.PUBLISHER.toString().equals(comment.getEntryPoint())) {
            commentDTO.setEntryPoint(CommentDTO.EntryPointEnum.PUBLISHER);
        }
        commentDTO.setReplies(CommentMappingUtil.fromCommentListToDTO(comment.getReplies(), false));
        return commentDTO;
    }

    public static CommentDTO fromCommentToDTOWithUserInfo(Comment comment, Map<String, Map<String, String>> userClaimsMap) throws APIManagementException {
        CommentDTO commentDTO = CommentMappingUtil.fromCommentToDTO(comment);
        if (userClaimsMap.get(comment.getUser()) != null) {
            Map<String, String> userClaims = userClaimsMap.get(comment.getUser());
            CommenterInfoDTO commenterInfoDTO = new CommenterInfoDTO();
            commenterInfoDTO.setFullName(userClaims.get("http://wso2.org/claims/fullname"));
            commenterInfoDTO.setFirstName(userClaims.get("http://wso2.org/claims/givenname"));
            commenterInfoDTO.setLastName(userClaims.get("http://wso2.org/claims/lastname"));
            commentDTO.setCommenterInfo(commenterInfoDTO);
        }
        return commentDTO;
    }

    public static Map<String, Map<String, String>> retrieveUserClaims(String username, Map<String, Map<String, String>> userClaimsMap) throws APIManagementException {
        if (userClaimsMap.get(username) == null) {
            Map userClaims = APIRealmUtils.getUserClaims((String)username);
            userClaimsMap.put(username, userClaims);
        }
        return userClaimsMap;
    }

    public static Comment fromDTOToComment(CommentDTO body, String username, String apiId) {
        Comment comment = new Comment();
        comment.setText(body.getContent());
        comment.setUser(username);
        comment.setApiId(apiId);
        return comment;
    }

    public static CommentListDTO fromCommentListToDTO(CommentList commentList, boolean includeCommenterInfo) {
        CommentListDTO commentListDTO = new CommentListDTO();
        ArrayList<CommentDTO> listOfCommentDTOs = new ArrayList<CommentDTO>();
        commentListDTO.setCount(commentList.getCount());
        PaginationDTO paginationDTO = new PaginationDTO();
        paginationDTO.setLimit(commentList.getPagination().getLimit());
        paginationDTO.setOffset(commentList.getPagination().getOffset());
        paginationDTO.setTotal(commentList.getPagination().getTotal());
        paginationDTO.setNext(commentList.getPagination().getNext());
        paginationDTO.setPrevious(commentList.getPagination().getPrevious());
        commentListDTO.setPagination(paginationDTO);
        Map<String, Map<String, String>> userClaimsMap = new HashMap<String, Map<String, String>>();
        for (Comment comment : commentList.getList()) {
            try {
                if (includeCommenterInfo) {
                    userClaimsMap = CommentMappingUtil.retrieveUserClaims(comment.getUser(), userClaimsMap);
                    listOfCommentDTOs.add(CommentMappingUtil.fromCommentToDTOWithUserInfo(comment, userClaimsMap));
                    continue;
                }
                listOfCommentDTOs.add(CommentMappingUtil.fromCommentToDTO(comment));
            }
            catch (APIManagementException e) {
                log.error("Error while creating comments list", (Throwable)e);
            }
        }
        commentListDTO.setList(listOfCommentDTOs);
        return commentListDTO;
    }
}

