/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings;

import com.nimbusds.jose.util.StandardCharset;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIMgtResourceNotFoundException;
import org.wso2.carbon.apimgt.api.APIProvider;
import org.wso2.carbon.apimgt.api.ErrorHandler;
import org.wso2.carbon.apimgt.api.ExceptionCodes;
import org.wso2.carbon.apimgt.api.dto.CertificateMetadataDTO;
import org.wso2.carbon.apimgt.api.dto.ClientCertificateDTO;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.rest.api.common.RestApiCommonUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.CertMetadataDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.CertificatesDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ClientCertMetadataDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ClientCertificatesDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.PaginationDTO;

public class CertificateRestApiUtils {
    private static final Log log = LogFactory.getLog(CertificateRestApiUtils.class);

    public static String generateEncodedCertificate(InputStream certificateInputStream) throws IOException {
        byte[] certificateBytes = IOUtils.toByteArray((InputStream)certificateInputStream);
        byte[] encodedCert = Base64.encodeBase64((byte[])certificateBytes);
        return new String(encodedCert, StandardCharset.UTF_8);
    }

    public static ByteArrayInputStream getDecodedCertificate(String certificate) throws APIManagementException {
        byte[] cert = Base64.decodeBase64((byte[])certificate.getBytes(StandardCharsets.UTF_8));
        ByteArrayInputStream serverCert = new ByteArrayInputStream(cert);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            if (serverCert.available() > 0) {
                Certificate generatedCertificate = cf.generateCertificate(serverCert);
                X509Certificate x509Certificate = (X509Certificate)generatedCertificate;
                return new ByteArrayInputStream(x509Certificate.getEncoded());
            }
        }
        catch (CertificateException e) {
            throw new APIManagementException("Error while decoding the certificate", (Throwable)e);
        }
        return null;
    }

    public static CertificatesDTO getPaginatedCertificates(List<CertificateMetadataDTO> certificateMetadataList, int limit, int offset, String query) {
        int start;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Filter the certificates based on the pagination parameters, limit = %d and offset = %d", limit, offset));
        }
        int certCount = certificateMetadataList.size();
        ArrayList<CertMetadataDTO> certificateList = new ArrayList<CertMetadataDTO>();
        CertificatesDTO certificatesDTO = new CertificatesDTO();
        certificatesDTO.setCount(certCount > limit ? limit : certCount);
        if (offset > certCount) {
            offset = 0;
        }
        int end = certCount > (start = offset) + limit ? start + limit : certCount;
        for (int i = start; i < end; ++i) {
            CertMetadataDTO certMetadataDTO = new CertMetadataDTO();
            CertificateMetadataDTO certificateMetadataDTO = certificateMetadataList.get(i);
            certMetadataDTO.setAlias(certificateMetadataDTO.getAlias());
            certMetadataDTO.setEndpoint(certificateMetadataDTO.getEndpoint());
            certificateList.add(certMetadataDTO);
        }
        Map paginatedParams = RestApiCommonUtil.getPaginationParams((Integer)offset, (Integer)limit, (Integer)certCount);
        String paginatedPrevious = "";
        String paginatedNext = "";
        if (paginatedParams.get("previous_offset") != null) {
            paginatedPrevious = CertificateRestApiUtils.getCertificatesPaginatedURL("/certificates?limit={limit}&offset={offset}{query}", (Integer)paginatedParams.get("previous_offset"), (Integer)paginatedParams.get("previous_limit"), query);
        }
        if (paginatedParams.get("next_offset") != null) {
            paginatedNext = CertificateRestApiUtils.getCertificatesPaginatedURL("/certificates?limit={limit}&offset={offset}{query}", (Integer)paginatedParams.get("next_offset"), (Integer)paginatedParams.get("next_limit"), query);
        }
        PaginationDTO paginationDTO = new PaginationDTO();
        paginationDTO.setNext(paginatedNext);
        paginationDTO.setPrevious(paginatedPrevious);
        paginationDTO.setLimit(limit);
        paginationDTO.setOffset(offset);
        paginationDTO.setTotal(certCount);
        certificatesDTO.setCount(certificateList.size());
        certificatesDTO.setCertificates(certificateList);
        certificatesDTO.setPagination(paginationDTO);
        return certificatesDTO;
    }

    public static ClientCertificatesDTO getPaginatedClientCertificates(List<ClientCertificateDTO> clientCertificateDTOList, int limit, int offset, String query) {
        int start;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Filter the client certificates based on the pagination parameters, limit = %d andoffset = %d", limit, offset));
        }
        int certCount = clientCertificateDTOList.size();
        ArrayList<ClientCertMetadataDTO> clientCertificateList = new ArrayList<ClientCertMetadataDTO>();
        ClientCertificatesDTO certificatesDTO = new ClientCertificatesDTO();
        certificatesDTO.setCount(certCount > limit ? limit : certCount);
        if (offset > certCount) {
            offset = 0;
        }
        int end = certCount > (start = offset) + limit ? start + limit : certCount;
        for (int i = start; i < end; ++i) {
            ClientCertMetadataDTO clientCertMetadataDTO = new ClientCertMetadataDTO();
            ClientCertificateDTO clientCertificateDTO = clientCertificateDTOList.get(i);
            clientCertMetadataDTO.setAlias(clientCertificateDTO.getAlias());
            clientCertMetadataDTO.setApiId(clientCertificateDTO.getApiIdentifier().toString());
            clientCertMetadataDTO.setTier(clientCertificateDTO.getTierName());
            clientCertificateList.add(clientCertMetadataDTO);
        }
        Map paginatedParams = RestApiCommonUtil.getPaginationParams((Integer)offset, (Integer)limit, (Integer)certCount);
        String paginatedPrevious = "";
        String paginatedNext = "";
        if (paginatedParams.get("previous_offset") != null) {
            paginatedPrevious = CertificateRestApiUtils.getCertificatesPaginatedURL("/clientCertificates?limit={limit}&offset={offset}{query}", (Integer)paginatedParams.get("previous_offset"), (Integer)paginatedParams.get("previous_limit"), query);
        }
        if (paginatedParams.get("next_offset") != null) {
            paginatedNext = CertificateRestApiUtils.getCertificatesPaginatedURL("/clientCertificates?limit={limit}&offset={offset}{query}", (Integer)paginatedParams.get("next_offset"), (Integer)paginatedParams.get("next_limit"), query);
        }
        certificatesDTO.setCount(clientCertificateList.size());
        certificatesDTO.setCertificates(clientCertificateList);
        return certificatesDTO;
    }

    private static String getCertificatesPaginatedURL(String paginatedURL, Integer offset, Integer limit, String query) {
        paginatedURL = paginatedURL.replace("{limit}", String.valueOf(limit));
        paginatedURL = paginatedURL.replace("{offset}", String.valueOf(offset));
        paginatedURL = paginatedURL.replace("{query}", query);
        return paginatedURL;
    }

    public static String buildQueryString(String firstParamName, String firstParamValue, String secondParamName, String secondParamValue) {
        String query = "";
        if (StringUtils.isNotBlank((CharSequence)firstParamValue)) {
            query = query + "&" + firstParamName + "=" + firstParamValue;
        }
        if (StringUtils.isNotBlank((CharSequence)secondParamValue)) {
            query = query + "&" + secondParamName + "=" + secondParamValue;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("The query string for the api : %s", query));
        }
        return query;
    }

    public static ClientCertificateDTO preValidateClientCertificate(String alias, APIIdentifier apiIdentifier) throws APIManagementException {
        String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        int tenantId = APIUtil.getTenantIdFromTenantDomain((String)tenantDomain);
        if (StringUtils.isEmpty((CharSequence)alias)) {
            throw new APIManagementException("The alias cannot be empty", (ErrorHandler)ExceptionCodes.ALIAS_CANNOT_BE_EMPTY);
        }
        APIProvider apiProvider = RestApiCommonUtil.getLoggedInUserProvider();
        ClientCertificateDTO clientCertificate = apiProvider.getClientCertificate(tenantId, alias, apiIdentifier);
        if (clientCertificate == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Could not find a client certificate in truststore which belongs to tenant : %d and with alias : %s. Hence the operation is terminated.", tenantId, alias));
            }
            String message = "Certificate for alias '" + alias + "' is not found.";
            throw new APIMgtResourceNotFoundException(message);
        }
        return clientCertificate;
    }
}

