/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.asyncapi.models.AaiSecurityScheme;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20Document;
import io.apicurio.datamodels.core.models.Extension;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.apimgt.api.APIConsumer;
import org.wso2.carbon.apimgt.api.APIDefinition;
import org.wso2.carbon.apimgt.api.APIDefinitionValidationResponse;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIProvider;
import org.wso2.carbon.apimgt.api.ErrorHandler;
import org.wso2.carbon.apimgt.api.ExceptionCodes;
import org.wso2.carbon.apimgt.api.WorkflowStatus;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APICategory;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.api.model.APIProductIdentifier;
import org.wso2.carbon.apimgt.api.model.APIProductResource;
import org.wso2.carbon.apimgt.api.model.APIResourceMediationPolicy;
import org.wso2.carbon.apimgt.api.model.APIRevision;
import org.wso2.carbon.apimgt.api.model.APIRevisionDeployment;
import org.wso2.carbon.apimgt.api.model.APIStateChangeResponse;
import org.wso2.carbon.apimgt.api.model.APIStatus;
import org.wso2.carbon.apimgt.api.model.CORSConfiguration;
import org.wso2.carbon.apimgt.api.model.Identifier;
import org.wso2.carbon.apimgt.api.model.LifeCycleEvent;
import org.wso2.carbon.apimgt.api.model.Mediation;
import org.wso2.carbon.apimgt.api.model.ResourcePath;
import org.wso2.carbon.apimgt.api.model.Scope;
import org.wso2.carbon.apimgt.api.model.ServiceEntry;
import org.wso2.carbon.apimgt.api.model.Tier;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import org.wso2.carbon.apimgt.api.model.WebsubSubscriptionConfiguration;
import org.wso2.carbon.apimgt.impl.APIConstants;
import org.wso2.carbon.apimgt.impl.APIMRegistryServiceImpl;
import org.wso2.carbon.apimgt.impl.ServiceCatalogImpl;
import org.wso2.carbon.apimgt.impl.definitions.OASParserUtil;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.impl.wsdl.model.WSDLInfo;
import org.wso2.carbon.apimgt.impl.wsdl.model.WSDLValidationResponse;
import org.wso2.carbon.apimgt.rest.api.common.RestApiCommonUtil;
import org.wso2.carbon.apimgt.rest.api.common.dto.ErrorDTO;
import org.wso2.carbon.apimgt.rest.api.common.dto.ErrorListItemDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.CommonMappingUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIAdditionalPropertiesDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIBusinessInformationDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APICorsConfigurationDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIListDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIListExpandedDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIMaxTpsDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIMonetizationInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIOperationsDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIProductBusinessInformationDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIProductDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIProductInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIProductListDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIRevisionAPIInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIRevisionDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIRevisionDeploymentDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIRevisionDeploymentListDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIRevisionListDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIScopeDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIServiceInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.AdvertiseInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.AsyncAPISpecificationValidationResponseDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.AsyncAPISpecificationValidationResponseInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.LifecycleHistoryDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.LifecycleHistoryItemDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.LifecycleStateAvailableTransitionsDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.LifecycleStateCheckItemsDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.LifecycleStateDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.MediationPolicyDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.MockResponsePayloadInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.MockResponsePayloadListDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.OpenAPIDefinitionValidationResponseDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.OpenAPIDefinitionValidationResponseInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.PaginationDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ProductAPIDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ResourcePathDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ResourcePathListDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ResourcePolicyInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ResourcePolicyListDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ScopeDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.WSDLInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.WSDLValidationResponseDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.WSDLValidationResponseWsdlInfoDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.WSDLValidationResponseWsdlInfoEndpointsDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.WebsubSubscriptionConfigurationDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.WorkflowResponseDTO;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.governance.custom.lifecycles.checklist.util.CheckListItem;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class APIMappingUtil {
    private static final Log log = LogFactory.getLog(APIMappingUtil.class);

    public static API fromDTOtoAPI(APIDTO dto, String provider) throws APIManagementException {
        APICorsConfigurationDTO apiCorsConfigurationDTO;
        ObjectMapper objectMapper;
        APIBusinessInformationDTO apiBusinessInformationDTO;
        List<String> accessControlRoles;
        String context;
        String providerEmailDomainReplaced = APIUtil.replaceEmailDomain((String)provider);
        APIIdentifier apiId = new APIIdentifier(providerEmailDomainReplaced, dto.getName(), dto.getVersion());
        API model = new API(apiId);
        String originalContext = context = dto.getContext();
        if (context.endsWith("/{version}")) {
            context = context.replace("/{version}", "");
        }
        context = context.startsWith("/") ? context : "/" + context;
        String providerDomain = MultitenantUtils.getTenantDomain((String)provider);
        if (!"carbon.super".equalsIgnoreCase(providerDomain) && dto.getId() == null) {
            context = "/t/" + providerDomain + context;
        }
        context = APIMappingUtil.checkAndSetVersionParam(context);
        model.setContextTemplate(context);
        context = APIMappingUtil.updateContextWithVersion(dto.getVersion(), originalContext, context);
        model.setContext(context);
        model.setDescription(dto.getDescription());
        if (dto.getEndpointConfig() != null) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                model.setEndpointConfig(mapper.writeValueAsString(dto.getEndpointConfig()));
            }
            catch (IOException e) {
                APIUtil.handleException((String)"Error while converting endpointConfig to json", (Throwable)e);
            }
        }
        model.setImplementation(dto.getEndpointImplementationType().toString());
        model.setType(dto.getType().toString());
        if (dto.getLifeCycleStatus() != null) {
            model.setStatus(dto.getLifeCycleStatus() != null ? dto.getLifeCycleStatus().toUpperCase() : null);
        }
        if (dto.isIsDefaultVersion() != null) {
            model.setAsDefaultVersion(dto.isIsDefaultVersion().booleanValue());
        }
        if (dto.isEnableSchemaValidation() != null) {
            model.setEnableSchemaValidation(dto.isEnableSchemaValidation().booleanValue());
        }
        model.setEnableStore(true);
        if (dto.getAdvertiseInfo() != null) {
            AdvertiseInfoDTO advertiseInfoDTO = dto.getAdvertiseInfo();
            model.setAdvertiseOnly(advertiseInfoDTO.isAdvertised().booleanValue());
            model.setRedirectURL(advertiseInfoDTO.getOriginalDevPortalUrl());
            model.setApiOwner(advertiseInfoDTO.getApiOwner());
            model.setAdvertiseOnlyAPIVendor(dto.getAdvertiseInfo().getVendor().value());
        }
        if (dto.isResponseCachingEnabled() != null && dto.isResponseCachingEnabled().booleanValue()) {
            model.setResponseCache("Enabled");
        } else {
            model.setResponseCache("Disabled");
        }
        if (dto.getCacheTimeout() != null) {
            model.setCacheTimeout(dto.getCacheTimeout().intValue());
        } else {
            model.setCacheTimeout(300);
        }
        if (dto.getMediationPolicies() != null) {
            List<MediationPolicyDTO> policies = dto.getMediationPolicies();
            for (MediationPolicyDTO policy : policies) {
                if ("in".equalsIgnoreCase(policy.getType())) {
                    model.setInSequence(policy.getName());
                    continue;
                }
                if ("out".equalsIgnoreCase(policy.getType())) {
                    model.setOutSequence(policy.getName());
                    continue;
                }
                model.setFaultSequence(policy.getName());
            }
        }
        if (dto.getSubscriptionAvailability() != null) {
            model.setSubscriptionAvailability(APIMappingUtil.mapSubscriptionAvailabilityFromDTOtoAPI(dto.getSubscriptionAvailability()));
        }
        if (dto.getSubscriptionAvailableTenants() != null) {
            model.setSubscriptionAvailableTenants(StringUtils.join(dto.getSubscriptionAvailableTenants(), (String)","));
        }
        Set<Scope> scopes = APIMappingUtil.getScopes(dto);
        model.setScopes(scopes);
        Set<URITemplate> uriTemplates = APIMappingUtil.getURITemplates(model, dto.getOperations());
        model.setUriTemplates(uriTemplates);
        if (dto.getType().toString().equals("WS")) {
            HashMap<String, String> wsUriMapping = new HashMap<String, String>();
            for (APIOperationsDTO aPIOperationsDTO : dto.getOperations()) {
                wsUriMapping.put(aPIOperationsDTO.getVerb() + "_" + aPIOperationsDTO.getTarget(), aPIOperationsDTO.getUriMapping());
            }
            model.setWsUriMapping(wsUriMapping);
        }
        if (dto.getTags() != null) {
            HashSet<String> apiTags = new HashSet<String>(dto.getTags());
            model.addTags(apiTags);
        }
        HashSet<Tier> apiTiers = new HashSet<Tier>();
        List<String> tiersFromDTO = dto.getPolicies();
        for (String tier : tiersFromDTO) {
            apiTiers.add(new Tier(tier));
        }
        model.addAvailableTiers(apiTiers);
        model.setApiLevelPolicy(dto.getApiThrottlingPolicy());
        String string = StringUtils.join(dto.getTransport(), (char)',');
        model.setTransports(string);
        if (dto.getVisibility() != null) {
            model.setVisibility(APIMappingUtil.mapVisibilityFromDTOtoAPI(dto.getVisibility()));
        }
        if (dto.getVisibleRoles() != null) {
            String visibleRoles = StringUtils.join(dto.getVisibleRoles(), (char)',');
            model.setVisibleRoles(visibleRoles);
        }
        if (dto.getVisibleTenants() != null && APIUtil.isCrossTenantSubscriptionsEnabled()) {
            String visibleTenants = StringUtils.join(dto.getVisibleTenants(), (char)',');
            model.setVisibleTenants(visibleTenants);
        }
        if ((accessControlRoles = dto.getAccessControlRoles()) == null || accessControlRoles.isEmpty()) {
            model.setAccessControl("all");
            model.setAccessControlRoles("null");
        } else {
            model.setAccessControlRoles(StringUtils.join(accessControlRoles, (char)',').toLowerCase());
            model.setAccessControl("restricted");
        }
        List<APIAdditionalPropertiesDTO> additionalProperties = dto.getAdditionalProperties();
        if (additionalProperties != null) {
            for (APIAdditionalPropertiesDTO property : additionalProperties) {
                if (property.isDisplay().booleanValue()) {
                    model.addProperty(property.getName() + "__display", property.getValue());
                    continue;
                }
                model.addProperty(property.getName(), property.getValue());
            }
        }
        if ((apiBusinessInformationDTO = (APIBusinessInformationDTO)(objectMapper = new ObjectMapper()).convertValue((Object)dto.getBusinessInformation(), APIBusinessInformationDTO.class)) != null) {
            model.setBusinessOwner(apiBusinessInformationDTO.getBusinessOwner());
            model.setBusinessOwnerEmail(apiBusinessInformationDTO.getBusinessOwnerEmail());
            model.setTechnicalOwner(apiBusinessInformationDTO.getTechnicalOwner());
            model.setTechnicalOwnerEmail(apiBusinessInformationDTO.getTechnicalOwnerEmail());
        }
        CORSConfiguration corsConfiguration = (apiCorsConfigurationDTO = dto.getCorsConfiguration()) != null ? new CORSConfiguration(apiCorsConfigurationDTO.isCorsConfigurationEnabled().booleanValue(), apiCorsConfigurationDTO.getAccessControlAllowOrigins(), apiCorsConfigurationDTO.isAccessControlAllowCredentials().booleanValue(), apiCorsConfigurationDTO.getAccessControlAllowHeaders(), apiCorsConfigurationDTO.getAccessControlAllowMethods()) : APIUtil.getDefaultCorsConfiguration();
        model.setCorsConfiguration(corsConfiguration);
        APIMappingUtil.setMaxTpsFromApiDTOToModel(dto, model);
        model.setAuthorizationHeader(dto.getAuthorizationHeader());
        model.setApiSecurity(APIMappingUtil.getSecurityScheme(dto.getSecurityScheme()));
        if (dto.getType().toString().equals("WEBSUB")) {
            WebsubSubscriptionConfigurationDTO websubSubscriptionConfigurationDTO = dto.getWebsubSubscriptionConfiguration();
            WebsubSubscriptionConfiguration websubSubscriptionConfiguration = websubSubscriptionConfigurationDTO != null ? new WebsubSubscriptionConfiguration(websubSubscriptionConfigurationDTO.isEnable().booleanValue(), websubSubscriptionConfigurationDTO.getSecret(), websubSubscriptionConfigurationDTO.getSigningAlgorithm(), websubSubscriptionConfigurationDTO.getSignatureHeader()) : APIUtil.getDefaultWebsubSubscriptionConfiguration();
            model.setWebsubSubscriptionConfiguration(websubSubscriptionConfiguration);
        }
        APIMappingUtil.setAPICategoriesToModel(dto, model, provider);
        if (dto.getKeyManagers() instanceof List) {
            model.setKeyManagers((List)dto.getKeyManagers());
        } else if (dto.getKeyManagers() == null) {
            model.setKeyManagers(Collections.singletonList("all"));
        } else {
            throw new APIManagementException("KeyManagers value need to be an array");
        }
        APIServiceInfoDTO serviceInfoDTO = dto.getServiceInfo();
        if (serviceInfoDTO != null) {
            ObjectMapper mapper = new ObjectMapper();
            JSONParser parser = new JSONParser();
            String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
            try {
                int tenantId = ServiceReferenceHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomain);
                JSONObject serviceInfoJson = (JSONObject)parser.parse(mapper.writeValueAsString((Object)serviceInfoDTO));
                ServiceCatalogImpl serviceCatalog = new ServiceCatalogImpl();
                ServiceEntry service = serviceCatalog.getServiceByKey(dto.getServiceInfo().getKey(), tenantId);
                if (service == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("A service with key" + dto.getServiceInfo().getKey() + " referenced in the API information is not available in the service catalog"));
                    }
                } else {
                    serviceInfoJson.put((Object)"md5", (Object)service.getMd5());
                }
                model.setServiceInfo(serviceInfoJson);
            }
            catch (JsonProcessingException | ParseException e) {
                String msg = "Error while getting json representation of APIServiceInfo";
                APIUtil.handleException((String)msg, (Throwable)e);
            }
            catch (UserStoreException e) {
                String msg = "Error while getting tenantId from the given tenant domain " + tenantDomain;
                APIUtil.handleException((String)msg, (Throwable)e);
            }
        }
        return model;
    }

    public static MockResponsePayloadListDTO fromMockPayloadsToListDTO(List<APIResourceMediationPolicy> mockPayloads) throws APIManagementException {
        MockResponsePayloadListDTO mockResponsePayloadListDTO = new MockResponsePayloadListDTO();
        List<MockResponsePayloadInfoDTO> mockResponsePayloadInfoDTOS = mockResponsePayloadListDTO.getList();
        for (APIResourceMediationPolicy apiResourceMediationPolicy : mockPayloads) {
            mockResponsePayloadInfoDTOS.add(APIMappingUtil.fromMockPayloadToDTO(apiResourceMediationPolicy));
        }
        return mockResponsePayloadListDTO;
    }

    public static MockResponsePayloadInfoDTO fromMockPayloadToDTO(APIResourceMediationPolicy model) {
        MockResponsePayloadInfoDTO mockResponsePayloadInfoDTO = new MockResponsePayloadInfoDTO();
        mockResponsePayloadInfoDTO.setPath(model.getPath());
        mockResponsePayloadInfoDTO.setVerb(model.getVerb());
        mockResponsePayloadInfoDTO.setContent(model.getContent());
        return mockResponsePayloadInfoDTO;
    }

    public static APIMonetizationInfoDTO getMonetizationInfoDTO(APIIdentifier apiIdentifier) throws APIManagementException {
        APIProvider apiProvider = RestApiCommonUtil.getLoggedInUserProvider();
        API api = apiProvider.getAPI(apiIdentifier);
        APIMonetizationInfoDTO apiMonetizationInfoDTO = new APIMonetizationInfoDTO();
        apiMonetizationInfoDTO.setEnabled(api.getMonetizationStatus());
        HashMap<String, String> monetizationPropertiesMap = new HashMap<String, String>();
        if (api.getMonetizationProperties() != null) {
            JSONObject monetizationProperties = api.getMonetizationProperties();
            for (Object propertyKey : monetizationProperties.keySet()) {
                String key = (String)propertyKey;
                monetizationPropertiesMap.put(key, (String)monetizationProperties.get((Object)key));
            }
        }
        apiMonetizationInfoDTO.setProperties(monetizationPropertiesMap);
        return apiMonetizationInfoDTO;
    }

    public static APIMonetizationInfoDTO getMonetizationInfoDTO(APIProductIdentifier apiProductIdentifier) throws APIManagementException {
        APIProvider apiProvider = RestApiCommonUtil.getLoggedInUserProvider();
        APIProduct apiProduct = apiProvider.getAPIProduct(apiProductIdentifier);
        APIMonetizationInfoDTO apiMonetizationInfoDTO = new APIMonetizationInfoDTO();
        apiMonetizationInfoDTO.setEnabled(apiProduct.getMonetizationStatus());
        HashMap<String, String> monetizationPropertiesMap = new HashMap<String, String>();
        if (apiProduct.getMonetizationProperties() != null) {
            JSONObject monetizationProperties = apiProduct.getMonetizationProperties();
            for (Object propertyKey : monetizationProperties.keySet()) {
                String key = (String)propertyKey;
                monetizationPropertiesMap.put(key, (String)monetizationProperties.get((Object)key));
            }
        }
        apiMonetizationInfoDTO.setProperties(monetizationPropertiesMap);
        return apiMonetizationInfoDTO;
    }

    public static APIMonetizationInfoDTO getMonetizedTiersDTO(APIIdentifier apiIdentifier, Map<String, String> monetizedPoliciesToPlanMapping) throws APIManagementException {
        APIProvider apiProvider = RestApiCommonUtil.getLoggedInUserProvider();
        API api = apiProvider.getAPI(apiIdentifier);
        APIMonetizationInfoDTO apiMonetizationInfoDTO = new APIMonetizationInfoDTO();
        apiMonetizationInfoDTO.setEnabled(api.getMonetizationStatus());
        apiMonetizationInfoDTO.setProperties(monetizedPoliciesToPlanMapping);
        return apiMonetizationInfoDTO;
    }

    public static APIMonetizationInfoDTO getMonetizedTiersDTO(APIProductIdentifier apiProductIdentifier, Map<String, String> monetizedPoliciesToPlanMapping) throws APIManagementException {
        APIProvider apiProvider = RestApiCommonUtil.getLoggedInUserProvider();
        APIProduct apiProduct = apiProvider.getAPIProduct(apiProductIdentifier);
        APIMonetizationInfoDTO apiMonetizationInfoDTO = new APIMonetizationInfoDTO();
        apiMonetizationInfoDTO.setEnabled(apiProduct.getMonetizationStatus());
        apiMonetizationInfoDTO.setProperties(monetizedPoliciesToPlanMapping);
        return apiMonetizationInfoDTO;
    }

    public static APIIdentifier getAPIIdentifierFromUUID(String apiId) throws APIManagementException {
        return APIUtil.getAPIIdentifierFromUUID((String)apiId);
    }

    public static API getAPIInfoFromUUID(String apiUUID, String requestedTenantDomain) throws APIManagementException {
        APIProvider apiProvider = RestApiCommonUtil.getLoggedInUserProvider();
        API api = apiProvider.getLightweightAPIByUUID(apiUUID, requestedTenantDomain);
        return api;
    }

    public static Object fromAPIListToDTO(List<API> apiList, boolean expand) throws APIManagementException {
        if (expand) {
            return APIMappingUtil.fromAPIListToExpandedDTO(apiList);
        }
        return APIMappingUtil.fromAPIListToInfoDTO(apiList);
    }

    public static APIListDTO fromAPIListToInfoDTO(List<API> apiList) throws APIManagementException {
        APIListDTO apiListDTO = new APIListDTO();
        List<APIInfoDTO> apiInfoDTOs = apiListDTO.getList();
        for (API api : apiList) {
            apiInfoDTOs.add(APIMappingUtil.fromAPIToInfoDTO(api));
        }
        apiListDTO.setCount(apiInfoDTOs.size());
        return apiListDTO;
    }

    public static List<APIOperationsDTO> fromURITemplateListToOprationList(List<URITemplate> uriTemplateList) {
        int index = 0;
        ArrayList<APIOperationsDTO> operations = new ArrayList<APIOperationsDTO>();
        for (URITemplate uriTemplate : uriTemplateList) {
            uriTemplate.setId(index++);
            operations.add(APIMappingUtil.fromURITemplateToOperationList(uriTemplate));
        }
        return operations;
    }

    private static APIOperationsDTO fromURITemplateToOperationList(URITemplate uriTemplate) {
        APIOperationsDTO operation = new APIOperationsDTO();
        operation.setId(Integer.toString(uriTemplate.getId()));
        operation.setVerb(uriTemplate.getHTTPVerb());
        operation.setTarget(uriTemplate.getUriTemplate());
        return operation;
    }

    public static APIListExpandedDTO fromAPIListToExpandedDTO(List<API> apiList) throws APIManagementException {
        APIListExpandedDTO apiListDTO = new APIListExpandedDTO();
        List<APIDTO> apiInfoDTOs = apiListDTO.getList();
        for (API api : apiList) {
            apiInfoDTOs.add(APIMappingUtil.fromAPItoDTO(api));
        }
        apiListDTO.setCount(apiInfoDTOs.size());
        return apiListDTO;
    }

    public static APIInfoDTO fromAPIToInfoDTO(API api) {
        SimpleDateFormat dateFormat;
        APIInfoDTO apiInfoDTO = new APIInfoDTO();
        apiInfoDTO.setDescription(api.getDescription());
        String context = api.getContextTemplate();
        if (context.endsWith("/{version}")) {
            context = context.replace("/{version}", "");
        }
        apiInfoDTO.setContext(context);
        apiInfoDTO.setId(api.getUUID());
        APIIdentifier apiId = api.getId();
        apiInfoDTO.setName(apiId.getApiName());
        apiInfoDTO.setVersion(apiId.getVersion());
        apiInfoDTO.setType(api.getType());
        String providerName = api.getId().getProviderName();
        apiInfoDTO.setProvider(APIUtil.replaceEmailDomainBack((String)providerName));
        apiInfoDTO.setLifeCycleStatus(api.getStatus());
        apiInfoDTO.setHasThumbnail(!StringUtils.isBlank((CharSequence)api.getThumbnailUrl()));
        if (api.getCreatedTime() != null) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            Date createdTime = new Date(Long.parseLong(api.getCreatedTime()));
            apiInfoDTO.setCreatedTime(dateFormat.format(createdTime));
        }
        if (api.getLastUpdated() != null) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            Date lastUpdatedTime = api.getLastUpdated();
            apiInfoDTO.setUpdatedTime(dateFormat.format(lastUpdatedTime));
        }
        return apiInfoDTO;
    }

    public static ResourcePolicyListDTO fromResourcePolicyStrToDTO(String conversionPolicyStr) throws APIManagementException {
        ResourcePolicyListDTO policyListDTO = new ResourcePolicyListDTO();
        List<ResourcePolicyInfoDTO> policyInfoDTOs = policyListDTO.getList();
        if (StringUtils.isNotEmpty((CharSequence)conversionPolicyStr)) {
            try {
                JSONObject conversionPolicyObj = (JSONObject)new JSONParser().parse(conversionPolicyStr);
                for (Object key : conversionPolicyObj.keySet()) {
                    JSONObject policyInfo = (JSONObject)conversionPolicyObj.get(key);
                    String keyStr = (String)key;
                    ResourcePolicyInfoDTO policyInfoDTO = new ResourcePolicyInfoDTO();
                    policyInfoDTO.setId(policyInfo.get((Object)"id").toString());
                    policyInfoDTO.setHttpVerb(policyInfo.get((Object)"method").toString());
                    if (keyStr.contains("_")) {
                        policyInfoDTO.setResourcePath(keyStr.substring(0, keyStr.lastIndexOf("_")));
                    } else {
                        policyInfoDTO.setResourcePath(keyStr);
                    }
                    policyInfoDTO.setContent(policyInfo.get((Object)"content").toString());
                    policyInfoDTOs.add(policyInfoDTO);
                }
            }
            catch (ParseException e) {
                throw new APIManagementException("Couldn't parse the conversion policy string.", (Throwable)e);
            }
        }
        policyListDTO.setCount(policyInfoDTOs.size());
        return policyListDTO;
    }

    public static ResourcePolicyInfoDTO fromResourcePolicyStrToInfoDTO(String conversionPolicyStr) throws APIManagementException {
        ResourcePolicyInfoDTO policyInfoDTO = new ResourcePolicyInfoDTO();
        if (StringUtils.isNotEmpty((CharSequence)conversionPolicyStr)) {
            try {
                JSONObject conversionPolicyObj = (JSONObject)new JSONParser().parse(conversionPolicyStr);
                for (Object key : conversionPolicyObj.keySet()) {
                    JSONObject policyInfo = (JSONObject)conversionPolicyObj.get(key);
                    String keyStr = (String)key;
                    policyInfoDTO.setId(policyInfo.get((Object)"id").toString());
                    policyInfoDTO.setHttpVerb(policyInfo.get((Object)"method").toString());
                    if (keyStr.contains("_")) {
                        policyInfoDTO.setResourcePath(keyStr.substring(0, keyStr.lastIndexOf("_")));
                    } else {
                        policyInfoDTO.setResourcePath(keyStr);
                    }
                    policyInfoDTO.setContent(policyInfo.get((Object)"content").toString());
                }
            }
            catch (ParseException e) {
                throw new APIManagementException("Couldn't parse the conversion policy string.", (Throwable)e);
            }
        }
        return policyInfoDTO;
    }

    public static void setPaginationParams(Object apiListDTO, String query, int offset, int limit, int size) {
        Map paginatedParams = RestApiCommonUtil.getPaginationParams((Integer)offset, (Integer)limit, (Integer)size);
        String paginatedPrevious = "";
        String paginatedNext = "";
        if (paginatedParams.get("previous_offset") != null) {
            paginatedPrevious = RestApiCommonUtil.getAPIPaginatedURL((Integer)((Integer)paginatedParams.get("previous_offset")), (Integer)((Integer)paginatedParams.get("previous_limit")), (String)query);
        }
        if (paginatedParams.get("next_offset") != null) {
            paginatedNext = RestApiCommonUtil.getAPIPaginatedURL((Integer)((Integer)paginatedParams.get("next_offset")), (Integer)((Integer)paginatedParams.get("next_limit")), (String)query);
        }
        PaginationDTO paginationDTO = CommonMappingUtil.getPaginationDTO(limit, offset, size, paginatedNext, paginatedPrevious);
        if (apiListDTO instanceof APIListDTO) {
            ((APIListDTO)apiListDTO).setPagination(paginationDTO);
        } else if (apiListDTO instanceof APIListExpandedDTO) {
            ((APIListExpandedDTO)apiListDTO).setPagination(paginationDTO);
        }
    }

    private static String checkAndSetVersionParam(String context) {
        if (!context.contains("{version}")) {
            if (!context.endsWith("/")) {
                context = context + "/";
            }
            context = context + "{version}";
        }
        return context;
    }

    private static String getThumbnailUri(String uuid) {
        return "/apis/{apiId}/thumbnail".replace("{apiId}", uuid);
    }

    private static String mapVisibilityFromDTOtoAPI(APIDTO.VisibilityEnum visibility) {
        switch (visibility) {
            case PUBLIC: {
                return "public";
            }
            case PRIVATE: {
                return "private";
            }
            case RESTRICTED: {
                return "restricted";
            }
        }
        return null;
    }

    private static String mapSubscriptionAvailabilityFromDTOtoAPI(APIDTO.SubscriptionAvailabilityEnum subscriptionAvailability) {
        switch (subscriptionAvailability) {
            case CURRENT_TENANT: {
                return "current_tenant";
            }
            case ALL_TENANTS: {
                return "all_tenants";
            }
            case SPECIFIC_TENANTS: {
                return "specific_tenants";
            }
        }
        return null;
    }

    private static String updateContextWithVersion(String version, String contextVal, String context) {
        context = version == null ? contextVal.replace("/{version}", "") : context.replace("{version}", version);
        return context;
    }

    private static void setMaxTpsFromApiDTOToModel(APIDTO dto, API api) {
        APIMaxTpsDTO maxTpsDTO = dto.getMaxTps();
        if (maxTpsDTO != null) {
            if (maxTpsDTO.getProduction() != null) {
                api.setProductionMaxTps(maxTpsDTO.getProduction().toString());
            }
            if (maxTpsDTO.getSandbox() != null) {
                api.setSandboxMaxTps(maxTpsDTO.getSandbox().toString());
            }
        }
    }

    public static APIDTO fromAPItoDTO(API model) throws APIManagementException {
        return APIMappingUtil.fromAPItoDTO(model, false, null);
    }

    public static APIDTO fromAPItoDTO(API model, APIProvider apiProvider) throws APIManagementException {
        return APIMappingUtil.fromAPItoDTO(model, false, apiProvider);
    }

    public static APIDTO fromAPItoDTO(API model, boolean preserveCredentials, APIProvider apiProviderParam) throws APIManagementException {
        List<ScopeDTO> scopeDTOS;
        List<APIOperationsDTO> apiOperationsDTO;
        String faultSequenceName;
        String outMedPolicyName;
        APIProvider apiProvider = apiProviderParam != null ? apiProviderParam : RestApiCommonUtil.getLoggedInUserProvider();
        APIDTO dto = new APIDTO();
        dto.setName(model.getId().getApiName());
        dto.setVersion(model.getId().getVersion());
        String providerName = model.getId().getProviderName();
        dto.setProvider(APIUtil.replaceEmailDomainBack((String)providerName));
        dto.setId(model.getUUID());
        String context = model.getContextTemplate();
        if (context.endsWith("/{version}")) {
            context = context.replace("/{version}", "");
        }
        dto.setContext(context);
        dto.setCreatedTime(model.getCreatedTime());
        if (model.getLastUpdated() != null) {
            dto.setLastUpdatedTime(Long.toString(model.getLastUpdated().getTime()));
        }
        dto.setDescription(model.getDescription());
        dto.setIsDefaultVersion(model.isDefaultVersion());
        dto.setIsRevision(model.isRevision());
        dto.setRevisionedApiId(model.getRevisionedApiId());
        dto.setRevisionId(model.getRevisionId());
        dto.setEnableSchemaValidation(model.isEnabledSchemaValidation());
        AdvertiseInfoDTO advertiseInfoDTO = new AdvertiseInfoDTO();
        advertiseInfoDTO.setAdvertised(model.isAdvertiseOnly());
        advertiseInfoDTO.setOriginalDevPortalUrl(model.getRedirectURL());
        advertiseInfoDTO.setApiOwner(model.getApiOwner());
        if (model.getAdvertiseOnlyAPIVendor() != null) {
            advertiseInfoDTO.setVendor(AdvertiseInfoDTO.VendorEnum.valueOf(model.getAdvertiseOnlyAPIVendor()));
        }
        dto.setAdvertiseInfo(advertiseInfoDTO);
        if ("Enabled".equals(model.getResponseCache())) {
            dto.setResponseCachingEnabled(Boolean.TRUE);
        } else {
            dto.setResponseCachingEnabled(Boolean.FALSE);
        }
        String serviceKey = model.getServiceInfo("key");
        if (StringUtils.isNotEmpty((CharSequence)serviceKey)) {
            APIServiceInfoDTO apiServiceInfoDTO = new APIServiceInfoDTO();
            apiServiceInfoDTO.setKey(serviceKey);
            apiServiceInfoDTO.setOutdated(Boolean.parseBoolean(model.getServiceInfo("outdated")));
            apiServiceInfoDTO.setName(model.getServiceInfo("name"));
            apiServiceInfoDTO.setVersion(model.getServiceInfo("version"));
            dto.setServiceInfo(apiServiceInfoDTO);
        }
        dto.setCacheTimeout(model.getCacheTimeout());
        String endpointConfig = model.getEndpointConfig();
        if (!StringUtils.isBlank((CharSequence)endpointConfig)) {
            try {
                JSONParser parser = new JSONParser();
                JSONObject endpointConfigJson = (JSONObject)parser.parse(endpointConfig);
                if ("awslambda".equals(endpointConfigJson.get((Object)"endpoint_type"))) {
                    APIMappingUtil.handleAWSCredentials(endpointConfigJson, preserveCredentials);
                }
                CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
                if (endpointConfigJson.get((Object)"endpoint_security") != null) {
                    String clientSecret;
                    JSONObject customParameters;
                    String customParametersString;
                    JSONObject endpointSecurity = (JSONObject)endpointConfigJson.get((Object)"endpoint_security");
                    if (endpointSecurity.get((Object)"production") != null) {
                        JSONObject productionEndpointSecurity = (JSONObject)endpointSecurity.get((Object)"production");
                        String productionEndpointType = (String)productionEndpointSecurity.get((Object)"type");
                        if (productionEndpointSecurity.get((Object)"customParameters") != null) {
                            customParametersString = (String)productionEndpointSecurity.get((Object)"customParameters");
                            customParameters = (JSONObject)parser.parse(customParametersString);
                            productionEndpointSecurity.put((Object)"customParameters", (Object)customParameters);
                        }
                        if ("OAUTH".equals(productionEndpointType) && StringUtils.isNotEmpty((CharSequence)(clientSecret = (String)productionEndpointSecurity.get((Object)"clientSecret")))) {
                            productionEndpointSecurity.put((Object)"clientSecret", (Object)new String(cryptoUtil.base64DecodeAndDecrypt(clientSecret)));
                        }
                        endpointSecurity.put((Object)"production", (Object)productionEndpointSecurity);
                        endpointConfigJson.put((Object)"endpoint_security", (Object)endpointSecurity);
                    }
                    if (endpointSecurity.get((Object)"sandbox") != null) {
                        JSONObject sandboxEndpointSecurity = (JSONObject)endpointSecurity.get((Object)"sandbox");
                        String sandboxEndpointType = (String)sandboxEndpointSecurity.get((Object)"type");
                        if (sandboxEndpointSecurity.get((Object)"customParameters") != null) {
                            customParametersString = (String)sandboxEndpointSecurity.get((Object)"customParameters");
                            customParameters = (JSONObject)parser.parse(customParametersString);
                            sandboxEndpointSecurity.put((Object)"customParameters", (Object)customParameters);
                        }
                        if ("OAUTH".equals(sandboxEndpointType) && StringUtils.isNotEmpty((CharSequence)(clientSecret = (String)sandboxEndpointSecurity.get((Object)"clientSecret")))) {
                            sandboxEndpointSecurity.put((Object)"clientSecret", (Object)new String(cryptoUtil.base64DecodeAndDecrypt(clientSecret)));
                        }
                        endpointSecurity.put((Object)"sandbox", (Object)sandboxEndpointSecurity);
                        endpointConfigJson.put((Object)"endpoint_security", (Object)endpointSecurity);
                    }
                    JSONObject jsonObject = APIMappingUtil.handleEndpointSecurity(model, (JSONObject)endpointConfigJson.get((Object)"endpoint_security"), preserveCredentials);
                    endpointConfigJson.put((Object)"endpoint_security", (Object)jsonObject);
                }
                dto.setEndpointConfig(endpointConfigJson);
            }
            catch (ParseException e) {
                log.error((Object)("Cannot convert endpoint configurations when setting endpoint for API. API ID = " + model.getId()), (Throwable)e);
            }
            catch (CryptoException e) {
                log.error((Object)("Error while decrypting client credentials for API: " + model.getId()), (Throwable)e);
            }
        }
        dto.setHasThumbnail(!StringUtils.isBlank((CharSequence)model.getThumbnailUrl()));
        ArrayList<MediationPolicyDTO> mediationPolicies = new ArrayList<MediationPolicyDTO>();
        String inMedPolicyName = model.getInSequence();
        if (inMedPolicyName != null && !inMedPolicyName.isEmpty()) {
            String type = "in";
            Mediation mediation = model.getInSequenceMediation();
            String mediationPolicyUUID = mediation != null ? mediation.getUuid() : null;
            boolean sharedStatus = mediation != null ? mediation.isGlobal() : false;
            MediationPolicyDTO inMedPolicy = new MediationPolicyDTO();
            inMedPolicy.setName(inMedPolicyName);
            inMedPolicy.setType(type.toUpperCase());
            inMedPolicy.setShared(sharedStatus);
            inMedPolicy.setId(mediationPolicyUUID);
            mediationPolicies.add(inMedPolicy);
        }
        if ((outMedPolicyName = model.getOutSequence()) != null && !outMedPolicyName.isEmpty()) {
            String type = "out";
            Mediation mediation = model.getOutSequenceMediation();
            String mediationPolicyUUID = mediation != null ? mediation.getUuid() : null;
            boolean sharedStatus = mediation != null ? mediation.isGlobal() : false;
            MediationPolicyDTO outMedPolicy = new MediationPolicyDTO();
            outMedPolicy.setName(outMedPolicyName);
            outMedPolicy.setType(type.toUpperCase());
            outMedPolicy.setShared(sharedStatus);
            outMedPolicy.setId(mediationPolicyUUID);
            mediationPolicies.add(outMedPolicy);
        }
        if ((faultSequenceName = model.getFaultSequence()) != null && !faultSequenceName.isEmpty()) {
            String type = "fault";
            Mediation mediation = model.getFaultSequenceMediation();
            String mediationPolicyUUID = mediation != null ? mediation.getUuid() : null;
            boolean sharedStatus = mediation != null ? mediation.isGlobal() : false;
            MediationPolicyDTO faultMedPolicy = new MediationPolicyDTO();
            faultMedPolicy.setName(faultSequenceName);
            faultMedPolicy.setType(type.toUpperCase());
            faultMedPolicy.setShared(sharedStatus);
            faultMedPolicy.setId(mediationPolicyUUID);
            mediationPolicies.add(faultMedPolicy);
        }
        dto.setMediationPolicies(mediationPolicies);
        dto.setLifeCycleStatus(model.getStatus());
        String subscriptionAvailability = model.getSubscriptionAvailability();
        if (subscriptionAvailability != null) {
            dto.setSubscriptionAvailability(APIMappingUtil.mapSubscriptionAvailabilityFromAPItoDTO(subscriptionAvailability));
        }
        if (model.getSubscriptionAvailableTenants() != null) {
            dto.setSubscriptionAvailableTenants(Arrays.asList(model.getSubscriptionAvailableTenants().split(",")));
        }
        String tenantDomain = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack((String)model.getId().getProviderName()));
        boolean isAsyncAPI = APIDTO.TypeEnum.WS.toString().equals(model.getType()) || APIDTO.TypeEnum.WEBSUB.toString().equals(model.getType()) || APIDTO.TypeEnum.SSE.toString().equals(model.getType());
        model.getId().setUuid(model.getUuid());
        if (!isAsyncAPI) {
            String apiSwaggerDefinition = model.getSwaggerDefinition() != null ? model.getSwaggerDefinition() : apiProvider.getOpenAPIDefinition((Identifier)model.getId(), tenantDomain);
            apiOperationsDTO = APIMappingUtil.getOperationsFromAPI(model);
            dto.setOperations(apiOperationsDTO);
            scopeDTOS = APIMappingUtil.getScopesFromSwagger(apiSwaggerDefinition);
            dto.setScopes(APIMappingUtil.getAPIScopesFromScopeDTOs(scopeDTOS, apiProvider));
        } else {
            apiOperationsDTO = APIMappingUtil.getOperationsFromAPI(model);
            dto.setOperations(apiOperationsDTO);
            String asyncAPIDefinition = model.getAsyncApiDefinition() != null ? model.getAsyncApiDefinition() : apiProvider.getAsyncAPIDefinition(model.getId().getUUID(), tenantDomain);
            scopeDTOS = APIMappingUtil.getScopesFromAsyncAPI(asyncAPIDefinition);
            dto.setScopes(APIMappingUtil.getAPIScopesFromScopeDTOs(scopeDTOS, apiProvider));
        }
        Set apiTags = model.getTags();
        ArrayList<String> tagsToReturn = new ArrayList<String>();
        tagsToReturn.addAll(apiTags);
        dto.setTags(tagsToReturn);
        Set apiTiers = model.getAvailableTiers();
        ArrayList<String> tiersToReturn = new ArrayList<String>();
        for (Tier tier : apiTiers) {
            tiersToReturn.add(tier.getName());
        }
        dto.setPolicies(tiersToReturn);
        dto.setApiThrottlingPolicy(model.getApiLevelPolicy());
        if (model.getType() == null || model.getType().toLowerCase().equals("null")) {
            dto.setType(APIDTO.TypeEnum.HTTP);
        } else {
            dto.setType(APIDTO.TypeEnum.fromValue(model.getType()));
        }
        if (!APIConstants.APITransportType.WS.toString().equals(model.getType())) {
            if (StringUtils.isEmpty((CharSequence)model.getTransports())) {
                ArrayList<String> transports = new ArrayList<String>();
                transports.add("https");
                dto.setTransport(transports);
            }
            dto.setTransport(Arrays.asList(model.getTransports().split(",")));
        }
        if (StringUtils.isEmpty((CharSequence)model.getTransports())) {
            dto.setVisibility(APIDTO.VisibilityEnum.PUBLIC);
        }
        dto.setVisibility(APIMappingUtil.mapVisibilityFromAPItoDTO(model.getVisibility()));
        if (model.getVisibleRoles() != null) {
            dto.setVisibleRoles(Arrays.asList(model.getVisibleRoles().split(",")));
        }
        if (model.getVisibleTenants() != null) {
            dto.setVisibleRoles(Arrays.asList(model.getVisibleTenants().split(",")));
        }
        if (model.getAdditionalProperties() != null) {
            JSONObject additionalProperties = model.getAdditionalProperties();
            ArrayList<APIAdditionalPropertiesDTO> additionalPropertiesList = new ArrayList<APIAdditionalPropertiesDTO>();
            for (Object propertyKey : additionalProperties.keySet()) {
                APIAdditionalPropertiesDTO additionalPropertiesDTO = new APIAdditionalPropertiesDTO();
                String key = (String)propertyKey;
                int index = key.lastIndexOf("__display");
                additionalPropertiesDTO.setValue((String)additionalProperties.get((Object)key));
                if (index > 0) {
                    additionalPropertiesDTO.setName(key.substring(0, index));
                    additionalPropertiesDTO.setDisplay(true);
                } else {
                    additionalPropertiesDTO.setName(key);
                    additionalPropertiesDTO.setDisplay(false);
                }
                additionalPropertiesList.add(additionalPropertiesDTO);
            }
            dto.setAdditionalProperties(additionalPropertiesList);
        }
        if (model.getImplementation() != null) {
            dto.setEndpointImplementationType(APIDTO.EndpointImplementationTypeEnum.valueOf(model.getImplementation()));
        }
        dto.setAccessControl("restricted".equals(model.getAccessControl()) ? APIDTO.AccessControlEnum.RESTRICTED : APIDTO.AccessControlEnum.NONE);
        if (model.getAccessControlRoles() != null) {
            dto.setAccessControlRoles(Arrays.asList(model.getAccessControlRoles().split(",")));
        }
        APIBusinessInformationDTO apiBusinessInformationDTO = new APIBusinessInformationDTO();
        apiBusinessInformationDTO.setBusinessOwner(model.getBusinessOwner());
        apiBusinessInformationDTO.setBusinessOwnerEmail(model.getBusinessOwnerEmail());
        apiBusinessInformationDTO.setTechnicalOwner(model.getTechnicalOwner());
        apiBusinessInformationDTO.setTechnicalOwnerEmail(model.getTechnicalOwnerEmail());
        dto.setBusinessInformation(apiBusinessInformationDTO);
        APICorsConfigurationDTO apiCorsConfigurationDTO = new APICorsConfigurationDTO();
        CORSConfiguration corsConfiguration = model.getCorsConfiguration();
        if (corsConfiguration == null) {
            corsConfiguration = APIUtil.getDefaultCorsConfiguration();
        }
        apiCorsConfigurationDTO.setAccessControlAllowOrigins(corsConfiguration.getAccessControlAllowOrigins());
        apiCorsConfigurationDTO.setAccessControlAllowHeaders(corsConfiguration.getAccessControlAllowHeaders());
        apiCorsConfigurationDTO.setAccessControlAllowMethods(corsConfiguration.getAccessControlAllowMethods());
        apiCorsConfigurationDTO.setCorsConfigurationEnabled(corsConfiguration.isCorsConfigurationEnabled());
        apiCorsConfigurationDTO.setAccessControlAllowCredentials(corsConfiguration.isAccessControlAllowCredentials());
        dto.setCorsConfiguration(apiCorsConfigurationDTO);
        WebsubSubscriptionConfigurationDTO websubSubscriptionConfigurationDTO = new WebsubSubscriptionConfigurationDTO();
        WebsubSubscriptionConfiguration websubSubscriptionConfiguration = model.getWebsubSubscriptionConfiguration();
        if (websubSubscriptionConfiguration == null) {
            websubSubscriptionConfiguration = APIUtil.getDefaultWebsubSubscriptionConfiguration();
        }
        websubSubscriptionConfigurationDTO.setEnable(websubSubscriptionConfiguration.isEnable());
        websubSubscriptionConfigurationDTO.setSecret(websubSubscriptionConfiguration.getSecret());
        websubSubscriptionConfigurationDTO.setSigningAlgorithm(websubSubscriptionConfiguration.getSigningAlgorithm());
        websubSubscriptionConfigurationDTO.setSignatureHeader(websubSubscriptionConfiguration.getSignatureHeader());
        dto.setWebsubSubscriptionConfiguration(websubSubscriptionConfigurationDTO);
        if (model.getWsdlUrl() != null) {
            WSDLInfoDTO wsdlInfoDTO = APIMappingUtil.getWsdlInfoDTO(model);
            dto.setWsdlInfo(wsdlInfoDTO);
        }
        dto.setWsdlUrl(model.getWsdlUrl());
        APIMappingUtil.setEndpointSecurityFromModelToApiDTO(model, dto, preserveCredentials);
        APIMappingUtil.setMaxTpsFromModelToApiDTO(model, dto);
        dto.setAuthorizationHeader(model.getAuthorizationHeader());
        if (model.getApiSecurity() != null) {
            dto.setSecurityScheme(Arrays.asList(model.getApiSecurity().split(",")));
        }
        if (null != model.getLastUpdated()) {
            Date lastUpdateDate = model.getLastUpdated();
            Timestamp timeStamp = new Timestamp(lastUpdateDate.getTime());
            dto.setLastUpdatedTime(String.valueOf(timeStamp));
        }
        if (null != model.getCreatedTime()) {
            Date created = new Date(Long.parseLong(model.getCreatedTime()));
            Timestamp timeStamp = new Timestamp(created.getTime());
            dto.setCreatedTime(String.valueOf(timeStamp));
        }
        dto.setWorkflowStatus(model.getWorkflowStatus());
        List apiCategories = model.getApiCategories();
        ArrayList<String> categoryNameList = new ArrayList<String>();
        if (apiCategories != null && !apiCategories.isEmpty()) {
            for (APICategory category : apiCategories) {
                categoryNameList.add(category.getName());
            }
        }
        dto.setCategories(categoryNameList);
        dto.setKeyManagers(model.getKeyManagers());
        return dto;
    }

    private static List<ScopeDTO> getScopesFromAsyncAPI(String asyncAPIDefinition) {
        Aai20Document document = (Aai20Document)Library.readDocumentFromJSONString((String)asyncAPIDefinition);
        ArrayList<ScopeDTO> scopeDTOS = new ArrayList<ScopeDTO>();
        if (document.components == null || document.components.securitySchemes == null || document.components.securitySchemes.get("oauth2") == null) {
            return scopeDTOS;
        }
        AaiSecurityScheme securityScheme = (AaiSecurityScheme)document.components.securitySchemes.get("oauth2");
        if (securityScheme.flows == null || securityScheme.flows.implicit == null || securityScheme.flows.implicit.scopes == null) {
            return scopeDTOS;
        }
        Map scopes = securityScheme.flows.implicit.scopes;
        Map scopeBindings = new HashMap();
        Extension xScopesBindings = securityScheme.flows.implicit.getExtension("x-scopes-bindings");
        if (xScopesBindings != null) {
            scopeBindings = (Map)xScopesBindings.value;
        }
        for (Map.Entry aScope : scopes.entrySet()) {
            ScopeDTO scopeDTO = new ScopeDTO();
            scopeDTO.setName((String)aScope.getKey());
            scopeDTO.setDisplayName((String)aScope.getKey());
            scopeDTO.setDescription((String)aScope.getValue());
            String roles = (String)scopeBindings.get(aScope.getKey());
            if (roles == null || roles.isEmpty()) {
                scopeDTO.setBindings(Collections.emptyList());
            } else {
                scopeDTO.setBindings(Arrays.asList(roles.split(",")));
            }
            scopeDTOS.add(scopeDTO);
        }
        return scopeDTOS;
    }

    public static WSDLInfoDTO getWsdlInfoDTO(API model) {
        if (model.getWsdlUrl() == null) {
            return null;
        }
        String wsdlRegistryUri = model.getWsdlUrl().toLowerCase();
        WSDLInfoDTO wsdlInfoDTO = new WSDLInfoDTO();
        if (wsdlRegistryUri.endsWith(".zip")) {
            wsdlInfoDTO.setType(WSDLInfoDTO.TypeEnum.ZIP);
        } else if (wsdlRegistryUri.endsWith("wsdl")) {
            wsdlInfoDTO.setType(WSDLInfoDTO.TypeEnum.WSDL);
        } else {
            log.warn((Object)("Unrecognized WSDL type in WSDL url: " + model.getWsdlUrl()));
        }
        return wsdlInfoDTO;
    }

    private static APIDTO.VisibilityEnum mapVisibilityFromAPItoDTO(String visibility) {
        switch (visibility) {
            case "public": {
                return APIDTO.VisibilityEnum.PUBLIC;
            }
            case "private": {
                return APIDTO.VisibilityEnum.PRIVATE;
            }
            case "restricted": {
                return APIDTO.VisibilityEnum.RESTRICTED;
            }
        }
        return null;
    }

    private static APIDTO.SubscriptionAvailabilityEnum mapSubscriptionAvailabilityFromAPItoDTO(String subscriptionAvailability) {
        switch (subscriptionAvailability) {
            case "current_tenant": {
                return APIDTO.SubscriptionAvailabilityEnum.CURRENT_TENANT;
            }
            case "all_tenants": {
                return APIDTO.SubscriptionAvailabilityEnum.ALL_TENANTS;
            }
            case "specific_tenants": {
                return APIDTO.SubscriptionAvailabilityEnum.SPECIFIC_TENANTS;
            }
        }
        return null;
    }

    private static void setEndpointSecurityFromModelToApiDTO(API api, APIDTO dto, boolean preserveCredentials) throws APIManagementException {
        JSONObject endpointSecurityObject = new JSONObject();
        Map endpointConfig = (Map)dto.getEndpointConfig();
        if (api.isEndpointSecured()) {
            endpointSecurityObject.put((Object)"enabled", (Object)true);
            endpointSecurityObject.put((Object)"type", (Object)"basic".toUpperCase());
            endpointSecurityObject.put((Object)"username", (Object)api.getEndpointUTUsername());
            String tenantDomain = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack((String)api.getId().getProviderName()));
            if (APIMappingUtil.checkEndpointSecurityPasswordEnabled(tenantDomain) || preserveCredentials) {
                endpointSecurityObject.put((Object)"password", (Object)api.getEndpointUTPassword());
            } else {
                endpointSecurityObject.put((Object)"password", (Object)"");
            }
            if (api.isEndpointAuthDigest()) {
                endpointSecurityObject.put((Object)"type", (Object)"digest".toUpperCase());
            }
            JSONObject endpointSecurityModel = new JSONObject();
            endpointSecurityModel.put((Object)"production", (Object)endpointSecurityObject);
            endpointSecurityModel.put((Object)"sandbox", (Object)endpointSecurityObject);
            if (!endpointConfig.containsKey("endpoint_security")) {
                endpointConfig.put("endpoint_security", endpointSecurityModel);
                dto.setEndpointConfig(endpointConfig);
            }
        }
    }

    private static boolean checkEndpointSecurityPasswordEnabled(String tenantDomainName) throws APIManagementException {
        try {
            Object value;
            JSONParser parser;
            JSONObject apiTenantConfig;
            APIMRegistryServiceImpl apimRegistryService = new APIMRegistryServiceImpl();
            String content = apimRegistryService.getConfigRegistryResourceContent(tenantDomainName, "/apimgt/applicationdata/tenant-conf.json");
            if (content != null && (apiTenantConfig = (JSONObject)(parser = new JSONParser()).parse(content)) != null && (value = apiTenantConfig.get((Object)"ExposeEndpointPassword")) != null) {
                return Boolean.parseBoolean(value.toString());
            }
        }
        catch (UserStoreException e) {
            String msg = "UserStoreException thrown when getting API tenant config from registry while reading ExposeEndpointPassword config";
            throw new APIManagementException(msg, (Throwable)e);
        }
        catch (RegistryException e) {
            String msg = "RegistryException thrown when getting API tenant config from registry while reading ExposeEndpointPassword config";
            throw new APIManagementException(msg, (Throwable)e);
        }
        catch (ParseException e) {
            String msg = "ParseException thrown when parsing API tenant config from registry while reading ExposeEndpointPassword config";
            throw new APIManagementException(msg, (Throwable)e);
        }
        return false;
    }

    private static void setMaxTpsFromModelToApiDTO(API api, APIDTO dto) {
        if (StringUtils.isBlank((CharSequence)api.getProductionMaxTps()) && StringUtils.isBlank((CharSequence)api.getSandboxMaxTps())) {
            return;
        }
        APIMaxTpsDTO maxTpsDTO = new APIMaxTpsDTO();
        try {
            if (!StringUtils.isBlank((CharSequence)api.getProductionMaxTps())) {
                maxTpsDTO.setProduction(Long.parseLong(api.getProductionMaxTps()));
            }
            if (!StringUtils.isBlank((CharSequence)api.getSandboxMaxTps())) {
                maxTpsDTO.setSandbox(Long.parseLong(api.getSandboxMaxTps()));
            }
            dto.setMaxTps(maxTpsDTO);
        }
        catch (NumberFormatException e) {
            log.error((Object)"Cannot convert to Long format when setting maxTps for API", (Throwable)e);
        }
    }

    public static LifecycleStateDTO fromLifecycleModelToDTO(Map<String, Object> apiLCData, boolean apiOlderVersionExist) {
        List checkListItems;
        LifecycleStateDTO lifecycleStateDTO = new LifecycleStateDTO();
        String currentState = (String)apiLCData.get("status:");
        lifecycleStateDTO.setState(currentState);
        String[] nextStates = (String[])apiLCData.get("nextStates");
        if (nextStates != null) {
            ArrayList<LifecycleStateAvailableTransitionsDTO> transitionDTOList = new ArrayList<LifecycleStateAvailableTransitionsDTO>();
            for (String state : nextStates) {
                LifecycleStateAvailableTransitionsDTO transitionDTO = new LifecycleStateAvailableTransitionsDTO();
                transitionDTO.setEvent(state);
                transitionDTO.setTargetState("");
                transitionDTOList.add(transitionDTO);
            }
            lifecycleStateDTO.setAvailableTransitions(transitionDTOList);
        }
        if ((checkListItems = (List)apiLCData.get("items")) != null) {
            ArrayList<LifecycleStateCheckItemsDTO> checkItemsDTOList = new ArrayList<LifecycleStateCheckItemsDTO>();
            for (Object checkListItemObj : checkListItems) {
                CheckListItem checkListItem = (CheckListItem)checkListItemObj;
                if (!apiOlderVersionExist && (checkListItem.getName().equals("Deprecate old versions after publishing the API") || checkListItem.getName().equals("Requires re-subscription when publishing the API"))) continue;
                LifecycleStateCheckItemsDTO checkItemsDTO = new LifecycleStateCheckItemsDTO();
                checkItemsDTO.setName(checkListItem.getName());
                checkItemsDTO.setValue(Boolean.getBoolean(checkListItem.getValue()));
                checkItemsDTO.setRequiredStates(new ArrayList<String>());
                checkItemsDTOList.add(checkItemsDTO);
            }
            lifecycleStateDTO.setCheckItems(checkItemsDTOList);
        }
        return lifecycleStateDTO;
    }

    public static LifecycleHistoryDTO fromLifecycleHistoryModelToDTO(List<LifeCycleEvent> lifeCycleEvents) {
        LifecycleHistoryDTO historyDTO = new LifecycleHistoryDTO();
        historyDTO.setCount(lifeCycleEvents.size());
        for (LifeCycleEvent event : lifeCycleEvents) {
            LifecycleHistoryItemDTO historyItemDTO = new LifecycleHistoryItemDTO();
            historyItemDTO.setPostState(event.getNewStatus());
            historyItemDTO.setPreviousState(event.getOldStatus());
            historyItemDTO.setUser(event.getUserId());
            String updatedTime = RestApiCommonUtil.getRFC3339Date((Date)event.getDate());
            historyItemDTO.setUpdatedTime(updatedTime);
            historyDTO.getList().add(historyItemDTO);
        }
        return historyDTO;
    }

    public static Set<URITemplate> getURITemplates(API model, List<APIOperationsDTO> operations) throws APIManagementException {
        boolean isHttpVerbDefined = false;
        LinkedHashSet<URITemplate> uriTemplates = new LinkedHashSet<URITemplate>();
        if (operations == null || operations.isEmpty()) {
            operations = APIMappingUtil.getDefaultOperationsList(model.getType());
        }
        for (APIOperationsDTO operation : operations) {
            String amznResourceName;
            URITemplate template = new URITemplate();
            String uriTempVal = operation.getTarget();
            String httpVerb = operation.getVerb();
            List<String> scopeList = operation.getScopes();
            if (scopeList != null) {
                block1: for (String scopeKey : scopeList) {
                    for (Scope definedScope : model.getScopes()) {
                        if (!definedScope.getKey().equalsIgnoreCase(scopeKey)) continue;
                        template.setScopes(definedScope);
                        template.setScope(definedScope);
                        continue block1;
                    }
                }
            }
            if ((amznResourceName = operation.getAmznResourceName()) != null) {
                template.setAmznResourceName(amznResourceName);
            }
            if (APIConstants.SUPPORTED_METHODS.contains(httpVerb.toLowerCase()) || APIConstants.GRAPHQL_SUPPORTED_METHOD_LIST.contains(httpVerb.toUpperCase()) || APIConstants.WEBSUB_SUPPORTED_METHOD_LIST.contains(httpVerb.toUpperCase()) || APIConstants.SSE_SUPPORTED_METHOD_LIST.contains(httpVerb.toUpperCase()) || APIConstants.WS_SUPPORTED_METHOD_LIST.contains(httpVerb.toUpperCase())) {
                isHttpVerbDefined = true;
                String authType = operation.getAuthType();
                authType = "Application & Application User".equals(authType) ? "Any" : ("Application User".equals(authType) ? "Application_User" : ("None".equals(authType) ? "None" : ("Application".equals(authType) ? "Application" : "Any")));
                template.setThrottlingTier(operation.getThrottlingPolicy());
                template.setThrottlingTiers(operation.getThrottlingPolicy());
                template.setUriTemplate(uriTempVal);
                template.setHTTPVerb(httpVerb.toUpperCase());
                template.setHttpVerbs(httpVerb.toUpperCase());
                template.setAuthType(authType);
                template.setAuthTypes(authType);
                uriTemplates.add(template);
            } else if ("GRAPHQL".equals(model.getType())) {
                APIUtil.handleException((String)("The GRAPHQL operation Type '" + httpVerb + "' provided for operation '" + uriTempVal + "' is invalid"));
            } else if ("WEBSUB".equals(model.getType())) {
                APIUtil.handleException((String)("The WEBSUB operation Type '" + httpVerb + "' provided for operation '" + uriTempVal + "' is invalid"));
            } else if ("SSE".equals(model.getType())) {
                APIUtil.handleException((String)("The SSE operation Type '" + httpVerb + "' provided for operation '" + uriTempVal + "' is invalid"));
            } else if ("WS".equals(model.getType())) {
                APIUtil.handleException((String)("The WEBSOCKET operation Type '" + httpVerb + "' provided for operation '" + uriTempVal + "' is invalid"));
            } else {
                APIUtil.handleException((String)("The HTTP method '" + httpVerb + "' provided for resource '" + uriTempVal + "' is invalid"));
            }
            if (isHttpVerbDefined) continue;
            if ("GRAPHQL".equals(model.getType())) {
                APIUtil.handleException((String)("Operation '" + uriTempVal + "' has global parameters without Operation Type"));
                continue;
            }
            if ("WEBSUB".equals(model.getType()) || "SSE".equals(model.getType())) {
                APIUtil.handleException((String)("Topic '" + uriTempVal + "' has global parameters without Operation Type"));
                continue;
            }
            APIUtil.handleException((String)("Resource '" + uriTempVal + "' has global parameters without HTTP methods"));
        }
        return uriTemplates;
    }

    public static List<APIOperationsDTO> getOperationListWithOldData(Set<URITemplate> uriTemplates, List<APIOperationsDTO> operations) {
        for (APIOperationsDTO operation : operations) {
            for (URITemplate uriTemplate : uriTemplates) {
                if (operation.getVerb().equalsIgnoreCase(uriTemplate.getHTTPVerb()) && operation.getTarget().equalsIgnoreCase(uriTemplate.getUriTemplate())) {
                    operation.setThrottlingPolicy(uriTemplate.getThrottlingTier());
                    operation.setAuthType(uriTemplate.getAuthType());
                    operation.setScopes(uriTemplate.retrieveAllScopes().stream().map(Scope::getKey).collect(Collectors.toList()));
                }
                if (operation.getThrottlingPolicy() != null) continue;
                operation.setThrottlingPolicy("Unlimited");
            }
        }
        return operations;
    }

    public static Set<Scope> getScopes(APIDTO apiDTO) {
        LinkedHashSet<Scope> scopeSet = new LinkedHashSet<Scope>();
        for (APIScopeDTO apiScopeDTO : apiDTO.getScopes()) {
            Scope scope = new Scope();
            ScopeDTO scopeDTO = apiScopeDTO.getScope();
            scope.setKey(scopeDTO.getName());
            scope.setName(scopeDTO.getDisplayName());
            scope.setDescription(scopeDTO.getDescription());
            scope.setRoles(String.join((CharSequence)",", scopeDTO.getBindings()));
            scopeSet.add(scope);
        }
        return scopeSet;
    }

    private static Set<Scope> getScopes(APIProductDTO apiProductDTO) {
        LinkedHashSet<Scope> scopeSet = new LinkedHashSet<Scope>();
        for (APIScopeDTO apiScopeDTO : apiProductDTO.getScopes()) {
            Scope scope = new Scope();
            ScopeDTO scopeDTO = apiScopeDTO.getScope();
            scope.setKey(scopeDTO.getName());
            scope.setName(scopeDTO.getDisplayName());
            scope.setDescription(scopeDTO.getDescription());
            scope.setRoles(String.join((CharSequence)",", scopeDTO.getBindings()));
            scopeSet.add(scope);
        }
        return scopeSet;
    }

    public static String getSecurityScheme(List<String> securitySchemes) {
        if (securitySchemes == null || securitySchemes.size() <= 0) {
            return "";
        }
        StringBuilder apiSecurityScheme = new StringBuilder();
        if (securitySchemes != null) {
            for (String scheme : securitySchemes) {
                apiSecurityScheme.append(scheme).append(",");
            }
            apiSecurityScheme.deleteCharAt(apiSecurityScheme.length() - 1);
        }
        return apiSecurityScheme.toString();
    }

    public static OpenAPIDefinitionValidationResponseDTO getOpenAPIDefinitionValidationResponseFromModel(APIDefinitionValidationResponse model, boolean returnContent) {
        OpenAPIDefinitionValidationResponseDTO responseDTO = new OpenAPIDefinitionValidationResponseDTO();
        responseDTO.setIsValid(model.isValid());
        if (model.isValid()) {
            APIDefinitionValidationResponse.Info modelInfo = model.getInfo();
            if (modelInfo != null) {
                OpenAPIDefinitionValidationResponseInfoDTO infoDTO = new OpenAPIDefinitionValidationResponseInfoDTO();
                infoDTO.setOpenAPIVersion(modelInfo.getOpenAPIVersion());
                infoDTO.setName(modelInfo.getName());
                infoDTO.setVersion(modelInfo.getVersion());
                infoDTO.setContext(modelInfo.getContext());
                infoDTO.setDescription(modelInfo.getDescription());
                infoDTO.setEndpoints(modelInfo.getEndpoints());
                responseDTO.setInfo(infoDTO);
            }
            if (returnContent) {
                responseDTO.setContent(model.getContent());
            }
        } else {
            responseDTO.setErrors(APIMappingUtil.getErrorListItemsDTOsFromErrorHandlers(model.getErrorItems()));
        }
        return responseDTO;
    }

    public static AsyncAPISpecificationValidationResponseDTO getAsyncAPISpecificationValidationResponseFromModel(APIDefinitionValidationResponse model, boolean returnContent) {
        AsyncAPISpecificationValidationResponseDTO responseDTO = new AsyncAPISpecificationValidationResponseDTO();
        responseDTO.setIsValid(model.isValid());
        if (model.isValid()) {
            APIDefinitionValidationResponse.Info modelInfo = model.getInfo();
            if (modelInfo != null) {
                AsyncAPISpecificationValidationResponseInfoDTO infoDTO = new AsyncAPISpecificationValidationResponseInfoDTO();
                infoDTO.setAsyncAPIVersion(modelInfo.getOpenAPIVersion());
                infoDTO.setName(modelInfo.getName());
                infoDTO.setVersion(modelInfo.getVersion());
                infoDTO.setContext(modelInfo.getContext());
                infoDTO.setDescription(modelInfo.getDescription());
                infoDTO.setEndpoints(modelInfo.getEndpoints());
                infoDTO.setProtocol(model.getProtocol());
                responseDTO.setInfo(infoDTO);
            }
            if (returnContent) {
                responseDTO.setContent(model.getContent());
            }
        } else {
            responseDTO.setErrors(APIMappingUtil.getErrorListItemsDTOsFromErrorHandlers(model.getErrorItems()));
        }
        return responseDTO;
    }

    public static List<org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ErrorListItemDTO> getErrorListItemsDTOsFromErrorHandlers(List<ErrorHandler> errorHandlers) {
        ArrayList<org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ErrorListItemDTO> errorListItemDTOs = new ArrayList<org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ErrorListItemDTO>();
        for (ErrorHandler handler : errorHandlers) {
            org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ErrorListItemDTO dto = new org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ErrorListItemDTO();
            dto.setCode(handler.getErrorCode() + "");
            dto.setMessage(handler.getErrorMessage());
            dto.setDescription(handler.getErrorDescription());
            errorListItemDTOs.add(dto);
        }
        return errorListItemDTOs;
    }

    public static List<org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ErrorListItemDTO> getErrorListItemsDTOsFromErrorHandler(ErrorHandler error) {
        ArrayList<org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ErrorListItemDTO> errorListItemDTOs = new ArrayList<org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ErrorListItemDTO>();
        org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ErrorListItemDTO dto = new org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ErrorListItemDTO();
        dto.setCode(error.getErrorCode() + "");
        dto.setMessage(error.getErrorMessage());
        dto.setDescription(error.getErrorDescription());
        errorListItemDTOs.add(dto);
        return errorListItemDTOs;
    }

    public static ErrorDTO getErrorDTOFromErrorListItems(List<org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ErrorListItemDTO> errorListItemDTOs) {
        ErrorDTO errorDTO = new ErrorDTO();
        for (int i = 0; i < errorListItemDTOs.size(); ++i) {
            if (i == 0) {
                org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.ErrorListItemDTO elementAt0 = errorListItemDTOs.get(0);
                errorDTO.setCode(Long.valueOf(Long.parseLong(elementAt0.getCode())));
                errorDTO.setMoreInfo("");
                errorDTO.setMessage(elementAt0.getMessage());
                errorDTO.setDescription(elementAt0.getDescription());
                continue;
            }
            ErrorListItemDTO errorListItemDTO = new ErrorListItemDTO();
            errorListItemDTO.setCode(errorListItemDTOs.get(i).getCode() + "");
            errorListItemDTO.setMessage(errorListItemDTOs.get(i).getMessage());
            errorListItemDTO.setDescription(errorListItemDTOs.get(i).getDescription());
            errorDTO.getError().add(errorListItemDTO);
        }
        return errorDTO;
    }

    public static WorkflowResponseDTO toWorkflowResponseDTO(LifecycleStateDTO lifecycleStateDTO, APIStateChangeResponse stateChangeResponse) {
        WorkflowResponseDTO workflowResponseDTO = new WorkflowResponseDTO();
        if (WorkflowStatus.APPROVED.toString().equals(stateChangeResponse.getStateChangeStatus())) {
            workflowResponseDTO.setWorkflowStatus(WorkflowResponseDTO.WorkflowStatusEnum.APPROVED);
        } else if (WorkflowStatus.CREATED.toString().equals(stateChangeResponse.getStateChangeStatus())) {
            workflowResponseDTO.setWorkflowStatus(WorkflowResponseDTO.WorkflowStatusEnum.CREATED);
        } else if (WorkflowStatus.REGISTERED.toString().equals(stateChangeResponse.getStateChangeStatus())) {
            workflowResponseDTO.setWorkflowStatus(WorkflowResponseDTO.WorkflowStatusEnum.REGISTERED);
        } else if (WorkflowStatus.REJECTED.toString().equals(stateChangeResponse.getStateChangeStatus())) {
            workflowResponseDTO.setWorkflowStatus(WorkflowResponseDTO.WorkflowStatusEnum.REJECTED);
        } else {
            log.error((Object)("Unrecognized state : " + stateChangeResponse.getStateChangeStatus()));
            workflowResponseDTO.setWorkflowStatus(WorkflowResponseDTO.WorkflowStatusEnum.CREATED);
        }
        workflowResponseDTO.setLifecycleState(lifecycleStateDTO);
        return workflowResponseDTO;
    }

    private static List<APIOperationsDTO> getOperationsFromAPI(API api) {
        Set uriTemplates = api.getUriTemplates();
        ArrayList<APIOperationsDTO> operationsDTOList = new ArrayList<APIOperationsDTO>();
        for (URITemplate uriTemplate : uriTemplates) {
            String wsUriMapping;
            Map wsUriMappings;
            APIOperationsDTO operationsDTO = APIMappingUtil.getOperationFromURITemplate(uriTemplate);
            if (api.getType().equals("WS") && (wsUriMappings = api.getWsUriMapping()) != null && (wsUriMapping = (String)wsUriMappings.get(operationsDTO.getVerb() + "_" + operationsDTO.getTarget())) != null) {
                operationsDTO.setUriMapping(wsUriMapping);
            }
            operationsDTOList.add(operationsDTO);
        }
        return operationsDTOList;
    }

    private static APIOperationsDTO getOperationFromURITemplate(URITemplate uriTemplate) {
        APIOperationsDTO operationsDTO = new APIOperationsDTO();
        operationsDTO.setId("");
        if ("Any".equals(uriTemplate.getAuthType())) {
            operationsDTO.setAuthType("Application & Application User");
        } else if ("Application_User".equals(uriTemplate.getAuthType())) {
            operationsDTO.setAuthType("Application User");
        } else if ("None".equals(uriTemplate.getAuthType())) {
            operationsDTO.setAuthType("None");
        } else if ("Application".equals(uriTemplate.getAuthType())) {
            operationsDTO.setAuthType("Application");
        } else {
            operationsDTO.setAuthType("Application & Application User");
        }
        operationsDTO.setVerb(uriTemplate.getHTTPVerb());
        operationsDTO.setTarget(uriTemplate.getUriTemplate());
        operationsDTO.setScopes(uriTemplate.retrieveAllScopes().stream().map(Scope::getKey).collect(Collectors.toList()));
        operationsDTO.setThrottlingPolicy(uriTemplate.getThrottlingTier());
        Set usedByProducts = uriTemplate.retrieveUsedByProducts();
        ArrayList<String> usedProductIds = new ArrayList<String>();
        for (APIProductIdentifier usedByProduct : usedByProducts) {
            usedProductIds.add(usedByProduct.getUUID());
        }
        if (!usedProductIds.isEmpty()) {
            operationsDTO.setUsedProductIds(usedProductIds);
        }
        return operationsDTO;
    }

    private static List<APIOperationsDTO> getDefaultOperationsList(String apiType) {
        ArrayList<APIOperationsDTO> operationsDTOs = new ArrayList<APIOperationsDTO>();
        String[] supportedMethods = apiType.equals("GRAPHQL") ? APIConstants.GRAPHQL_SUPPORTED_METHODS : (apiType.equals("SOAP") ? APIConstants.SOAP_DEFAULT_METHODS : (apiType.equals("WEBSUB") ? APIConstants.WEBSUB_SUPPORTED_METHODS : (apiType.equals("SSE") ? APIConstants.SSE_SUPPORTED_METHODS : (apiType.equals("WS") ? APIConstants.WS_SUPPORTED_METHODS : APIConstants.HTTP_DEFAULT_METHODS))));
        String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        String defaultThrottlingPolicy = APIUtil.getDefaultThrottlingPolicy((String)tenantDomain);
        for (String verb : supportedMethods) {
            APIOperationsDTO operationsDTO = new APIOperationsDTO();
            if (apiType.equals("WEBSUB")) {
                operationsDTO.setTarget("_default");
            } else {
                operationsDTO.setTarget("/*");
            }
            operationsDTO.setVerb(verb);
            operationsDTO.setThrottlingPolicy(defaultThrottlingPolicy);
            operationsDTO.setAuthType("Any");
            operationsDTOs.add(operationsDTO);
        }
        return operationsDTOs;
    }

    public static APIProductListDTO fromAPIProductListtoDTO(List<APIProduct> productList) {
        APIProductListDTO listDto = new APIProductListDTO();
        ArrayList<APIProductInfoDTO> list = new ArrayList<APIProductInfoDTO>();
        for (APIProduct apiProduct : productList) {
            APIProductInfoDTO productDto = new APIProductInfoDTO();
            productDto.setName(apiProduct.getId().getName());
            productDto.setProvider(APIUtil.replaceEmailDomainBack((String)apiProduct.getId().getProviderName()));
            productDto.setContext(apiProduct.getContext());
            productDto.setDescription(apiProduct.getDescription());
            productDto.setState(APIProductInfoDTO.StateEnum.valueOf(apiProduct.getState()));
            productDto.setId(apiProduct.getUuid());
            if (apiProduct.getApiSecurity() != null) {
                productDto.setSecurityScheme(Arrays.asList(apiProduct.getApiSecurity().split(",")));
            }
            list.add(productDto);
        }
        listDto.setList(list);
        listDto.setCount(list.size());
        return listDto;
    }

    public static APIProductDTO fromAPIProducttoDTO(APIProduct product) throws APIManagementException {
        Timestamp timeStamp;
        APIProductDTO productDto = new APIProductDTO();
        APIProvider apiProvider = RestApiCommonUtil.getLoggedInUserProvider();
        productDto.setName(product.getId().getName());
        productDto.setProvider(APIUtil.replaceEmailDomainBack((String)product.getId().getProviderName()));
        productDto.setId(product.getUuid());
        productDto.setContext(product.getContext());
        productDto.setDescription(product.getDescription());
        productDto.setApiType(APIProductDTO.ApiTypeEnum.fromValue("APIProduct"));
        productDto.setAuthorizationHeader(product.getAuthorizationHeader());
        Set apiTags = product.getTags();
        ArrayList<String> tagsToReturn = new ArrayList<String>(apiTags);
        productDto.setTags(tagsToReturn);
        productDto.setEnableSchemaValidation(product.isEnabledSchemaValidation());
        productDto.setIsRevision(product.isRevision());
        productDto.setRevisionedApiProductId(product.getRevisionedApiProductId());
        productDto.setRevisionId(product.getRevisionId());
        if ("Enabled".equals(product.getResponseCache())) {
            productDto.setResponseCachingEnabled(Boolean.TRUE);
        } else {
            productDto.setResponseCachingEnabled(Boolean.FALSE);
        }
        productDto.setCacheTimeout(product.getCacheTimeout());
        APIProductBusinessInformationDTO businessInformation = new APIProductBusinessInformationDTO();
        businessInformation.setBusinessOwner(product.getBusinessOwner());
        businessInformation.setBusinessOwnerEmail(product.getBusinessOwnerEmail());
        businessInformation.setTechnicalOwner(product.getTechnicalOwner());
        businessInformation.setTechnicalOwnerEmail(product.getTechnicalOwnerEmail());
        productDto.setBusinessInformation(businessInformation);
        APICorsConfigurationDTO apiCorsConfigurationDTO = new APICorsConfigurationDTO();
        CORSConfiguration corsConfiguration = product.getCorsConfiguration();
        if (corsConfiguration == null) {
            corsConfiguration = APIUtil.getDefaultCorsConfiguration();
        }
        apiCorsConfigurationDTO.setAccessControlAllowOrigins(corsConfiguration.getAccessControlAllowOrigins());
        apiCorsConfigurationDTO.setAccessControlAllowHeaders(corsConfiguration.getAccessControlAllowHeaders());
        apiCorsConfigurationDTO.setAccessControlAllowMethods(corsConfiguration.getAccessControlAllowMethods());
        apiCorsConfigurationDTO.setCorsConfigurationEnabled(corsConfiguration.isCorsConfigurationEnabled());
        apiCorsConfigurationDTO.setAccessControlAllowCredentials(corsConfiguration.isAccessControlAllowCredentials());
        productDto.setCorsConfiguration(apiCorsConfigurationDTO);
        productDto.setState(APIProductDTO.StateEnum.valueOf(product.getState()));
        HashMap<String, ProductAPIDTO> aggregatedAPIs = new HashMap<String, ProductAPIDTO>();
        List resources = product.getProductResources();
        for (APIProductResource apiProductResource : resources) {
            Object operation;
            ProductAPIDTO productAPI;
            String uuid = apiProductResource.getApiId();
            if (aggregatedAPIs.containsKey(uuid)) {
                productAPI = (ProductAPIDTO)aggregatedAPIs.get(uuid);
                URITemplate template = apiProductResource.getUriTemplate();
                List<APIOperationsDTO> operations = productAPI.getOperations();
                operation = APIMappingUtil.getOperationFromURITemplate(template);
                operations.add((APIOperationsDTO)operation);
                continue;
            }
            productAPI = new ProductAPIDTO();
            productAPI.setApiId(uuid);
            productAPI.setName(apiProductResource.getApiName());
            productAPI.setVersion(apiProductResource.getApiIdentifier().getVersion());
            ArrayList<APIOperationsDTO> operations = new ArrayList<APIOperationsDTO>();
            URITemplate template = apiProductResource.getUriTemplate();
            operation = APIMappingUtil.getOperationFromURITemplate(template);
            operations.add((APIOperationsDTO)operation);
            productAPI.setOperations(operations);
            aggregatedAPIs.put(uuid, productAPI);
        }
        productDto.setApis(new ArrayList<ProductAPIDTO>(aggregatedAPIs.values()));
        String tenantDomain = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack((String)product.getId().getProviderName()));
        String apiSwaggerDefinition = apiProvider.getOpenAPIDefinition((Identifier)product.getId(), tenantDomain);
        List<ScopeDTO> scopeDTOS = APIMappingUtil.getScopesFromSwagger(apiSwaggerDefinition);
        productDto.setScopes(APIMappingUtil.getAPIScopesFromScopeDTOs(scopeDTOS));
        String subscriptionAvailability = product.getSubscriptionAvailability();
        if (subscriptionAvailability != null) {
            productDto.setSubscriptionAvailability(APIMappingUtil.mapSubscriptionAvailabilityFromAPIProducttoDTO(subscriptionAvailability));
        }
        if (product.getSubscriptionAvailableTenants() != null) {
            productDto.setSubscriptionAvailableTenants(Arrays.asList(product.getSubscriptionAvailableTenants().split(",")));
        }
        Set apiTiers = product.getAvailableTiers();
        ArrayList<String> tiersToReturn = new ArrayList<String>();
        for (Tier tier : apiTiers) {
            tiersToReturn.add(tier.getName());
        }
        productDto.setPolicies(tiersToReturn);
        productDto.setApiThrottlingPolicy(product.getProductLevelPolicy());
        if (product.getVisibility() != null) {
            productDto.setVisibility(APIMappingUtil.mapVisibilityFromAPIProducttoDTO(product.getVisibility()));
        }
        if (product.getVisibleRoles() != null) {
            productDto.setVisibleRoles(Arrays.asList(product.getVisibleRoles().split(",")));
        }
        if (product.getVisibleTenants() != null) {
            productDto.setVisibleTenants(Arrays.asList(product.getVisibleTenants().split(",")));
        }
        productDto.setAccessControl("restricted".equals(product.getAccessControl()) ? APIProductDTO.AccessControlEnum.RESTRICTED : APIProductDTO.AccessControlEnum.NONE);
        if (product.getAccessControlRoles() != null) {
            productDto.setAccessControlRoles(Arrays.asList(product.getAccessControlRoles().split(",")));
        }
        if (StringUtils.isEmpty((CharSequence)product.getTransports())) {
            ArrayList<String> transports = new ArrayList<String>();
            transports.add("https");
            productDto.setTransport(transports);
        } else {
            productDto.setTransport(Arrays.asList(product.getTransports().split(",")));
        }
        if (product.getAdditionalProperties() != null) {
            JSONObject additionalProperties = product.getAdditionalProperties();
            ArrayList<APIAdditionalPropertiesDTO> additionalPropertiesList = new ArrayList<APIAdditionalPropertiesDTO>();
            for (Object propertyKey : additionalProperties.keySet()) {
                APIAdditionalPropertiesDTO additionalPropertiesDTO = new APIAdditionalPropertiesDTO();
                String key = (String)propertyKey;
                int index = key.lastIndexOf("__display");
                additionalPropertiesDTO.setValue((String)additionalProperties.get((Object)key));
                if (index > 0) {
                    additionalPropertiesDTO.setName(key.substring(0, index));
                    additionalPropertiesDTO.setDisplay(true);
                } else {
                    additionalPropertiesDTO.setName(key);
                    additionalPropertiesDTO.setDisplay(false);
                }
                additionalPropertiesList.add(additionalPropertiesDTO);
            }
            productDto.setAdditionalProperties(additionalPropertiesList);
        }
        if (product.getApiSecurity() != null) {
            productDto.setSecurityScheme(Arrays.asList(product.getApiSecurity().split(",")));
        }
        List apiCategories = product.getApiCategories();
        ArrayList<String> categoryNameList = new ArrayList<String>();
        if (apiCategories != null && !apiCategories.isEmpty()) {
            for (APICategory category : apiCategories) {
                categoryNameList.add(category.getName());
            }
        }
        productDto.setCategories(categoryNameList);
        if (null != product.getLastUpdated()) {
            Date lastUpdateDate = product.getLastUpdated();
            timeStamp = new Timestamp(lastUpdateDate.getTime());
            productDto.setLastUpdatedTime(String.valueOf(timeStamp));
        }
        if (null != product.getCreatedTime()) {
            Date createdTime = product.getCreatedTime();
            timeStamp = new Timestamp(createdTime.getTime());
            productDto.setCreatedTime(String.valueOf(timeStamp));
        }
        return productDto;
    }

    private static APIProductDTO.SubscriptionAvailabilityEnum mapSubscriptionAvailabilityFromAPIProducttoDTO(String subscriptionAvailability) {
        switch (subscriptionAvailability) {
            case "current_tenant": {
                return APIProductDTO.SubscriptionAvailabilityEnum.CURRENT_TENANT;
            }
            case "all_tenants": {
                return APIProductDTO.SubscriptionAvailabilityEnum.ALL_TENANTS;
            }
            case "specific_tenants": {
                return APIProductDTO.SubscriptionAvailabilityEnum.SPECIFIC_TENANTS;
            }
        }
        return null;
    }

    private static APIProductDTO.VisibilityEnum mapVisibilityFromAPIProducttoDTO(String visibility) {
        switch (visibility) {
            case "public": {
                return APIProductDTO.VisibilityEnum.PUBLIC;
            }
            case "private": {
                return APIProductDTO.VisibilityEnum.PRIVATE;
            }
            case "restricted": {
                return APIProductDTO.VisibilityEnum.RESTRICTED;
            }
        }
        return null;
    }

    public static APIProduct fromDTOtoAPIProduct(APIProductDTO dto, String provider) throws APIManagementException {
        List<APIAdditionalPropertiesDTO> additionalProperties;
        List<String> accessControlRoles;
        APIProduct product = new APIProduct();
        APIProductIdentifier id = new APIProductIdentifier(APIUtil.replaceEmailDomain((String)provider), dto.getName(), "1.0.0");
        product.setID(id);
        product.setUuid(dto.getId());
        product.setDescription(dto.getDescription());
        String context = dto.getContext();
        if (context.endsWith("/{version}")) {
            context = context.replace("/{version}", "");
        }
        context = context.startsWith("/") ? context : "/" + context;
        String providerDomain = MultitenantUtils.getTenantDomain((String)provider);
        if (!"carbon.super".equalsIgnoreCase(providerDomain) && dto.getId() == null) {
            context = "/t/" + providerDomain + context;
        }
        product.setType("API Product".replaceAll("\\s", ""));
        product.setContext(context);
        context = APIMappingUtil.checkAndSetVersionParam(context);
        product.setContextTemplate(context);
        List<String> apiProductTags = dto.getTags();
        HashSet<String> tagsToReturn = new HashSet<String>(apiProductTags);
        product.addTags(tagsToReturn);
        if (dto.isEnableSchemaValidation() != null) {
            product.setEnableSchemaValidation(dto.isEnableSchemaValidation().booleanValue());
        }
        product.setEnableStore(true);
        if (dto.isResponseCachingEnabled() != null && dto.isResponseCachingEnabled().booleanValue()) {
            product.setResponseCache("Enabled");
        } else {
            product.setResponseCache("Disabled");
        }
        if (dto.getCacheTimeout() != null) {
            product.setCacheTimeout(dto.getCacheTimeout().intValue());
        } else {
            product.setCacheTimeout(300);
        }
        if (dto.getBusinessInformation() != null) {
            product.setBusinessOwner(dto.getBusinessInformation().getBusinessOwner());
            product.setBusinessOwnerEmail(dto.getBusinessInformation().getBusinessOwnerEmail());
            product.setTechnicalOwner(dto.getBusinessInformation().getTechnicalOwner());
            product.setTechnicalOwnerEmail(dto.getBusinessInformation().getTechnicalOwnerEmail());
        }
        product.setState(APIStatus.PUBLISHED.toString());
        HashSet<Tier> apiTiers = new HashSet<Tier>();
        List<String> tiersFromDTO = dto.getPolicies();
        if (dto.getVisibility() != null) {
            product.setVisibility(APIMappingUtil.mapVisibilityFromDTOtoAPIProduct(dto.getVisibility()));
        }
        if (dto.getVisibleRoles() != null) {
            String visibleRoles = StringUtils.join(dto.getVisibleRoles(), (char)',');
            product.setVisibleRoles(visibleRoles);
        }
        if (dto.getVisibleTenants() != null) {
            String visibleTenants = StringUtils.join(dto.getVisibleTenants(), (char)',');
            product.setVisibleTenants(visibleTenants);
        }
        if ((accessControlRoles = dto.getAccessControlRoles()) == null || accessControlRoles.isEmpty()) {
            product.setAccessControl("all");
            product.setAccessControlRoles("null");
        } else {
            product.setAccessControlRoles(StringUtils.join(accessControlRoles, (char)',').toLowerCase());
            product.setAccessControl("restricted");
        }
        for (String string : tiersFromDTO) {
            apiTiers.add(new Tier(string));
        }
        product.setAvailableTiers(apiTiers);
        product.setProductLevelPolicy(dto.getApiThrottlingPolicy());
        if (dto.getSubscriptionAvailability() != null) {
            product.setSubscriptionAvailability(APIMappingUtil.mapSubscriptionAvailabilityFromDTOtoAPIProduct(dto.getSubscriptionAvailability()));
        }
        if ((additionalProperties = dto.getAdditionalProperties()) != null) {
            for (APIAdditionalPropertiesDTO property : additionalProperties) {
                if (property.isDisplay().booleanValue()) {
                    product.addProperty(property.getName() + "__display", property.getValue());
                    continue;
                }
                product.addProperty(property.getName(), property.getValue());
            }
        }
        if (dto.getSubscriptionAvailableTenants() != null) {
            product.setSubscriptionAvailableTenants(StringUtils.join(dto.getSubscriptionAvailableTenants(), (String)","));
        }
        String string = StringUtils.join(dto.getTransport(), (char)',');
        product.setTransports(string);
        ArrayList<APIProductResource> productResources = new ArrayList<APIProductResource>();
        HashSet<String> verbResourceCombo = new HashSet<String>();
        for (ProductAPIDTO res : dto.getApis()) {
            List<APIOperationsDTO> productAPIOperationsDTO = res.getOperations();
            for (APIOperationsDTO resourceItem : productAPIOperationsDTO) {
                if (!verbResourceCombo.add(resourceItem.getVerb() + resourceItem.getTarget())) {
                    throw new APIManagementException("API Product resource: " + resourceItem.getTarget() + ", with verb: " + resourceItem.getVerb() + " , is duplicated for id " + id, ExceptionCodes.from((ErrorHandler)ExceptionCodes.API_PRODUCT_DUPLICATE_RESOURCE, (String[])new String[]{resourceItem.getTarget(), resourceItem.getVerb()}));
                }
                URITemplate template = new URITemplate();
                template.setHTTPVerb(resourceItem.getVerb());
                template.setResourceURI(resourceItem.getTarget());
                template.setUriTemplate(resourceItem.getTarget());
                APIProductResource resource = new APIProductResource();
                resource.setApiId(res.getApiId());
                resource.setUriTemplate(template);
                productResources.add(resource);
            }
        }
        Set<Scope> scopes = APIMappingUtil.getScopes(dto);
        product.setScopes(scopes);
        APICorsConfigurationDTO apiCorsConfigurationDTO = dto.getCorsConfiguration();
        CORSConfiguration corsConfiguration = apiCorsConfigurationDTO != null ? new CORSConfiguration(apiCorsConfigurationDTO.isCorsConfigurationEnabled().booleanValue(), apiCorsConfigurationDTO.getAccessControlAllowOrigins(), apiCorsConfigurationDTO.isAccessControlAllowCredentials().booleanValue(), apiCorsConfigurationDTO.getAccessControlAllowHeaders(), apiCorsConfigurationDTO.getAccessControlAllowMethods()) : APIUtil.getDefaultCorsConfiguration();
        product.setCorsConfiguration(corsConfiguration);
        product.setProductResources(productResources);
        product.setApiSecurity(APIMappingUtil.getSecurityScheme(dto.getSecurityScheme()));
        product.setAuthorizationHeader(dto.getAuthorizationHeader());
        APIMappingUtil.setAPICategoriesToModel(dto, product, provider);
        return product;
    }

    private static String mapVisibilityFromDTOtoAPIProduct(APIProductDTO.VisibilityEnum visibility) {
        switch (visibility) {
            case PUBLIC: {
                return "public";
            }
            case PRIVATE: {
                return "private";
            }
            case RESTRICTED: {
                return "restricted";
            }
        }
        return null;
    }

    private static String mapSubscriptionAvailabilityFromDTOtoAPIProduct(APIProductDTO.SubscriptionAvailabilityEnum subscriptionAvailability) {
        switch (subscriptionAvailability) {
            case CURRENT_TENANT: {
                return "current_tenant";
            }
            case ALL_TENANTS: {
                return "all_tenants";
            }
            case SPECIFIC_TENANTS: {
                return "specific_tenants";
            }
        }
        return "current_tenant";
    }

    public static ResourcePathListDTO fromResourcePathListToDTO(List<ResourcePath> resourcePathList, int limit, int offset) {
        ResourcePathListDTO resourcePathListDTO = new ResourcePathListDTO();
        ArrayList<ResourcePathDTO> resourcePathDTOs = new ArrayList<ResourcePathDTO>();
        int size = resourcePathList.size();
        int start = offset < size && offset >= 0 ? offset : Integer.MAX_VALUE;
        int end = offset + limit - 1 <= size - 1 ? offset + limit - 1 : size - 1;
        for (int i = start; i <= end; ++i) {
            ResourcePath path = resourcePathList.get(i);
            ResourcePathDTO dto = new ResourcePathDTO();
            dto.setId(path.getId());
            dto.setResourcePath(path.getResourcePath());
            dto.setHttpVerb(path.getHttpVerb());
            resourcePathDTOs.add(dto);
        }
        resourcePathListDTO.setCount(resourcePathDTOs.size());
        resourcePathListDTO.setList(resourcePathDTOs);
        return resourcePathListDTO;
    }

    public static void setPaginationParamsForAPIResourcePathList(ResourcePathListDTO resourcePathListDTO, int offset, int limit, int size) {
        Map paginatedParams = RestApiCommonUtil.getPaginationParams((Integer)offset, (Integer)limit, (Integer)size);
        String paginatedPrevious = "";
        String paginatedNext = "";
        if (paginatedParams.get("previous_offset") != null) {
            paginatedPrevious = RestApiCommonUtil.getResourcePathPaginatedURL((Integer)((Integer)paginatedParams.get("previous_offset")), (Integer)((Integer)paginatedParams.get("previous_limit")));
        }
        if (paginatedParams.get("next_offset") != null) {
            paginatedNext = RestApiCommonUtil.getResourcePathPaginatedURL((Integer)((Integer)paginatedParams.get("next_offset")), (Integer)((Integer)paginatedParams.get("next_limit")));
        }
        PaginationDTO paginationDTO = CommonMappingUtil.getPaginationDTO(limit, offset, size, paginatedNext, paginatedPrevious);
        resourcePathListDTO.setPagination(paginationDTO);
    }

    public static void setPaginationParams(APIProductListDTO apiProductListDTO, String query, int offset, int limit, int size) {
        Map paginatedParams = RestApiCommonUtil.getPaginationParams((Integer)offset, (Integer)limit, (Integer)size);
        String paginatedPrevious = "";
        String paginatedNext = "";
        if (paginatedParams.get("previous_offset") != null) {
            paginatedPrevious = RestApiCommonUtil.getAPIProductPaginatedURL((Integer)((Integer)paginatedParams.get("previous_offset")), (Integer)((Integer)paginatedParams.get("previous_limit")), (String)query);
        }
        if (paginatedParams.get("next_offset") != null) {
            paginatedNext = RestApiCommonUtil.getAPIProductPaginatedURL((Integer)((Integer)paginatedParams.get("next_offset")), (Integer)((Integer)paginatedParams.get("next_limit")), (String)query);
        }
        PaginationDTO paginationDTO = CommonMappingUtil.getPaginationDTO(limit, offset, size, paginatedNext, paginatedPrevious);
        apiProductListDTO.setPagination(paginationDTO);
    }

    public static APIProductIdentifier getAPIProductIdentifierFromUUID(String productId, String requestedTenantDomain) throws APIManagementException {
        APIProvider apiProvider = RestApiCommonUtil.getLoggedInUserProvider();
        APIProduct product = apiProvider.getAPIProductbyUUID(productId, requestedTenantDomain);
        return product.getId();
    }

    public static WSDLValidationResponseDTO fromWSDLValidationResponseToDTO(WSDLValidationResponse validationResponse) {
        WSDLValidationResponseDTO wsdlValidationResponseDTO = new WSDLValidationResponseDTO();
        if (validationResponse.isValid()) {
            wsdlValidationResponseDTO.setIsValid(true);
            WSDLInfo wsdlInfo = validationResponse.getWsdlInfo();
            WSDLValidationResponseWsdlInfoDTO wsdlInfoDTO = new WSDLValidationResponseWsdlInfoDTO();
            wsdlInfoDTO.setVersion(wsdlInfo.getVersion());
            List<WSDLValidationResponseWsdlInfoEndpointsDTO> endpointsDTOList = APIMappingUtil.fromEndpointsMapToWSDLValidationResponseEndpointsDTO(wsdlInfo.getEndpoints());
            wsdlInfoDTO.setEndpoints(endpointsDTOList);
            wsdlValidationResponseDTO.setWsdlInfo(wsdlInfoDTO);
        } else {
            wsdlValidationResponseDTO.setIsValid(false);
            wsdlValidationResponseDTO.setErrors(APIMappingUtil.getErrorListItemsDTOsFromErrorHandler(validationResponse.getError()));
        }
        return wsdlValidationResponseDTO;
    }

    private static List<WSDLValidationResponseWsdlInfoEndpointsDTO> fromEndpointsMapToWSDLValidationResponseEndpointsDTO(Map<String, String> endpoints) {
        ArrayList<WSDLValidationResponseWsdlInfoEndpointsDTO> endpointsDTOList = new ArrayList<WSDLValidationResponseWsdlInfoEndpointsDTO>();
        for (String endpointName : endpoints.keySet()) {
            WSDLValidationResponseWsdlInfoEndpointsDTO endpointDTO = new WSDLValidationResponseWsdlInfoEndpointsDTO();
            endpointDTO.setName(endpointName);
            endpointDTO.setLocation(endpoints.get(endpointName));
            endpointsDTOList.add(endpointDTO);
        }
        return endpointsDTOList;
    }

    private static List<ScopeDTO> getScopesFromSwagger(String swagger) throws APIManagementException {
        APIDefinition apiDefinition = OASParserUtil.getOASParser((String)swagger);
        Set scopes = apiDefinition.getScopes(swagger);
        ArrayList<ScopeDTO> scopeDTOS = new ArrayList<ScopeDTO>();
        for (Scope aScope : scopes) {
            ScopeDTO scopeDTO = new ScopeDTO();
            scopeDTO.setName(aScope.getKey());
            scopeDTO.setDisplayName(aScope.getName());
            scopeDTO.setDescription(aScope.getDescription());
            String roles = aScope.getRoles();
            if (roles == null || roles.isEmpty()) {
                scopeDTO.setBindings(Collections.emptyList());
            } else {
                scopeDTO.setBindings(Arrays.asList(roles.split(",")));
            }
            scopeDTOS.add(scopeDTO);
        }
        return scopeDTOS;
    }

    private static List<APIScopeDTO> getAPIScopesFromScopeDTOs(List<ScopeDTO> scopeDTOS) throws APIManagementException {
        ArrayList<APIScopeDTO> apiScopeDTOS = new ArrayList<APIScopeDTO>();
        APIProvider apiProvider = RestApiCommonUtil.getLoggedInUserProvider();
        String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        Set allSharedScopeKeys = apiProvider.getAllSharedScopeKeys(tenantDomain);
        scopeDTOS.forEach(scopeDTO -> {
            APIScopeDTO apiScopeDTO = new APIScopeDTO();
            apiScopeDTO.setScope((ScopeDTO)scopeDTO);
            apiScopeDTO.setShared(allSharedScopeKeys.contains(scopeDTO.getName()) ? Boolean.TRUE : Boolean.FALSE);
            apiScopeDTOS.add(apiScopeDTO);
        });
        return apiScopeDTOS;
    }

    private static List<APIScopeDTO> getAPIScopesFromScopeDTOs(List<ScopeDTO> scopeDTOS, APIProvider apiProvider) throws APIManagementException {
        ArrayList<APIScopeDTO> apiScopeDTOS = new ArrayList<APIScopeDTO>();
        String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        Set allSharedScopeKeys = apiProvider.getAllSharedScopeKeys(tenantDomain);
        scopeDTOS.forEach(scopeDTO -> {
            APIScopeDTO apiScopeDTO = new APIScopeDTO();
            apiScopeDTO.setScope((ScopeDTO)scopeDTO);
            apiScopeDTO.setShared(allSharedScopeKeys.contains(scopeDTO.getName()) ? Boolean.TRUE : Boolean.FALSE);
            apiScopeDTOS.add(apiScopeDTO);
        });
        return apiScopeDTOS;
    }

    public static APIIdentifier getAPIIdentifierFromApiIdOrUUID(String apiId, String requestedTenantDomain) throws APIManagementException {
        APIConsumer apiConsumer = RestApiCommonUtil.getLoggedInUserConsumer();
        APIIdentifier apiIdentifier = RestApiCommonUtil.isUUID((String)apiId) ? apiConsumer.getLightweightAPIByUUID(apiId, requestedTenantDomain).getId() : apiConsumer.getLightweightAPI(APIMappingUtil.getAPIIdentifierFromApiId(apiId), requestedTenantDomain).getId();
        return apiIdentifier;
    }

    public static APIIdentifier getAPIIdentifierFromApiId(String apiId) throws APIManagementException {
        String[] apiIdDetails = (apiId = APIUtil.replaceEmailDomainBack((String)apiId)).split("-");
        if (apiIdDetails.length < 3) {
            throw new APIManagementException("Provided API identifier '" + apiId + "' is invalid", ExceptionCodes.from((ErrorHandler)ExceptionCodes.INVALID_API_IDENTIFIER, (String[])new String[]{apiId}));
        }
        String providerName = null;
        try {
            providerName = URLDecoder.decode(apiIdDetails[0], "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            String errorMsg = "Couldn't decode value providerName: " + providerName;
            throw new APIManagementException(errorMsg, (Throwable)e);
        }
        String apiName = null;
        try {
            apiName = URLDecoder.decode(apiIdDetails[1], "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            String errorMsg = "Couldn't decode value apiName : " + apiName;
            throw new APIManagementException(errorMsg, (Throwable)e);
        }
        String version = null;
        try {
            version = URLDecoder.decode(apiIdDetails[2], "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            String errorMsg = "Couldn't decode value version : " + version;
            throw new APIManagementException(errorMsg, (Throwable)e);
        }
        String providerNameEmailReplaced = APIUtil.replaceEmailDomain((String)providerName);
        return new APIIdentifier(providerNameEmailReplaced, apiName, version);
    }

    public static API getAPIFromApiIdOrUUID(String apiId, String requestedTenantDomain) throws APIManagementException {
        API api;
        APIProvider apiProvider = RestApiCommonUtil.getLoggedInUserProvider();
        if (RestApiCommonUtil.isUUID((String)apiId)) {
            api = apiProvider.getAPIbyUUID(apiId, requestedTenantDomain);
        } else {
            APIIdentifier apiIdentifier = APIMappingUtil.getAPIIdentifierFromApiId(apiId);
            RestApiCommonUtil.validateUserTenantWithAPIIdentifier((APIIdentifier)apiIdentifier);
            api = apiProvider.getAPI(apiIdentifier);
        }
        return api;
    }

    private static boolean getSharedStatus(String resourcePath, String policyName) {
        return null != resourcePath && resourcePath.contains("/apimgt/customsequences");
    }

    private static Map<String, String> getMediationPolicyAttributes(String sequenceName, String direction, APIDTO dto) {
        APIIdentifier apiIdentifier = new APIIdentifier(dto.getProvider(), dto.getName(), dto.getVersion());
        String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        try {
            int tenantId = ServiceReferenceHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomain);
            return APIUtil.getMediationPolicyAttributes((String)sequenceName, (int)tenantId, (String)direction, (APIIdentifier)apiIdentifier);
        }
        catch (UserStoreException e) {
            log.error((Object)"Error occurred while reading tenant information ", (Throwable)e);
        }
        catch (APIManagementException e) {
            log.error((Object)"Error occurred while getting the uuid of the mediation sequence", (Throwable)e);
        }
        return null;
    }

    private static void setAPICategoriesToModel(Object dto, Object model, String provider) {
        List<Object> apiCategoryNames = new ArrayList();
        if (dto instanceof APIDTO) {
            APIDTO apiDTO = (APIDTO)dto;
            apiCategoryNames = apiDTO.getCategories();
        } else {
            APIProductDTO apiProductDTO = (APIProductDTO)dto;
            apiCategoryNames = apiProductDTO.getCategories();
        }
        provider = APIUtil.replaceEmailDomainBack((String)provider);
        String tenantDomain = MultitenantUtils.getTenantDomain((String)provider);
        int tenantId = APIUtil.getTenantIdFromTenantDomain((String)tenantDomain);
        ArrayList<APICategory> apiCategories = new ArrayList<APICategory>();
        for (String string : apiCategoryNames) {
            APICategory category = new APICategory();
            category.setName(string);
            category.setTenantID(tenantId);
            apiCategories.add(category);
        }
        if (model instanceof API) {
            ((API)model).setApiCategories(apiCategories);
        } else {
            ((APIProduct)model).setApiCategories(apiCategories);
        }
    }

    private static JSONObject handleEndpointSecurity(API api, JSONObject endpointSecurity, boolean preserveCredentials) throws APIManagementException {
        JSONObject productionEndpointSecurity;
        JSONObject sandboxEndpointSecurity;
        String tenantDomain = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack((String)api.getId().getProviderName()));
        if (APIMappingUtil.checkEndpointSecurityPasswordEnabled(tenantDomain) | preserveCredentials) {
            return endpointSecurity;
        }
        JSONObject endpointSecurityElement = new JSONObject();
        endpointSecurityElement.putAll((Map)endpointSecurity);
        if (endpointSecurityElement.get((Object)"sandbox") != null && (sandboxEndpointSecurity = (JSONObject)endpointSecurityElement.get((Object)"sandbox")).get((Object)"password") != null) {
            sandboxEndpointSecurity.put((Object)"password", (Object)"");
            if (sandboxEndpointSecurity.get((Object)"type").equals("oauth")) {
                sandboxEndpointSecurity.put((Object)"clientId", (Object)"");
                sandboxEndpointSecurity.put((Object)"clientSecret", (Object)"");
            }
        }
        if (endpointSecurityElement.get((Object)"production") != null && (productionEndpointSecurity = (JSONObject)endpointSecurityElement.get((Object)"production")).get((Object)"password") != null) {
            productionEndpointSecurity.put((Object)"password", (Object)"");
            if (productionEndpointSecurity.get((Object)"type").equals("oauth")) {
                productionEndpointSecurity.put((Object)"clientId", (Object)"");
                productionEndpointSecurity.put((Object)"clientSecret", (Object)"");
            }
        }
        return endpointSecurityElement;
    }

    private static JSONObject handleAWSCredentials(JSONObject awsEndpointConfig, boolean preserveCredentials) {
        if (StringUtils.isNotEmpty((CharSequence)((String)awsEndpointConfig.get((Object)"amznSecretKey")))) {
            if (!preserveCredentials) {
                awsEndpointConfig.put((Object)"amznSecretKey", (Object)"AWS_SECRET_KEY");
                return awsEndpointConfig;
            }
            String secretKey = (String)awsEndpointConfig.get((Object)"amznSecretKey");
            try {
                CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
                String decryptedSecret = new String(cryptoUtil.base64DecodeAndDecrypt(secretKey), "UTF-8");
                awsEndpointConfig.put((Object)"amznSecretKey", (Object)decryptedSecret);
                return awsEndpointConfig;
            }
            catch (UnsupportedEncodingException | CryptoException e) {
                log.error((Object)"Error while decrypting the Amazon key", e);
            }
        }
        return awsEndpointConfig;
    }

    public static APIRevisionDTO fromAPIRevisiontoDTO(APIRevision model) throws APIManagementException {
        APIRevisionDTO apiRevisionDTO = new APIRevisionDTO();
        apiRevisionDTO.setId(model.getRevisionUUID());
        String key = "Revision " + model.getId();
        apiRevisionDTO.setDisplayName(key);
        apiRevisionDTO.setDescription(model.getDescription());
        if (model.getCreatedTime() != null) {
            Date parsedDate;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            try {
                parsedDate = dateFormat.parse(model.getCreatedTime());
            }
            catch (java.text.ParseException e) {
                throw new APIManagementException("Error while parsing the created time:" + model.getCreatedTime(), (Throwable)e);
            }
            Timestamp timestamp = new Timestamp(parsedDate.getTime());
            apiRevisionDTO.setCreatedTime(timestamp);
        }
        APIRevisionAPIInfoDTO apiRevisionAPIInfoDTO = new APIRevisionAPIInfoDTO();
        apiRevisionAPIInfoDTO.setId(model.getApiUUID());
        apiRevisionDTO.setApiInfo(apiRevisionAPIInfoDTO);
        ArrayList<APIRevisionDeploymentDTO> apiRevisionDeploymentDTOS = new ArrayList<APIRevisionDeploymentDTO>();
        if (model.getApiRevisionDeploymentList() != null) {
            for (APIRevisionDeployment apiRevisionDeployment : model.getApiRevisionDeploymentList()) {
                apiRevisionDeploymentDTOS.add(APIMappingUtil.fromAPIRevisionDeploymenttoDTO(apiRevisionDeployment));
            }
        }
        apiRevisionDTO.setDeploymentInfo(apiRevisionDeploymentDTOS);
        return apiRevisionDTO;
    }

    public static APIRevisionListDTO fromListAPIRevisiontoDTO(List<APIRevision> apiRevisionList) throws APIManagementException {
        APIRevisionListDTO apiRevisionListDTO = new APIRevisionListDTO();
        ArrayList<APIRevisionDTO> apiRevisionDTOS = new ArrayList<APIRevisionDTO>();
        for (APIRevision apiRevision : apiRevisionList) {
            apiRevisionDTOS.add(APIMappingUtil.fromAPIRevisiontoDTO(apiRevision));
        }
        apiRevisionListDTO.setCount(apiRevisionList.size());
        apiRevisionListDTO.setList(apiRevisionDTOS);
        return apiRevisionListDTO;
    }

    public static APIRevisionDeploymentDTO fromAPIRevisionDeploymenttoDTO(APIRevisionDeployment model) throws APIManagementException {
        APIRevisionDeploymentDTO apiRevisionDeploymentDTO = new APIRevisionDeploymentDTO();
        apiRevisionDeploymentDTO.setName(model.getDeployment());
        apiRevisionDeploymentDTO.setVhost(model.getVhost());
        if (model.getRevisionUUID() != null) {
            apiRevisionDeploymentDTO.setRevisionUuid(model.getRevisionUUID());
        }
        apiRevisionDeploymentDTO.setDisplayOnDevportal(model.isDisplayOnDevportal());
        if (model.getDeployedTime() != null) {
            Date parsedDate;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            try {
                parsedDate = dateFormat.parse(model.getDeployedTime());
            }
            catch (java.text.ParseException e) {
                throw new APIManagementException("Error while parsing the created time:" + model.getDeployedTime(), (Throwable)e);
            }
            Timestamp timestamp = new Timestamp(parsedDate.getTime());
            apiRevisionDeploymentDTO.setDeployedTime(timestamp);
        }
        return apiRevisionDeploymentDTO;
    }

    public static APIRevisionDeploymentListDTO fromListAPIRevisionDeploymentToDTO(List<APIRevisionDeployment> apiRevisionDeploymentList) throws APIManagementException {
        APIRevisionDeploymentListDTO apiRevisionDeploymentListDTO = new APIRevisionDeploymentListDTO();
        ArrayList<APIRevisionDeploymentDTO> apiRevisionDeploymentDTOS = new ArrayList<APIRevisionDeploymentDTO>();
        for (APIRevisionDeployment apiRevisionDeployment : apiRevisionDeploymentList) {
            apiRevisionDeploymentDTOS.add(APIMappingUtil.fromAPIRevisionDeploymenttoDTO(apiRevisionDeployment));
        }
        apiRevisionDeploymentListDTO.setList(apiRevisionDeploymentDTOS);
        return apiRevisionDeploymentListDTO;
    }
}

