/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.ErrorHandler;
import org.wso2.carbon.apimgt.api.ExceptionCodes;
import org.wso2.carbon.apimgt.api.dto.CertificateMetadataDTO;
import org.wso2.carbon.apimgt.api.dto.ClientCertificateDTO;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.api.model.Identifier;
import org.wso2.carbon.apimgt.impl.importexport.APIImportExportException;
import org.wso2.carbon.apimgt.impl.importexport.ExportFormat;
import org.wso2.carbon.apimgt.impl.importexport.ImportExportConstants;
import org.wso2.carbon.apimgt.impl.importexport.utils.CommonUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.APIMappingUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.ImportUtils;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIProductDTO;

public class APIControllerUtil {
    public static JsonObject resolveAPIControllerEnvParams(String pathToArchive) throws IOException {
        String jsonParamsContent = ImportUtils.getFileContentAsJson(pathToArchive + ImportExportConstants.INTERMEDIATE_PARAMS_FILE_LOCATION);
        if (StringUtils.isEmpty((CharSequence)jsonParamsContent)) {
            return null;
        }
        JsonElement paramsElement = new JsonParser().parse(jsonParamsContent);
        return paramsElement.getAsJsonObject();
    }

    public static JsonObject getDependentAPIsParams(String path) throws IOException {
        JsonObject paramsConfigObject = APIControllerUtil.resolveAPIControllerEnvParams(path);
        JsonObject dependentAPIsParams = null;
        if (paramsConfigObject != null && paramsConfigObject.has("dependentAPIs")) {
            dependentAPIsParams = paramsConfigObject.get("dependentAPIs").getAsJsonObject();
        }
        return dependentAPIsParams;
    }

    public static JsonObject getDependentAPIParams(JsonObject dependentAPIsParams, String apiDirectoryName) {
        if (dependentAPIsParams.has(apiDirectoryName)) {
            return dependentAPIsParams.get(apiDirectoryName).getAsJsonObject();
        }
        return null;
    }

    public static APIDTO injectEnvParamsToAPI(APIDTO importedApiDto, JsonObject envParams, String pathToArchive) throws APIManagementException {
        JsonElement policies;
        HashMap endpointConfig;
        if (envParams == null || envParams.isJsonNull()) {
            return importedApiDto;
        }
        API importedApi = APIMappingUtil.fromDTOtoAPI(importedApiDto, importedApiDto.getProvider());
        JsonElement endpointTypeElement = envParams.get("endpointType");
        String endpointType = null;
        endpointType = endpointTypeElement != null ? endpointTypeElement.getAsString() : "rest";
        JsonObject jsonObject = APIControllerUtil.setupMultipleEndpoints(envParams, endpointType);
        if (envParams.get("security") != null) {
            APIControllerUtil.handleEndpointSecurityConfigs(envParams, jsonObject);
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            endpointConfig = (HashMap)mapper.readValue(jsonObject.toString(), HashMap.class);
            APIControllerUtil.convertValuesToStrings(endpointConfig);
        }
        catch (JsonProcessingException e) {
            String errorMessage = "Error while reading endpointConfig information in the params file.";
            throw new APIManagementException(errorMessage, (Throwable)e, (ErrorHandler)ExceptionCodes.ERROR_READING_PARAMS_FILE);
        }
        importedApiDto.setEndpointConfig(endpointConfig);
        APIControllerUtil.handleMutualSslCertificates(envParams, importedApiDto, null, (Identifier)importedApi.getId(), pathToArchive);
        JsonElement endpointCertificates = envParams.get("certs");
        if (endpointCertificates != null) {
            try {
                String jsonString = endpointCertificates.toString();
                APIControllerUtil.handleEndpointCertificates(new JsonParser().parse(jsonString).getAsJsonArray(), pathToArchive);
            }
            catch (IOException e) {
                String errorMessage = "Error while generating meta information of client certificates from path.";
                throw new APIManagementException(errorMessage, (Throwable)e, (ErrorHandler)ExceptionCodes.ERROR_READING_PARAMS_FILE);
            }
        }
        if ((policies = envParams.get("policies")) != null && !policies.isJsonNull()) {
            APIControllerUtil.handleSubscriptionPolicies(policies, importedApiDto, null);
        }
        return importedApiDto;
    }

    private static void convertValuesToStrings(Map<String, Object> keyValuePairs) {
        for (Map.Entry<String, Object> pair : keyValuePairs.entrySet()) {
            if (pair.getValue() instanceof Integer && pair.getKey() instanceof String) {
                keyValuePairs.replace(pair.getKey().toString(), pair.getValue().toString());
            }
            if (!(pair.getValue() instanceof Map)) continue;
            APIControllerUtil.convertValuesToStrings((Map)pair.getValue());
        }
    }

    private static void handleMutualSslCertificates(JsonObject envParams, APIDTO importedApiDto, APIProductDTO importedApiProductDto, Identifier identifier, String pathToArchive) throws APIManagementException {
        JsonElement clientCertificates = envParams.get("mutualSslCerts");
        if (clientCertificates != null) {
            try {
                List<String> apiSecurity;
                List<String> list = apiSecurity = importedApiDto != null ? importedApiDto.getSecurityScheme() : importedApiProductDto.getSecurityScheme();
                if (!apiSecurity.isEmpty()) {
                    if (!apiSecurity.contains("mutualssl")) {
                        apiSecurity.add("mutualssl");
                    }
                } else {
                    apiSecurity.add("mutualssl");
                }
                if (importedApiDto != null) {
                    importedApiDto.securityScheme(apiSecurity);
                } else {
                    importedApiProductDto.securityScheme(apiSecurity);
                }
                String jsonString = clientCertificates.toString();
                APIControllerUtil.handleClientCertificates(new JsonParser().parse(jsonString).getAsJsonArray(), identifier, pathToArchive);
            }
            catch (IOException e) {
                String errorMessage = "Error while generating meta information of client certificates from path.";
                throw new APIManagementException(errorMessage, (Throwable)e, (ErrorHandler)ExceptionCodes.ERROR_READING_PARAMS_FILE);
            }
        }
    }

    public static APIProductDTO injectEnvParamsToAPIProduct(APIProductDTO importedApiProductDto, JsonObject envParams, String pathToArchive) throws APIManagementException {
        if (envParams == null || envParams.isJsonNull()) {
            return importedApiProductDto;
        }
        APIProduct importedApiProduct = APIMappingUtil.fromDTOtoAPIProduct(importedApiProductDto, importedApiProductDto.getProvider());
        APIControllerUtil.handleMutualSslCertificates(envParams, null, importedApiProductDto, (Identifier)importedApiProduct.getId(), pathToArchive);
        JsonElement policies = envParams.get("policies");
        if (policies != null && !policies.isJsonNull()) {
            APIControllerUtil.handleSubscriptionPolicies(policies, null, importedApiProductDto);
        }
        return importedApiProductDto;
    }

    private static void handleEndpointSecurityConfigs(JsonObject envParams, JsonObject endpointConfig) throws APIManagementException {
        String[] endpointTypes;
        JsonObject security = envParams.getAsJsonObject("security");
        if (security == null) {
            return;
        }
        for (String endpointType : endpointTypes = new String[]{"production", "sandbox"}) {
            if (security.has(endpointType)) {
                String securityEnabled;
                JsonObject endpointSecurityDetails = security.get(endpointType).getAsJsonObject();
                if (!endpointSecurityDetails.has("enabled") || !Boolean.parseBoolean(securityEnabled = endpointSecurityDetails.get("enabled").getAsString())) continue;
                JsonElement type = endpointSecurityDetails.get("type");
                if (endpointSecurityDetails.get("username") == null) {
                    throw new APIManagementException("You have enabled endpoint security but the username is not found in the params file. Please specify username field for and continue...", (ErrorHandler)ExceptionCodes.ERROR_READING_PARAMS_FILE);
                }
                if (endpointSecurityDetails.get("password") == null) {
                    throw new APIManagementException("You have enabled endpoint security but the password is not found in the params file. Please specify password field for and continue...", (ErrorHandler)ExceptionCodes.ERROR_READING_PARAMS_FILE);
                }
                if (type == null) {
                    throw new APIManagementException("You have enabled endpoint security but the password is not found in the params file. Please specify password field for and continue...", (ErrorHandler)ExceptionCodes.ERROR_READING_PARAMS_FILE);
                }
                endpointSecurityDetails.remove("type");
                if (StringUtils.equals((CharSequence)type.getAsString().toLowerCase(), (CharSequence)"digest")) {
                    endpointSecurityDetails.addProperty("type", "digest".toUpperCase());
                    continue;
                }
                if (StringUtils.equals((CharSequence)type.getAsString().toLowerCase(), (CharSequence)"basic")) {
                    endpointSecurityDetails.addProperty("type", "basic".toUpperCase());
                    continue;
                }
                throw new APIManagementException("Invalid endpoint security type found in the params file. Should be either basic or digestPlease specify correct security types field for and continue...", (ErrorHandler)ExceptionCodes.ERROR_READING_PARAMS_FILE);
            }
            JsonObject endpointSecurityForNotDefinedEndpointType = new JsonObject();
            endpointSecurityForNotDefinedEndpointType.addProperty("type", "NONE");
            endpointSecurityForNotDefinedEndpointType.addProperty("enabled", Boolean.FALSE);
            security.add(endpointType, (JsonElement)endpointSecurityForNotDefinedEndpointType);
        }
        endpointConfig.add("endpoint_security", (JsonElement)security);
    }

    private static void handleSubscriptionPolicies(JsonElement policies, APIDTO importedApiDto, APIProductDTO importedApiProductDto) {
        JsonArray definedPolicies = policies.getAsJsonArray();
        ArrayList<String> policiesListToAdd = new ArrayList<String>();
        for (JsonElement definedPolicy : definedPolicies) {
            String policyToAdd;
            if (definedPolicy.isJsonNull() || StringUtils.isEmpty((CharSequence)(policyToAdd = definedPolicy.getAsString()))) continue;
            policiesListToAdd.add(definedPolicy.getAsString());
        }
        if (policiesListToAdd.size() > 0) {
            if (importedApiDto != null) {
                importedApiDto.setPolicies(policiesListToAdd);
            } else {
                importedApiProductDto.setPolicies(policiesListToAdd);
            }
        }
    }

    private static List<String> setupGatewayEnvironments(JsonArray gatewayEnvironments) {
        ArrayList<String> environments = new ArrayList<String>();
        for (int i = 0; i < gatewayEnvironments.size(); ++i) {
            environments.add(gatewayEnvironments.get(i).getAsString());
        }
        return environments;
    }

    private static JsonObject setupMultipleEndpoints(JsonObject envParams, String endpointType) throws APIManagementException {
        JsonObject defaultProductionEndpoint = new JsonObject();
        defaultProductionEndpoint.addProperty("url", "localhost");
        JsonObject defaultSandboxEndpoint = new JsonObject();
        defaultSandboxEndpoint.addProperty("url", "localhost");
        JsonObject multipleEndpointsConfig = null;
        String routingPolicy = null;
        if (envParams.get("endpointRoutingPolicy") != null) {
            routingPolicy = envParams.get("endpointRoutingPolicy").getAsString();
        }
        if (StringUtils.isEmpty(routingPolicy)) {
            multipleEndpointsConfig = APIControllerUtil.handleDynamicAndAwsEndpoints(envParams, defaultProductionEndpoint, defaultSandboxEndpoint, endpointType);
        }
        if (StringUtils.equals((CharSequence)endpointType, (CharSequence)"http") || StringUtils.equals((CharSequence)endpointType, (CharSequence)"rest")) {
            multipleEndpointsConfig = APIControllerUtil.handleRestEndpoints(routingPolicy, envParams, defaultProductionEndpoint, defaultSandboxEndpoint);
        }
        if ("soap".equals(endpointType)) {
            multipleEndpointsConfig = APIControllerUtil.handleSoapEndpoints(routingPolicy, envParams, defaultProductionEndpoint, defaultSandboxEndpoint);
        }
        return multipleEndpointsConfig;
    }

    private static JsonObject handleDynamicAndAwsEndpoints(JsonObject envParams, JsonObject defaultProductionEndpoint, JsonObject defaultSandboxEndpoint, String endpointType) throws APIManagementException {
        JsonObject endpointsObject = null;
        if (envParams.get("endpoints") != null) {
            endpointsObject = envParams.get("endpoints").getAsJsonObject();
        }
        if ("rest".equals(endpointType) || "soap".equals(endpointType) || "http".equals(endpointType)) {
            return null;
        }
        if ("dynamic".equals(endpointType)) {
            JsonObject updatedDynamicEndpointParams = new JsonObject();
            defaultProductionEndpoint.addProperty("url", "default");
            defaultSandboxEndpoint.addProperty("url", "default");
            updatedDynamicEndpointParams.addProperty("endpoint_type", "default");
            updatedDynamicEndpointParams.addProperty("failover", Boolean.FALSE.toString());
            APIControllerUtil.handleEndpointValues(endpointsObject, updatedDynamicEndpointParams, defaultProductionEndpoint, defaultSandboxEndpoint);
            return updatedDynamicEndpointParams;
        }
        if ("aws".equals(endpointType)) {
            if (envParams.get("awsLambdaEndpoints") == null) {
                throw new APIManagementException("Please specify awsLambdaEndpoints field for the environment and continue...", (ErrorHandler)ExceptionCodes.ERROR_READING_PARAMS_FILE);
            }
            JsonObject awsEndpointParams = envParams.get("awsLambdaEndpoints").getAsJsonObject();
            JsonObject updatedAwsEndpointParams = new JsonObject();
            if (StringUtils.equals((CharSequence)awsEndpointParams.get("accessMethod").getAsString(), (CharSequence)"stored")) {
                updatedAwsEndpointParams = awsEndpointParams;
                updatedAwsEndpointParams.remove("accessMethod");
                updatedAwsEndpointParams.addProperty("access_method", "stored");
            } else {
                updatedAwsEndpointParams.addProperty("access_method", "role-supplied");
            }
            updatedAwsEndpointParams.addProperty("endpoint_type", "awslambda");
            APIControllerUtil.handleEndpointValues(endpointsObject, updatedAwsEndpointParams, defaultProductionEndpoint, defaultSandboxEndpoint);
            return updatedAwsEndpointParams;
        }
        throw new APIManagementException("Please specify valid endpoint configurations for the environment and continue...", (ErrorHandler)ExceptionCodes.ERROR_READING_PARAMS_FILE);
    }

    private static JsonObject handleRestEndpoints(String routingPolicy, JsonObject envParams, JsonObject defaultProductionEndpoint, JsonObject defaultSandboxEndpoint) throws APIManagementException {
        JsonObject updatedRESTEndpointParams = new JsonObject();
        JsonObject endpoints = null;
        if (envParams.get("endpoints") != null) {
            endpoints = envParams.get("endpoints").getAsJsonObject();
        }
        if (StringUtils.isEmpty((CharSequence)routingPolicy)) {
            updatedRESTEndpointParams.addProperty("endpoint_type", "http");
            APIControllerUtil.handleEndpointValues(endpoints, updatedRESTEndpointParams, defaultProductionEndpoint, defaultSandboxEndpoint);
        } else if ("load_balanced".equals(routingPolicy)) {
            JsonElement sessionTimeOut;
            JsonElement loadBalancedConfigElement = envParams.get("loadBalanceEndpoints");
            if (loadBalancedConfigElement == null) {
                throw new APIManagementException("Please specify loadBalanceEndpoints for the environment and continue...", (ErrorHandler)ExceptionCodes.ERROR_READING_PARAMS_FILE);
            }
            JsonObject loadBalancedConfigs = loadBalancedConfigElement.getAsJsonObject();
            updatedRESTEndpointParams.addProperty("endpoint_type", "load_balance");
            updatedRESTEndpointParams.addProperty("algoClassName", "org.apache.synapse.endpoints.algorithms.RoundRobin");
            JsonElement sessionManagement = loadBalancedConfigs.get("sessionManagement");
            if (sessionManagement != null && !sessionManagement.isJsonNull() && !StringUtils.equals((CharSequence)sessionManagement.getAsString(), (CharSequence)"transport")) {
                updatedRESTEndpointParams.add("sessionManagement", loadBalancedConfigs.get("sessionManagement"));
            }
            if ((sessionTimeOut = loadBalancedConfigs.get("sessionTimeOut")) != null) {
                updatedRESTEndpointParams.add("sessionTimeOut", loadBalancedConfigs.get("sessionTimeOut"));
            }
            APIControllerUtil.handleEndpointValues(loadBalancedConfigs, updatedRESTEndpointParams, defaultProductionEndpoint, defaultSandboxEndpoint);
        } else if ("failover".equals(routingPolicy)) {
            JsonElement failoverConfigElement = envParams.get("failoverEndpoints");
            if (failoverConfigElement == null) {
                throw new APIManagementException("Please specify failoverEndpoints field for the environment and continue...", (ErrorHandler)ExceptionCodes.ERROR_READING_PARAMS_FILE);
            }
            JsonObject failoverConfigs = failoverConfigElement.getAsJsonObject();
            updatedRESTEndpointParams.addProperty("endpoint_type", "failover");
            updatedRESTEndpointParams.addProperty("failOver", Boolean.TRUE.toString());
            JsonElement productionEndpoints = failoverConfigs.get("production");
            JsonElement productionFailOvers = failoverConfigs.get("productionFailovers");
            if (productionFailOvers == null) {
                if (productionEndpoints != null) {
                    throw new APIManagementException("Please specify production failover field for the environment and continue...", (ErrorHandler)ExceptionCodes.ERROR_READING_PARAMS_FILE);
                }
            } else if (!productionFailOvers.isJsonNull()) {
                updatedRESTEndpointParams.add("production_failovers", productionFailOvers);
            }
            JsonElement sandboxFailOvers = failoverConfigs.get("sandboxFailovers");
            JsonElement sandboxEndpoints = failoverConfigs.get("sandbox");
            if (sandboxFailOvers == null) {
                if (sandboxEndpoints != null) {
                    throw new APIManagementException("Please specify sandbox failover field for for the environment and continue...", (ErrorHandler)ExceptionCodes.ERROR_READING_PARAMS_FILE);
                }
            } else if (!sandboxFailOvers.isJsonNull()) {
                updatedRESTEndpointParams.add("sandbox_failovers", sandboxFailOvers);
            }
            APIControllerUtil.handleEndpointValues(failoverConfigs, updatedRESTEndpointParams, defaultProductionEndpoint, defaultSandboxEndpoint);
        }
        return updatedRESTEndpointParams;
    }

    private static JsonObject handleSoapEndpoints(String routingPolicy, JsonObject envParams, JsonObject defaultProductionEndpoint, JsonObject defaultSandboxEndpoint) throws APIManagementException {
        JsonObject updatedSOAPEndpointParams = new JsonObject();
        JsonObject endpoints = null;
        if (envParams.get("endpoints") != null) {
            endpoints = envParams.get("endpoints").getAsJsonObject();
        }
        if (StringUtils.isEmpty((CharSequence)routingPolicy)) {
            updatedSOAPEndpointParams.addProperty("endpoint_type", "address");
            APIControllerUtil.handleEndpointValues(endpoints, updatedSOAPEndpointParams, defaultProductionEndpoint, defaultSandboxEndpoint);
        } else if ("load_balanced".equals(routingPolicy)) {
            JsonElement sandboxEndpoints;
            JsonElement productionEndpoints;
            JsonElement sessionTimeOut;
            JsonElement loadBalancedConfigElement = envParams.get("loadBalanceEndpoints");
            if (loadBalancedConfigElement == null) {
                throw new APIManagementException("Please specify loadBalanceEndpoints field for for the environment and continue...", (ErrorHandler)ExceptionCodes.ERROR_READING_PARAMS_FILE);
            }
            JsonObject loadBalancedConfigs = loadBalancedConfigElement.getAsJsonObject();
            updatedSOAPEndpointParams.addProperty("endpoint_type", "load_balance");
            updatedSOAPEndpointParams.addProperty("algoClassName", "org.apache.synapse.endpoints.algorithms.RoundRobin");
            JsonElement sessionManagement = loadBalancedConfigs.get("sessionManagement");
            if (sessionManagement != null && !sessionManagement.isJsonNull() && !StringUtils.equals((CharSequence)sessionManagement.getAsString(), (CharSequence)"transport")) {
                updatedSOAPEndpointParams.add("sessionManagement", loadBalancedConfigs.get("sessionManagement"));
            }
            if ((sessionTimeOut = loadBalancedConfigs.get("sessionTimeOut")) != null) {
                updatedSOAPEndpointParams.add("sessionTimeOut", loadBalancedConfigs.get("sessionTimeOut"));
            }
            if ((productionEndpoints = loadBalancedConfigs.get("production")) != null) {
                updatedSOAPEndpointParams.add("production_endpoints", (JsonElement)APIControllerUtil.handleSoapFailoverAndLoadBalancedEndpointValues(productionEndpoints.getAsJsonArray()));
            }
            if ((sandboxEndpoints = loadBalancedConfigs.get("sandbox")) != null) {
                updatedSOAPEndpointParams.add("sandbox_endpoints", (JsonElement)sandboxEndpoints.getAsJsonArray());
            }
        } else if ("failover".equals(routingPolicy)) {
            JsonElement failoverConfigElement = envParams.get("failoverEndpoints");
            if (failoverConfigElement == null) {
                throw new APIManagementException("Please specify failoverEndpoints field for the environment and continue...", (ErrorHandler)ExceptionCodes.ERROR_READING_PARAMS_FILE);
            }
            JsonObject failoverConfigs = failoverConfigElement.getAsJsonObject();
            updatedSOAPEndpointParams.addProperty("endpoint_type", "failover");
            updatedSOAPEndpointParams.addProperty("failOver", Boolean.TRUE.toString());
            JsonElement productionFailOvers = failoverConfigs.get("productionFailovers");
            JsonElement productionEndpoints = failoverConfigs.get("production");
            if (productionFailOvers == null) {
                if (productionEndpoints != null) {
                    throw new APIManagementException("Please specify production failover field for the environment and continue...", (ErrorHandler)ExceptionCodes.ERROR_READING_PARAMS_FILE);
                }
            } else if (!productionFailOvers.isJsonNull()) {
                updatedSOAPEndpointParams.add("production_failovers", (JsonElement)APIControllerUtil.handleSoapFailoverAndLoadBalancedEndpointValues(productionFailOvers.getAsJsonArray()));
            }
            JsonElement sandboxFailOvers = failoverConfigs.get("sandboxFailovers");
            JsonElement sandboxEndpoints = failoverConfigs.get("sandbox");
            if (sandboxFailOvers == null) {
                if (sandboxEndpoints != null) {
                    throw new APIManagementException("Please specify sandbox failover field for the environment and continue...", (ErrorHandler)ExceptionCodes.ERROR_READING_PARAMS_FILE);
                }
            } else if (!sandboxFailOvers.isJsonNull()) {
                updatedSOAPEndpointParams.add("sandbox_failovers", (JsonElement)APIControllerUtil.handleSoapFailoverAndLoadBalancedEndpointValues(sandboxFailOvers.getAsJsonArray()));
            }
            updatedSOAPEndpointParams.add("production_endpoints", (JsonElement)APIControllerUtil.handleSoapProdAndSandboxEndpointValues(productionEndpoints));
            updatedSOAPEndpointParams.add("sandbox_endpoints", (JsonElement)APIControllerUtil.handleSoapProdAndSandboxEndpointValues(sandboxEndpoints));
        }
        return updatedSOAPEndpointParams;
    }

    private static void handleEndpointValues(JsonObject endpointConfigs, JsonObject updatedEndpointParams, JsonObject defaultProductionEndpoint, JsonObject defaultSandboxEndpoint) throws APIManagementException {
        if (endpointConfigs == null) {
            updatedEndpointParams.add("production_endpoints", (JsonElement)defaultProductionEndpoint);
            updatedEndpointParams.add("sandbox_endpoints", (JsonElement)defaultSandboxEndpoint);
        } else {
            if (endpointConfigs.get("production") != null) {
                updatedEndpointParams.add("production_endpoints", endpointConfigs.get("production"));
            }
            if (endpointConfigs.get("sandbox") != null) {
                updatedEndpointParams.add("sandbox_endpoints", endpointConfigs.get("sandbox"));
            }
            if (updatedEndpointParams.get("sandbox_endpoints") == null && updatedEndpointParams.get("production_endpoints") == null) {
                throw new APIManagementException("Please specify production sandbox or endpoints for the environment and continue...", (ErrorHandler)ExceptionCodes.ERROR_READING_PARAMS_FILE);
            }
            if (updatedEndpointParams.get("sandbox_endpoints") != null && updatedEndpointParams.get("sandbox_endpoints").isJsonNull() && updatedEndpointParams.get("production_endpoints") != null && updatedEndpointParams.get("production_endpoints").isJsonNull()) {
                throw new APIManagementException("Please specify production or sandbox endpoints for the environment and continue...", (ErrorHandler)ExceptionCodes.ERROR_READING_PARAMS_FILE);
            }
        }
    }

    private static JsonArray handleSoapFailoverAndLoadBalancedEndpointValues(JsonArray failoverEndpoints) {
        for (JsonElement endpoint : failoverEndpoints) {
            JsonObject endpointObject = endpoint.getAsJsonObject();
            endpointObject.addProperty("endpoint_type", "address");
        }
        return failoverEndpoints;
    }

    private static JsonObject handleSoapProdAndSandboxEndpointValues(JsonElement soapEndpoint) {
        JsonObject soapEndpointObj = null;
        if (soapEndpoint == null) {
            return null;
        }
        if (!soapEndpoint.isJsonNull()) {
            soapEndpointObj = soapEndpoint.getAsJsonObject();
            soapEndpointObj.addProperty("endpoint_type", "address");
        }
        return soapEndpointObj;
    }

    private static void handleClientCertificates(JsonArray certificates, Identifier identifier, String pathToArchive) throws IOException, APIManagementException {
        APIIdentifier apiIdentifier = new APIIdentifier(identifier.getProviderName(), identifier.getName(), identifier.getVersion());
        ArrayList<ClientCertificateDTO> certs = new ArrayList<ClientCertificateDTO>();
        for (JsonElement certificate : certificates) {
            JsonObject certObject = certificate.getAsJsonObject();
            String alias = certObject.get("alias").getAsString();
            ClientCertificateDTO cert = new ClientCertificateDTO();
            cert.setApiIdentifier(apiIdentifier);
            cert.setAlias(alias);
            cert.setTierName(certObject.get("tierName").getAsString());
            String certName = certObject.get("path").getAsString();
            cert.setCertificate(certName);
            certs.add(cert);
            String clientCertificatesDirectory = pathToArchive + ImportExportConstants.CLIENT_CERTIFICATES_DIRECTORY_PATH;
            if (!CommonUtil.checkFileExistence((String)clientCertificatesDirectory)) {
                try {
                    CommonUtil.createDirectory((String)clientCertificatesDirectory);
                }
                catch (APIImportExportException e) {
                    throw new APIManagementException((Throwable)e);
                }
            }
            String userCertificatesTempDirectory = pathToArchive + ImportExportConstants.DEPLOYMENT_DIRECTORY + ImportExportConstants.CERTIFICATE_DIRECTORY;
            String sourcePath = userCertificatesTempDirectory + File.separator + certName;
            String destinationPath = clientCertificatesDirectory + File.separator + certName;
            if (Files.notExists(Paths.get(sourcePath, new String[0]), new LinkOption[0])) {
                String errorMessage = "The mentioned certificate file " + certName + " is not in the certificates directory";
                throw new APIManagementException(errorMessage, (ErrorHandler)ExceptionCodes.ERROR_READING_PARAMS_FILE);
            }
            CommonUtil.moveFile((String)sourcePath, (String)destinationPath);
        }
        JsonElement jsonElement = new Gson().toJsonTree(certs);
        String metadataFilePath = pathToArchive + ImportExportConstants.CLIENT_CERTIFICATES_META_DATA_FILE_PATH;
        try {
            File oldFile;
            if (CommonUtil.checkFileExistence((String)(metadataFilePath + ".yaml"))) {
                oldFile = new File(metadataFilePath + ".yaml");
                oldFile.delete();
            }
            if (CommonUtil.checkFileExistence((String)(metadataFilePath + ".json"))) {
                oldFile = new File(metadataFilePath + ".json");
                oldFile.delete();
            }
            CommonUtil.writeDtoToFile((String)metadataFilePath, (ExportFormat)ExportFormat.JSON, (String)"client_certificates", (Object)jsonElement);
        }
        catch (APIImportExportException e) {
            throw new APIManagementException((Throwable)e);
        }
    }

    private static void handleEndpointCertificates(JsonArray certificates, String pathToArchive) throws IOException, APIManagementException {
        JsonArray updatedCertsArray = new JsonArray();
        for (JsonElement certificate : certificates) {
            JsonObject certObject = certificate.getAsJsonObject();
            String alias = certObject.get("alias").getAsString();
            CertificateMetadataDTO certificateMetadataDTO = new CertificateMetadataDTO();
            certificateMetadataDTO.setAlias(alias);
            certificateMetadataDTO.setEndpoint(certObject.get("hostName").getAsString());
            JsonElement jsonElement = new Gson().toJsonTree((Object)certificateMetadataDTO);
            JsonObject updatedCertObj = jsonElement.getAsJsonObject();
            String certName = certObject.get("path").getAsString();
            updatedCertObj.addProperty("certificate", certName);
            updatedCertsArray.add((JsonElement)updatedCertObj);
            String endpointCertificatesDirectory = pathToArchive + ImportExportConstants.ENDPOINT_CERTIFICATES_DIRECTORY_PATH;
            if (!CommonUtil.checkFileExistence((String)endpointCertificatesDirectory)) {
                try {
                    CommonUtil.createDirectory((String)endpointCertificatesDirectory);
                }
                catch (APIImportExportException e) {
                    throw new APIManagementException((Throwable)e);
                }
            }
            String userCertificatesTempDirectory = pathToArchive + ImportExportConstants.DEPLOYMENT_DIRECTORY + ImportExportConstants.CERTIFICATE_DIRECTORY;
            String sourcePath = userCertificatesTempDirectory + File.separator + certName;
            String destinationPath = endpointCertificatesDirectory + File.separator + certName;
            if (Files.notExists(Paths.get(sourcePath, new String[0]), new LinkOption[0])) {
                String errorMessage = "The mentioned certificate file " + certName + " is not in the certificates directory";
                throw new APIManagementException(errorMessage, (ErrorHandler)ExceptionCodes.ERROR_READING_PARAMS_FILE);
            }
            CommonUtil.moveFile((String)sourcePath, (String)destinationPath);
        }
        String metadataFilePath = pathToArchive + ImportExportConstants.ENDPOINT_CERTIFICATES_META_DATA_FILE_PATH;
        try {
            File oldFile;
            if (CommonUtil.checkFileExistence((String)(metadataFilePath + ".yaml"))) {
                oldFile = new File(metadataFilePath + ".yaml");
                oldFile.delete();
            }
            if (CommonUtil.checkFileExistence((String)(metadataFilePath + ".json"))) {
                oldFile = new File(metadataFilePath + ".json");
                oldFile.delete();
            }
            CommonUtil.writeDtoToFile((String)metadataFilePath, (ExportFormat)ExportFormat.JSON, (String)"endpoint_certificates", (Object)updatedCertsArray);
        }
        catch (APIImportExportException e) {
            throw new APIManagementException((Throwable)e);
        }
    }
}

