/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.apimgt.api.APIDefinition;
import org.wso2.carbon.apimgt.api.APIDefinitionValidationResponse;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.dto.ClientCertificateDTO;
import org.wso2.carbon.apimgt.api.gateway.CredentialDto;
import org.wso2.carbon.apimgt.api.gateway.GatewayAPIDTO;
import org.wso2.carbon.apimgt.api.gateway.GatewayContentDTO;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.api.model.APIProductIdentifier;
import org.wso2.carbon.apimgt.api.model.APIProductResource;
import org.wso2.carbon.apimgt.api.model.CORSConfiguration;
import org.wso2.carbon.apimgt.api.model.Environment;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import org.wso2.carbon.apimgt.api.model.WebSocketTopicMappingConfiguration;
import org.wso2.carbon.apimgt.impl.APIConstants;
import org.wso2.carbon.apimgt.impl.APIMRegistryServiceImpl;
import org.wso2.carbon.apimgt.impl.certificatemgt.exceptions.CertificateManagementException;
import org.wso2.carbon.apimgt.impl.dto.SoapToRestMediationDto;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.template.APITemplateBuilder;
import org.wso2.carbon.apimgt.impl.template.APITemplateException;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.impl.utils.CertificateMgtUtils;
import org.wso2.carbon.apimgt.impl.utils.GatewayUtils;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.APIMappingUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.ImportUtils;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.template.APITemplateBuilderImpl;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIOperationsDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.MediationPolicyDTO;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.user.api.UserStoreException;

public class TemplateBuilderUtil {
    private static final String ENDPOINT_PRODUCTION = "_PRODUCTION_";
    private static final String ENDPOINT_SANDBOX = "_SANDBOX_";
    private static final Log log = LogFactory.getLog(TemplateBuilderUtil.class);

    public static APITemplateBuilderImpl getAPITemplateBuilder(API api, String tenantDomain, List<ClientCertificateDTO> clientCertificateDTOS, List<SoapToRestMediationDto> soapToRestInMediationDtos, List<SoapToRestMediationDto> soapToRestMediationDtos) throws APIManagementException {
        String removeHeaderFromOutMessage;
        int tenantId = APIUtil.getTenantIdFromTenantDomain((String)tenantDomain);
        APITemplateBuilderImpl vtb = new APITemplateBuilderImpl(api, soapToRestInMediationDtos, soapToRestMediationDtos);
        HashMap<String, String> latencyStatsProperties = new HashMap<String, String>();
        latencyStatsProperties.put("apiUUID", api.getUUID());
        if (!APIUtil.isStreamingApi((API)api)) {
            vtb.addHandler("org.wso2.carbon.apimgt.gateway.handlers.common.APIMgtLatencyStatsHandler", latencyStatsProperties);
        }
        HashMap<String, String> corsProperties = new HashMap<String, String>();
        corsProperties.put("apiImplementationType", api.getImplementation());
        String authorizationHeader = !StringUtils.isBlank((CharSequence)api.getAuthorizationHeader()) ? api.getAuthorizationHeader() : APIUtil.getOAuthConfiguration((int)tenantId, (String)"AuthorizationHeader");
        if (!StringUtils.isBlank((CharSequence)authorizationHeader)) {
            corsProperties.put("AuthorizationHeader", authorizationHeader);
        }
        if (!APIConstants.APITransportType.WS.toString().equals(api.getType())) {
            if (api.getCorsConfiguration() != null && api.getCorsConfiguration().isCorsConfigurationEnabled()) {
                CORSConfiguration corsConfiguration = api.getCorsConfiguration();
                if (corsConfiguration.getAccessControlAllowHeaders() != null) {
                    StringBuilder allowHeaders = new StringBuilder();
                    for (String header : corsConfiguration.getAccessControlAllowHeaders()) {
                        allowHeaders.append(header).append(',');
                    }
                    if (allowHeaders.length() != 0) {
                        allowHeaders.deleteCharAt(allowHeaders.length() - 1);
                        corsProperties.put("allowHeaders", allowHeaders.toString());
                    }
                }
                if (corsConfiguration.getAccessControlAllowOrigins() != null) {
                    StringBuilder allowOrigins = new StringBuilder();
                    for (String origin : corsConfiguration.getAccessControlAllowOrigins()) {
                        allowOrigins.append(origin).append(',');
                    }
                    if (allowOrigins.length() != 0) {
                        allowOrigins.deleteCharAt(allowOrigins.length() - 1);
                        corsProperties.put("allowedOrigins", allowOrigins.toString());
                    }
                }
                if (corsConfiguration.getAccessControlAllowMethods() != null) {
                    StringBuilder allowedMethods = new StringBuilder();
                    for (String methods : corsConfiguration.getAccessControlAllowMethods()) {
                        allowedMethods.append(methods).append(',');
                    }
                    if (allowedMethods.length() != 0) {
                        allowedMethods.deleteCharAt(allowedMethods.length() - 1);
                        corsProperties.put("allowedMethods", allowedMethods.toString());
                    }
                }
                if (corsConfiguration.isAccessControlAllowCredentials()) {
                    corsProperties.put("allowCredentials", String.valueOf(corsConfiguration.isAccessControlAllowCredentials()));
                }
                vtb.addHandler("org.wso2.carbon.apimgt.gateway.handlers.security.CORSRequestHandler", corsProperties);
            } else if (APIUtil.isCORSEnabled()) {
                vtb.addHandler("org.wso2.carbon.apimgt.gateway.handlers.security.CORSRequestHandler", corsProperties);
            }
            vtb.addHandler("org.wso2.carbon.apimgt.gateway.handlers.common.APIStatusHandler", Collections.emptyMap());
        }
        HashMap<String, String> clientCertificateObject = null;
        CertificateMgtUtils certificateMgtUtils = CertificateMgtUtils.getInstance();
        if (clientCertificateDTOS != null) {
            clientCertificateObject = new HashMap<String, String>();
            for (ClientCertificateDTO clientCertificateDTO : clientCertificateDTOS) {
                clientCertificateObject.put(certificateMgtUtils.getUniqueIdentifierOfCertificate(clientCertificateDTO.getCertificate()), clientCertificateDTO.getTierName());
            }
        }
        HashMap<String, String> authProperties = new HashMap<String, String>();
        if (!StringUtils.isBlank((CharSequence)authorizationHeader)) {
            authProperties.put("AuthorizationHeader", authorizationHeader);
        }
        String apiSecurity = api.getApiSecurity();
        String apiLevelPolicy = api.getApiLevelPolicy();
        authProperties.put("APISecurity", apiSecurity);
        authProperties.put("APILevelPolicy", apiLevelPolicy);
        if (clientCertificateObject != null) {
            authProperties.put("CertificateInformation", ((Object)clientCertificateObject).toString());
        }
        if (!StringUtils.isBlank((CharSequence)(removeHeaderFromOutMessage = APIUtil.getOAuthConfiguration((int)tenantId, (String)"RemoveOAuthHeadersFromOutMessage")))) {
            authProperties.put("RemoveOAuthHeadersFromOutMessage", removeHeaderFromOutMessage);
        } else {
            authProperties.put("RemoveOAuthHeadersFromOutMessage", "true");
        }
        authProperties.put("apiUUID", api.getUUID());
        authProperties.put("keyManagers", String.join((CharSequence)",", api.getKeyManagers()));
        if ("GRAPHQL".equals(api.getType())) {
            HashMap<String, String> apiUUIDProperty = new HashMap<String, String>();
            apiUUIDProperty.put("apiUUID", api.getUUID());
            vtb.addHandler("org.wso2.carbon.apimgt.gateway.handlers.graphQL.GraphQLAPIHandler", apiUUIDProperty);
        }
        if (APIConstants.APITransportType.WEBSUB.toString().equals(api.getType())) {
            authProperties.put("eventReceiverResourcePath", "/webhooks_events_receiver_resource");
            authProperties.put("topicQueryParamName", "hub.topic");
            vtb.addHandler("org.wso2.carbon.apimgt.gateway.handlers.streaming.webhook.WebhookApiHandler", authProperties);
            vtb.addHandler("org.wso2.carbon.apimgt.gateway.handlers.streaming.webhook.WebhooksExtensionHandler", Collections.emptyMap());
        } else if (APIConstants.APITransportType.SSE.toString().equals(api.getType())) {
            vtb.addHandler("org.wso2.carbon.apimgt.gateway.handlers.streaming.sse.SseApiHandler", authProperties);
        } else if (!APIConstants.APITransportType.WS.toString().equals(api.getType())) {
            vtb.addHandler("org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", authProperties);
        }
        if ("GRAPHQL".equals(api.getType())) {
            vtb.addHandler("org.wso2.carbon.apimgt.gateway.handlers.graphQL.GraphQLQueryAnalysisHandler", Collections.emptyMap());
        }
        if (!APIUtil.isStreamingApi((API)api)) {
            HashMap<String, String> properties = new HashMap<String, String>();
            if (api.getProductionMaxTps() != null) {
                properties.put("productionMaxCount", api.getProductionMaxTps());
            }
            if (api.getSandboxMaxTps() != null) {
                properties.put("sandboxMaxCount", api.getSandboxMaxTps());
            }
            vtb.addHandler("org.wso2.carbon.apimgt.gateway.handlers.throttling.ThrottleHandler", properties);
            properties = new HashMap();
            properties.put("configKey", "ga-config-key");
            vtb.addHandler("org.wso2.carbon.apimgt.gateway.handlers.analytics.APIMgtGoogleAnalyticsTrackingHandler", properties);
            String extensionHandlerPosition = TemplateBuilderUtil.getExtensionHandlerPosition(tenantDomain);
            if ("top".equalsIgnoreCase(extensionHandlerPosition)) {
                vtb.addHandlerPriority("org.wso2.carbon.apimgt.gateway.handlers.ext.APIManagerExtensionHandler", Collections.emptyMap(), 0);
            } else {
                vtb.addHandler("org.wso2.carbon.apimgt.gateway.handlers.ext.APIManagerExtensionHandler", Collections.emptyMap());
            }
        }
        return vtb;
    }

    public static APITemplateBuilderImpl getAPITemplateBuilder(APIProduct apiProduct, String tenantDomain, List<ClientCertificateDTO> clientCertificateDTOS, Map<String, APIDTO> associatedAPIMap) throws APIManagementException {
        String removeHeaderFromOutMessage;
        int tenantId = APIUtil.getTenantIdFromTenantDomain((String)tenantDomain);
        APITemplateBuilderImpl vtb = new APITemplateBuilderImpl(apiProduct, associatedAPIMap);
        HashMap<String, String> latencyStatsProperties = new HashMap<String, String>();
        latencyStatsProperties.put("apiUUID", apiProduct.getUuid());
        if (!APIUtil.isStreamingApi((APIProduct)apiProduct)) {
            vtb.addHandler("org.wso2.carbon.apimgt.gateway.handlers.common.APIMgtLatencyStatsHandler", latencyStatsProperties);
        }
        HashMap<String, String> corsProperties = new HashMap<String, String>();
        corsProperties.put("apiImplementationType", "ENDPOINT");
        String authorizationHeader = !StringUtils.isBlank((CharSequence)apiProduct.getAuthorizationHeader()) ? apiProduct.getAuthorizationHeader() : APIUtil.getOAuthConfiguration((int)tenantId, (String)"AuthorizationHeader");
        if (!StringUtils.isBlank((CharSequence)authorizationHeader)) {
            corsProperties.put("AuthorizationHeader", authorizationHeader);
        }
        if (apiProduct.getCorsConfiguration() != null && apiProduct.getCorsConfiguration().isCorsConfigurationEnabled()) {
            CORSConfiguration corsConfiguration = apiProduct.getCorsConfiguration();
            if (corsConfiguration.getAccessControlAllowHeaders() != null) {
                StringBuilder allowHeaders = new StringBuilder();
                for (String header : corsConfiguration.getAccessControlAllowHeaders()) {
                    allowHeaders.append(header).append(',');
                }
                if (allowHeaders.length() != 0) {
                    allowHeaders.deleteCharAt(allowHeaders.length() - 1);
                    corsProperties.put("allowHeaders", allowHeaders.toString());
                }
            }
            if (corsConfiguration.getAccessControlAllowOrigins() != null) {
                StringBuilder allowOrigins = new StringBuilder();
                for (String origin : corsConfiguration.getAccessControlAllowOrigins()) {
                    allowOrigins.append(origin).append(',');
                }
                if (allowOrigins.length() != 0) {
                    allowOrigins.deleteCharAt(allowOrigins.length() - 1);
                    corsProperties.put("allowedOrigins", allowOrigins.toString());
                }
            }
            if (corsConfiguration.getAccessControlAllowMethods() != null) {
                StringBuilder allowedMethods = new StringBuilder();
                for (String methods : corsConfiguration.getAccessControlAllowMethods()) {
                    allowedMethods.append(methods).append(',');
                }
                if (allowedMethods.length() != 0) {
                    allowedMethods.deleteCharAt(allowedMethods.length() - 1);
                    corsProperties.put("allowedMethods", allowedMethods.toString());
                }
            }
            if (corsConfiguration.isAccessControlAllowCredentials()) {
                corsProperties.put("allowCredentials", String.valueOf(corsConfiguration.isAccessControlAllowCredentials()));
            }
            vtb.addHandler("org.wso2.carbon.apimgt.gateway.handlers.security.CORSRequestHandler", corsProperties);
        } else if (APIUtil.isCORSEnabled()) {
            vtb.addHandler("org.wso2.carbon.apimgt.gateway.handlers.security.CORSRequestHandler", corsProperties);
        }
        HashMap<String, String> clientCertificateObject = null;
        CertificateMgtUtils certificateMgtUtils = CertificateMgtUtils.getInstance();
        if (clientCertificateDTOS != null) {
            clientCertificateObject = new HashMap<String, String>();
            for (ClientCertificateDTO clientCertificateDTO : clientCertificateDTOS) {
                clientCertificateObject.put(certificateMgtUtils.getUniqueIdentifierOfCertificate(clientCertificateDTO.getCertificate()), clientCertificateDTO.getTierName());
            }
        }
        HashMap<String, String> authProperties = new HashMap<String, String>();
        if (!StringUtils.isBlank((CharSequence)authorizationHeader)) {
            authProperties.put("AuthorizationHeader", authorizationHeader);
        }
        String apiSecurity = apiProduct.getApiSecurity();
        String apiLevelPolicy = apiProduct.getProductLevelPolicy();
        authProperties.put("APISecurity", apiSecurity);
        authProperties.put("APILevelPolicy", apiLevelPolicy);
        if (clientCertificateObject != null) {
            authProperties.put("CertificateInformation", ((Object)clientCertificateObject).toString());
        }
        if (!StringUtils.isBlank((CharSequence)(removeHeaderFromOutMessage = APIUtil.getOAuthConfiguration((int)tenantId, (String)"RemoveOAuthHeadersFromOutMessage")))) {
            authProperties.put("RemoveOAuthHeadersFromOutMessage", removeHeaderFromOutMessage);
        } else {
            authProperties.put("RemoveOAuthHeadersFromOutMessage", "true");
        }
        authProperties.put("apiType", APIConstants.ApiTypes.PRODUCT_API.name());
        vtb.addHandler("org.wso2.carbon.apimgt.gateway.handlers.security.APIAuthenticationHandler", authProperties);
        HashMap<String, String> properties = new HashMap<String, String>();
        if (apiProduct.getProductionMaxTps() != null) {
            properties.put("productionMaxCount", apiProduct.getProductionMaxTps());
        }
        if (apiProduct.getSandboxMaxTps() != null) {
            properties.put("sandboxMaxCount", apiProduct.getSandboxMaxTps());
        }
        if (!APIUtil.isStreamingApi((APIProduct)apiProduct)) {
            vtb.addHandler("org.wso2.carbon.apimgt.gateway.handlers.throttling.ThrottleHandler", properties);
            properties = new HashMap();
            properties.put("configKey", "ga-config-key");
            vtb.addHandler("org.wso2.carbon.apimgt.gateway.handlers.analytics.APIMgtGoogleAnalyticsTrackingHandler", properties);
            String extensionHandlerPosition = TemplateBuilderUtil.getExtensionHandlerPosition(tenantDomain);
            if ("top".equalsIgnoreCase(extensionHandlerPosition)) {
                vtb.addHandlerPriority("org.wso2.carbon.apimgt.gateway.handlers.ext.APIManagerExtensionHandler", Collections.emptyMap(), 0);
            } else {
                vtb.addHandler("org.wso2.carbon.apimgt.gateway.handlers.ext.APIManagerExtensionHandler", Collections.emptyMap());
            }
        }
        return vtb;
    }

    private static String getExtensionHandlerPosition(String tenantDomain) throws APIManagementException {
        String extensionHandlerPosition = null;
        try {
            String content = TemplateBuilderUtil.getTenantConfigContent(tenantDomain);
            if (content != null) {
                JSONParser jsonParser = new JSONParser();
                JSONObject tenantConf = (JSONObject)jsonParser.parse(content);
                extensionHandlerPosition = (String)tenantConf.get((Object)"ExtensionHandlerPosition");
            }
        }
        catch (RegistryException | UserStoreException e) {
            throw new APIManagementException("Couldn't read tenant configuration from tenant registry", e);
        }
        catch (ParseException e) {
            throw new APIManagementException("Couldn't parse tenant configuration for reading extension handler position", (Throwable)e);
        }
        return extensionHandlerPosition;
    }

    protected static String getTenantConfigContent(String tenantDomain) throws RegistryException, UserStoreException {
        APIMRegistryServiceImpl apimRegistryService = new APIMRegistryServiceImpl();
        return apimRegistryService.getConfigRegistryResourceContent(tenantDomain, "/apimgt/applicationdata/tenant-conf.json");
    }

    public static GatewayAPIDTO retrieveGatewayAPIDto(API api, Environment environment, String tenantDomain, APIDTO apidto, String extractedFolderPath) throws APIManagementException, XMLStreamException, APITemplateException {
        List<ClientCertificateDTO> clientCertificatesDTOList = ImportUtils.retrieveClientCertificates(extractedFolderPath);
        List<SoapToRestMediationDto> soapToRestInMediationDtoList = ImportUtils.retrieveSoapToRestFlowMediations(extractedFolderPath, "in");
        List<SoapToRestMediationDto> soapToRestOutMediationDtoList = ImportUtils.retrieveSoapToRestFlowMediations(extractedFolderPath, "out");
        APITemplateBuilderImpl apiTemplateBuilder = TemplateBuilderUtil.getAPITemplateBuilder(api, tenantDomain, clientCertificatesDTOList, soapToRestInMediationDtoList, soapToRestOutMediationDtoList);
        return TemplateBuilderUtil.createAPIGatewayDTOtoPublishAPI(environment, api, apiTemplateBuilder, tenantDomain, extractedFolderPath, apidto, clientCertificatesDTOList);
    }

    public static GatewayAPIDTO retrieveGatewayAPIDto(API api, Environment environment, String tenantDomain, APIDTO apidto, String extractedFolderPath, APIDefinitionValidationResponse apiDefinitionValidationResponse) throws APIManagementException, XMLStreamException, APITemplateException, CertificateManagementException {
        if (apiDefinitionValidationResponse.isValid()) {
            APIDefinition parser = apiDefinitionValidationResponse.getParser();
            String definition = apiDefinitionValidationResponse.getJsonContent();
            if (parser != null) {
                Set uriTemplates = parser.getURITemplates(definition);
                block0: for (URITemplate uriTemplate : uriTemplates) {
                    for (URITemplate template : api.getUriTemplates()) {
                        if (!template.getHTTPVerb().equalsIgnoreCase(uriTemplate.getHTTPVerb()) || !template.getUriTemplate().equals(uriTemplate.getUriTemplate())) continue;
                        template.setMediationScript(uriTemplate.getMediationScript());
                        template.setMediationScripts(uriTemplate.getHTTPVerb(), uriTemplate.getMediationScript());
                        template.setAmznResourceName(uriTemplate.getAmznResourceName());
                        template.setAmznResourceTimeout(uriTemplate.getAmznResourceTimeout());
                        continue block0;
                    }
                }
            }
        }
        return TemplateBuilderUtil.retrieveGatewayAPIDto(api, environment, tenantDomain, apidto, extractedFolderPath);
    }

    public static GatewayAPIDTO retrieveGatewayAPIDtoForStreamingAPI(API api, Environment environment, String tenantDomain, APIDTO apidto, String extractedFolderPath) throws APIManagementException, XMLStreamException, APITemplateException, CertificateManagementException {
        return TemplateBuilderUtil.retrieveGatewayAPIDto(api, environment, tenantDomain, apidto, extractedFolderPath);
    }

    public static GatewayAPIDTO retrieveGatewayAPIDto(APIProduct apiProduct, Environment environment, String tenantDomain, String extractedFolderPath) throws APIManagementException, XMLStreamException, APITemplateException {
        List<ClientCertificateDTO> clientCertificatesDTOList = ImportUtils.retrieveClientCertificates(extractedFolderPath);
        Map<String, APIDTO> apidtoMap = TemplateBuilderUtil.retrieveAssociatedApis(extractedFolderPath);
        Map<String, APIDTO> associatedAPIsMap = TemplateBuilderUtil.convertAPIIdToDto(apidtoMap.values());
        for (APIProductResource productResource : apiProduct.getProductResources()) {
            String sequenceName;
            String apiId = productResource.getApiId();
            APIDTO apidto = associatedAPIsMap.get(apiId);
            if (apidto == null) continue;
            API api = APIMappingUtil.fromDTOtoAPI(apidto, apidto.getProvider());
            productResource.setApiIdentifier(api.getId());
            productResource.setEndpointConfig(api.getEndpointConfig());
            if (StringUtils.isNotEmpty((CharSequence)api.getInSequence())) {
                sequenceName = APIUtil.getSequenceExtensionName((String)apiProduct.getId().getName(), (String)apiProduct.getId().getVersion()) + "--In";
                productResource.setInSequenceName(sequenceName);
            }
            if (StringUtils.isNotEmpty((CharSequence)api.getOutSequence())) {
                sequenceName = APIUtil.getSequenceExtensionName((String)apiProduct.getId().getName(), (String)apiProduct.getId().getVersion()) + "--Out";
                productResource.setOutSequenceName(sequenceName);
            }
            if (StringUtils.isNotEmpty((CharSequence)api.getFaultSequence())) {
                sequenceName = APIUtil.getSequenceExtensionName((String)apiProduct.getId().getName(), (String)apiProduct.getId().getVersion()) + "--Fault";
                productResource.setFaultSequenceName(sequenceName);
            }
            productResource.setProductIdentifier(apiProduct.getId());
            productResource.setEndpointSecurityMap(APIUtil.setEndpointSecurityForAPIProduct((API)api));
        }
        APITemplateBuilderImpl apiTemplateBuilder = TemplateBuilderUtil.getAPITemplateBuilder(apiProduct, tenantDomain, clientCertificatesDTOList, TemplateBuilderUtil.convertAPIIdToDto(associatedAPIsMap.values()));
        return TemplateBuilderUtil.createAPIGatewayDTOtoPublishAPI(environment, apiProduct, apiTemplateBuilder, tenantDomain, apidtoMap, clientCertificatesDTOList);
    }

    private static GatewayAPIDTO createAPIGatewayDTOtoPublishAPI(Environment environment, APIProduct apiProduct, APITemplateBuilder builder, String tenantDomain, Map<String, APIDTO> associatedAPIsMap, List<ClientCertificateDTO> clientCertificatesDTOList) throws APITemplateException, XMLStreamException, APIManagementException {
        APIProductIdentifier id = apiProduct.getId();
        GatewayAPIDTO productAPIDto = new GatewayAPIDTO();
        productAPIDto.setProvider(id.getProviderName());
        productAPIDto.setApiId(apiProduct.getUuid());
        productAPIDto.setName(id.getName());
        productAPIDto.setVersion(id.getVersion());
        productAPIDto.setTenantDomain(tenantDomain);
        String definition = apiProduct.getDefinition();
        productAPIDto.setLocalEntriesToBeRemove(GatewayUtils.addStringToList((String)apiProduct.getUuid(), (String[])productAPIDto.getLocalEntriesToBeRemove()));
        GatewayContentDTO productLocalEntry = new GatewayContentDTO();
        productLocalEntry.setName(apiProduct.getUuid());
        productLocalEntry.setContent("<localEntry key=\"" + apiProduct.getUuid() + "\">" + definition.replaceAll("&(?!amp;)", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "</localEntry>");
        productAPIDto.setLocalEntriesToBeAdd(TemplateBuilderUtil.addGatewayContentToList(productLocalEntry, productAPIDto.getLocalEntriesToBeAdd()));
        TemplateBuilderUtil.setClientCertificatesToBeAdded(tenantDomain, productAPIDto, clientCertificatesDTOList);
        productAPIDto.setApiDefinition(builder.getConfigStringForTemplate(environment));
        for (Map.Entry<String, APIDTO> apidtoEntry : associatedAPIsMap.entrySet()) {
            String apiExtractedPath = apidtoEntry.getKey();
            APIDTO apidto = apidtoEntry.getValue();
            API api = APIMappingUtil.fromDTOtoAPI(apidto, apidto.getProvider());
            api.setUuid(apidto.getId());
            GatewayUtils.setCustomSequencesToBeRemoved((APIProductIdentifier)apiProduct.getId(), (String)api.getUuid(), (GatewayAPIDTO)productAPIDto);
            APITemplateBuilderImpl apiTemplateBuilder = new APITemplateBuilderImpl(api, apiProduct);
            TemplateBuilderUtil.addEndpoints(api, apiTemplateBuilder, productAPIDto);
            TemplateBuilderUtil.setCustomSequencesToBeAdded(apiProduct, api, productAPIDto, apiExtractedPath, apidto);
            TemplateBuilderUtil.setAPIFaultSequencesToBeAdded(api, productAPIDto, apiExtractedPath, apidto);
            String prefix = id.getName() + "--v" + id.getVersion();
            TemplateBuilderUtil.setSecureVaultPropertyToBeAdded(prefix, api, productAPIDto);
        }
        return productAPIDto;
    }

    private static void setCustomSequencesToBeAdded(APIProduct apiProduct, API api, GatewayAPIDTO gatewayAPIDTO, String extractedPath, APIDTO apidto) throws APIManagementException {
        GatewayContentDTO gatewayOutContentDTO;
        GatewayContentDTO gatewayInContentDTO = TemplateBuilderUtil.retrieveSequence(apiProduct, extractedPath, apidto.getMediationPolicies(), "in", api);
        if (gatewayInContentDTO != null) {
            gatewayAPIDTO.setSequenceToBeAdd(TemplateBuilderUtil.addGatewayContentToList(gatewayInContentDTO, gatewayAPIDTO.getSequenceToBeAdd()));
        }
        if ((gatewayOutContentDTO = TemplateBuilderUtil.retrieveSequence(apiProduct, extractedPath, apidto.getMediationPolicies(), "out", api)) != null) {
            gatewayAPIDTO.setSequenceToBeAdd(TemplateBuilderUtil.addGatewayContentToList(gatewayOutContentDTO, gatewayAPIDTO.getSequenceToBeAdd()));
        }
    }

    private static GatewayAPIDTO createAPIGatewayDTOtoPublishAPI(Environment environment, API api, APITemplateBuilder builder, String tenantDomain, String extractedPath, APIDTO apidto, List<ClientCertificateDTO> clientCertificatesDTOList) throws APIManagementException, APITemplateException, XMLStreamException {
        GatewayContentDTO apiLocalEntry;
        GatewayAPIDTO gatewayAPIDTO = new GatewayAPIDTO();
        gatewayAPIDTO.setName(api.getId().getName());
        gatewayAPIDTO.setVersion(api.getId().getVersion());
        gatewayAPIDTO.setProvider(api.getId().getProviderName());
        gatewayAPIDTO.setApiId(api.getUUID());
        gatewayAPIDTO.setTenantDomain(tenantDomain);
        if (api.getType() != null && APIConstants.APITransportType.GRAPHQL.toString().equals(api.getType())) {
            gatewayAPIDTO.setLocalEntriesToBeRemove(GatewayUtils.addStringToList((String)(api.getUUID() + "_graphQL"), (String[])gatewayAPIDTO.getLocalEntriesToBeRemove()));
            GatewayContentDTO graphqlLocalEntry = new GatewayContentDTO();
            graphqlLocalEntry.setName(api.getUUID() + "_graphQL");
            graphqlLocalEntry.setContent("<localEntry key=\"" + api.getUUID() + "_graphQL\">" + api.getGraphQLSchema() + "</localEntry>");
            gatewayAPIDTO.setLocalEntriesToBeAdd(TemplateBuilderUtil.addGatewayContentToList(graphqlLocalEntry, gatewayAPIDTO.getLocalEntriesToBeAdd()));
            HashSet<URITemplate> uriTemplates = new HashSet<URITemplate>();
            URITemplate template = new URITemplate();
            template.setAuthType("Any");
            template.setHTTPVerb("POST");
            template.setHttpVerbs("POST");
            template.setUriTemplate("/*");
            uriTemplates.add(template);
            api.setUriTemplates(uriTemplates);
        } else if (api.getType() != null && (APIConstants.APITransportType.HTTP.toString().equals(api.getType()) || "SOAP".equals(api.getType()) || "SOAPTOREST".equals(api.getType()))) {
            String definition = api.getSwaggerDefinition();
            gatewayAPIDTO.setLocalEntriesToBeRemove(GatewayUtils.addStringToList((String)api.getUUID(), (String[])gatewayAPIDTO.getLocalEntriesToBeRemove()));
            apiLocalEntry = new GatewayContentDTO();
            apiLocalEntry.setName(api.getUUID());
            apiLocalEntry.setContent("<localEntry key=\"" + api.getUUID() + "\">" + definition.replaceAll("&(?!amp;)", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "</localEntry>");
            gatewayAPIDTO.setLocalEntriesToBeAdd(TemplateBuilderUtil.addGatewayContentToList(apiLocalEntry, gatewayAPIDTO.getLocalEntriesToBeAdd()));
        } else if (api.getType() != null && (APIConstants.APITransportType.WS.toString().equals(api.getType()) || APIConstants.APITransportType.SSE.toString().equals(api.getType()) || APIConstants.APITransportType.WEBSUB.toString().equals(api.getType()))) {
            gatewayAPIDTO.setLocalEntriesToBeRemove(GatewayUtils.addStringToList((String)api.getUUID(), (String[])gatewayAPIDTO.getLocalEntriesToBeRemove()));
            String definition = api.getAsyncApiDefinition();
            apiLocalEntry = new GatewayContentDTO();
            apiLocalEntry.setName(api.getUUID());
            apiLocalEntry.setContent("<localEntry key=\"" + api.getUUID() + "\">" + definition.replaceAll("&(?!amp;)", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "</localEntry>");
            gatewayAPIDTO.setLocalEntriesToBeAdd(TemplateBuilderUtil.addGatewayContentToList(apiLocalEntry, gatewayAPIDTO.getLocalEntriesToBeAdd()));
        }
        if ("production".equals(environment.getType()) && !APIUtil.isProductionEndpointsExists((String)api.getEndpointConfig()) || "sandbox".equals(environment.getType()) && !APIUtil.isSandboxEndpointsExists((String)api.getEndpointConfig())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Not adding API to environment " + environment.getName() + " since its endpoint URL cannot be found"));
            }
            return null;
        }
        GatewayUtils.setCustomSequencesToBeRemoved((API)api, (GatewayAPIDTO)gatewayAPIDTO);
        TemplateBuilderUtil.setAPIFaultSequencesToBeAdded(api, gatewayAPIDTO, extractedPath, apidto);
        TemplateBuilderUtil.setCustomSequencesToBeAdded(api, gatewayAPIDTO, extractedPath, apidto);
        TemplateBuilderUtil.setClientCertificatesToBeAdded(tenantDomain, gatewayAPIDTO, clientCertificatesDTOList);
        boolean isWsApi = APIConstants.APITransportType.WS.toString().equals(api.getType());
        if (isWsApi) {
            TemplateBuilderUtil.addWebsocketTopicMappings(api, apidto);
        }
        if ("INLINE".equalsIgnoreCase(api.getImplementation())) {
            String prototypeScriptAPI = builder.getConfigStringForPrototypeScriptAPI(environment);
            gatewayAPIDTO.setApiDefinition(prototypeScriptAPI);
        } else if ("ENDPOINT".equalsIgnoreCase(api.getImplementation())) {
            String apiConfig = builder.getConfigStringForTemplate(environment);
            gatewayAPIDTO.setApiDefinition(apiConfig);
            org.json.JSONObject endpointConfig = new org.json.JSONObject(api.getEndpointConfig());
            if (!endpointConfig.get("endpoint_type").equals("awslambda")) {
                if (!isWsApi) {
                    TemplateBuilderUtil.addEndpoints(api, builder, gatewayAPIDTO);
                } else {
                    TemplateBuilderUtil.addWebSocketResourceEndpoints(api, builder, gatewayAPIDTO);
                }
            }
        }
        TemplateBuilderUtil.setSecureVaultPropertyToBeAdded(null, api, gatewayAPIDTO);
        return gatewayAPIDTO;
    }

    private static void addWebsocketTopicMappings(API api, APIDTO apidto) {
        org.json.JSONObject endpointConfiguration = new org.json.JSONObject(api.getEndpointConfig());
        String sandboxEndpointUrl = !endpointConfiguration.isNull("sandbox_endpoints") ? endpointConfiguration.getJSONObject("sandbox_endpoints").getString("url") : null;
        String productionEndpointUrl = !endpointConfiguration.isNull("production_endpoints") ? endpointConfiguration.getJSONObject("production_endpoints").getString("url") : null;
        HashMap perTopicMappings = new HashMap();
        for (APIOperationsDTO operation : apidto.getOperations()) {
            String key = operation.getTarget();
            String mapping = operation.getUriMapping() == null ? "" : Paths.get("/", operation.getUriMapping()).toString();
            HashMap<String, String> endpoints = new HashMap<String, String>();
            if (sandboxEndpointUrl != null) {
                endpoints.put("sandbox", sandboxEndpointUrl + mapping);
            }
            if (productionEndpointUrl != null) {
                endpoints.put("production", productionEndpointUrl + mapping);
            }
            perTopicMappings.put(key, endpoints);
        }
        api.setWebSocketTopicMappingConfiguration(new WebSocketTopicMappingConfiguration(perTopicMappings));
        TemplateBuilderUtil.addWebsocketTopicResourceKeys(api);
    }

    private static void setCustomSequencesToBeAdded(API api, GatewayAPIDTO gatewayAPIDTO, String extractedPath, APIDTO apidto) throws APIManagementException {
        GatewayContentDTO gatewayOutContentDTO;
        GatewayContentDTO gatewayInContentDTO = TemplateBuilderUtil.retrieveSequence(extractedPath, apidto.getMediationPolicies(), "in", api);
        if (gatewayInContentDTO != null) {
            gatewayAPIDTO.setSequenceToBeAdd(TemplateBuilderUtil.addGatewayContentToList(gatewayInContentDTO, gatewayAPIDTO.getSequenceToBeAdd()));
        }
        if ((gatewayOutContentDTO = TemplateBuilderUtil.retrieveSequence(extractedPath, apidto.getMediationPolicies(), "out", api)) != null) {
            gatewayAPIDTO.setSequenceToBeAdd(TemplateBuilderUtil.addGatewayContentToList(gatewayOutContentDTO, gatewayAPIDTO.getSequenceToBeAdd()));
        }
    }

    private static void setAPIFaultSequencesToBeAdded(API api, GatewayAPIDTO gatewayAPIDTO, String extractedPath, APIDTO apidto) throws APIManagementException {
        String faultSeqExt = APIUtil.getSequenceExtensionName((API)api) + "--Fault";
        gatewayAPIDTO.setSequencesToBeRemove(GatewayUtils.addStringToList((String)faultSeqExt, (String[])gatewayAPIDTO.getSequencesToBeRemove()));
        List<MediationPolicyDTO> mediationPolicies = apidto.getMediationPolicies();
        GatewayContentDTO faultSequenceContent = TemplateBuilderUtil.retrieveSequence(extractedPath, mediationPolicies, "fault", api);
        if (faultSequenceContent != null) {
            gatewayAPIDTO.setSequenceToBeAdd(TemplateBuilderUtil.addGatewayContentToList(faultSequenceContent, gatewayAPIDTO.getSequenceToBeAdd()));
        }
        gatewayAPIDTO.setSequencesToBeRemove(GatewayUtils.addStringToList((String)faultSeqExt, (String[])gatewayAPIDTO.getSequencesToBeRemove()));
    }

    private static void setClientCertificatesToBeAdded(String tenantDomain, GatewayAPIDTO gatewayAPIDTO, List<ClientCertificateDTO> clientCertificatesDTOList) {
        int tenantId = APIUtil.getTenantIdFromTenantDomain((String)tenantDomain);
        if (clientCertificatesDTOList != null) {
            for (ClientCertificateDTO clientCertificateDTO : clientCertificatesDTOList) {
                GatewayContentDTO clientCertificate = new GatewayContentDTO();
                clientCertificate.setName(clientCertificateDTO.getAlias() + "_" + tenantId);
                clientCertificate.setContent(clientCertificateDTO.getCertificate());
                gatewayAPIDTO.setClientCertificatesToBeAdd(TemplateBuilderUtil.addGatewayContentToList(clientCertificate, gatewayAPIDTO.getClientCertificatesToBeAdd()));
            }
        }
    }

    private static GatewayContentDTO[] addGatewayContentToList(GatewayContentDTO gatewayContentDTO, GatewayContentDTO[] gatewayContents) {
        if (gatewayContents == null) {
            return new GatewayContentDTO[]{gatewayContentDTO};
        }
        HashSet<GatewayContentDTO> gatewayContentDTOList = new HashSet<GatewayContentDTO>();
        Collections.addAll(gatewayContentDTOList, gatewayContents);
        gatewayContentDTOList.add(gatewayContentDTO);
        return gatewayContentDTOList.toArray(new GatewayContentDTO[gatewayContentDTOList.size()]);
    }

    private static void addEndpoints(API api, APITemplateBuilder builder, GatewayAPIDTO gatewayAPIDTO) throws APITemplateException, XMLStreamException {
        ArrayList<String> arrayListToAdd = TemplateBuilderUtil.getEndpointType(api);
        for (String type : arrayListToAdd) {
            String endpointConfigContext = builder.getConfigStringForEndpointTemplate(type);
            GatewayContentDTO endpoint = new GatewayContentDTO();
            endpoint.setName(TemplateBuilderUtil.getEndpointName(endpointConfigContext));
            endpoint.setContent(endpointConfigContext);
            gatewayAPIDTO.setEndpointEntriesToBeAdd(TemplateBuilderUtil.addGatewayContentToList(endpoint, gatewayAPIDTO.getEndpointEntriesToBeAdd()));
        }
    }

    private static void addWebsocketTopicResourceKeys(API api) {
        WebSocketTopicMappingConfiguration mappingsConfig = api.getWebSocketTopicMappingConfiguration();
        for (String topic : mappingsConfig.getMappings().keySet()) {
            mappingsConfig.setResourceKey(topic, TemplateBuilderUtil.getWebsocketResourceKey(topic));
        }
    }

    private static String getWebsocketResourceKey(String topic) {
        String resourceKey = topic.contains("{") || topic.contains("*") && !topic.endsWith("/*") ? "template_" + topic : "mapping_" + topic;
        return resourceKey.replaceAll("/", "_").replaceAll("\\{", "(").replaceAll("}", ")").replaceAll("\\*", "wildcard");
    }

    private static void addWebSocketResourceEndpoints(API api, APITemplateBuilder builder, GatewayAPIDTO gatewayAPIDTO) throws APITemplateException, XMLStreamException {
        Set uriTemplates = api.getUriTemplates();
        Map topicMappings = api.getWebSocketTopicMappingConfiguration().getMappings();
        ArrayList<GatewayContentDTO> endpointsToAdd = new ArrayList<GatewayContentDTO>();
        for (URITemplate resource : uriTemplates) {
            String topic = resource.getUriTemplate();
            Map endpoints = (Map)topicMappings.get(topic);
            for (Map.Entry endpointData : endpoints.entrySet()) {
                if ("resourceKey".equals(endpointData.getKey())) continue;
                String endpointType = (String)endpointData.getKey();
                String endpointUrl = (String)endpointData.getValue();
                String endpointConfigContext = builder.getConfigStringForWebSocketEndpointTemplate(endpointType, TemplateBuilderUtil.getWebsocketResourceKey(topic), endpointUrl);
                GatewayContentDTO endpoint = new GatewayContentDTO();
                endpoint.setName(TemplateBuilderUtil.getEndpointName(endpointConfigContext));
                endpoint.setContent(endpointConfigContext);
                endpointsToAdd.add(endpoint);
            }
        }
        gatewayAPIDTO.setEndpointEntriesToBeAdd(endpointsToAdd.toArray(new GatewayContentDTO[endpointsToAdd.size()]));
    }

    public static ArrayList<String> getEndpointType(API api) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (APIUtil.isProductionEndpointsExists((String)api.getEndpointConfig()) && !APIUtil.isSandboxEndpointsExists((String)api.getEndpointConfig())) {
            arrayList.add("production_endpoints");
        } else if (APIUtil.isSandboxEndpointsExists((String)api.getEndpointConfig()) && !APIUtil.isProductionEndpointsExists((String)api.getEndpointConfig())) {
            arrayList.add("sandbox_endpoints");
        } else {
            arrayList.add("production_endpoints");
            arrayList.add("sandbox_endpoints");
        }
        return arrayList;
    }

    private static String getEndpointName(String endpointConfig) throws XMLStreamException {
        OMElement omElement = AXIOMUtil.stringToOM((String)endpointConfig);
        OMAttribute nameAttribute = omElement.getAttribute(new QName("name"));
        if (nameAttribute != null) {
            return nameAttribute.getAttributeValue();
        }
        return null;
    }

    private static void setSecureVaultPropertyToBeAdded(String prefix, API api, GatewayAPIDTO gatewayAPIDTO) {
        boolean isSecureVaultEnabled = Boolean.parseBoolean(ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration().getFirstProperty("EnableSecureVault"));
        if (isSecureVaultEnabled) {
            org.json.JSONObject endpointConfig = new org.json.JSONObject(api.getEndpointConfig());
            if (endpointConfig.has("endpoint_security")) {
                org.json.JSONObject endpoints = (org.json.JSONObject)endpointConfig.get("endpoint_security");
                org.json.JSONObject productionEndpointSecurity = (org.json.JSONObject)endpoints.get("production");
                org.json.JSONObject sandboxEndpointSecurity = (org.json.JSONObject)endpoints.get("sandbox");
                boolean isProductionEndpointSecured = (Boolean)productionEndpointSecurity.get("enabled");
                boolean isSandboxEndpointSecured = (Boolean)sandboxEndpointSecurity.get("enabled");
                if (isProductionEndpointSecured) {
                    TemplateBuilderUtil.addCredentialsToList(prefix, api, gatewayAPIDTO, productionEndpointSecurity, "production");
                }
                if (isSandboxEndpointSecured) {
                    TemplateBuilderUtil.addCredentialsToList(prefix, api, gatewayAPIDTO, sandboxEndpointSecurity, "sandbox");
                }
            } else if ("awslambda".equals(endpointConfig.get("endpoint_type"))) {
                TemplateBuilderUtil.addAWSCredentialsToList(prefix, api, gatewayAPIDTO, endpointConfig);
            }
        }
    }

    private static void addAWSCredentialsToList(String prefix, API api, GatewayAPIDTO gatewayAPIDTO, org.json.JSONObject endpointConfig) {
        if (StringUtils.isNotEmpty((CharSequence)((String)endpointConfig.get("amznSecretKey")))) {
            CredentialDto awsSecretDto = new CredentialDto();
            if (StringUtils.isNotEmpty((CharSequence)prefix)) {
                awsSecretDto.setAlias(prefix.concat("--").concat(GatewayUtils.retrieveAWSCredAlias((String)api.getId().getApiName(), (String)api.getId().getVersion(), (String)"awslambda")));
            } else {
                awsSecretDto.setAlias(GatewayUtils.retrieveAWSCredAlias((String)api.getId().getApiName(), (String)api.getId().getVersion(), (String)"awslambda"));
            }
            awsSecretDto.setPassword((String)endpointConfig.get("amznSecretKey"));
            gatewayAPIDTO.setCredentialsToBeAdd(TemplateBuilderUtil.addCredentialsToList(awsSecretDto, gatewayAPIDTO.getCredentialsToBeAdd()));
        }
    }

    private static void addCredentialsToList(String prefix, API api, GatewayAPIDTO gatewayAPIDTO, org.json.JSONObject endpointSecurity, String type) {
        if ("oauth".equalsIgnoreCase((String)endpointSecurity.get("type"))) {
            CredentialDto clientSecretDto = new CredentialDto();
            if (StringUtils.isNotEmpty((CharSequence)prefix)) {
                clientSecretDto.setAlias(prefix.concat("--").concat(GatewayUtils.retrieveOauthClientSecretAlias((String)api.getId().getApiName(), (String)api.getId().getVersion(), (String)type)));
            } else {
                clientSecretDto.setAlias(GatewayUtils.retrieveOauthClientSecretAlias((String)api.getId().getApiName(), (String)api.getId().getVersion(), (String)type));
            }
            clientSecretDto.setPassword((String)endpointSecurity.get("clientSecret"));
            gatewayAPIDTO.setCredentialsToBeAdd(TemplateBuilderUtil.addCredentialsToList(clientSecretDto, gatewayAPIDTO.getCredentialsToBeAdd()));
            if (endpointSecurity.has("password")) {
                CredentialDto passwordDto = new CredentialDto();
                if (StringUtils.isNotEmpty((CharSequence)prefix)) {
                    passwordDto.setAlias(prefix.concat("--").concat(GatewayUtils.retrieveOAuthPasswordAlias((String)api.getId().getApiName(), (String)api.getId().getVersion(), (String)type)));
                } else {
                    passwordDto.setAlias(GatewayUtils.retrieveOAuthPasswordAlias((String)api.getId().getApiName(), (String)api.getId().getVersion(), (String)type));
                }
                passwordDto.setPassword((String)endpointSecurity.get("password"));
                gatewayAPIDTO.setCredentialsToBeAdd(TemplateBuilderUtil.addCredentialsToList(passwordDto, gatewayAPIDTO.getCredentialsToBeAdd()));
            }
        } else if ("basic".equalsIgnoreCase((String)endpointSecurity.get("type"))) {
            CredentialDto credentialDto = new CredentialDto();
            if (StringUtils.isNotEmpty((CharSequence)prefix)) {
                credentialDto.setAlias(prefix.concat("--").concat(GatewayUtils.retrieveBasicAuthAlias((String)api.getId().getApiName(), (String)api.getId().getVersion(), (String)type)));
            } else {
                credentialDto.setAlias(GatewayUtils.retrieveBasicAuthAlias((String)api.getId().getApiName(), (String)api.getId().getVersion(), (String)type));
            }
            credentialDto.setPassword((String)endpointSecurity.get("password"));
            gatewayAPIDTO.setCredentialsToBeAdd(TemplateBuilderUtil.addCredentialsToList(credentialDto, gatewayAPIDTO.getCredentialsToBeAdd()));
        }
    }

    private static CredentialDto[] addCredentialsToList(CredentialDto credential, CredentialDto[] credentials) {
        if (credentials == null) {
            return new CredentialDto[]{credential};
        }
        HashSet<CredentialDto> credentialList = new HashSet<CredentialDto>();
        Collections.addAll(credentialList, credentials);
        credentialList.add(credential);
        return credentialList.toArray(new CredentialDto[credentialList.size()]);
    }

    private static GatewayContentDTO retrieveSequence(APIProduct apiProduct, String pathToAchieve, List<MediationPolicyDTO> mediationPolicies, String type, API api) throws APIManagementException {
        APIProductIdentifier apiProductIdentifier = apiProduct.getId();
        MediationPolicyDTO mediationPolicyDTO = null;
        for (MediationPolicyDTO mediationPolicy : mediationPolicies) {
            if (!type.equalsIgnoreCase(mediationPolicy.getType())) continue;
            mediationPolicyDTO = mediationPolicy;
            break;
        }
        if (mediationPolicyDTO != null) {
            GatewayContentDTO sequenceContentDto = new GatewayContentDTO();
            String sequenceContent = ImportUtils.retrieveSequenceContent(pathToAchieve, mediationPolicyDTO.isShared() == false, type.toLowerCase(), mediationPolicyDTO.getName());
            if (StringUtils.isNotEmpty((CharSequence)sequenceContent)) {
                try {
                    OMElement omElement = APIUtil.buildOMElement((InputStream)new ByteArrayInputStream(sequenceContent.getBytes()));
                    if (omElement != null) {
                        String seqExt = APIUtil.getSequenceExtensionName((String)apiProductIdentifier.getName(), (String)apiProductIdentifier.getVersion()).concat("--").concat(api.getUuid());
                        if ("fault".equalsIgnoreCase(type)) {
                            seqExt = seqExt + "--Fault";
                        } else if ("out".equalsIgnoreCase(type)) {
                            seqExt = seqExt + "--Out";
                        } else if ("in".equalsIgnoreCase(type)) {
                            seqExt = seqExt + "--In";
                        }
                        if (omElement.getAttribute(new QName("name")) != null) {
                            omElement.getAttribute(new QName("name")).setAttributeValue(seqExt);
                        }
                        sequenceContentDto.setName(seqExt);
                        sequenceContentDto.setContent(APIUtil.convertOMtoString((OMElement)omElement));
                        return sequenceContentDto;
                    }
                }
                catch (Exception e) {
                    throw new APIManagementException((Throwable)e);
                }
            }
        }
        return null;
    }

    private static GatewayContentDTO retrieveSequence(String pathToAchieve, List<MediationPolicyDTO> mediationPolicies, String type, API api) throws APIManagementException {
        MediationPolicyDTO mediationPolicyDTO = null;
        for (MediationPolicyDTO mediationPolicy : mediationPolicies) {
            if (!type.equalsIgnoreCase(mediationPolicy.getType())) continue;
            mediationPolicyDTO = mediationPolicy;
            break;
        }
        if (mediationPolicyDTO != null) {
            GatewayContentDTO sequenceContentDto = new GatewayContentDTO();
            String sequenceContent = ImportUtils.retrieveSequenceContent(pathToAchieve, mediationPolicyDTO.isShared() == false, type.toLowerCase(), mediationPolicyDTO.getName());
            if (StringUtils.isNotEmpty((CharSequence)sequenceContent)) {
                try {
                    OMElement omElement = APIUtil.buildOMElement((InputStream)new ByteArrayInputStream(sequenceContent.getBytes()));
                    if (omElement != null) {
                        String seqExt = APIUtil.getSequenceExtensionName((API)api);
                        if ("fault".equalsIgnoreCase(type)) {
                            seqExt = seqExt + "--Fault";
                        } else if ("out".equalsIgnoreCase(type)) {
                            seqExt = seqExt + "--Out";
                        } else if ("in".equalsIgnoreCase(type)) {
                            seqExt = seqExt + "--In";
                        }
                        if (omElement.getAttribute(new QName("name")) != null) {
                            omElement.getAttribute(new QName("name")).setAttributeValue(seqExt);
                        }
                        sequenceContentDto.setName(seqExt);
                        sequenceContentDto.setContent(APIUtil.convertOMtoString((OMElement)omElement));
                        return sequenceContentDto;
                    }
                }
                catch (Exception e) {
                    throw new APIManagementException((Throwable)e);
                }
            }
        }
        return null;
    }

    private static Map<String, APIDTO> retrieveAssociatedApis(String extractedPath) throws APIManagementException {
        HashMap<String, APIDTO> apidtoMap = new HashMap<String, APIDTO>();
        String apisDirectoryPath = extractedPath + File.separator + "APIs";
        File apisDirectory = new File(apisDirectoryPath);
        File[] apisDirectoryListing = apisDirectory.listFiles();
        if (apisDirectoryListing != null) {
            for (File file : apisDirectoryListing) {
                try {
                    APIDTO apidto = ImportUtils.retrievedAPIDto(file.getAbsolutePath());
                    apidtoMap.put(file.getAbsolutePath(), apidto);
                }
                catch (IOException e) {
                    throw new APIManagementException("Error while reading api", (Throwable)e);
                }
            }
        }
        return apidtoMap;
    }

    private static Map<String, APIDTO> convertAPIIdToDto(Collection<APIDTO> apidtoSet) {
        HashMap<String, APIDTO> apidtoMap = new HashMap<String, APIDTO>();
        for (APIDTO apidto : apidtoSet) {
            apidtoMap.put(apidto.getId(), apidto);
        }
        return apidtoMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] websocketEndpointConfig(API api, String urlType) throws JSONException {
        org.json.JSONObject obj = new org.json.JSONObject(api.getEndpointConfig());
        org.json.JSONObject endpointObj = null;
        if (ENDPOINT_PRODUCTION.equalsIgnoreCase(urlType)) {
            org.json.JSONObject prodEP = obj.getJSONObject("production_endpoints");
            if (!prodEP.has("config") || !(prodEP.get("config") instanceof org.json.JSONObject)) return new String[]{"", "", ""};
            endpointObj = prodEP.getJSONObject("config");
        } else if (ENDPOINT_SANDBOX.equalsIgnoreCase(urlType)) {
            org.json.JSONObject sandEP = obj.getJSONObject("sandbox_endpoints");
            if (!sandEP.has("config") || !(sandEP.get("config") instanceof org.json.JSONObject)) return new String[]{"", "", ""};
            endpointObj = sandEP.getJSONObject("config");
        }
        String duration = TemplateBuilderUtil.validateJSONObjKey("actionDuration", endpointObj) ? "\t\t<duration>" + endpointObj.get("actionDuration") + "</duration>\n" : "";
        String responseAction = TemplateBuilderUtil.validateJSONObjKey("actionSelect", endpointObj) ? "\t\t<responseAction>" + endpointObj.get("actionSelect") + "</responseAction>\n" : "";
        String timeout = duration + "\n" + responseAction;
        if (TemplateBuilderUtil.validateJSONObjKey("suspendDuration", endpointObj) && Integer.parseInt(endpointObj.get("suspendDuration").toString()) == 0) {
            String suspendOnFailure = "\t\t<errorCodes>-1</errorCodes>\n\t\t<initialDuration>0</initialDuration>\n\t\t<progressionFactor>1.0</progressionFactor>\n\t\t<maximumDuration>0</maximumDuration>";
            String markForSuspension = "\t\t<errorCodes>-1</errorCodes>";
            return new String[]{timeout, suspendOnFailure, markForSuspension};
        }
        String suspendErrorCode = TemplateBuilderUtil.parseWsEndpointConfigErrorCodes(endpointObj, "suspendErrorCode");
        String suspendDuration = TemplateBuilderUtil.validateJSONObjKey("suspendDuration", endpointObj) ? "\t\t<initialDuration>" + endpointObj.get("suspendDuration").toString() + "</initialDuration>" : "";
        String suspendMaxDuration = TemplateBuilderUtil.validateJSONObjKey("suspendMaxDuration", endpointObj) ? "\t\t<maximumDuration>" + endpointObj.get("suspendMaxDuration") + "</maximumDuration>" : "";
        String factor = TemplateBuilderUtil.validateJSONObjKey("factor", endpointObj) ? "\t\t<progressionFactor>" + endpointObj.get("factor") + "</progressionFactor>" : "";
        String suspendOnFailure = suspendErrorCode + "\n" + suspendDuration + "\n" + suspendMaxDuration + "\n" + factor;
        String retryErrorCode = TemplateBuilderUtil.parseWsEndpointConfigErrorCodes(endpointObj, "retryErroCode");
        String retryTimeOut = TemplateBuilderUtil.validateJSONObjKey("retryTimeOut", endpointObj) ? "\t\t<retriesBeforeSuspension>" + endpointObj.get("retryTimeOut") + "</retriesBeforeSuspension>" : "";
        String retryDelay = TemplateBuilderUtil.validateJSONObjKey("retryDelay", endpointObj) ? "\t\t<retryDelay>" + endpointObj.get("retryDelay") + "</retryDelay>" : "";
        String markForSuspension = retryErrorCode + "\n" + retryTimeOut + "\n" + retryDelay;
        return new String[]{timeout, suspendOnFailure, markForSuspension};
    }

    private static boolean validateJSONObjKey(String key, org.json.JSONObject endpointObj) {
        return endpointObj.has(key) && endpointObj.get(key) instanceof String && StringUtils.isNotEmpty((CharSequence)endpointObj.getString(key));
    }

    private static String parseWsEndpointConfigErrorCodes(org.json.JSONObject endpointObj, String errorCodeType) {
        if (endpointObj.has(errorCodeType)) {
            if (endpointObj.get(errorCodeType) instanceof JSONArray && ((JSONArray)endpointObj.get(errorCodeType)).length() != 0) {
                StringBuilder codeListBuilder = new StringBuilder();
                for (int i = 0; i < endpointObj.getJSONArray(errorCodeType).length(); ++i) {
                    codeListBuilder.append(endpointObj.getJSONArray(errorCodeType).get(i).toString()).append(",");
                }
                String codeList = codeListBuilder.toString();
                return "\t\t<errorCodes>" + codeList.substring(0, codeList.length() - 1) + "</errorCodes>";
            }
            if (endpointObj.get(errorCodeType) instanceof String) {
                return "\t\t<errorCodes>" + endpointObj.get(errorCodeType) + "</errorCodes>";
            }
        }
        return "";
    }
}

