/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common;

import com.google.gson.Gson;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.wso2.carbon.apimgt.api.APIDefinitionValidationResponse;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.gateway.GatewayAPIDTO;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.api.model.Environment;
import org.wso2.carbon.apimgt.api.model.SwaggerData;
import org.wso2.carbon.apimgt.api.model.graphql.queryanalysis.GraphqlComplexityInfo;
import org.wso2.carbon.apimgt.impl.APIConstants;
import org.wso2.carbon.apimgt.impl.definitions.GraphQLSchemaDefinition;
import org.wso2.carbon.apimgt.impl.definitions.OAS3Parser;
import org.wso2.carbon.apimgt.impl.dto.APIRuntimeArtifactDto;
import org.wso2.carbon.apimgt.impl.dto.RuntimeArtifactDto;
import org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.GatewayArtifactGenerator;
import org.wso2.carbon.apimgt.impl.importexport.utils.CommonUtil;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.TemplateBuilderUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.APIMappingUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.ImportUtils;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIProductDTO;

@Component(name="synapse.artifact.generator.service", immediate=true, service={GatewayArtifactGenerator.class})
public class SynapseArtifactGenerator
implements GatewayArtifactGenerator {
    private static final Log log = LogFactory.getLog(SynapseArtifactGenerator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuntimeArtifactDto generateGatewayArtifact(List<APIRuntimeArtifactDto> apiRuntimeArtifactDtoList) throws APIManagementException {
        RuntimeArtifactDto runtimeArtifactDto = new RuntimeArtifactDto();
        ArrayList<String> synapseArtifacts = new ArrayList<String>();
        for (APIRuntimeArtifactDto runTimeArtifact : apiRuntimeArtifactDtoList) {
            if (!runTimeArtifact.isFile()) continue;
            String tenantDomain = runTimeArtifact.getTenantDomain();
            String label = runTimeArtifact.getLabel();
            Environment environment = (Environment)APIUtil.getEnvironments().get(label);
            GatewayAPIDTO gatewayAPIDTO = null;
            if (environment == null) continue;
            try {
                InputStream artifact = (InputStream)runTimeArtifact.getArtifact();
                Throwable throwable = null;
                try {
                    File baseDirectory = CommonUtil.createTempDirectory(null);
                    try {
                        APIDefinitionValidationResponse apiDefinitionValidationResponse;
                        String extractedFolderPath = ImportUtils.getArchivePathOfExtractedDirectory(baseDirectory.getAbsolutePath(), artifact);
                        if ("APIProduct".equals(runTimeArtifact.getType())) {
                            APIProductDTO apiProductDTO = ImportUtils.retrieveAPIProductDto(extractedFolderPath);
                            apiProductDTO.setId(runTimeArtifact.getApiId());
                            APIProduct apiProduct = APIMappingUtil.fromDTOtoAPIProduct(apiProductDTO, apiProductDTO.getProvider());
                            apiDefinitionValidationResponse = ImportUtils.retrieveValidatedSwaggerDefinitionFromArchive(extractedFolderPath);
                            apiProduct.setDefinition(apiDefinitionValidationResponse.getContent());
                            gatewayAPIDTO = TemplateBuilderUtil.retrieveGatewayAPIDto(apiProduct, environment, tenantDomain, extractedFolderPath);
                        } else {
                            APIDTO apidto = ImportUtils.retrievedAPIDto(extractedFolderPath);
                            API api = APIMappingUtil.fromDTOtoAPI(apidto, apidto.getProvider());
                            api.setUUID(apidto.getId());
                            if (APIConstants.APITransportType.GRAPHQL.toString().equals(api.getType())) {
                                OAS3Parser parser = new OAS3Parser();
                                SwaggerData swaggerData = new SwaggerData(api);
                                String apiDefinition = parser.generateAPIDefinition(swaggerData);
                                api.setSwaggerDefinition(apiDefinition);
                                GraphqlComplexityInfo graphqlComplexityInfo = APIUtil.getComplexityDetails((API)api);
                                String graphqlSchema = ImportUtils.retrieveValidatedGraphqlSchemaFromArchive(extractedFolderPath);
                                api.setGraphQLSchema(graphqlSchema);
                                GraphQLSchemaDefinition graphQLSchemaDefinition = new GraphQLSchemaDefinition();
                                graphqlSchema = graphQLSchemaDefinition.buildSchemaWithAdditionalInfo(api, graphqlComplexityInfo);
                                api.setGraphQLSchema(graphqlSchema);
                                gatewayAPIDTO = TemplateBuilderUtil.retrieveGatewayAPIDto(api, environment, tenantDomain, apidto, extractedFolderPath);
                            } else if (api.getType() != null && (APIConstants.APITransportType.HTTP.toString().equals(api.getType()) || "SOAP".equals(api.getType()) || "SOAPTOREST".equals(api.getType()))) {
                                apiDefinitionValidationResponse = ImportUtils.retrieveValidatedSwaggerDefinitionFromArchive(extractedFolderPath);
                                api.setSwaggerDefinition(apiDefinitionValidationResponse.getContent());
                                gatewayAPIDTO = TemplateBuilderUtil.retrieveGatewayAPIDto(api, environment, tenantDomain, apidto, extractedFolderPath, apiDefinitionValidationResponse);
                            } else if (api.getType() != null && (APIConstants.APITransportType.WS.toString().equals(api.getType()) || APIConstants.APITransportType.SSE.toString().equals(api.getType()) || APIConstants.APITransportType.WEBSUB.toString().equals(api.getType()))) {
                                APIDefinitionValidationResponse asyncApiDefinition = ImportUtils.retrieveValidatedAsyncApiDefinitionFromArchive(extractedFolderPath);
                                api.setAsyncApiDefinition(asyncApiDefinition.getContent());
                                gatewayAPIDTO = TemplateBuilderUtil.retrieveGatewayAPIDtoForStreamingAPI(api, environment, tenantDomain, apidto, extractedFolderPath);
                            }
                        }
                        if (gatewayAPIDTO == null) continue;
                        String content = new Gson().toJson((Object)gatewayAPIDTO);
                        synapseArtifacts.add(content);
                    }
                    finally {
                        FileUtils.deleteQuietly((File)baseDirectory);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (artifact == null) continue;
                    if (throwable != null) {
                        try {
                            artifact.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    artifact.close();
                }
            }
            catch (Exception e) {
                log.error((Object)"Error while creating Synapse configurations", (Throwable)e);
            }
        }
        runtimeArtifactDto.setFile(false);
        runtimeArtifactDto.setArtifact(synapseArtifacts);
        return runtimeArtifactDto;
    }

    public String getType() {
        return "Synapse";
    }
}

