/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.api.publisher.v1.common;

import java.io.File;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIProvider;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.api.model.APIProductIdentifier;
import org.wso2.carbon.apimgt.impl.importexport.APIImportExportException;
import org.wso2.carbon.apimgt.impl.importexport.ExportFormat;
import org.wso2.carbon.apimgt.impl.importexport.ImportExportAPI;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.rest.api.common.RestApiCommonUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.APIMappingUtil;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.ExportUtils;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.common.mappings.ImportUtils;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIDTO;
import org.wso2.carbon.apimgt.rest.api.publisher.v1.dto.APIProductDTO;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

@Component(name="import.export.service.component", immediate=true, service={ImportExportAPI.class})
public class ImportExportAPIServiceImpl
implements ImportExportAPI {
    public File exportAPI(String apiId, String name, String version, String revisionNum, String providerName, boolean preserveStatus, ExportFormat format, boolean preserveDocs, boolean preserveCredentials, boolean exportLatestRevision, String originalDevPortalUrl) throws APIManagementException, APIImportExportException {
        APIIdentifier apiIdentifier;
        APIProvider apiProvider = RestApiCommonUtil.getLoggedInUserProvider();
        String userName = RestApiCommonUtil.getLoggedInUsername();
        String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        if (apiId == null) {
            String provider = ExportUtils.validateExportParams(name, version, providerName);
            apiIdentifier = new APIIdentifier(APIUtil.replaceEmailDomain((String)provider), name, version);
            apiId = APIUtil.getUUIDFromIdentifier((APIIdentifier)apiIdentifier);
            if (apiId == null) {
                throw new APIImportExportException("API Id not found for the provided details");
            }
        } else {
            apiIdentifier = APIMappingUtil.getAPIIdentifierFromUUID(apiId);
        }
        String exportAPIUUID = exportLatestRevision ? apiProvider.getLatestRevisionUUID(apiId) : (StringUtils.isNotBlank((CharSequence)revisionNum) ? apiProvider.getAPIRevisionUUID(revisionNum, apiId) : apiId);
        exportAPIUUID = exportAPIUUID == null ? apiId : exportAPIUUID;
        API api = apiProvider.getAPIbyUUID(exportAPIUUID, tenantDomain);
        APIDTO apiDtoToReturn = APIMappingUtil.fromAPItoDTO(api, preserveCredentials, apiProvider);
        apiIdentifier.setUuid(exportAPIUUID);
        return ExportUtils.exportApi(apiProvider, apiIdentifier, apiDtoToReturn, api, userName, format, preserveStatus, preserveDocs, originalDevPortalUrl);
    }

    public File exportAPI(String apiId, String revisionUUID, boolean preserveStatus, ExportFormat format, boolean preserveDocs, boolean preserveCredentials) throws APIManagementException, APIImportExportException {
        APIProvider apiProvider = RestApiCommonUtil.getLoggedInUserProvider();
        String userName = RestApiCommonUtil.getLoggedInUsername();
        String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        APIIdentifier apiIdentifier = APIMappingUtil.getAPIIdentifierFromUUID(apiId);
        API api = apiProvider.getAPIbyUUID(revisionUUID, tenantDomain);
        api.setUuid(apiId);
        APIDTO apiDtoToReturn = APIMappingUtil.fromAPItoDTO(api, preserveCredentials, apiProvider);
        return ExportUtils.exportApi(apiProvider, apiIdentifier, apiDtoToReturn, api, userName, format, preserveStatus, preserveDocs, "");
    }

    public File exportAPIProduct(String apiId, String revisionUUID, boolean preserveStatus, ExportFormat format, boolean preserveDocs, boolean preserveCredentials) throws APIManagementException, APIImportExportException {
        APIProvider apiProvider = RestApiCommonUtil.getLoggedInUserProvider();
        String userName = RestApiCommonUtil.getLoggedInUsername();
        String tenantDomain = RestApiCommonUtil.getLoggedInUserTenantDomain();
        APIProductIdentifier apiProductIdentifier = APIUtil.getAPIProductIdentifierFromUUID((String)apiId);
        APIProduct product = apiProvider.getAPIProductbyUUID(revisionUUID, tenantDomain);
        APIProductDTO apiProductDtoToReturn = APIMappingUtil.fromAPIProducttoDTO(product);
        return ExportUtils.exportApiProduct(apiProvider, apiProductIdentifier, apiProductDtoToReturn, userName, format, preserveStatus, preserveDocs, preserveCredentials);
    }

    public File exportAPIProduct(String apiId, String name, String version, String providerName, String revisionNum, ExportFormat format, boolean preserveStatus, boolean preserveDocs, boolean preserveCredentials, boolean exportLatestRevision) throws APIManagementException, APIImportExportException {
        APIProductIdentifier apiProductIdentifier;
        APIProvider apiProvider = RestApiCommonUtil.getLoggedInUserProvider();
        String userName = RestApiCommonUtil.getLoggedInUsername();
        String tenantDomain = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack((String)userName));
        if (apiId != null) {
            apiProductIdentifier = APIMappingUtil.getAPIProductIdentifierFromUUID(apiId, tenantDomain);
        } else {
            String provider = ExportUtils.validateExportParams(name, version, providerName);
            apiProductIdentifier = new APIProductIdentifier(APIUtil.replaceEmailDomain((String)provider), name, version);
            apiId = APIUtil.getUUIDFromIdentifier((APIProductIdentifier)apiProductIdentifier);
        }
        String exportAPIProductUUID = exportLatestRevision ? apiProvider.getLatestRevisionUUID(apiId) : (revisionNum != null ? apiProvider.getAPIRevisionUUID(revisionNum, apiId) : apiId);
        exportAPIProductUUID = exportAPIProductUUID == null ? apiId : exportAPIProductUUID;
        APIProduct apiProduct = apiProvider.getAPIProductbyUUID(exportAPIProductUUID, tenantDomain);
        apiProductIdentifier.setUUID(exportAPIProductUUID);
        if (apiProduct != null) {
            APIProductDTO apiProductDtoToReturn = APIMappingUtil.fromAPIProducttoDTO(apiProduct);
            return ExportUtils.exportApiProduct(apiProvider, apiProductIdentifier, apiProductDtoToReturn, userName, format, preserveStatus, preserveDocs, preserveCredentials);
        }
        return null;
    }

    public API importAPI(InputStream fileInputStream, Boolean preserveProvider, Boolean rotateRevision, Boolean overwrite, String[] tokenScopes) throws APIManagementException {
        String extractedFolderPath;
        try {
            extractedFolderPath = ImportUtils.getArchivePathOfExtractedDirectory(fileInputStream);
        }
        catch (APIImportExportException e) {
            throw new APIManagementException((Throwable)e);
        }
        return ImportUtils.importApi(extractedFolderPath, null, preserveProvider, rotateRevision, overwrite, false, tokenScopes, null);
    }

    public APIProduct importAPIProduct(InputStream fileInputStream, Boolean preserveProvider, Boolean rotateRevision, Boolean overwriteAPIProduct, Boolean overwriteAPIs, Boolean importAPIs, String[] tokenScopes) throws APIManagementException {
        String extractedFolderPath;
        try {
            extractedFolderPath = ImportUtils.getArchivePathOfExtractedDirectory(fileInputStream);
        }
        catch (APIImportExportException e) {
            throw new APIManagementException((Throwable)e);
        }
        return ImportUtils.importApiProduct(extractedFolderPath, preserveProvider, rotateRevision, overwriteAPIProduct, overwriteAPIs, importAPIs, tokenScopes);
    }
}

