/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.broker.lifecycle.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.andes.listeners.BrokerLifecycleListener;
import org.wso2.carbon.andes.service.QpidService;
import org.wso2.carbon.apimgt.broker.lifecycle.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.jms.listener.JMSListenerShutDownService;

@Component(name="org.wso2.apimgt.broker.lifecycle", immediate=true)
public class LifecycleComponent {
    private static final Log log = LogFactory.getLog(LifecycleComponent.class);

    @Activate
    protected void activate(ComponentContext context) {
        log.debug((Object)"Activating component...");
    }

    @Reference(name="QpidService", service=QpidService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetQpidService")
    public void setQpidService(QpidService qpidService) {
        log.debug((Object)"Setting QpidService...");
        ServiceReferenceHolder.getInstance().setQpidService(qpidService);
        if (qpidService != null) {
            qpidService.registerBrokerLifecycleListener(new BrokerLifecycleListener(){

                public void onShuttingdown() {
                    if (ServiceReferenceHolder.getInstance().getListenerShutdownService() == null) {
                        return;
                    }
                    log.debug((Object)"Triggering a Shutdown of the Listener...");
                    ServiceReferenceHolder.getInstance().getListenerShutdownService().shutDownListener();
                }

                public void onShutdown() {
                }
            });
        }
    }

    public void unsetQpidService(QpidService qpidService) {
        log.debug((Object)"Un Setting QpidService...");
        ServiceReferenceHolder.getInstance().setQpidService(null);
    }

    @Reference(name="shutdown.listener", service=JMSListenerShutDownService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetShutDownService")
    public void setShutDownService(JMSListenerShutDownService shutDownService) {
        log.debug((Object)"Setting JMS Listener Shutdown Service");
        ServiceReferenceHolder.getInstance().setListenerShutdownService(shutDownService);
    }

    public void unsetShutDownService(JMSListenerShutDownService shutDownService) {
        log.debug((Object)"Setting JMS Listener Shutdown Service");
        ServiceReferenceHolder.getInstance().setListenerShutdownService(null);
    }
}

