/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.simulator.admin.internal.util;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.carbon.event.simulator.admin.internal.ExecutionInfo;
import org.wso2.carbon.event.simulator.admin.internal.jaxbMappings.Element;
import org.wso2.carbon.event.simulator.admin.internal.jaxbMappings.Mapping;
import org.wso2.carbon.event.simulator.admin.internal.jaxbMappings.Mappings;
import org.wso2.carbon.event.simulator.admin.internal.util.EventSimulatorAdminvalueHolder;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.CarbonDataSource;
import org.wso2.carbon.utils.CarbonUtils;

public class EventSimulatorDataSourceInfo {
    private static Map<String, Map<String, String>> dbTypeMappings;
    private static final Log log;

    private static void populateJaxbMappings() throws AxisFault {
        dbTypeMappings = new HashMap<String, Map<String, String>>();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Mappings.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            String path = CarbonUtils.getCarbonConfigDirPath() + File.separator + "cep/" + "rdbms-configuration.xml";
            File configFile = new File(path);
            if (!configFile.exists()) {
                throw new AxisFault("The rdbms-configuration.xml can not found in " + path);
            }
            Mappings mappings = (Mappings)unmarshaller.unmarshal(configFile);
            HashMap<String, Mapping> dbMap = new HashMap<String, Mapping>();
            List<Mapping> mappingList = mappings.getMapping();
            for (Mapping mapping : mappingList) {
                dbMap.put(mapping.getDb(), mapping);
            }
            for (Mapping mapping : mappingList) {
                if (mapping.getDb() == null) continue;
                Mapping defaultMapping = (Mapping)dbMap.get(null);
                Mapping specificMapping = (Mapping)dbMap.get(mapping.getDb());
                List<Element> defaultElementList = defaultMapping.getElements().getElementList();
                HashMap<String, String> elementMappings = new HashMap<String, String>();
                for (Element element : defaultElementList) {
                    Element elementDetails = null;
                    if (specificMapping.getElements().getElementList() != null) {
                        elementDetails = specificMapping.getElements().getType(element.getKey());
                    }
                    if (elementDetails == null) {
                        elementDetails = defaultMapping.getElements().getType(element.getKey());
                    }
                    elementMappings.put(elementDetails.getKey(), elementDetails.getValue());
                }
                dbTypeMappings.put(mapping.getDb(), elementMappings);
            }
        }
        catch (JAXBException e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }

    public static ExecutionInfo getInitializedDatabaseExecutionInfo(JSONObject tableAndAttributeMappingJsonObj) throws AxisFault {
        EventSimulatorDataSourceInfo.populateJaxbMappings();
        ExecutionInfo executionInfo = new ExecutionInfo();
        try {
            String dataSourceName = tableAndAttributeMappingJsonObj.getString("dataSource");
            String tableName = tableAndAttributeMappingJsonObj.getString("tableName");
            try {
                CarbonDataSource carbonDataSource = EventSimulatorAdminvalueHolder.getDataSourceService().getDataSource(dataSourceName);
                if (carbonDataSource != null) {
                    executionInfo.setDatasource((DataSource)carbonDataSource.getDSObject());
                }
                try {
                    Connection con = executionInfo.getDatasource().getConnection();
                    DatabaseMetaData databaseMetaData = con.getMetaData();
                    String dbName = databaseMetaData.getDatabaseProductName();
                    Map<String, String> elementMappings = dbTypeMappings.get(dbName.toLowerCase());
                    String isTableExistQuery = elementMappings.get("isTableExist").replace("$TABLE_NAME", tableName);
                    executionInfo.setPreparedTableExistenceCheckStatement(isTableExistQuery);
                    try {
                        Statement stmt = con.createStatement();
                        stmt.executeQuery(executionInfo.getPreparedTableExistenceCheckStatement());
                        String getColumnsQuery = "";
                        boolean addedFirstColumn = false;
                        JSONArray attributeColumnMappingArray = tableAndAttributeMappingJsonObj.getJSONArray("dataSourceColumnsAndTypes");
                        for (int i = 0; i < attributeColumnMappingArray.length(); ++i) {
                            JSONObject attributeAndMappingColumn = attributeColumnMappingArray.getJSONObject(i);
                            if (getColumnsQuery.contains(attributeAndMappingColumn.getString("columnName"))) continue;
                            if (addedFirstColumn) {
                                getColumnsQuery = getColumnsQuery + ",";
                            }
                            addedFirstColumn = true;
                            getColumnsQuery = getColumnsQuery + attributeAndMappingColumn.getString("columnName");
                        }
                        String columnsDataTypeQuery = elementMappings.get("selectAllColumnsDataTypeInTable").replace("$TABLE_NAME", tableName);
                        String selectQuery = elementMappings.get("selectFromTable").replace("$TABLE_NAME", tableName).replace("$COLUMNS", getColumnsQuery);
                        executionInfo.setPreparedCheckTableColumnsDataTypeStatement(columnsDataTypeQuery);
                        executionInfo.setPreparedSelectStatement(selectQuery);
                        int columnAndDataTypeCount = 0;
                        columnsDataTypeQuery = executionInfo.getPreparedCheckTableColumnsDataTypeStatement();
                        ResultSet rs = stmt.executeQuery(columnsDataTypeQuery);
                        while (rs.next()) {
                            String tableVariable = rs.getString(1);
                            for (int j = 0; j < attributeColumnMappingArray.length(); ++j) {
                                JSONObject mappingAttributeAndColumn = attributeColumnMappingArray.getJSONObject(j);
                                if (!mappingAttributeAndColumn.getString("columnName").equalsIgnoreCase(tableVariable)) continue;
                                ++columnAndDataTypeCount;
                            }
                        }
                        if (columnAndDataTypeCount < attributeColumnMappingArray.length()) {
                            log.error((Object)("Entered Column name(s) are nt valid in " + tableName));
                            throw new AxisFault("Entered Column name(s) are nt valid in " + tableName);
                        }
                        rs = stmt.executeQuery(executionInfo.getPreparedSelectStatement());
                        if (!rs.next()) {
                            log.error((Object)(tableName + " table does not contain data"));
                            throw new AxisFault(tableName + " table does not contain data");
                        }
                        EventSimulatorDataSourceInfo.cleanupConnections(stmt, con);
                    }
                    catch (SQLException e) {
                        log.error((Object)(tableName + " table does not exist or no data"), (Throwable)e);
                        throw new AxisFault(tableName + " table does not exist or no data", (Throwable)e);
                    }
                }
                catch (SQLException e) {
                    log.error((Object)("Exception when getting connection string for : " + dataSourceName), (Throwable)e);
                    throw new AxisFault("Exception when getting connection string for : " + dataSourceName, (Throwable)e);
                }
            }
            catch (DataSourceException e) {
                log.error((Object)("There is no any data source found named: " + dataSourceName), (Throwable)e);
                throw new AxisFault("There is no any data source found named: " + dataSourceName, (Throwable)e);
            }
        }
        catch (JSONException e) {
            log.error((Object)"Created JSON formatted string with attribute mapping information is not valid", (Throwable)e);
            throw new AxisFault("Created JSON formatted string with attribute mapping information is not valid", (Throwable)e);
        }
        return executionInfo;
    }

    private static void cleanupConnections(Statement stmt, Connection connection) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                log.error((Object)"unable to close statement", (Throwable)e);
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.error((Object)"unable to close connection", (Throwable)e);
            }
        }
    }

    static {
        log = LogFactory.getLog(EventSimulatorDataSourceInfo.class);
    }
}

