/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.simulator.admin;

import java.util.Collection;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.simulator.admin.CSVFileInfoDto;
import org.wso2.carbon.event.simulator.admin.DataSourceTableAndStreamInfoDto;
import org.wso2.carbon.event.simulator.admin.EventDto;
import org.wso2.carbon.event.simulator.admin.StreamAttributeDto;
import org.wso2.carbon.event.simulator.admin.StreamDefinitionInfoDto;
import org.wso2.carbon.event.simulator.admin.UploadedFileItemDto;
import org.wso2.carbon.event.simulator.admin.internal.ExecutionInfo;
import org.wso2.carbon.event.simulator.admin.internal.util.EventSimulatorAdminvalueHolder;
import org.wso2.carbon.event.simulator.admin.internal.util.EventSimulatorDataSourceInfo;
import org.wso2.carbon.event.simulator.core.CSVFileInfo;
import org.wso2.carbon.event.simulator.core.DataSourceTableAndStreamInfo;
import org.wso2.carbon.event.simulator.core.Event;
import org.wso2.carbon.event.simulator.core.EventSimulator;
import org.wso2.carbon.event.simulator.core.UploadedFileItem;

public class EventSimulatorAdminService
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(EventSimulatorAdminService.class);

    public StreamDefinitionInfoDto[] getAllEventStreamInfoDto() throws AxisFault {
        EventSimulator eventSimulator = EventSimulatorAdminvalueHolder.getEventSimulator();
        try {
            Collection eventStreamDefinitionList = eventSimulator.getAllEventStreamDefinitions();
            if (eventStreamDefinitionList != null) {
                StreamDefinitionInfoDto[] streamDefinitionInfoDtos = new StreamDefinitionInfoDto[eventStreamDefinitionList.size()];
                int index = 0;
                for (StreamDefinition streamDefinition : eventStreamDefinitionList) {
                    List payloadDataAttributeList;
                    List correlationDataAttributeList;
                    streamDefinitionInfoDtos[index] = new StreamDefinitionInfoDto();
                    streamDefinitionInfoDtos[index].setStreamName(streamDefinition.getName());
                    streamDefinitionInfoDtos[index].setStreamVersion(streamDefinition.getVersion());
                    streamDefinitionInfoDtos[index].setStreamDefinition(streamDefinition.toString());
                    streamDefinitionInfoDtos[index].setStreamDescription(streamDefinition.getDescription());
                    List meataDataAttributeList = streamDefinition.getMetaData();
                    if (meataDataAttributeList != null) {
                        StreamAttributeDto[] metaDataAttributeArray = new StreamAttributeDto[meataDataAttributeList.size()];
                        for (int i = 0; i < metaDataAttributeArray.length; ++i) {
                            metaDataAttributeArray[i] = new StreamAttributeDto();
                            metaDataAttributeArray[i].setAttributeName(((Attribute)meataDataAttributeList.get(i)).getName());
                            metaDataAttributeArray[i].setAttributeType(((Attribute)meataDataAttributeList.get(i)).getType().toString());
                        }
                        streamDefinitionInfoDtos[index].setMetaAttributes(metaDataAttributeArray);
                    }
                    if ((correlationDataAttributeList = streamDefinition.getCorrelationData()) != null) {
                        StreamAttributeDto[] correlationDataAttributeArray = new StreamAttributeDto[correlationDataAttributeList.size()];
                        for (int j = 0; j < correlationDataAttributeArray.length; ++j) {
                            correlationDataAttributeArray[j] = new StreamAttributeDto();
                            correlationDataAttributeArray[j].setAttributeName(((Attribute)correlationDataAttributeList.get(j)).getName());
                            correlationDataAttributeArray[j].setAttributeType(((Attribute)correlationDataAttributeList.get(j)).getType().toString());
                        }
                        streamDefinitionInfoDtos[index].setCorrelationAttributes(correlationDataAttributeArray);
                    }
                    if ((payloadDataAttributeList = streamDefinition.getPayloadData()) != null) {
                        StreamAttributeDto[] payloadDataAttributesArray = new StreamAttributeDto[payloadDataAttributeList.size()];
                        for (int k = 0; k < payloadDataAttributesArray.length; ++k) {
                            payloadDataAttributesArray[k] = new StreamAttributeDto();
                            payloadDataAttributesArray[k].setAttributeName(((Attribute)payloadDataAttributeList.get(k)).getName());
                            payloadDataAttributesArray[k].setAttributeType(((Attribute)payloadDataAttributeList.get(k)).getType().toString());
                        }
                        streamDefinitionInfoDtos[index].setPayloadAttributes(payloadDataAttributesArray);
                    }
                    ++index;
                }
                return streamDefinitionInfoDtos;
            }
            return new StreamDefinitionInfoDto[0];
        }
        catch (Exception e) {
            log.error((Object)"Exception when retrieving stream details", (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
    }

    public boolean sendEvent(EventDto eventDto) throws AxisFault {
        EventSimulator eventSimulator = EventSimulatorAdminvalueHolder.getEventSimulator();
        StreamDefinition streamDefinition = null;
        String streamID = eventDto.getEventStreamId();
        String[] attributeValues = eventDto.getAttributeValues();
        try {
            Collection streamDefinitionList = eventSimulator.getAllEventStreamDefinitions();
            if (streamDefinitionList != null) {
                for (StreamDefinition streamDefinition1 : streamDefinitionList) {
                    if (!streamDefinition1.getStreamId().equals(streamID)) continue;
                    streamDefinition = streamDefinition1;
                    break;
                }
            }
            Event event = new Event();
            if (streamDefinition == null) {
                throw new AxisFault("Relevant stream not found");
            }
            event.setStreamDefinition(streamDefinition);
            event.setAttributeValues(attributeValues);
            eventSimulator.sendEvent(event);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public boolean uploadService(UploadedFileItemDto[] fileItems) throws AxisFault {
        EventSimulator eventSimulator = EventSimulatorAdminvalueHolder.getEventSimulator();
        ConfigurationContext configurationContext = this.getConfigContext();
        AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
        UploadedFileItem[] uploadedFileItems = new UploadedFileItem[fileItems.length];
        int index = 0;
        for (UploadedFileItemDto uploadedFileItemDto : fileItems) {
            uploadedFileItems[index] = new UploadedFileItem();
            uploadedFileItems[index].setFileName(uploadedFileItemDto.getFileName());
            uploadedFileItems[index].setFileType(uploadedFileItemDto.getFileType());
            uploadedFileItems[index].setDataHandler(uploadedFileItemDto.getDataHandler());
            ++index;
        }
        eventSimulator.uploadService(uploadedFileItems, axisConfiguration);
        return true;
    }

    public void sendConfigDetails(String fileName, String streamId, String separateChar, long delayBetweenEventsInMilies) {
        EventSimulator eventSimulator = EventSimulatorAdminvalueHolder.getEventSimulator();
        ConfigurationContext configurationContext = this.getConfigContext();
        AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
        eventSimulator.createConfigurationXML(fileName, streamId, separateChar, delayBetweenEventsInMilies, axisConfiguration);
    }

    public CSVFileInfoDto[] getAllCSVFileInfo() {
        EventSimulator eventSimulator = EventSimulatorAdminvalueHolder.getEventSimulator();
        try {
            List CSVFileInfoList = eventSimulator.getAllCSVFileInfo();
            if (CSVFileInfoList != null) {
                CSVFileInfoDto[] CSVFileInfoDtoArray = new CSVFileInfoDto[CSVFileInfoList.size()];
                int index = 0;
                for (CSVFileInfo csvFileInfo : CSVFileInfoList) {
                    CSVFileInfoDtoArray[index] = new CSVFileInfoDto();
                    CSVFileInfoDtoArray[index].setFileName(csvFileInfo.getFileName());
                    CSVFileInfoDtoArray[index].setFilePath(csvFileInfo.getFilePath());
                    CSVFileInfoDtoArray[index].setStatus(csvFileInfo.getStatus().toString());
                    if (csvFileInfo.getStreamID() != null) {
                        CSVFileInfoDtoArray[index].setStreamID(csvFileInfo.getStreamID());
                    }
                    if (csvFileInfo.getDelayBetweenEventsInMillis() != 0L) {
                        CSVFileInfoDtoArray[index].setDelayBetweenEventsInMillis(csvFileInfo.getDelayBetweenEventsInMillis());
                    }
                    ++index;
                }
                return CSVFileInfoDtoArray;
            }
            return new CSVFileInfoDto[0];
        }
        catch (Exception e) {
            log.error((Object)"Exception occurred while retrieving CSV File details", (Throwable)e);
            return new CSVFileInfoDto[0];
        }
    }

    public boolean sendEventsViaFile(String fileName) throws AxisFault {
        EventSimulator eventSimulator = EventSimulatorAdminvalueHolder.getEventSimulator();
        eventSimulator.sendEvents(fileName);
        return true;
    }

    public boolean pauseEventsViaFile(String fileName) throws AxisFault {
        EventSimulator eventSimulator = EventSimulatorAdminvalueHolder.getEventSimulator();
        eventSimulator.pauseEvents(fileName);
        return true;
    }

    public boolean resumeEventsViaFile(String fileName) throws AxisFault {
        EventSimulator eventSimulator = EventSimulatorAdminvalueHolder.getEventSimulator();
        eventSimulator.resumeEvents(fileName);
        return true;
    }

    public boolean stopEventsViaFile(String fileName) throws AxisFault {
        EventSimulator eventSimulator = EventSimulatorAdminvalueHolder.getEventSimulator();
        eventSimulator.stopEvents(fileName);
        return true;
    }

    public boolean deleteFile(String fileName) throws AxisFault {
        EventSimulator eventSimulator = EventSimulatorAdminvalueHolder.getEventSimulator();
        ConfigurationContext configurationContext = this.getConfigContext();
        AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
        eventSimulator.deleteFile(fileName, axisConfiguration);
        return true;
    }

    public boolean sendDBConfigFileNameToSimulate(String fileName) throws AxisFault {
        ExecutionInfo executionInfo;
        JSONObject jsonConvertedInfo;
        EventSimulator eventSimulator = EventSimulatorAdminvalueHolder.getEventSimulator();
        String streamAttributeAndColumnMapping = eventSimulator.createTableAndAttributeMappingInfo(fileName);
        try {
            jsonConvertedInfo = new JSONObject(streamAttributeAndColumnMapping);
            executionInfo = EventSimulatorDataSourceInfo.getInitializedDatabaseExecutionInfo(jsonConvertedInfo);
        }
        catch (JSONException e) {
            throw new AxisFault("JSON exception when converting result of information retrieved by file name.");
        }
        eventSimulator.sendEventsViaDB(fileName, jsonConvertedInfo, executionInfo.getPreparedSelectStatement());
        return true;
    }

    public boolean pauseDBConfigFileNameToSimulate(String fileName) throws AxisFault {
        EventSimulator eventSimulator = EventSimulatorAdminvalueHolder.getEventSimulator();
        eventSimulator.pauseEventsViaDB(fileName);
        return true;
    }

    public boolean resumeDBConfigFileNameToSimulate(String fileName) throws AxisFault {
        EventSimulator eventSimulator = EventSimulatorAdminvalueHolder.getEventSimulator();
        eventSimulator.resumeEventsViaDB(fileName);
        return true;
    }

    public boolean stopDBConfigFileNameToSimulate(String fileName) throws AxisFault {
        EventSimulator eventSimulator = EventSimulatorAdminvalueHolder.getEventSimulator();
        eventSimulator.stopEventsViaDB(fileName);
        return true;
    }

    public boolean deleteDBConfigFile(String fileName) throws AxisFault {
        EventSimulator eventSimulator = EventSimulatorAdminvalueHolder.getEventSimulator();
        ConfigurationContext configurationContext = this.getConfigContext();
        AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
        eventSimulator.deleteDBConfigFile(fileName, axisConfiguration);
        return true;
    }

    public String testSimulateRDBMSDataSourceConnection(String tableAndAttributeMappingInfo) throws AxisFault {
        try {
            JSONObject tableAndAttributeMappingJsonObj = new JSONObject(tableAndAttributeMappingInfo);
            ExecutionInfo executionInfo = EventSimulatorDataSourceInfo.getInitializedDatabaseExecutionInfo(tableAndAttributeMappingJsonObj);
            if (executionInfo != null) {
                String result = "{\"streamID\":\"" + tableAndAttributeMappingJsonObj.getString("streamID") + "\",\"" + "eventStreamName" + "\":\"" + tableAndAttributeMappingJsonObj.getString("eventStreamName") + "\",\"" + "dataSource" + "\":\"" + tableAndAttributeMappingJsonObj.getString("dataSource") + "\",\"" + "tableName" + "\":\"" + tableAndAttributeMappingJsonObj.getString("tableName") + "\",\"" + "name" + "\":\"" + tableAndAttributeMappingJsonObj.getString("name") + "\",\"" + "delayBetweenEventsInMilies" + "\":\"" + tableAndAttributeMappingJsonObj.getLong("delayBetweenEventsInMilies") + "\",\"" + "dataSourceColumnsAndTypes" + "\":" + tableAndAttributeMappingJsonObj.getJSONArray("dataSourceColumnsAndTypes") + "}";
                return result;
            }
        }
        catch (JSONException e) {
            log.error((Object)"Created JSON formatted string with attribute mapping information is not valid", (Throwable)e);
            throw new AxisFault("Created JSON formatted string with attribute mapping information is not valid", (Throwable)e);
        }
        return "failed";
    }

    public boolean saveDataSourceConfigDetails(String tableAndAttributeMappingInfo) throws AxisFault {
        EventSimulator eventSimulator = EventSimulatorAdminvalueHolder.getEventSimulator();
        ConfigurationContext configurationContext = this.getConfigContext();
        AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
        eventSimulator.createConfigurationXMLForDataSource(tableAndAttributeMappingInfo, axisConfiguration);
        return true;
    }

    public DataSourceTableAndStreamInfoDto[] getAllDataSourceTableAndStreamInfo() throws AxisFault {
        EventSimulator eventSimulator = EventSimulatorAdminvalueHolder.getEventSimulator();
        try {
            List DataSourceTableAndStreamInfoList = eventSimulator.getAllDataSourceInfo();
            if (DataSourceTableAndStreamInfoList != null) {
                DataSourceTableAndStreamInfoDto[] dataSourceTableAndStreamInfoDtoArray = new DataSourceTableAndStreamInfoDto[DataSourceTableAndStreamInfoList.size()];
                int index = 0;
                for (DataSourceTableAndStreamInfo dataSourceTableAndStreamInfo : DataSourceTableAndStreamInfoList) {
                    dataSourceTableAndStreamInfoDtoArray[index] = new DataSourceTableAndStreamInfoDto();
                    dataSourceTableAndStreamInfoDtoArray[index].setConfigurationName(dataSourceTableAndStreamInfo.getConfigurationName());
                    dataSourceTableAndStreamInfoDtoArray[index].setDataSourceName(dataSourceTableAndStreamInfo.getDataSourceName());
                    dataSourceTableAndStreamInfoDtoArray[index].setTableName(dataSourceTableAndStreamInfo.getTableName());
                    dataSourceTableAndStreamInfoDtoArray[index].setEventStreamID(dataSourceTableAndStreamInfo.getEventStreamID());
                    dataSourceTableAndStreamInfoDtoArray[index].setColumnNames(dataSourceTableAndStreamInfo.getDataSourceColumnsAndTypes()[0]);
                    dataSourceTableAndStreamInfoDtoArray[index].setStreamAttributeNames(dataSourceTableAndStreamInfo.getDataSourceColumnsAndTypes()[1]);
                    dataSourceTableAndStreamInfoDtoArray[index].setFileName(dataSourceTableAndStreamInfo.getFileName());
                    dataSourceTableAndStreamInfoDtoArray[index].setFilePath(dataSourceTableAndStreamInfo.getFilePath());
                    dataSourceTableAndStreamInfoDtoArray[index].setDelayBetweenEventsInMillis(dataSourceTableAndStreamInfo.getDelayBetweenEventsInMillis());
                    dataSourceTableAndStreamInfoDtoArray[index].setStatus(dataSourceTableAndStreamInfo.getStatus().toString());
                    ++index;
                }
                return dataSourceTableAndStreamInfoDtoArray;
            }
            return new DataSourceTableAndStreamInfoDto[0];
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }
}

