/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.template.deployer;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.processor.core.exception.ExecutionPlanConfigurationException;
import org.wso2.carbon.event.processor.core.exception.ExecutionPlanDependencyValidationException;
import org.wso2.carbon.event.processor.template.deployer.internal.ExecutionPlanDeployerValueHolder;
import org.wso2.carbon.event.template.manager.core.DeployableTemplate;
import org.wso2.carbon.event.template.manager.core.TemplateDeployer;
import org.wso2.carbon.event.template.manager.core.TemplateDeploymentException;
import org.wso2.siddhi.query.api.util.AnnotationHelper;
import org.wso2.siddhi.query.compiler.SiddhiCompiler;
import org.wso2.siddhi.query.compiler.exception.SiddhiParserException;

public class ExecutionPlanTemplateDeployer
implements TemplateDeployer {
    private static final Log log = LogFactory.getLog(ExecutionPlanTemplateDeployer.class);

    public String getType() {
        return "realtime";
    }

    public void deployArtifact(DeployableTemplate template) throws TemplateDeploymentException {
        try {
            if (template == null) {
                throw new TemplateDeploymentException("No artifact received to be deployed.");
            }
            String planName = template.getArtifactId();
            planName = planName.replaceAll(" ", "_");
            this.undeployArtifact(planName);
            String updatedExecutionPlan = template.getArtifact();
            String executionPlanNameDefinition = "@Plan:name('" + planName + "')";
            updatedExecutionPlan = AnnotationHelper.getAnnotationElement((String)"name", null, (List)SiddhiCompiler.parse((String)updatedExecutionPlan).getAnnotations()) == null || !updatedExecutionPlan.contains("@Plan:name") ? executionPlanNameDefinition + updatedExecutionPlan : updatedExecutionPlan.replaceAll("@Plan:name\\(.*?\\)", executionPlanNameDefinition);
            ExecutionPlanDeployerValueHolder.getEventProcessorService().deployExecutionPlan(updatedExecutionPlan);
        }
        catch (SiddhiParserException e) {
            throw new TemplateDeploymentException("Validation exception occurred when parsing Execution Plan of Template " + template.getConfiguration().getName() + " of Domain " + template.getConfiguration().getDomain(), (Exception)((Object)e));
        }
        catch (ExecutionPlanConfigurationException e) {
            throw new TemplateDeploymentException("Configuration exception occurred when adding Execution Plan of Template " + template.getConfiguration().getName() + " of Domain " + template.getConfiguration().getDomain(), (Exception)((Object)e));
        }
        catch (ExecutionPlanDependencyValidationException e) {
            throw new TemplateDeploymentException("Validation exception occurred when adding Execution Plan of Template " + template.getConfiguration().getName() + " of Domain " + template.getConfiguration().getDomain(), (Exception)((Object)e));
        }
    }

    public void deployIfNotDoneAlready(DeployableTemplate template) throws TemplateDeploymentException {
        if (template == null) {
            throw new TemplateDeploymentException("No artifact received to be deployed.");
        }
        String planName = template.getArtifactId();
        planName = planName.replaceAll(" ", "_");
        if (ExecutionPlanDeployerValueHolder.getEventProcessorService().getAllActiveExecutionConfigurations().get(planName) == null) {
            this.deployArtifact(template);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Common Artifact: " + planName + " of Domain " + template.getConfiguration().getDomain() + " was not deployed as it is already being deployed."));
        }
    }

    public void undeployArtifact(String artifactId) throws TemplateDeploymentException {
        artifactId = artifactId.replaceAll(" ", "_");
        try {
            if (ExecutionPlanDeployerValueHolder.getEventProcessorService().getAllActiveExecutionConfigurations().keySet().contains(artifactId)) {
                ExecutionPlanDeployerValueHolder.getEventProcessorService().undeployActiveExecutionPlan(artifactId);
            } else {
                ExecutionPlanDeployerValueHolder.getEventProcessorService().undeployInactiveExecutionPlan(artifactId + ".siddhiql");
            }
        }
        catch (ExecutionPlanConfigurationException e) {
            throw new TemplateDeploymentException("Could not undeploy exceution plan: " + artifactId, (Exception)((Object)e));
        }
    }
}

