/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.xpath;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Stack;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.transport.http.util.URIEncoderDecoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.template.TemplateContext;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.apache.synapse.util.xpath.ext.XpathExtensionUtil;
import org.jaxen.JaxenException;
import org.jaxen.UnresolvableException;
import org.jaxen.VariableContext;

public class SynapseXPathVariableContext
implements VariableContext {
    private static final Log log = LogFactory.getLog(SynapseXPathVariableContext.class);
    private final VariableContext parent;
    private final MessageContext synCtx;
    private final SOAPEnvelope env;

    public SynapseXPathVariableContext(VariableContext parent, MessageContext synCtx) {
        this.parent = parent;
        this.synCtx = synCtx;
        this.env = synCtx.getEnvelope();
    }

    public SynapseXPathVariableContext(VariableContext parent, SOAPEnvelope env) {
        this.parent = parent;
        this.synCtx = null;
        this.env = env;
    }

    public SynapseXPathVariableContext(VariableContext parent, MessageContext synCtx, SOAPEnvelope env) {
        this.parent = parent;
        this.synCtx = synCtx;
        this.env = env;
    }

    public Object getVariableValue(String namespaceURI, String prefix, String localName) throws UnresolvableException {
        Object obj;
        if (namespaceURI == null) {
            if (this.env != null) {
                if ("body".equals(localName)) {
                    return this.env.getBody();
                }
                if ("header".equals(localName)) {
                    return this.env.getHeader();
                }
                if ("env".equals(localName)) {
                    return this.env;
                }
            }
            if (prefix != null && !"".equals(prefix) && this.synCtx != null) {
                if ("ctx".equals(prefix)) {
                    return this.synCtx.getProperty(localName);
                }
                if ("axis2".equals(prefix)) {
                    return ((Axis2MessageContext)this.synCtx).getAxis2MessageContext().getProperty(localName);
                }
                if ("func".equals(prefix)) {
                    Stack functionStack = (Stack)this.synCtx.getProperty("_SYNAPSE_FUNCTION_STACK");
                    TemplateContext topCtxt = (TemplateContext)functionStack.peek();
                    if (topCtxt != null) {
                        Object result = topCtxt.getParameterValue(localName);
                        if (result != null && result instanceof SynapseXPath && this.env != null) {
                            SynapseXPath expression = (SynapseXPath)((Object)topCtxt.getParameterValue(localName));
                            try {
                                return expression.evaluate(this.env);
                            }
                            catch (JaxenException e) {
                                return null;
                            }
                        }
                        return result;
                    }
                } else {
                    Object valueObject;
                    if ("trp".equals(prefix)) {
                        org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)this.synCtx).getAxis2MessageContext();
                        Object headers = axis2MessageContext.getProperty("TRANSPORT_HEADERS");
                        if (headers != null && headers instanceof Map) {
                            Map headersMap = (Map)headers;
                            return headersMap.get(localName);
                        }
                        return null;
                    }
                    if ("url".equals(prefix)) {
                        EndpointReference toEPR = this.synCtx.getTo();
                        if (toEPR != null) {
                            String queryString;
                            int i;
                            String completeURL = toEPR.getAddress();
                            AxisBindingOperation axisBindingOperation = (AxisBindingOperation)((Axis2MessageContext)this.synCtx).getAxis2MessageContext().getProperty("AxisBindingOperation");
                            String queryParameterSeparator = null;
                            if (axisBindingOperation != null) {
                                queryParameterSeparator = (String)axisBindingOperation.getProperty("whttp:queryParameterSeparator");
                            }
                            if (queryParameterSeparator == null) {
                                queryParameterSeparator = "&";
                            }
                            if ((i = completeURL.indexOf("?")) > -1 && (queryString = completeURL.substring(i + 1)) != null && !queryString.equals("")) {
                                String[] params = queryString.split(queryParameterSeparator);
                                if (params == null || params.length == 0) {
                                    return "";
                                }
                                for (String param : params) {
                                    String[] temp = param.split("=");
                                    if (temp == null || temp.length < 1 || !temp[0].equalsIgnoreCase(localName)) continue;
                                    try {
                                        return temp.length > 1 ? URIEncoderDecoder.decode((String)temp[1]) : "";
                                    }
                                    catch (UnsupportedEncodingException e) {
                                        String msg = "Couldn't decode the URL parameter value " + temp[1] + " with name " + localName;
                                        log.error((Object)msg, (Throwable)e);
                                        throw new UnresolvableException(msg + e.getMessage());
                                    }
                                }
                            }
                        }
                        return "";
                    }
                    if ("operation".equals(prefix)) {
                        Axis2MessageContext axis2smc = (Axis2MessageContext)this.synCtx;
                        return axis2smc.getAxis2MessageContext().getOperationContext().getProperty(localName);
                    }
                    if ("sys".equals(prefix)) {
                        String propVal = System.getProperty(localName);
                        if (propVal != null) {
                            return propVal;
                        }
                        return "";
                    }
                    Object o = this.synCtx.getProperty(prefix);
                    if (o instanceof Map && (valueObject = ((Map)o).get(localName)) != null) {
                        return valueObject.toString();
                    }
                }
            }
        }
        if ((obj = XpathExtensionUtil.resolveVariableContext(this.synCtx, namespaceURI, prefix, localName)) != null) {
            return obj;
        }
        return this.parent.getVariableValue(namespaceURI, prefix, localName);
    }
}

