/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.xpath;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.axiom.om.impl.llom.OMDocumentImpl;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.axiom.om.impl.llom.util.AXIOMUtil;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.dom.factory.DOMSOAPFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.config.SynapsePropertiesLoader;
import org.apache.synapse.config.xml.OMElementUtils;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.transport.passthru.config.PassThroughConfiguration;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.apache.synapse.util.streaming_xpath.StreamingXPATH;
import org.apache.synapse.util.streaming_xpath.compiler.exception.StreamingXPATHCompilerException;
import org.apache.synapse.util.streaming_xpath.custom.components.ParserComponent;
import org.apache.synapse.util.streaming_xpath.exception.StreamingXPATHException;
import org.apache.synapse.util.xpath.DOMSynapseXPathVariableResolver;
import org.apache.synapse.util.xpath.GetPropertyFunctionResolver;
import org.apache.synapse.util.xpath.SynapseXPathFunctionContext;
import org.apache.synapse.util.xpath.SynapseXPathVariableContext;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.UnresolvableException;
import org.jaxen.VariableContext;
import org.jaxen.XPath;
import org.jaxen.util.SingletonList;

public class SynapseXPath
extends SynapsePath {
    private static final long serialVersionUID = 7639226137534334222L;
    private static final Log log = LogFactory.getLog(SynapseXPath.class);
    private javax.xml.xpath.XPath domXpath = XPathFactory.newInstance().newXPath();
    private String domXpathConfig = SynapsePropertiesLoader.loadSynapseProperties().getProperty("synapse.xpath.dom.failover.enabled");
    private boolean forceDisableStreamXpath = false;
    private String enableStreamingXpath = SynapsePropertiesLoader.loadSynapseProperties().getProperty("synapse.streaming.xpath.enabled");
    private StreamingXPATH streamingXPATH = null;
    private Boolean forceFailoverEvaluation = Boolean.FALSE;
    private String evaluator = "null";

    public String getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(String evaluator) {
        this.evaluator = evaluator;
    }

    public SynapseXPath(String xpathString) throws JaxenException {
        super(xpathString, log);
        this.setPathType("X_PATH");
        this.expression = xpathString;
        PassThroughConfiguration conf = PassThroughConfiguration.getInstance();
        this.bufferSizeSupport = conf.getIOBufferSize();
        this.contentAware = xpathString.contains("/") ? true : xpathString.contains("get-property('From'") || xpathString.contains("get-property('FAULT')");
        String propertyScope = this.getPropertyScope(xpathString);
        if ("registry".equals(propertyScope) || "system".equals(propertyScope) || "transport".equals(propertyScope) || "env".equals(propertyScope) || "file".equals(propertyScope)) {
            this.contentAware = false;
            return;
        }
        if (xpathString.contains("$trp") || xpathString.contains("$ctx") || xpathString.contains("$axis2")) {
            this.contentAware = false;
            return;
        }
        if ("true".equals(this.enableStreamingXpath)) {
            try {
                this.streamingXPATH = new StreamingXPATH(xpathString);
                this.contentAware = false;
            }
            catch (StreamingXPATHException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Provided XPATH expression " + xpathString + " cant be evaluated custom."));
                }
                this.contentAware = true;
            }
            catch (StreamingXPATHCompilerException exception) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Provided XPATH expression " + xpathString + " cant be evaluated custom."));
                }
                this.contentAware = true;
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Provided XPATH expression " + xpathString + " cant be evaluated custom."));
                }
                this.contentAware = true;
            }
        }
    }

    private String getPropertyScope(String xPathString) {
        String xpath = null;
        String scope = "";
        if (xPathString.contains("get-property")) {
            String[] args;
            Matcher matcher = Pattern.compile("get-property\\(([^)]+)\\)").matcher(xPathString);
            if (matcher.find()) {
                xpath = matcher.group(1);
            }
            if (xpath != null && (args = xpath.split(",")).length == 2) {
                scope = args[0].trim().replaceAll("^'|'$", "").trim();
            }
        }
        return scope;
    }

    public SynapseXPath(String xpathExpr, OMElement elem) throws JaxenException {
        super(xpathExpr, "X_PATH", log);
        OMElementUtils.addNameSpaces((XPath)this, elem, log);
        this.addNamespacesForFallbackProcessing(elem);
        this.domXpath.setNamespaceContext(this.domNamespaceMap);
        this.setPathType("X_PATH");
        try {
            XPathExpression xPathExpression = this.domXpath.compile(xpathExpr);
        }
        catch (XPathExpressionException e) {
            throw new JaxenException((Throwable)e);
        }
        this.forceFailoverEvaluation = Boolean.TRUE;
        PassThroughConfiguration conf = PassThroughConfiguration.getInstance();
        this.bufferSizeSupport = conf.getIOBufferSize();
        this.contentAware = xpathExpr.contains("/") || xpathExpr.contains("get-property('From'") || xpathExpr.contains("get-property('FAULT')");
        if (xpathExpr.contains("$trp") || xpathExpr.contains("$ctx") || xpathExpr.contains("$axis2")) {
            this.contentAware = false;
        }
    }

    public SynapseXPath(OMElement element, String xpathExpr) throws JaxenException {
        super(element, xpathExpr, log);
        this.expression = xpathExpr;
        this.setPathType("X_PATH");
    }

    public SynapseXPath(OMAttribute attribute) throws JaxenException {
        super(attribute, log);
        this.expression = attribute.getAttributeValue();
        this.setPathType("X_PATH");
    }

    public static SynapseXPath parseXPathString(String xPathStr) throws JaxenException {
        if (xPathStr.indexOf(123) == -1) {
            return new SynapseXPath(xPathStr);
        }
        int count = 0;
        StringBuffer newXPath = new StringBuffer();
        HashMap<String, String> nameSpaces = new HashMap<String, String>();
        String curSegment = null;
        boolean xPath = false;
        StringTokenizer st = new StringTokenizer(xPathStr, "{}", true);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if ("{".equals(s)) {
                xPath = true;
                continue;
            }
            if ("}".equals(s)) {
                xPath = false;
                String prefix = "rp" + count++;
                nameSpaces.put(prefix, curSegment);
                newXPath.append(prefix).append(":");
                continue;
            }
            if (xPath) {
                curSegment = s;
                continue;
            }
            newXPath.append(s);
        }
        SynapseXPath synXPath = new SynapseXPath(newXPath.toString());
        for (Map.Entry entry : nameSpaces.entrySet()) {
            synXPath.addNamespace((String)entry.getKey(), (String)entry.getValue());
        }
        return synXPath;
    }

    @Override
    public String stringValueOf(MessageContext synCtx) {
        try {
            if (this.forceFailoverEvaluation.booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Forced evaluation of the expression with the DOM parser by bypassing the Jaxen: " + this.getExpression()));
                }
                throw new UnresolvableException("Forced to evaluate with DOM parser bypassing Jaxen");
            }
            InputStream inputStream = null;
            Object result = null;
            org.apache.axis2.context.MessageContext axis2MC = null;
            if (!this.forceDisableStreamXpath && "true".equals(this.enableStreamingXpath) && this.streamingXPATH != null && (((Axis2MessageContext)synCtx).getEnvelope() == null || ((Axis2MessageContext)synCtx).getEnvelope().getBody().getFirstElement() == null)) {
                try {
                    axis2MC = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
                    String contentType = (String)axis2MC.getProperty("ContentType");
                    if (!this.isStreamingXpathSupportedContentType(contentType) && !Boolean.TRUE.equals("message.builder.invoked")) {
                        RelayUtils.buildMessage((org.apache.axis2.context.MessageContext)axis2MC);
                    } else {
                        inputStream = this.getMessageInputStreamPT(axis2MC);
                    }
                }
                catch (XMLStreamException e) {
                    this.handleException("Error occurred while building the message from the message context", e);
                }
                catch (IOException e) {
                    log.error((Object)"Error occurred while obtaining input stream from the message context", (Throwable)e);
                }
                if (inputStream != null) {
                    try {
                        result = this.streamingXPATH.getStringValue(inputStream);
                    }
                    catch (XMLStreamException e) {
                        this.handleException("Error occurred while parsing the XPATH String", e);
                    }
                    catch (StreamingXPATHException e) {
                        this.handleException("Error occurred while parsing the XPATH String", e);
                    }
                } else {
                    try {
                        result = this.streamingXPATH.getStringValue((OMElement)synCtx.getEnvelope());
                    }
                    catch (XMLStreamException e) {
                        this.handleException("Error occurred while parsing the XPATH String", e);
                    }
                    catch (StreamingXPATHException e) {
                        this.handleException("Error occurred while parsing the XPATH String", e);
                    }
                }
            } else {
                result = this.evaluate(synCtx);
            }
            if (result == null) {
                return null;
            }
            StringBuffer textValue = new StringBuffer();
            if (result instanceof List) {
                List list = (List)result;
                for (Object o : list) {
                    if (o == null && list.size() == 1) {
                        return null;
                    }
                    if (o instanceof OMTextImpl) {
                        textValue.append(((OMTextImpl)o).getText());
                        continue;
                    }
                    if (o instanceof OMElementImpl) {
                        if (list.size() == 1) {
                            String s = ((OMElementImpl)o).getText();
                            if (s.replace(String.valueOf('\u00a0'), " ").trim().length() == 0) {
                                s = o.toString();
                            }
                            textValue.append(s);
                            continue;
                        }
                        String tmp = ((OMElementImpl)o).getText();
                        String trimmedText = tmp.replace(String.valueOf('\u00a0'), " ").trim();
                        String s = o.toString();
                        s = s.replace(tmp, trimmedText);
                        if (trimmedText.length() == 0) {
                            s = o.toString();
                        }
                        textValue.append(s);
                        continue;
                    }
                    if (o instanceof OMDocumentImpl) {
                        textValue.append(((OMDocumentImpl)o).getOMDocumentElement().toString());
                        continue;
                    }
                    if (o instanceof OMAttribute) {
                        textValue.append(((OMAttribute)o).getAttributeValue());
                        continue;
                    }
                    if (o instanceof SynapseXPath) {
                        textValue.append(((SynapseXPath)((Object)o)).stringValueOf(synCtx));
                        continue;
                    }
                    if (!(o instanceof JsonElement)) continue;
                    textValue.append(o.toString());
                }
            } else if ("true".equals(this.enableStreamingXpath) && this.streamingXPATH != null) {
                if (!"".equals((String)result)) {
                    OMElement re = AXIOMUtil.stringToOM((String)((String)result));
                    if (re != null) {
                        textValue.append(re.getText());
                    } else {
                        textValue.append(result.toString());
                    }
                }
            } else {
                textValue.append(result.toString());
            }
            return textValue.toString();
        }
        catch (UnresolvableException ex) {
            if ("true".equals(this.domXpathConfig)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"AXIOM xpath evaluation failed with UnresolvableException, trying to perform DOM based XPATH", (Throwable)ex);
                }
                try {
                    return this.evaluateDOMXPath(synCtx);
                }
                catch (Exception e) {
                    this.handleException("Evaluation of the XPath expression " + this.toString() + " resulted in an error", e);
                }
            } else {
                this.handleException("Evaluation of the XPath expression " + this.toString() + " resulted in an error", ex);
            }
        }
        catch (JaxenException je) {
            this.handleException("Evaluation of the XPath expression " + this.toString() + " resulted in an error", je);
        }
        catch (XMLStreamException e) {
            this.handleException("Evaluation of the XPath expression " + this.toString() + " resulted in an error", e);
        }
        return null;
    }

    public Object evaluate(Object primaryContext, MessageContext secondaryContext) {
        Object result = null;
        if (secondaryContext != null) {
            try {
                result = this.evaluate(new ContextWrapper((SOAPEnvelope)primaryContext, secondaryContext));
            }
            catch (Exception e) {
                this.handleException("Evaluation of the XPath expression " + this.toString() + " resulted in an error", e);
            }
        } else {
            try {
                result = this.evaluate(primaryContext);
            }
            catch (JaxenException e) {
                this.handleException("Evaluation of the XPath expression " + this.toString() + " resulted in an error", e);
            }
        }
        return result;
    }

    public void addNamespace(OMNamespace ns) throws JaxenException {
        this.addNamespace(ns.getPrefix(), ns.getNamespaceURI());
        this.domNamespaceMap.addNamespace(ns.getPrefix(), ns.getNamespaceURI());
        ParserComponent.addToNameSpaceMap(ns.getPrefix(), ns.getNamespaceURI());
    }

    protected Context getContext(Object obj) {
        if (obj instanceof MessageContext) {
            MessageContext synCtx = (MessageContext)obj;
            ContextSupport baseContextSupport = this.getContextSupport();
            ContextSupport contextSupport = new ContextSupport(baseContextSupport.getNamespaceContext(), (FunctionContext)new SynapseXPathFunctionContext(baseContextSupport.getFunctionContext(), synCtx), (VariableContext)new SynapseXPathVariableContext(baseContextSupport.getVariableContext(), synCtx), baseContextSupport.getNavigator());
            Context context = new Context(contextSupport);
            context.setNodeSet((List)new SingletonList((Object)synCtx.getEnvelope()));
            return context;
        }
        if (obj instanceof SOAPEnvelope) {
            SOAPEnvelope env = (SOAPEnvelope)obj;
            ContextSupport baseContextSupport = this.getContextSupport();
            ContextSupport contextSupport = new ContextSupport(baseContextSupport.getNamespaceContext(), baseContextSupport.getFunctionContext(), (VariableContext)new SynapseXPathVariableContext(baseContextSupport.getVariableContext(), env), baseContextSupport.getNavigator());
            Context context = new Context(contextSupport);
            context.setNodeSet((List)new SingletonList((Object)env));
            return context;
        }
        if (obj instanceof ContextWrapper) {
            ContextWrapper wrapper = (ContextWrapper)obj;
            ContextSupport baseContextSupport = this.getContextSupport();
            ContextSupport contextSupport = new ContextSupport(baseContextSupport.getNamespaceContext(), baseContextSupport.getFunctionContext(), (VariableContext)new SynapseXPathVariableContext(baseContextSupport.getVariableContext(), wrapper.getMessageCtxt(), wrapper.getEnvelope()), baseContextSupport.getNavigator());
            Context context = new Context(contextSupport);
            context.setNodeSet((List)new SingletonList((Object)wrapper.getEnvelope()));
            return context;
        }
        return super.getContext(obj);
    }

    public boolean isForceDisableStreamXpath() {
        return this.forceDisableStreamXpath;
    }

    public void setForceDisableStreamXpath(boolean forceDisableStreamXpath) {
        this.forceDisableStreamXpath = forceDisableStreamXpath;
    }

    public synchronized String evaluateDOMXPath(MessageContext synCtx) throws XPathExpressionException {
        OMElement element = synCtx.getEnvelope().getBody().getFirstElement();
        OMElement doomElement = element == null ? new DOMSOAPFactory().createOMElement(new QName("")) : this.convertToDOOM(element);
        this.domXpath.setNamespaceContext(this.domNamespaceMap);
        this.domXpath.setXPathFunctionResolver(new GetPropertyFunctionResolver(synCtx));
        this.domXpath.setXPathVariableResolver(new DOMSynapseXPathVariableResolver(this.getVariableContext(), synCtx));
        XPathExpression expr = this.domXpath.compile(this.getExpression());
        String result = expr.evaluate(doomElement);
        if (result != null) {
            return result.toString();
        }
        return null;
    }

    private OMElement convertToDOOM(OMElement element) {
        XMLStreamReader llomReader = element.getXMLStreamReader();
        OMFactory doomFactory = DOOMAbstractFactory.getOMFactory();
        StAXOMBuilder doomBuilder = new StAXOMBuilder(doomFactory, llomReader);
        return doomBuilder.getDocumentElement();
    }

    private boolean isStreamingXpathSupportedContentType(String contentType) {
        return contentType != null && (contentType.indexOf("text/xml") != -1 || contentType.indexOf("application/soap+xml") != -1 || contentType.indexOf("application/xml") != -1);
    }

    private static class ContextWrapper {
        private MessageContext ctxt;
        private SOAPEnvelope env;

        public ContextWrapper(SOAPEnvelope env, MessageContext ctxt) {
            this.env = env;
            this.ctxt = ctxt;
        }

        public SOAPEnvelope getEnvelope() {
            return this.env;
        }

        public MessageContext getMessageCtxt() {
            return this.ctxt;
        }
    }
}

