/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.xpath;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axiom.om.OMElement;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.config.SynapsePropertiesLoader;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.eip.EIPUtils;
import org.apache.synapse.util.InlineExpressionUtil;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class SynapseJsonPath
extends SynapsePath {
    private static final Log log = LogFactory.getLog(SynapseJsonPath.class);
    private static final String EXTRACT_PROP_REGEX = "^(\\$ctx|\\$trp|\\$axis2):([a-zA-Z0-9]+)";
    private String propertyExpression;
    private String enableStreamingJsonPath = SynapsePropertiesLoader.loadSynapseProperties().getProperty("synapse.streaming.jsonpath.enabled");
    private JsonPath jsonPath;
    private boolean isWholeBody = false;
    private boolean isJSONPathNeedsProcessing = false;

    public JsonPath getJsonPath() {
        return this.jsonPath;
    }

    public String getParentPath() {
        Object[] array = this.expression.split("\\.");
        if (array.length > 1) {
            if (array[array.length - 1].endsWith("]")) {
                array[array.length - 1] = array[array.length - 1].replaceAll("\\[(.*?)\\]", "");
                return StringUtils.join((Object[])array, (String)".");
            }
            Object[] parent = Arrays.copyOf(array, array.length - 1);
            return StringUtils.join((Object[])parent, (String)".");
        }
        return null;
    }

    public void setJsonPath(JsonPath jsonPath) {
        this.jsonPath = jsonPath;
    }

    public SynapseJsonPath(String jsonPathExpression) throws JaxenException {
        super(jsonPathExpression, "JSON_PATH", log);
        EIPUtils.setJsonPathConfiguration();
        this.contentAware = true;
        if (jsonPathExpression.startsWith("$ctx:") || jsonPathExpression.startsWith("$trp:") || jsonPathExpression.startsWith("$axis2:")) {
            Pattern extractProp = Pattern.compile(EXTRACT_PROP_REGEX);
            Matcher extractPropMatcher = extractProp.matcher(jsonPathExpression);
            if (extractPropMatcher.find()) {
                this.propertyExpression = extractPropMatcher.group(0);
                this.expression = "$" + jsonPathExpression.substring(this.propertyExpression.length());
            }
        } else {
            this.expression = jsonPathExpression;
        }
        if (this.expression.endsWith(".")) {
            this.expression = this.expression.substring(0, this.expression.length() - 1);
        }
        this.jsonPath = JsonPath.compile((String)this.expression, (Predicate[])new Predicate[0]);
        if ("$".equals(this.jsonPath.getPath().trim()) || "$.".equals(this.jsonPath.getPath().trim())) {
            this.isWholeBody = true;
        }
        if (InlineExpressionUtil.checkForInlineExpressions(this.expression)) {
            this.isJSONPathNeedsProcessing = true;
        }
        this.setPathType("JSON_PATH");
    }

    public String stringValueOf(String jsonString) {
        if (jsonString == null) {
            return "";
        }
        if (this.isWholeBody) {
            return jsonString;
        }
        Object read = this.formatJsonPathResponse(this.jsonPath.read(jsonString));
        return null == read ? "null" : read.toString();
    }

    @Override
    public String stringValueOf(MessageContext synCtx) {
        if (this.isJSONPathNeedsProcessing) {
            this.jsonPath = JsonPath.compile((String)InlineExpressionUtil.replaceDynamicValuesForJSONPath(synCtx, this.expression), (Predicate[])new Predicate[0]);
        }
        if (this.propertyExpression != null) {
            try {
                SynapseXPath xPath = new SynapseXPath(this.propertyExpression);
                String result = xPath.stringValueOf(synCtx);
                return this.stringValueOf(result);
            }
            catch (JaxenException e) {
                log.error((Object)("Xpath evaluation failed : " + this.propertyExpression), (Throwable)e);
                return "";
            }
        }
        org.apache.axis2.context.MessageContext amc = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        if (!JsonUtil.hasAJsonPayload((org.apache.axis2.context.MessageContext)amc) || "true".equals(this.enableStreamingJsonPath)) {
            try {
                InputStream stream;
                if (null == amc.getEnvelope().getBody().getFirstElement()) {
                    stream = this.getMessageInputStreamPT(amc);
                    if (stream == null) {
                        stream = JsonUtil.getJsonPayload((org.apache.axis2.context.MessageContext)amc);
                    } else {
                        JsonUtil.getNewJsonPayload((org.apache.axis2.context.MessageContext)amc, (InputStream)stream, (boolean)true, (boolean)true);
                    }
                } else {
                    stream = JsonUtil.toJsonStream((OMElement)amc.getEnvelope().getBody().getFirstElement());
                }
                if (stream != null) {
                    return this.stringValueOf(stream);
                }
                log.warn((Object)"Json Payload is empty.");
                return "";
            }
            catch (IOException e) {
                this.handleException("Could not find JSON Stream in PassThrough Pipe during JSON path evaluation.", e);
            }
        } else {
            InputStream stream = JsonUtil.getJsonPayload((org.apache.axis2.context.MessageContext)amc);
            return this.stringValueOf(stream);
        }
        return "";
    }

    public String stringValueOf(InputStream jsonStream) {
        if (jsonStream == null) {
            return "";
        }
        if (this.isWholeBody) {
            try {
                return IOUtils.toString((InputStream)jsonStream);
            }
            catch (IOException e) {
                log.error((Object)"#stringValueOf. Could not convert JSON input stream to String.");
                return "";
            }
        }
        try {
            Object read = this.formatJsonPathResponse(this.jsonPath.read(jsonStream));
            if (log.isDebugEnabled()) {
                log.debug((Object)("#stringValueOf. Evaluated JSON path <" + this.jsonPath.getPath() + "> : <" + (read == null ? null : read.toString()) + ">"));
            }
            return null == read ? "null" : read.toString();
        }
        catch (IOException e) {
            this.handleException("Error evaluating JSON Path <" + this.jsonPath.getPath() + ">", e);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("#stringValueOf. Error evaluating JSON Path <" + this.jsonPath.getPath() + ">. Returning empty result. Error>>> " + e.getLocalizedMessage()));
            }
            return "";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("#stringValueOf. Evaluated JSON path <" + this.jsonPath.getPath() + "> : <null>."));
        }
        return "";
    }

    public String getJsonPathExpression() {
        return this.expression;
    }

    public void setJsonPathExpression(String jsonPathExpression) {
        this.expression = jsonPathExpression;
    }

    public Object evaluate(Object object) {
        List result = null;
        if (object != null) {
            if (object instanceof MessageContext) {
                MessageContext synCtx = (MessageContext)object;
                result = this.listValueOf(synCtx);
            } else if (object instanceof String) {
                result = this.listValueOf(IOUtils.toInputStream((String)object.toString()));
            }
        }
        return result;
    }

    private List listValueOf(MessageContext synCtx) {
        org.apache.axis2.context.MessageContext amc = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        if (!JsonUtil.hasAJsonPayload((org.apache.axis2.context.MessageContext)amc) || "true".equals(this.enableStreamingJsonPath)) {
            try {
                InputStream stream;
                if (null == amc.getEnvelope().getBody().getFirstElement()) {
                    stream = this.getMessageInputStreamPT(amc);
                    if (stream == null) {
                        stream = JsonUtil.getJsonPayload((org.apache.axis2.context.MessageContext)amc);
                    } else {
                        JsonUtil.getNewJsonPayload((org.apache.axis2.context.MessageContext)amc, (InputStream)stream, (boolean)true, (boolean)true);
                    }
                } else {
                    stream = JsonUtil.toJsonStream((OMElement)amc.getEnvelope().getBody().getFirstElement());
                }
                return this.listValueOf(stream);
            }
            catch (IOException e) {
                this.handleException("Could not find JSON Stream in PassThrough Pipe during JSON path evaluation.", e);
            }
        } else {
            InputStream stream = JsonUtil.getJsonPayload((org.apache.axis2.context.MessageContext)amc);
            return this.listValueOf(stream);
        }
        return null;
    }

    private List listValueOf(InputStream jsonStream) {
        if (jsonStream == null) {
            return null;
        }
        List<JsonElement> result = new ArrayList<Object>();
        try {
            Object object = this.formatJsonPathResponse(this.jsonPath.read(jsonStream));
            if (object != null) {
                if (object instanceof List && !this.jsonPath.isDefinite()) {
                    result = (List)object;
                } else if (object instanceof JsonArray) {
                    for (JsonElement element : (JsonArray)object) {
                        result.add(element);
                    }
                } else {
                    result.add((JsonElement)object);
                }
            }
        }
        catch (IOException e) {
            log.error((Object)("AggregateMediator Failed to evaluate correlate expression: " + this.jsonPath.getPath()));
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("#listValueOf. Evaluated JSON path <" + this.jsonPath.getPath() + "> : <null>."));
        }
        return result;
    }

    private Object formatJsonPathResponse(Object input) {
        if (input instanceof Number) {
            return input;
        }
        JsonElement jsonElement = (JsonElement)input;
        if (jsonElement.isJsonPrimitive()) {
            return jsonElement.getAsString();
        }
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject.has("members")) {
                return jsonObject.get("members");
            }
            if (jsonObject.has("elements")) {
                return jsonObject.get("elements");
            }
            return jsonObject.toString();
        }
        return jsonElement.isJsonArray() ? jsonElement : null;
    }

    public Object replace(Object rootObject, Object newChild) {
        if (this.isWholeBody) {
            rootObject = newChild;
        } else {
            JsonParser parser = new JsonParser();
            JsonElement jsonElement = parser.parse(rootObject.toString());
            Object attachPathObject = null;
            try {
                attachPathObject = this.formatJsonPathResponse(JsonPath.parse((String)jsonElement.toString()).read(this.getJsonPath()));
            }
            catch (PathNotFoundException e) {
                this.handleException("Unable to get the attach path specified by the expression " + this.expression, e);
            }
            if (attachPathObject != null) {
                rootObject = JsonPath.parse((String)jsonElement.toString()).set(this.expression, newChild, new Predicate[0]).jsonString();
            }
        }
        return rootObject;
    }

    public boolean isWholeBody() {
        return this.isWholeBody;
    }

    public boolean booleanValueOf(MessageContext synCtx) {
        return Boolean.parseBoolean(this.stringValueOf(synCtx));
    }
}

